/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.cli.CLISession;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.ComlianceScheduleUtility;
import com.adventnet.fa.server.DynamicLocks;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FWAEnumConstants;
import com.adventnet.fa.server.rules.CiscoPolicyProcessor;
import com.adventnet.fa.server.rules.DeviceCommandParser;
import com.adventnet.fa.server.rules.DeviceConnection;
import com.adventnet.fa.server.rules.FirewallPolicyFormat;
import com.adventnet.fa.server.rules.FortiGatePolicyProcessor;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.fa.server.rules.PolicyProcessor;
import com.adventnet.fa.server.rules.PolicyProcessorUtilityClass;
import com.adventnet.fa.server.rules.SRXPolicyProcessor;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class ComplianceGenerator {
    private static final Logger LOGGER = Logger.getLogger(ComplianceGenerator.class.getName());
    EncryptionAPI decryptionObj = EncryptionAPI.getDecryptionObj();
    ResourceBundle bundle = ProductBundle.getInstance().getBundle();
    private static final byte[] SYNCOBJ = new byte[0];
    private static final byte[] CHECKLIST_SYNCOBJ = new byte[0];
    private static final String[] ALL_SERVICEBASED_FALSEPOSITIVE_CHECKLIST_ARRAY = new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "30"};
    private static final List<String> SERVICEBASED_FALSEPOSITIVE_GENERIC_CHECKLIST = Arrays.asList(ALL_SERVICEBASED_FALSEPOSITIVE_CHECKLIST_ARRAY);
    private static final String[] ALL_NON_SERVICEBASED_FALSEPOSITIVE_CHECKLIST_ARRAY = new String[]{"1", "2"};
    private static final List<String> NON_SERVICEBASED_FALSEPOSITIVE_GENERIC_CHECKLIST = Arrays.asList(ALL_NON_SERVICEBASED_FALSEPOSITIVE_CHECKLIST_ARRAY);
    private static final String[] PCI_DEFAULT_USERCALL_SECTION_ARRAY = new String[]{"1.1.1", "1.1.6", "10.1", "10.2.1", "10.2.2", "10.2.4", "10.2.6 a", "10.2.6 b", "10.6", "11.5"};
    private static final String[] NIST_DEFAULT_USERCALL_SECTION_ARRAY = new String[]{"3.1"};
    private static final String[] ISO_DEFAULT_USERCALL_SECTION_ARRAY = new String[]{"12.3", "12.4.3"};
    private static final String[] NERC_DEFAULT_USERCALL_SECTION_ARRAY = new String[]{"CIP-003-R6", "CIP-005-R3", "CIP-005-R3.2.a", "CIP-005-R3.2.b", "CIP-005-R4.5", "CIP-005-R5.3", "CIP-007-R5.1.1", "CIP-007-R5.1.2", "CIP-007-R5.6.2", "CIP-007-R6.2", "CIP-007-R6.4", "CIP-007-R8.2", "CIP-008-R1.2", "CIP-009-R4"};
    private static final String[] SANS_DEFAULT_USERCALL_SECTION_ARRAY = new String[]{"24"};
    private static final String[] NO_EXPLICIT_DENY_RULE_SECTION_ARRAY = new String[]{"PCI DSS_1.2.1 b", "NIST_2.1", "ISO_13.1.2", "NERC-CIP_CIP-005-R2.1", "NERC-CIP_CIP-007-R2.2"};
    private LinkedHashMap<String, String> sectionVsRBBs = null;
    private LinkedHashMap<String, String> sectionVsBriefDesc = null;
    private LinkedHashMap<String, Long> sectionVsFWASectionID = null;
    private HashMap<String, String> sectionVsGenericIDs = null;
    private HashMap<String, String> rbbVsQuery = null;
    private HashMap<String, String> rbbVsTitle = null;
    private HashMap<String, String> rbbVsColList = null;
    private HashMap<String, String> rbbVsStatusDeciderMap = null;
    private HashMap<String, String> rbbVsDataDisplayType = null;
    private HashMap<String, String> rbbVsHighlightColList = null;
    private ArrayList<String> genericSecurityAuditDataDisplayList = null;
    private ArrayList<String> statusBasedSectionDescList = null;
    private ArrayList<Long> disabledGenericIDList = null;
    private HashMap<String, String> genericIDVsServiceMap = null;
    private HashMap<String, String> sectionAppendMap = null;
    private HashMap<String, String> sectionVsLinkDetailsMap = null;
    private ArrayList<String> sectionList = null;
    String dbConfigData = null;
    String deviceType = null;
    private JSONObject mainJson = null;
    private ComlianceScheduleUtility csu = null;
    private Pattern ciscoSrcAndDstObjExtractPatternFromRuleService = Pattern.compile("^Source:(\\S+)\\s*(?:and\\s+Destination:(\\S+))?");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String regenerate(Long rID, String displayName, String complianceReportName, String userInput, Long rptID, String isServiceChanged, String resourceName, Long latestConfigVersionNo, String firewallDeviceType) throws Exception {
        Object object;
        if (FAServerUtil.isExcludeServicesProcessingNow() || FAServerUtil.isNonServiceFalsePositivesProcessingNow()) {
            LOGGER.info("ComplianceGenerator....Waiting to generate " + complianceReportName + " compliance report for the device " + displayName + " because of false positive handling has already triggerred..");
            try {
                Object globalCompLock;
                object = globalCompLock = FAServerUtil.GLOBALCOMPLIANCELOCK;
                synchronized (object) {
                    globalCompLock.wait();
                }
            }
            catch (Exception lockExp) {
                throw new Exception("ComplianceGenerator:::Exception while waiting on Global Compliance Lock while generating " + complianceReportName + " Compliance Report...for firewall " + displayName, lockExp);
            }
        }
        if (FAServerUtil.isPolicyProcessing(rID)) {
            LOGGER.info("ComplianceGenerator....Waiting to generate " + complianceReportName + " compliance report for the device " + displayName + " because policy processing has already triggerred for this device..");
            try {
                Object compLock;
                object = compLock = DynamicLocks.getLockFor(rID + "_compliance");
                synchronized (object) {
                    compLock.wait();
                }
            }
            catch (Exception lockExp) {
                throw new Exception("ComplianceGenerator:::Exception while waiting on rid specific compliance lock while generating " + complianceReportName + " Compliance Report...for firewall " + displayName, lockExp);
            }
        }
        try {
            String excludedServices;
            HashMap<String, String> userInputHashMap;
            boolean isAlreadyParsed;
            FAServerUtil.addToCurrentComplianceProcesses(rID);
            this.csu = ComlianceScheduleUtility.getInstance();
            this.deviceType = firewallDeviceType;
            this.sectionVsRBBs = new LinkedHashMap(30);
            this.sectionVsBriefDesc = new LinkedHashMap(30);
            this.sectionVsFWASectionID = new LinkedHashMap(30);
            this.sectionVsGenericIDs = new HashMap(30);
            this.rbbVsQuery = new HashMap(30);
            this.rbbVsTitle = new HashMap(30);
            this.rbbVsColList = new HashMap(30);
            this.rbbVsStatusDeciderMap = new HashMap(30);
            this.rbbVsDataDisplayType = new HashMap(30);
            this.rbbVsHighlightColList = new HashMap(30);
            this.genericSecurityAuditDataDisplayList = new ArrayList();
            this.statusBasedSectionDescList = new ArrayList();
            this.sectionAppendMap = new HashMap(30);
            this.sectionVsLinkDetailsMap = new HashMap(30);
            this.sectionList = new ArrayList();
            this.disabledGenericIDList = new ArrayList();
            this.genericIDVsServiceMap = new HashMap();
            this.mainJson = new JSONObject();
            boolean fileImport = false;
            if (latestConfigVersionNo == null || latestConfigVersionNo < 0L) {
                List vdomList;
                String resIP = null;
                Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)rID, 0);
                DataObject resDO = DataAccess.get((String)"Resources", (Criteria)crit);
                if (!resDO.isEmpty()) {
                    resIP = (String)resDO.getFirstValue("Resources", "IPADDRESS");
                }
                if ((vdomList = FAServerUtil.getVdomDevicesList()).contains(resIP)) {
                    FAServerUtil.removeFromCurrentComplianceProcesses(rID);
                    this.releaseLocks(rID, displayName, "policyProcess");
                    this.releaseGlobalLocks();
                    return this.bundle.getString("Configure_ChangeMgmt_Message");
                }
                Properties props = this.getDeviceDetailsToFetchTheConfig(rID);
                if (props != null && !"0".equals(props.getProperty("mode"))) {
                    this.dbConfigData = this.getConfigByconnectingToDevice(rID, props);
                    if (this.dbConfigData == null) {
                        FAServerUtil.removeFromCurrentComplianceProcesses(rID);
                        this.releaseLocks(rID, displayName, "policyProcess");
                        this.releaseGlobalLocks();
                        return this.bundle.getString("CompliancePage_Config_Fetch_Error");
                    }
                    latestConfigVersionNo = new Long(0L);
                } else {
                    fileImport = true;
                }
            }
            if (!(isAlreadyParsed = this.csu.checkForParsing(latestConfigVersionNo, rID, displayName, complianceReportName)) && !fileImport) {
                boolean userInputsExists;
                if (latestConfigVersionNo > 0L) {
                    this.loadLatestConfigIntoMemory(rID, displayName, latestConfigVersionNo);
                }
                if (this.dbConfigData == null) {
                    FAServerUtil.removeFromCurrentComplianceProcesses(rID);
                    this.releaseLocks(rID, displayName, "policyProcess");
                    this.releaseGlobalLocks();
                    return this.bundle.getString("CompliancePage_Config_Read_Error");
                }
                if (userInput != null) {
                    userInputHashMap = this.csu.parseUserInput(userInput);
                    this.csu.dumpUserInputsIntoDB(rID, userInputHashMap, this.deviceType, displayName);
                    FAServerUtil.removeFromCurrentUserInputProcesses(rID);
                    if ("true".equals(isServiceChanged)) {
                        excludedServices = userInputHashMap.get("ServiceExclude");
                        this.csu.handleExcludeServices(rID, excludedServices, displayName, true);
                    }
                }
                if (latestConfigVersionNo < 1L) {
                    long start = System.currentTimeMillis();
                    boolean success = this.parseNow(rID, displayName, latestConfigVersionNo);
                    long totalTimeTaken = System.currentTimeMillis() - start;
                    LOGGER.info("ComplianceGenerator....Total time taken for parsing and dumping into DB:::" + totalTimeTaken);
                    if (!success) {
                        FAServerUtil.removeFromCurrentComplianceProcesses(rID);
                        this.releaseLocks(rID, displayName, "policyProcess");
                        this.releaseGlobalLocks();
                        return this.bundle.getString("CompliancePage_Parse_Error");
                    }
                }
                if (!(userInputsExists = this.csu.checkForUserInputs(rID, displayName))) {
                    FAServerUtil.removeFromCurrentComplianceProcesses(rID);
                    this.releaseLocks(rID, displayName, "policyProcess");
                    this.releaseGlobalLocks();
                    return this.bundle.getString("CompliancePage_No_User_Inputs");
                }
            } else if (userInput != null) {
                userInputHashMap = this.csu.parseUserInput(userInput);
                this.csu.dumpUserInputsIntoDB(rID, userInputHashMap, this.deviceType, displayName);
                this.csu.updateRuleDetailsBasedOnUserInput(rID, displayName, this.deviceType, latestConfigVersionNo);
                FAServerUtil.removeFromCurrentUserInputProcesses(rID);
                if ("true".equals(isServiceChanged)) {
                    excludedServices = userInputHashMap.get("ServiceExclude");
                    this.csu.handleExcludeServices(rID, excludedServices, displayName, true);
                }
            }
            this.loadSectionVsRBBMap(complianceReportName, displayName);
            this.loadCheckListDetails();
            String reportBasicInfo = null;
            String reportNameToDisplay = null;
            String rbbgName = null;
            if ("PCI DSS".equals(complianceReportName)) {
                reportBasicInfo = this.bundle.getString("PCIBasicInfo");
                reportNameToDisplay = this.bundle.getString("PCIComplainceReportName");
                rbbgName = "PCI-DSS Compliance Queries";
            } else if ("SANS".equals(complianceReportName)) {
                reportBasicInfo = this.bundle.getString("SANSBasicInfo");
                reportNameToDisplay = this.bundle.getString("SANSComplainceReportName");
                rbbgName = "SANS Compliance Queries";
            } else if ("NIST".equals(complianceReportName)) {
                reportBasicInfo = this.bundle.getString("NISTBasicInfo");
                reportNameToDisplay = this.bundle.getString("NISTComplainceReportName");
                rbbgName = "NIST Compliance Queries";
            } else if ("ISO".equals(complianceReportName)) {
                reportBasicInfo = this.bundle.getString("ISOBasicInfo");
                reportNameToDisplay = this.bundle.getString("ISOComplainceReportName");
                rbbgName = "ISO Compliance Queries";
            } else if ("NERC-CIP".equals(complianceReportName)) {
                reportBasicInfo = this.bundle.getString("NERCBasicInfo");
                reportNameToDisplay = this.bundle.getString("NERCComplainceReportName");
                rbbgName = "NERC-CIP Compliance Queries";
            }
            this.loadQueriesIntoMemory(rptID, rbbgName, displayName);
            HashMap<String, String> sectionVsStatusMap = new HashMap<String, String>();
            int[] resultsCount = null;
            resultsCount = this.generateComplianceReport(rID, rptID, displayName, complianceReportName, sectionVsStatusMap, latestConfigVersionNo);
            int passCount = resultsCount[0];
            int userCallCount = resultsCount[1];
            int totalSections = this.sectionVsFWASectionID.size();
            int totalNonUserCallSectionCount = (totalSections -= this.sectionAppendMap.size()) - userCallCount;
            int failedCount = totalNonUserCallSectionCount - passCount;
            String ruleCompliantDesc = null;
            double compliantPercentage = passCount * 100 / totalNonUserCallSectionCount;
            String compliantPerc = String.valueOf(Math.round(compliantPercentage));
            ruleCompliantDesc = compliantPercentage <= 50.0 ? this.bundle.getString("LessCompliant") : (compliantPercentage > 50.0 && compliantPercentage <= 75.0 ? this.bundle.getString("ModerateCompliant") : (compliantPercentage > 75.0 && compliantPercentage < 100.0 ? this.bundle.getString("MoreCompliant") : this.bundle.getString("TotallyCompliant")));
            Timestamp reportDate = new Timestamp(System.currentTimeMillis());
            String reportGenTime = ((Date)reportDate).toString();
            int colonIndex = reportGenTime.lastIndexOf(":");
            if (colonIndex > -1) {
                reportGenTime = reportGenTime.substring(0, colonIndex);
            }
            this.dumpDashboardInfoIntoDB(rID, displayName, latestConfigVersionNo, reportGenTime, compliantPerc, failedCount, userCallCount, passCount, totalSections, complianceReportName, ruleCompliantDesc);
            this.dumpSummaryInfoIntoDB(rID, displayName, reportGenTime, latestConfigVersionNo, sectionVsStatusMap, complianceReportName);
            JSONArray sectionOrderJSONArray = new JSONArray(this.sectionList);
            this.sectionList.clear();
            this.mainJson.put("sectionDisplayOrder", (Object)sectionOrderJSONArray);
            this.mainJson.put("reportName", (Object)reportNameToDisplay);
            this.mainJson.put("reportDate", (Object)reportGenTime);
            this.mainJson.put("reportDesc", (Object)reportBasicInfo);
            this.mainJson.put("ruleConfigPerc", (Object)compliantPerc);
            this.mainJson.put("ruleVer", (Object)latestConfigVersionNo.toString());
            this.mainJson.put("ruleConfigDesc", (Object)ruleCompliantDesc);
            this.mainJson.put("totalSectionCount", (Object)("" + totalSections));
            this.mainJson.put("failedSectionCount", (Object)("" + failedCount));
            this.mainJson.put("passSectionCount", (Object)("" + passCount));
            this.mainJson.put("userCallSectionCount", (Object)("" + userCallCount));
            JSONObject userInputJSON = new JSONObject();
            userInputJSON.put("netSuggest", (Object)this.csu.getActiveInterfaceJSONArray(rID));
            Criteria crit = new Criteria(new Column("ComplianceUserInputs", "RID"), (Object)rID, 0);
            DataObject userInputDO = DataAccess.get((String)"ComplianceUserInputs", (Criteria)crit);
            if (!userInputDO.isEmpty()) {
                HashMap<String, String> userInputMap = new HashMap<String, String>();
                userInputMap.put("LAN", (String)userInputDO.getFirstValue("ComplianceUserInputs", "LAN_INTERFACE"));
                userInputMap.put("WAN", (String)userInputDO.getFirstValue("ComplianceUserInputs", "WAN_INTERFACE"));
                userInputMap.put("DMZ", (String)userInputDO.getFirstValue("ComplianceUserInputs", "DMZ_INTERFACE"));
                userInputMap.put("PCI Zone", (String)userInputDO.getFirstValue("ComplianceUserInputs", "PCIZone_INTERFACE"));
                userInputMap.put("Service Allowed", (String)userInputDO.getFirstValue("ComplianceUserInputs", "SERVICES_ALLOWED"));
                String inputInfo = null;
                List<String> inputList = null;
                JSONArray inputJSONArray = null;
                for (Map.Entry mapEntry : userInputMap.entrySet()) {
                    inputInfo = (String)mapEntry.getValue();
                    if (inputInfo == null) continue;
                    inputList = Arrays.asList(inputInfo.split(","));
                    inputJSONArray = new JSONArray(inputList);
                    userInputJSON.put((String)mapEntry.getKey(), (Object)inputJSONArray);
                }
            }
            this.mainJson.put("netWorkDetails", (Object)userInputJSON);
            this.saveJSONToFlatFile(rID, this.mainJson.toString(), complianceReportName, displayName, resourceName);
            this.cleanupMemory();
            FAServerUtil.removeFromCurrentComplianceProcesses(rID);
            this.releaseLocks(rID, displayName, "policyProcess");
            this.releaseGlobalLocks();
            if (userInput != null) {
                return "success";
            }
            return null;
        }
        catch (Exception ee) {
            FAServerUtil.removeFromCurrentComplianceProcesses(rID);
            throw new Exception("ComplianceScheduleUtility:::Exception while regenerating " + complianceReportName + " Compliant Report...for firewall " + displayName, ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocks(Long resID, String displayName, String lockTypes) {
        String[] locks;
        for (String lockType : locks = lockTypes.split(",")) {
            try {
                Object waitLock;
                Object object = waitLock = DynamicLocks.getLockFor(resID + "_" + lockType);
                synchronized (object) {
                    waitLock.notifyAll();
                }
            }
            catch (Exception ee) {
                LOGGER.info("ComplianceGenerator:::Exception while releasing " + lockType + " lock for the firewall ..." + displayName);
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseGlobalLocks() {
        if (!FAServerUtil.isComplianceGeneratingNow()) {
            Object[] globalLocks = new Object[]{FAServerUtil.GLOBALEXCLUDESERVICELOCK, FAServerUtil.GLOBALNONSERVICEFALSEPOSITIVELOCK};
            for (Object waitLock : globalLocks) {
                try {
                    Object object = waitLock;
                    synchronized (object) {
                        waitLock.notifyAll();
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("ComplianceGenerator:::Exception while releasing global locks...");
                    ee.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private JSONArray constructJSONWithCheckList(Long rID, String displayName, ArrayList<Long> genericIDList, ArrayList<String> checkListStatusList, boolean showCheckListAsData, ArrayList<String> failedGenericServiceList, ArrayList<String> sectionBasedGenericIDRecommendationList) throws Exception {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        boolean sectionData = false;
        Long[] genericIDs = new Long[genericIDList.size()];
        int i = 0;
        Iterator<Long> i$ = genericIDList.iterator();
        while (i$.hasNext()) {
            Long genericID;
            genericIDs[i] = genericID = i$.next();
            ++i;
        }
        Criteria crit = new Criteria(new Column("ConfigCheckListStatusSummary", "RID"), (Object)rID, 0);
        DataObject configCheckListDO = DataAccess.get((String)"ConfigCheckListStatusSummary", (Criteria)(crit = crit.and(new Criteria(new Column("ConfigCheckListStatusSummary", "GENERIC_SECTION_ID"), (Object)genericIDs, 8))));
        if (!configCheckListDO.isEmpty()) {
            Iterator itr = configCheckListDO.getRows("ConfigCheckListStatusSummary");
            while (itr.hasNext()) {
                String genericSecID;
                String sectionColumn;
                String status;
                JSONObject rowData;
                Long thisGenericID;
                block14: {
                    Row row = (Row)itr.next();
                    thisGenericID = (Long)row.get("GENERIC_SECTION_ID");
                    if (this.disabledGenericIDList.contains(thisGenericID)) continue;
                    rowData = new JSONObject();
                    if (!sectionData) {
                        sectionData = true;
                    }
                    status = (String)row.get("STATUS");
                    sectionColumn = this.bundle.getString("Details");
                    if (showCheckListAsData) {
                        String data = (String)row.get("DATA");
                        if ("Fail".equals(status)) {
                            sectionBasedGenericIDRecommendationList.add(this.bundle.getString("GenericID_" + thisGenericID + "_Recommendation"));
                        }
                        if (data != null && !"".equals(data.trim())) {
                            rowData.put(sectionColumn, (Object)data);
                            break block14;
                        } else {
                            checkListStatusList.add(status);
                            return null;
                        }
                    }
                    String description = this.bundle.getString("GenericID_" + thisGenericID + "_DESCRIPTION");
                    rowData.put(sectionColumn, (Object)description);
                    if (!"Pass".equals(status)) {
                        String data = (String)row.get("DATA");
                        failedGenericServiceList.add(thisGenericID.toString());
                        rowData.put("sectionData", (Object)data);
                        rowData.put("popUpTitle", (Object)this.bundle.getString("GenericID_" + thisGenericID + "_PopupTitle"));
                    }
                }
                if (NON_SERVICEBASED_FALSEPOSITIVE_GENERIC_CHECKLIST.contains(genericSecID = thisGenericID.toString())) {
                    if ("Fail".equals(status)) {
                        rowData.put("showFalsePositive", (Object)"true");
                    } else if ("UserCall".equals(status)) {
                        rowData.put("showFalsePositive", (Object)"false");
                    }
                    rowData.put("genericSectionID", (Object)genericSecID);
                }
                checkListStatusList.add(status);
                sectionColumn = this.bundle.getString("STATUS");
                rowData.put(sectionColumn, (Object)status);
                resultList.add(rowData);
            }
        }
        if (!sectionData) {
            return null;
        }
        return new JSONArray(resultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int[] generateComplianceReport(Long rID, Long reportID, String displayName, String compliantReportType, HashMap<String, String> sectionVsStatusMap, Long versionNo) throws Exception {
        noExplictDenySectionList = Arrays.asList(ComplianceGenerator.NO_EXPLICIT_DENY_RULE_SECTION_ARRAY);
        countResults = new int[2];
        passCount = 0;
        userCallCount = 0;
        allResultObj = new JSONObject();
        allQueryResultList = new ArrayList<JSONObject>();
        try {
            section = null;
            sectionRBBs = null;
            sectionGenericIDs = null;
            sectionStatus = null;
            queryBasedSectionStatus = null;
            checkListBasedSectionStatus = null;
            rbbToSkip = null;
            sectionRBBData = false;
            sectionCheckListData = false;
            toAppend = false;
            hasRBB = false;
            hasCheckList = false;
            currentJsonObj = null;
            currentSectionColListObject = null;
            currentSectionQueryJsonResult = null;
            baseJSONMap = new HashMap<String, JSONObject>();
            subSectionStatusMap = new HashMap<String, String>();
            subSectionHasQueryDataTrackMap = new HashMap<String, String>();
            subSectionHasCheckListDataTrackMap = new HashMap<String, String>();
            sectionBasedSecurityAuditJSONList = new ArrayList<JSONObject>();
            sectionBasedGenericIDRecommendationList = new ArrayList<String>();
            sectionSpecificSecurityAuditStatusList = new ArrayList<String>();
            failedGenericServiceList = null;
            sectionRecommendation = new HashMap<String, String>();
            i$ = this.sectionVsFWASectionID.entrySet().iterator();
lbl33:
            // 4 sources

            while (true) {
                block69: {
                    if (!i$.hasNext()) break block69;
                    entry = i$.next();
                    sectionRBBData = false;
                    sectionCheckListData = false;
                    hasRBB = false;
                    hasCheckList = false;
                    rbbToSkip = null;
                    sectionStatus = null;
                    queryBasedSectionStatus = null;
                    checkListBasedSectionStatus = null;
                    failedGenericServiceList = new ArrayList<String>();
                    section = entry.getKey();
                    sectionRBBs = this.sectionVsRBBs.get(section);
                    sectionGenericIDs = this.sectionVsGenericIDs.get(section);
                    if (noExplictDenySectionList.contains(compliantReportType + "_" + section) && !"Cisco".equals(this.deviceType)) {
                        rbbToSkip = compliantReportType + "_No Explicit Deny Rule";
                    }
                    sectionJsonObj = null;
                    if (this.sectionAppendMap != null && this.sectionAppendMap.containsKey(section)) {
                        toAppend = true;
                        sectionJsonObj = currentJsonObj;
                        baseSection = this.sectionAppendMap.get(section);
                        baseJSONMap.put(baseSection, currentJsonObj);
                    } else {
                        toAppend = false;
                        if (!baseJSONMap.isEmpty() || !sectionBasedSecurityAuditJSONList.isEmpty()) {
                            baseSectionStatus = this.appendAllSubSectionsToBaseSection(currentJsonObj, baseJSONMap, subSectionHasQueryDataTrackMap, subSectionHasCheckListDataTrackMap, compliantReportType, subSectionStatusMap, currentSectionColListObject, currentSectionQueryJsonResult, sectionBasedSecurityAuditJSONList, allQueryResultList, sectionSpecificSecurityAuditStatusList, sectionVsStatusMap, sectionBasedGenericIDRecommendationList, sectionRecommendation);
                            if ("Pass".equals(baseSectionStatus)) {
                                ++passCount;
                            } else if ("UserCall".equals(baseSectionStatus)) {
                                ++userCallCount;
                            }
                            baseJSONMap.clear();
                            subSectionHasQueryDataTrackMap.clear();
                            subSectionHasCheckListDataTrackMap.clear();
                            subSectionStatusMap.clear();
                            sectionBasedSecurityAuditJSONList.clear();
                            sectionBasedGenericIDRecommendationList.clear();
                        }
                        this.sectionList.add(section);
                        currentJsonObj = sectionJsonObj = new JSONObject();
                        currentSectionColListObject = new JSONObject();
                        currentSectionQueryJsonResult = new JSONObject();
                        sectionJsonObj.put("rule", (Object)section);
                        sectionDesc = this.bundle.getString(compliantReportType + "_" + section);
                        sectionJsonObj.put("Description", (Object)sectionDesc);
                    }
                    if (sectionRBBs != null && !"".equals(sectionRBBs.trim())) {
                        hasRBB = true;
                        sectionColListObject = null;
                        sectionQueryJsonResult = null;
                        if (toAppend) {
                            sectionColListObject = currentSectionColListObject;
                            sectionQueryJsonResult = currentSectionQueryJsonResult;
                        } else {
                            sectionColListObject = new JSONObject();
                            sectionQueryJsonResult = new JSONObject();
                            currentSectionColListObject = sectionColListObject;
                            currentSectionQueryJsonResult = sectionQueryJsonResult;
                        }
                        arr$ = var42_45 = sectionRBBs.split(",");
                        len$ = arr$.length;
                        i$ = 0;
                        break;
                    }
                    ** GOTO lbl209
                }
                if (!baseJSONMap.isEmpty() || !sectionBasedSecurityAuditJSONList.isEmpty()) {
                    baseSectionStatus = this.appendAllSubSectionsToBaseSection(currentJsonObj, baseJSONMap, subSectionHasQueryDataTrackMap, subSectionHasCheckListDataTrackMap, compliantReportType, subSectionStatusMap, currentSectionColListObject, currentSectionQueryJsonResult, sectionBasedSecurityAuditJSONList, allQueryResultList, sectionSpecificSecurityAuditStatusList, sectionVsStatusMap, sectionBasedGenericIDRecommendationList, sectionRecommendation);
                    if ("Pass".equals(baseSectionStatus)) {
                        ++passCount;
                    } else if ("UserCall".equals(sectionStatus)) {
                        ++userCallCount;
                    }
                    baseJSONMap.clear();
                    subSectionHasQueryDataTrackMap.clear();
                    subSectionHasCheckListDataTrackMap.clear();
                    subSectionStatusMap.clear();
                    sectionBasedSecurityAuditJSONList.clear();
                    sectionBasedGenericIDRecommendationList.clear();
                }
                if (!sectionRecommendation.isEmpty()) {
                    this.mainJson.put("checkListRec", (Object)new JSONObject(sectionRecommendation));
                }
                allResultJSONArray = new JSONArray(allQueryResultList);
                allResultObj.put(compliantReportType + " Summary", (Object)allResultJSONArray);
                this.mainJson.put("reportRes", (Object)allResultObj);
                baseJSONMap = null;
                subSectionStatusMap = null;
                subSectionHasQueryDataTrackMap = null;
                subSectionHasCheckListDataTrackMap = null;
                sectionSpecificSecurityAuditStatusList = null;
                sectionSpecificSecurityAuditStatusList = null;
                countResults[0] = passCount;
                countResults[1] = userCallCount;
                return countResults;
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while executing " + compliantReportType + " Compliant sections...for firewall " + displayName, ee);
        }
        while (true) {
            block71: {
                block74: {
                    block73: {
                        block75: {
                            block70: {
                                block72: {
                                    if (i$ >= len$) break block70;
                                    rbb = arr$[i$];
                                    if (rbb.equals(rbbToSkip)) break block71;
                                    hasData = false;
                                    thisRbbStatus = "false";
                                    query = this.rbbVsQuery.get(rbb);
                                    sectionColListString = this.rbbVsColList.get(rbb);
                                    title = this.rbbVsTitle.get(rbb);
                                    rbbStatusDecider = this.rbbVsStatusDeciderMap.get(rbb);
                                    rbbDataDisplayType = this.rbbVsDataDisplayType.get(rbb);
                                    queryResult = this.getQueryResultIntoJSONArray(rID, reportID, rbb, query, section, displayName, compliantReportType, sectionJsonObj, sectionVsStatusMap);
                                    v0 = hasData = queryResult.length() > 0;
                                    if (rbbStatusDecider.equals("Fail")) {
                                        thisRbbStatus = hasData != false ? "Fail" : "Pass";
                                    } else if (rbbStatusDecider.equals("UserCall")) {
                                        thisRbbStatus = "UserCall";
                                    } else if (rbbStatusDecider.equals("Pass")) {
                                        v1 = thisRbbStatus = hasData != false ? "Pass" : "Fail";
                                    }
                                    if (!"Fail".equals(queryBasedSectionStatus)) {
                                        if (rbbStatusDecider.equals("Fail")) {
                                            queryBasedSectionStatus = hasData != false ? "Fail" : ("UserCall".equals(queryBasedSectionStatus) == false ? "Pass" : "UserCall");
                                        } else if (rbbStatusDecider.equals("UserCall")) {
                                            queryBasedSectionStatus = "UserCall";
                                        } else if (rbbStatusDecider.equals("Pass") && !"UserCall".equals(queryBasedSectionStatus)) {
                                            queryBasedSectionStatus = hasData != false ? "Pass" : "Fail";
                                        }
                                    }
                                    v2 = statusBasedDesc = this.statusBasedSectionDescList != null && this.statusBasedSectionDescList.contains(section) != false;
                                    if (!toAppend) {
                                        title = statusBasedDesc != false ? this.bundle.getString(compliantReportType + "_" + section + "_" + thisRbbStatus) : title;
                                    } else {
                                        title = this.bundle.getString(compliantReportType + "_" + section);
                                        title = statusBasedDesc != false ? this.bundle.getString(compliantReportType + "_" + section + "_" + thisRbbStatus) : title;
                                        title = section + " " + title;
                                    }
                                    if (!hasData) {
                                        noDataText = null;
                                        noDataText = toAppend == false ? this.bundle.getString("No_String") + " " + title : this.bundle.getString(compliantReportType + "_" + section + "_NoData");
                                        rowDataList = new ArrayList<JSONObject>();
                                        rowData = new JSONObject();
                                        rowData.put("NoData", (Object)noDataText);
                                        rowDataList.add(rowData);
                                        queryResult = new JSONArray(rowDataList);
                                    } else if (!sectionRBBData) {
                                        if (!toAppend) {
                                            sectionRBBData = true;
                                        } else {
                                            subSectionHasQueryDataTrackMap.put(section, "true");
                                        }
                                    }
                                    sectionQueryJsonResult.put(title, (Object)queryResult);
                                    sectionColArray = sectionColListString.split(",");
                                    sectionColList = new ArrayList<String>();
                                    if (!rbbDataDisplayType.equals("Table")) break block72;
                                    arr$ = sectionColArray;
                                    len$ = arr$.length;
                                    break block73;
                                }
                                sectionCol = this.bundle.getString("Details");
                                sectionColList.add(sectionCol);
                                sectionCol = this.bundle.getString("Status");
                                sectionColList.add(sectionCol);
                                break block74;
                            }
                            if (!toAppend) {
                                sectionQueryJsonResult.put("colList", (Object)sectionColListObject);
                                sectionJsonObj.put("ruleDetail", (Object)sectionQueryJsonResult);
                            }
lbl209:
                            // 4 sources

                            if (sectionGenericIDs != null && !"".equals(sectionGenericIDs.trim())) {
                                hasCheckList = true;
                                try {
                                    genericIDs = sectionGenericIDs.split(",");
                                    genericIDList = new ArrayList<Long>();
                                    for (String genericID : genericIDs) {
                                        genericIDAsLong = new Long(genericID);
                                        if (this.disabledGenericIDList.contains(genericIDAsLong)) continue;
                                        genericIDList.add(genericIDAsLong);
                                    }
                                    var42_47 = ComplianceGenerator.CHECKLIST_SYNCOBJ;
                                    // MONITORENTER : com.adventnet.fa.server.ComplianceGenerator.CHECKLIST_SYNCOBJ
                                    checkListDetailsToExecuteNow = this.getTheUnExecutedCheckListDetails(rID, versionNo, genericIDList);
                                    if (checkListDetailsToExecuteNow != null && !checkListDetailsToExecuteNow.isEmpty()) {
                                        this.executeCheckListAndUpdateDataInToDB(rID, reportID, displayName, checkListDetailsToExecuteNow, versionNo);
                                    }
                                    // MONITOREXIT : var42_47
                                    var42_48 = this.genericSecurityAuditDataDisplayList.contains(section);
                                    checkListStatusList = new ArrayList<String>();
                                    sectionCheckListJsonResult = this.constructJSONWithCheckList(rID, displayName, genericIDList, checkListStatusList, var42_48, failedGenericServiceList, sectionBasedGenericIDRecommendationList);
                                    sectionSecurityAuditJSONObject = new JSONObject();
                                    if (sectionCheckListJsonResult != null) {
                                        sectionCheckListData = true;
                                        sectionSecurityAuditJSONObject.put("DATA", (Object)sectionCheckListJsonResult);
                                        if (!var42_48) {
                                            sectionSecurityAuditJSONObject.put("SpecialTreatment", (Object)"true");
                                        }
                                    } else {
                                        noDataStr = this.bundle.getString(compliantReportType + "_" + section + "_NoData");
                                        sectionSecurityAuditJSONObject.put("NoData", (Object)noDataStr);
                                    }
                                    checkListTitle = "";
                                    v3 = statusBasedDesc = this.statusBasedSectionDescList != null && this.statusBasedSectionDescList.contains(section) != false;
                                    if (toAppend) {
                                        thisCheckListStatus = this.statusDeciderFromList(checkListStatusList);
                                        checkListTitle = statusBasedDesc != false ? this.bundle.getString(compliantReportType + "_" + section + "_" + thisCheckListStatus) : this.bundle.getString(compliantReportType + "_" + section);
                                        checkListTitle = section + " " + checkListTitle;
                                    } else {
                                        checkListTitle = hasRBB ? (!var42_48 ? this.bundle.getString("CommoncheckListString") : this.bundle.getString(compliantReportType + "_" + section)) : "";
                                    }
                                    detailsColName = this.bundle.getString("Details");
                                    statusColName = this.bundle.getString("Status");
                                    sectionSecurityAuditJSONObject.put("ColList", (Object)(detailsColName + "," + statusColName));
                                    sectionSecurityAuditJSONObject.put("Title", (Object)checkListTitle);
                                    sectionBasedSecurityAuditJSONList.add(sectionSecurityAuditJSONObject);
                                    if (sectionCheckListData && !toAppend) {
                                        sectionBasedSecurityAuditJSONArray = new JSONArray(sectionBasedSecurityAuditJSONList);
                                        sectionJsonObj.put("checkListDetail", (Object)sectionBasedSecurityAuditJSONArray);
                                        sectionBasedSecurityAuditJSONList.clear();
                                        sectionBasedGenericIDRecommendationList.clear();
                                        checkListBasedSectionStatus = this.statusDeciderFromList(checkListStatusList);
                                    } else {
                                        sectionSpecificSecurityAuditStatusList.addAll(checkListStatusList);
                                        if (sectionCheckListData) {
                                            subSectionHasCheckListDataTrackMap.put(section, "true");
                                        }
                                    }
                                    if (!toAppend && !sectionBasedSecurityAuditJSONList.isEmpty()) {
                                        sectionBasedSecurityAuditJSONList.clear();
                                        sectionBasedGenericIDRecommendationList.clear();
                                    }
                                }
                                catch (Exception ee) {
                                    ComplianceGenerator.LOGGER.info("ComplianceGenerator::::Problem while processing checklist for the resource..." + displayName + " and for the section::" + section + " of " + compliantReportType + " compliance");
                                    ee.printStackTrace();
                                }
                            }
                            sectionStatus = queryBasedSectionStatus != null || checkListBasedSectionStatus != null ? this.sectionStatusDeciderBasedOnTwoStatus(queryBasedSectionStatus, checkListBasedSectionStatus) : this.getDefaultStatus(section);
                            if (toAppend || this.sectionAppendMap.containsValue(section)) break block75;
                            if (!sectionJsonObj.has("Status")) {
                                userCallSectionList = this.getDefaultUserCallSectionList(compliantReportType);
                                if (userCallSectionList.contains(section) && "Fail".equals(sectionStatus)) {
                                    sectionStatus = "UserCall";
                                }
                                sectionJsonObj.put("Status", (Object)sectionStatus);
                                sectionVsStatusMap.put(section, sectionStatus);
                            }
                            if (!sectionRBBData && !sectionCheckListData && this.isSectionSpecificNoDataMsgToBeShown(section, compliantReportType)) {
                                sectionJsonObj.remove("ruleDetail");
                                noDataText = this.bundle.getString(compliantReportType + "_" + section + "_" + "NoData");
                                sectionJsonObj.put("NoData", (Object)noDataText);
                            }
                            if ("Fail".equals(sectionStatus)) {
                                if (hasCheckList) {
                                    insecureServiceBuilder = new StringBuilder();
                                    excludeServiceJSONArray = this.getExcludeServicesJSONArray(failedGenericServiceList, insecureServiceBuilder);
                                    if (insecureServiceBuilder.length() > 0) {
                                        var42_49 = insecureServiceBuilder.substring(0, insecureServiceBuilder.lastIndexOf(","));
                                        genericRecommendation = this.bundle.getString("Generic_Recommendation");
                                        genericRecommendation = genericRecommendation.replaceAll("xxx", var42_49);
                                        sectionJsonObj.put("excludeServiceList", (Object)excludeServiceJSONArray);
                                        sectionJsonObj.put("sectionRecommendation", (Object)genericRecommendation);
                                        sectionRecommendation.put(section, genericRecommendation);
                                    }
                                } else {
                                    recommendation = this.bundle.getString(compliantReportType + "_" + section + "_" + "Recommendation");
                                    sectionJsonObj.put("sectionRecommendation", (Object)recommendation);
                                }
                            }
                            if ("Pass".equals(statusCountCheck = (String)sectionJsonObj.get("Status"))) {
                                ++passCount;
                            } else if ("UserCall".equals(statusCountCheck)) {
                                ++userCallCount;
                            }
                            allQueryResultList.add(sectionJsonObj);
                            ** GOTO lbl33
                        }
                        if (this.sectionAppendMap.containsValue(section)) ** GOTO lbl33
                        subSectionStatusMap.put(section, sectionStatus);
                        ** continue;
                    }
                    for (i$ = 0; i$ < len$; ++i$) {
                        sectionCol = arr$[i$];
                        if (sectionCol.equals("RULE_SRC")) {
                            sectionCol = "RULE_SOURCE";
                        } else if (sectionCol.equals("RULE_DST")) {
                            sectionCol = "Destination";
                        }
                        sectionCol = this.bundle.getString(sectionCol);
                        sectionColList.add(sectionCol);
                    }
                }
                sectionColListJSONArray = new JSONArray(sectionColList);
                sectionColListObject.put(title, (Object)sectionColListJSONArray);
            }
            ++i$;
        }
    }

    private List<String> getDefaultUserCallSectionList(String compliantReportType) {
        List<String> listToReturn = null;
        if ("PCI DSS".equals(compliantReportType)) {
            listToReturn = Arrays.asList(PCI_DEFAULT_USERCALL_SECTION_ARRAY);
        } else if ("SANS".equals(compliantReportType)) {
            listToReturn = Arrays.asList(SANS_DEFAULT_USERCALL_SECTION_ARRAY);
        } else if ("NIST".equals(compliantReportType)) {
            listToReturn = Arrays.asList(NIST_DEFAULT_USERCALL_SECTION_ARRAY);
        } else if ("ISO".equals(compliantReportType)) {
            listToReturn = Arrays.asList(ISO_DEFAULT_USERCALL_SECTION_ARRAY);
        } else if ("NERC-CIP".equals(compliantReportType)) {
            listToReturn = Arrays.asList(NERC_DEFAULT_USERCALL_SECTION_ARRAY);
        }
        return listToReturn;
    }

    private boolean isSectionSpecificNoDataMsgToBeShown(String sectionName, String compliantReportType) {
        List<String> listToReturn = this.getDefaultUserCallSectionList(compliantReportType);
        return listToReturn.contains(sectionName);
    }

    private String statusDeciderFromMap(HashMap<String, String> statusMap) {
        String status = null;
        for (Map.Entry<String, String> entry : statusMap.entrySet()) {
            String tmpStatus = entry.getValue();
            if (!"Fail".equals(tmpStatus)) {
                if ("UserCall".equals(tmpStatus)) {
                    status = "UserCall";
                    continue;
                }
                if (!"Pass".equals(tmpStatus) || "UserCall".equals(status)) continue;
                status = "Pass";
                continue;
            }
            status = "Fail";
            break;
        }
        return status;
    }

    private String appendAllSubSectionsToBaseSection(JSONObject currentJsonObj, HashMap<String, JSONObject> baseJSONMap, HashMap<String, String> subSectionHasQueryDataTrackMap, HashMap<String, String> subSectionHasCheckListDataTrackMap, String compliantReportType, HashMap<String, String> subSectionStatusMap, JSONObject currentSectionColListObject, JSONObject currentSectionQueryJsonResult, ArrayList<JSONObject> sectionBasedSecurityAuditJSONList, List<JSONObject> allQueryResultList, ArrayList<String> sectionSpecificSecurityAuditStatusList, HashMap<String, String> sectionVsStatusMap, ArrayList<String> sectionBasedGenericIDRecommendationList, Map sectionRec) throws Exception {
        String baseSectionStatus = null;
        JSONObject baseJSONObject = currentJsonObj;
        String baseRBBSectionStatus = null;
        String baseSecurityAuditSectionStatus = null;
        Object[] keySetArray = baseJSONMap.keySet().toArray();
        String baseSectionID = (String)keySetArray[0];
        boolean tmpHasData = false;
        if (!subSectionHasQueryDataTrackMap.isEmpty() || !subSectionHasCheckListDataTrackMap.isEmpty()) {
            tmpHasData = true;
        }
        if (!tmpHasData) {
            String noDataText = this.bundle.getString(compliantReportType + "_" + baseSectionID + "_" + "NoData");
            baseJSONObject.put("NoData", (Object)noDataText);
            baseSectionStatus = this.getDefaultStatus(baseSectionID);
            baseJSONObject.put("Status", (Object)baseSectionStatus);
        } else {
            if (!baseJSONMap.isEmpty()) {
                if (!subSectionHasQueryDataTrackMap.isEmpty()) {
                    currentSectionQueryJsonResult.put("colList", (Object)currentSectionColListObject);
                    baseJSONObject.put("ruleDetail", (Object)currentSectionQueryJsonResult);
                    baseRBBSectionStatus = this.statusDeciderFromMap(subSectionStatusMap);
                }
                subSectionStatusMap.clear();
            }
            if (!sectionBasedSecurityAuditJSONList.isEmpty()) {
                baseJSONObject = baseJSONObject != null ? baseJSONObject : currentJsonObj;
                JSONArray sectionBasedSecurityAuditJSONArray = new JSONArray(sectionBasedSecurityAuditJSONList);
                baseJSONObject.put("checkListDetail", (Object)sectionBasedSecurityAuditJSONArray);
                baseSecurityAuditSectionStatus = this.statusDeciderFromList(sectionSpecificSecurityAuditStatusList);
                if (!sectionBasedGenericIDRecommendationList.isEmpty()) {
                    StringBuilder sectionRecommendationBuilder = new StringBuilder();
                    for (String recommendation : sectionBasedGenericIDRecommendationList) {
                        sectionRecommendationBuilder.append(recommendation);
                        sectionRecommendationBuilder.append("<br>");
                    }
                    String sectionRecommendation = sectionRecommendationBuilder.substring(0, sectionRecommendationBuilder.lastIndexOf("<br>"));
                    baseJSONObject.put("sectionRecommendation", (Object)sectionRecommendation);
                    sectionRec.put(baseSectionID, sectionRecommendation);
                }
                sectionBasedSecurityAuditJSONList.clear();
                sectionSpecificSecurityAuditStatusList.clear();
            }
            baseSectionStatus = this.sectionStatusDeciderBasedOnTwoStatus(baseRBBSectionStatus, baseSecurityAuditSectionStatus);
            baseSectionStatus = baseRBBSectionStatus != null || baseSecurityAuditSectionStatus != null ? this.sectionStatusDeciderBasedOnTwoStatus(baseRBBSectionStatus, baseSecurityAuditSectionStatus) : this.getDefaultStatus(baseSectionID);
            sectionVsStatusMap.put(baseSectionID, baseSectionStatus);
            baseJSONObject.put("Status", (Object)baseSectionStatus);
        }
        allQueryResultList.add(baseJSONObject);
        return baseSectionStatus;
    }

    private String statusDeciderFromList(ArrayList<String> statusList) {
        String status = null;
        status = statusList.contains("Fail") ? "Fail" : (statusList.contains("UserCall") ? "UserCall" : "Pass");
        return status;
    }

    private String getDefaultStatus(String section) {
        try {
            Criteria crit = new Criteria(new Column("FWAComplianceSectionDetails", "SECTION_NAME"), (Object)section, 0);
            DataObject complianceSectionDO = DataAccess.get((String)"FWAComplianceSectionDetails", (Criteria)crit);
            if (!complianceSectionDO.isEmpty()) {
                return (String)complianceSectionDO.getFirstValue("FWAComplianceSectionDetails", "NODATA_STATUS_DECIDER");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    private String sectionStatusDeciderBasedOnTwoStatus(String queryBasedSectionStatus, String checkListBasedSectionStatus) {
        Object sectionStatus = null;
        sectionStatus = "Fail".equals(queryBasedSectionStatus) || "Fail".equals(checkListBasedSectionStatus) ? "Fail" : ("Pass".equals(queryBasedSectionStatus) && "Pass".equals(checkListBasedSectionStatus) ? "Pass" : (queryBasedSectionStatus == null && checkListBasedSectionStatus == null ? null : (queryBasedSectionStatus == null && "Pass".equals(checkListBasedSectionStatus) ? "Pass" : (checkListBasedSectionStatus == null && "Pass".equals(queryBasedSectionStatus) ? "Pass" : "UserCall"))));
        return sectionStatus;
    }

    private void dumpSummaryInfoIntoDB(Long rID, String displayName, String reportGenTime, Long latestConfigVersionNo, HashMap<String, String> sectionVsStatusMap, String complianceReportName) throws Exception {
        try {
            Criteria summaryCrit = new Criteria(new Column("ComplianceStatusSummary", "RID"), (Object)rID, 0);
            summaryCrit = summaryCrit.and(new Criteria(new Column("ComplianceStatusSummary", "COMPLIANCE_TYPE"), (Object)complianceReportName, 0));
            FAServerUtil.getPersistence().delete(summaryCrit);
            String sectionName = null;
            String status = null;
            DataObject dObj = DataAccess.constructDataObject();
            for (Map.Entry<String, String> mapEntry : sectionVsStatusMap.entrySet()) {
                Row complianceStatusSummaryRow = new Row("ComplianceStatusSummary");
                sectionName = mapEntry.getKey();
                status = mapEntry.getValue();
                complianceStatusSummaryRow.set("RID", (Object)rID);
                complianceStatusSummaryRow.set("FWA_SECTION_ID", (Object)this.sectionVsFWASectionID.get(sectionName));
                complianceStatusSummaryRow.set("STATUS", (Object)status);
                complianceStatusSummaryRow.set("VERSION_NO", (Object)latestConfigVersionNo);
                complianceStatusSummaryRow.set("LAST_GENERATED", (Object)reportGenTime);
                complianceStatusSummaryRow.set("COMPLIANCE_TYPE", (Object)complianceReportName);
                dObj.addRow(complianceStatusSummaryRow);
            }
            DataAccess.add((DataObject)dObj);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while dumping complaince results for summary into DB for the firewall " + displayName, ee);
        }
    }

    private void saveJSONToFlatFile(Long rID, String mainJson, String complianceRptName, String displayName, String resourceName) throws Exception {
        FileOutputStream fop = null;
        String folderName = "";
        try {
            String filePath;
            File file;
            folderName = "PCI DSS".equals(complianceRptName) ? "PCI_DSS" : complianceRptName;
            String dirPath = System.getProperty("server.dir") + File.separator + "server" + File.separator + "configData" + File.separator + rID + File.separator + folderName;
            File fileDirPath = new File(dirPath);
            if (!fileDirPath.exists()) {
                fileDirPath.mkdirs();
            }
            if (!(file = new File(filePath = dirPath + File.separator + resourceName + "_JSON.txt")).exists()) {
                file.createNewFile();
            }
            fop = new FileOutputStream(file);
            byte[] contentInBytes = mainJson.getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
        }
        catch (IOException ee) {
            throw new Exception("ComplianceGenerator:::Exception while saving JSON to flatfile...for the firewall " + displayName + " and for the report::" + folderName, ee);
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void dumpDashboardInfoIntoDB(Long rID, String displayName, Long latestConfigVersionNo, String reportGenTime, String compliantPerc, int failedCount, int userCallCount, int passCount, int totalSections, String complianceReportName, String ruleCompliantDesc) throws Exception {
        try {
            Criteria dashboardCrit = new Criteria(new Column("ComplianceDashboardInfo", "RID"), (Object)rID, 0);
            dashboardCrit = dashboardCrit.and(new Criteria(new Column("ComplianceDashboardInfo", "COMPLIANCE_TYPE"), (Object)complianceReportName, 0));
            FAServerUtil.getPersistence().delete(dashboardCrit);
            Row complianceDashboardInfoRow = new Row("ComplianceDashboardInfo");
            complianceDashboardInfoRow.set("RID", (Object)rID);
            complianceDashboardInfoRow.set("VERSION_NO", (Object)latestConfigVersionNo.toString());
            complianceDashboardInfoRow.set("LAST_GENERATED", (Object)reportGenTime);
            complianceDashboardInfoRow.set("COMPLIANT_PERCENTAGE", (Object)compliantPerc);
            complianceDashboardInfoRow.set("TOTAL_COUNT", (Object)("" + totalSections));
            complianceDashboardInfoRow.set("PASS_COUNT", (Object)("" + passCount));
            complianceDashboardInfoRow.set("FAILED_COUNT", (Object)("" + failedCount));
            complianceDashboardInfoRow.set("USERCALL_COUNT", (Object)("" + userCallCount));
            complianceDashboardInfoRow.set("COMPLIANCE_TYPE", (Object)complianceReportName);
            complianceDashboardInfoRow.set("COMPLIANT_DESCRIPTION", (Object)ruleCompliantDesc);
            DataObject dObj = DataAccess.constructDataObject();
            dObj.addRow(complianceDashboardInfoRow);
            DataAccess.add((DataObject)dObj);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while dumping complaince results for summary into DB for the firewall " + displayName, ee);
        }
    }

    private JSONArray checkListresultSetToJsonArray(ResultSet rs, Long rID, Long reportID, String genericCheckListColListString, String displayName) throws Exception {
        try {
            String[] genericCheckListColListArray = genericCheckListColListString.split(",");
            List<String> genericCheckListColList = Arrays.asList(genericCheckListColListArray);
            String value = null;
            String trimValue = null;
            String detailValue = null;
            ArrayList<JSONObject> rowDataList = new ArrayList<JSONObject>();
            do {
                JSONObject rowData = new JSONObject();
                for (int j = 0; j < genericCheckListColList.size(); ++j) {
                    String sectionColumn = genericCheckListColList.get(j);
                    detailValue = null;
                    value = rs.getString(sectionColumn);
                    String string = trimValue = value != null ? value.trim() : null;
                    if (sectionColumn.equals("RULE_SRC")) {
                        sectionColumn = "RULE_SOURCE";
                    } else if (sectionColumn.equals("RULE_DST")) {
                        sectionColumn = "Destination";
                    } else if (sectionColumn.equals("SERVICE")) {
                        detailValue = rs.getString("DETAILED_SERVICE");
                    }
                    if (detailValue != null) {
                        value = this.generateLink(value, detailValue, rID, displayName, sectionColumn, this.deviceType);
                    }
                    if (value == null || "".equals(trimValue)) {
                        value = "-";
                    }
                    sectionColumn = this.bundle.getString(sectionColumn);
                    rowData.put(sectionColumn, (Object)value);
                }
                rowDataList.add(rowData);
            } while (rs.next());
            JSONArray jSONArray = new JSONArray(rowDataList);
            return jSONArray;
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Inside resultSetToJsonArray...exception while processing resultset::" + rs + " for the firewall::" + displayName, ee);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCheckListQueryAndDumpIntoDB(String query, Long rID, Long reportID, String rbbColList, String statusDecider, String displayName, Long checkListID, Long versionNo) {
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        String status = null;
        String data = null;
        boolean hasData = false;
        try {
            try {
                conn = RelationalAPI.getInstance().getConnection();
                stat = conn.createStatement();
                rs = stat.executeQuery(query);
            }
            catch (Exception ee) {
                LOGGER.info("ComplianceGenerator::::Problem while executing generic section ID query:::::" + query);
                ee.printStackTrace();
            }
            if (rs.next()) {
                hasData = true;
            }
            if (statusDecider.equals("Fail")) {
                status = hasData ? "Fail" : "Pass";
            } else if (statusDecider.equals("UserCall")) {
                status = "UserCall";
            } else if (statusDecider.equals("Pass")) {
                String string = status = hasData ? "Pass" : "Fail";
            }
            if (hasData && !"Pass".equals(status)) {
                data = this.checkListresultSetToJsonArray(rs, rID, reportID, rbbColList, displayName).toString();
            }
            Criteria summaryCrit = new Criteria(new Column("ConfigCheckListStatusSummary", "RID"), (Object)rID, 0);
            summaryCrit = summaryCrit.and(new Criteria(new Column("ConfigCheckListStatusSummary", "GENERIC_SECTION_ID"), (Object)checkListID, 0));
            DataAccess.delete((Criteria)summaryCrit);
            Timestamp reportDate = new Timestamp(System.currentTimeMillis());
            String reportGenTime = ((Date)reportDate).toString();
            int colonIndex = reportGenTime.lastIndexOf(":");
            if (colonIndex > -1) {
                reportGenTime = reportGenTime.substring(0, colonIndex);
            }
            DataObject dObj = DataAccess.constructDataObject();
            Row configCheckListStatusSummaryRow = new Row("ConfigCheckListStatusSummary");
            configCheckListStatusSummaryRow.set("RID", (Object)rID);
            configCheckListStatusSummaryRow.set("GENERIC_SECTION_ID", (Object)checkListID);
            configCheckListStatusSummaryRow.set("DATA", (Object)data);
            configCheckListStatusSummaryRow.set("STATUS", (Object)status);
            configCheckListStatusSummaryRow.set("VERSION_NO", (Object)versionNo);
            configCheckListStatusSummaryRow.set("LAST_GENERATED", (Object)reportGenTime);
            dObj.addRow(configCheckListStatusSummaryRow);
            DataAccess.add((DataObject)dObj);
        }
        catch (Exception e) {
            LOGGER.info("ComplianceGenerator::::Problem while getting Query Result Into JSONArray for the resource..." + displayName + " and for the query::" + query);
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private String getReportConfigQuery(String checkListRBB, Long reportID) {
        try {
            Criteria crit = new Criteria(new Column("ReportConfigToRBBMapping", "REPORTID"), (Object)reportID, 0);
            crit = crit.and(new Criteria(new Column("ReportConfigToRBBMapping", "RBBNAME"), (Object)checkListRBB, 0));
            DataObject doo = DataAccess.get((String)"ReportConfigToRBBMapping", (Criteria)crit);
            if (!doo.isEmpty()) {
                return (String)doo.getFirstValue("ReportConfigToRBBMapping", "GENSQL");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    private void executeCheckListAndUpdateDataInToDB(Long rID, Long reportID, String displayName, ArrayList<HashMap<Long, String>> checkListDetailsToExecuteNow, Long versionNo) throws Exception {
        Long checkListID = null;
        String checkListRBB = null;
        String checkListRBBColList = null;
        String checkListStatusDecider = null;
        HashMap<Long, String> checkListVsRBB = checkListDetailsToExecuteNow.get(0);
        HashMap<Long, String> checkListVsRBBColList = checkListDetailsToExecuteNow.get(1);
        HashMap<Long, String> checkListVsRBBStatusDecider = checkListDetailsToExecuteNow.get(2);
        for (Map.Entry<Long, String> entry : checkListVsRBB.entrySet()) {
            checkListID = entry.getKey();
            checkListRBB = entry.getValue();
            if (checkListRBB != null) {
                checkListStatusDecider = checkListVsRBBStatusDecider.get(checkListID);
                checkListRBBColList = checkListVsRBBColList.get(checkListID);
                String queryToExecute = this.getReportConfigQuery(checkListRBB, reportID);
                this.executeCheckListQueryAndDumpIntoDB(queryToExecute, rID, reportID, checkListRBBColList, checkListStatusDecider, displayName, checkListID, versionNo);
                continue;
            }
            if (this.dbConfigData == null) {
                if (versionNo == null || versionNo == -1L) {
                    Properties props = this.getDeviceDetailsToFetchTheConfig(rID);
                    if (props != null && "0".equals(props.getProperty("mode"))) {
                        return;
                    }
                    this.dbConfigData = this.getConfigByconnectingToDevice(rID, props);
                    if (this.dbConfigData == null) {
                        return;
                    }
                } else if (versionNo > 0L) {
                    this.loadLatestConfigIntoMemory(rID, displayName, versionNo);
                }
            }
            PolicyProcessor pp = null;
            if ("Cisco".equals(this.deviceType)) {
                pp = new CiscoPolicyProcessor(rID, displayName, this.dbConfigData, versionNo, Boolean.TRUE);
            } else if ("FortiGate".equals(this.deviceType)) {
                pp = new FortiGatePolicyProcessor(rID, displayName, this.dbConfigData, versionNo);
            } else if ("SRX Log Format".equals(this.deviceType)) {
                pp = new SRXPolicyProcessor(rID, displayName, this.dbConfigData, versionNo);
            }
            FirewallPolicyFormat fpf = PolicyProcessorUtilityClass.getInstance().getVendorSpecificPolicyFormat("Cisco");
            if (fpf != null) {
                int checkListIDInt = checkListID.intValue();
                LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults = new LinkedHashMap<FWAEnumConstants.ParserKeys, String>();
                StringBuilder resultBuilder = new StringBuilder();
                switch (checkListIDInt) {
                    case 1: {
                        pp.parseAndProcessHttpConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                        break;
                    }
                    case 2: {
                        pp.parseAndProcessTelnetConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                        break;
                    }
                    case 3: {
                        pp.parseAndProcessSSHConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                        break;
                    }
                    case 4: {
                        pp.parseAndProcessSnmpConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                        break;
                    }
                    case 5: {
                        pp.parseAndProcessUserAccessConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                        break;
                    }
                    case 6: {
                        pp.parseAndProcessNTPConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                        break;
                    }
                    case 8: {
                        pp.parseAndProcessSyslogLoggingConfig(this.dbConfigData, fpf, parseResults, resultBuilder);
                    }
                }
                continue;
            }
            throw new Exception("No Policy Format exists for the firewall " + displayName + " of " + this.deviceType + " Vendor...");
        }
    }

    private ArrayList<HashMap<Long, String>> getTheUnExecutedCheckListDetails(Long rID, Long versionNo, ArrayList<Long> genericIDList) throws Exception {
        ArrayList<HashMap<Long, String>> genericSectionIDDetailList = new ArrayList<HashMap<Long, String>>();
        HashMap<Long, String> genericIDVsRBBQuery = null;
        HashMap<Long, String> genericIDVsRBBCols = null;
        HashMap<Long, String> genericIDVsStatusDecider = null;
        Table fwaConfigCheckListDetailsTable = new Table("FWAConfigCheckListDetails");
        Table ConfigCheckListStatusSummaryTable = new Table("ConfigCheckListStatusSummary");
        Criteria joinCrit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)new Column("ConfigCheckListStatusSummary", "GENERIC_SECTION_ID"), 0);
        joinCrit = joinCrit.and(new Criteria(new Column("ConfigCheckListStatusSummary", "RID"), (Object)rID, 0));
        Join join = new Join(fwaConfigCheckListDetailsTable, ConfigCheckListStatusSummaryTable, joinCrit, 1);
        SelectQueryImpl sql = new SelectQueryImpl(new Table("FWAConfigCheckListDetails"));
        sql.addJoin(join);
        sql.addSelectColumn(new Column("FWAConfigCheckListDetails", "*"));
        Criteria crt = new Criteria(new Column("ConfigCheckListStatusSummary", "VERSION_NO"), null, 0);
        crt = crt.or(new Criteria(new Column("ConfigCheckListStatusSummary", "VERSION_NO"), (Object)new Long("0"), 6));
        Criteria finalCrit = crt = crt.or(new Criteria(new Column("ConfigCheckListStatusSummary", "VERSION_NO"), (Object)versionNo, 7));
        sql.setCriteria(finalCrit);
        DataObject checkListDO = DataAccess.get((SelectQuery)sql);
        if (!checkListDO.isEmpty()) {
            genericIDVsRBBQuery = new HashMap<Long, String>();
            genericIDVsRBBCols = new HashMap<Long, String>();
            genericIDVsStatusDecider = new HashMap<Long, String>();
            Row fwaCheckListRow = null;
            Long sectionID = null;
            String rbbName = null;
            String statusDecider = null;
            String colsToDisplay = null;
            Iterator itr = checkListDO.getRows("FWAConfigCheckListDetails");
            while (itr.hasNext()) {
                fwaCheckListRow = (Row)itr.next();
                sectionID = (Long)fwaCheckListRow.get("GENERIC_SECTION_ID");
                if (!genericIDList.contains(sectionID)) continue;
                rbbName = (String)fwaCheckListRow.get("RBBNAME");
                colsToDisplay = (String)fwaCheckListRow.get("COLUMNS_TO_DISPLAY");
                statusDecider = (String)fwaCheckListRow.get("STATUS_DECIDER");
                genericIDVsRBBQuery.put(sectionID, rbbName);
                genericIDVsRBBCols.put(sectionID, colsToDisplay);
                genericIDVsStatusDecider.put(sectionID, statusDecider);
            }
            genericSectionIDDetailList.add(genericIDVsRBBQuery);
            genericSectionIDDetailList.add(genericIDVsRBBCols);
            genericSectionIDDetailList.add(genericIDVsStatusDecider);
        }
        return genericSectionIDDetailList;
    }

    private ArrayList<HashMap<Long, String>> getTheUnExecutedCheckListDetails_ori(Long rID, Long versionNo, ArrayList<Long> genericIDList) throws Exception {
        ArrayList<HashMap<Long, String>> genericSectionIDDetailList = new ArrayList<HashMap<Long, String>>();
        HashMap<Long, String> genericIDVsRBBQuery = null;
        HashMap<Long, String> genericIDVsRBBCols = null;
        HashMap<Long, String> genericIDVsStatusDecider = null;
        Table fwaConfigCheckListDetailsTable = new Table("FWAConfigCheckListDetails");
        Table ConfigCheckListStatusSummaryTable = new Table("ConfigCheckListStatusSummary");
        Criteria joinCrit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)new Column("ConfigCheckListStatusSummary", "GENERIC_SECTION_ID"), 0);
        joinCrit = joinCrit.and(new Criteria(new Column("ConfigCheckListStatusSummary", "RID"), (Object)rID, 0));
        Join join = new Join(fwaConfigCheckListDetailsTable, ConfigCheckListStatusSummaryTable, joinCrit, 1);
        SelectQueryImpl sql = new SelectQueryImpl(new Table("FWAConfigCheckListDetails"));
        sql.addJoin(join);
        sql.addSelectColumn(new Column("FWAConfigCheckListDetails", "*"));
        Criteria enableCrt = new Criteria(new Column("FWAConfigCheckListDetails", "ENABLE"), (Object)Boolean.TRUE, 0);
        Criteria crt = new Criteria(new Column("ConfigCheckListStatusSummary", "VERSION_NO"), null, 0);
        crt = crt.or(new Criteria(new Column("ConfigCheckListStatusSummary", "VERSION_NO"), (Object)versionNo, 7));
        Criteria finalCrit = enableCrt.and(crt);
        sql.setCriteria(finalCrit);
        DataObject checkListDO = DataAccess.get((SelectQuery)sql);
        if (!checkListDO.isEmpty()) {
            genericIDVsRBBQuery = new HashMap<Long, String>();
            genericIDVsRBBCols = new HashMap<Long, String>();
            genericIDVsStatusDecider = new HashMap<Long, String>();
            Row fwaCheckListRow = null;
            Long sectionID = null;
            String rbbName = null;
            String statusDecider = null;
            String colsToDisplay = null;
            Iterator itr = checkListDO.getRows("FWAConfigCheckListDetails");
            while (itr.hasNext()) {
                fwaCheckListRow = (Row)itr.next();
                sectionID = (Long)fwaCheckListRow.get("GENERIC_SECTION_ID");
                if (!genericIDList.contains(sectionID)) continue;
                rbbName = (String)fwaCheckListRow.get("RBBNAME");
                colsToDisplay = (String)fwaCheckListRow.get("COLUMNS_TO_DISPLAY");
                statusDecider = (String)fwaCheckListRow.get("STATUS_DECIDER");
                genericIDVsRBBQuery.put(sectionID, rbbName);
                genericIDVsRBBCols.put(sectionID, colsToDisplay);
                genericIDVsStatusDecider.put(sectionID, statusDecider);
            }
            genericSectionIDDetailList.add(genericIDVsRBBQuery);
            genericSectionIDDetailList.add(genericIDVsRBBCols);
            genericSectionIDDetailList.add(genericIDVsStatusDecider);
        }
        return genericSectionIDDetailList;
    }

    private String getHighlightedData(Long rID, String sectionColListToHightlight) {
        try {
            StringBuilder mainSB = new StringBuilder();
            String[] sectionCols = sectionColListToHightlight.split(",");
            int i = 0;
            for (String colDetails : sectionCols) {
                if (i > 0) {
                    mainSB.append("&&");
                }
                String[] colDetailsArray = colDetails.split("=");
                String colName = colDetailsArray[0];
                String colValsToHighlight = colDetailsArray[1];
                if (colName.equals("SRC_INT") || colName.equals("DST_INT")) {
                    String[] vals;
                    HashMap<String, String> interfaceVsZoneMap = PolicyProcessorUtilityClass.getResourceSpecificInterfaceVsZoneMap(rID);
                    if (interfaceVsZoneMap == null) {
                        interfaceVsZoneMap = PolicyProcessorUtilityClass.getInstance().populateInterfaceVsZoneMapFromDB(rID);
                    }
                    StringBuilder sb = new StringBuilder();
                    int j = 0;
                    for (String val : vals = colValsToHighlight.split(" and ")) {
                        if (j > 0) {
                            sb.append(",");
                        }
                        PolicyProcessorUtilityClass policyProcessorUtilityObject = new PolicyProcessorUtilityClass();
                        sb.append(policyProcessorUtilityObject.getInterfacesForTheZone(val, interfaceVsZoneMap));
                        ++j;
                    }
                    colValsToHighlight = sb.toString();
                }
                mainSB.append(this.bundle.getString(colName));
                mainSB.append("=");
                mainSB.append(colValsToHighlight);
                ++i;
            }
            return mainSB.toString();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private JSONArray resultSetToJsonArray(ResultSet rs, Long rID, Long reportID, String section, String sectionColListString, String displayName, String sectionColListToHightlight, String displayType, String compliantReportType, JSONObject sectionJsonObj, HashMap<String, String> sectionVsStatusMap) throws Exception {
        try {
            String[] defaultUserCallSectionCols = new String[]{"MODIFIED_TIME", "TO_ADDRESS", "Available_From", "GEN_COMP_RPT", "TASKNAME", "TASK_DETAILS_INFO"};
            List<String> defaultUserCallList = Arrays.asList(defaultUserCallSectionCols);
            String[] sectionColListArray = sectionColListString.split(",");
            List<String> sectionColList = Arrays.asList(sectionColListArray);
            String value = null;
            String trimValue = null;
            String detailValue = null;
            ArrayList<JSONObject> rowDataList = new ArrayList<JSONObject>();
            while (rs.next()) {
                String dataToHighlight;
                JSONObject rowData = new JSONObject();
                if (sectionColListToHightlight != null && (dataToHighlight = this.getHighlightedData(rID, sectionColListToHightlight)) != null) {
                    rowData.put("highlight", (Object)dataToHighlight);
                }
                if (displayType.equals("Table")) {
                    for (int j = 0; j < sectionColList.size(); ++j) {
                        String sectionColumn = sectionColList.get(j);
                        detailValue = null;
                        value = rs.getString(sectionColumn);
                        String string = trimValue = value != null ? value.trim() : null;
                        if (sectionColumn.equals("RULE_SRC")) {
                            detailValue = rs.getString("DETAILED_SRC");
                            sectionColumn = "RULE_SOURCE";
                        } else if (sectionColumn.equals("RULE_DST")) {
                            detailValue = rs.getString("DETAILED_DST");
                            sectionColumn = "Destination";
                        } else if (sectionColumn.equals("SERVICE")) {
                            detailValue = rs.getString("DETAILED_SERVICE");
                        }
                        if (detailValue != null) {
                            value = this.generateLink(value, detailValue, rID, displayName, sectionColumn, this.deviceType);
                        }
                        if (value == null || "".equals(trimValue)) {
                            value = "-";
                        }
                        sectionColumn = this.bundle.getString(sectionColumn);
                        rowData.put(sectionColumn, (Object)value);
                    }
                    rowDataList.add(rowData);
                    continue;
                }
                String tempVal = null;
                for (int j = 0; j < sectionColList.size(); ++j) {
                    String status;
                    rowData = new JSONObject();
                    String sectionColumn = sectionColList.get(j);
                    detailValue = null;
                    Object colValue = rs.getObject(sectionColumn);
                    String string = colValue != null ? "Pass" : (status = defaultUserCallList.contains(sectionColumn) ? "UserCall" : "Fail");
                    if (!status.equals("Pass")) {
                        sectionJsonObj.put("Status", (Object)status);
                        sectionVsStatusMap.put(section, status);
                    }
                    String valToDisplay = "";
                    if (colValue == null) {
                        valToDisplay = compliantReportType + "_" + section + "_DataListDisplayString_" + sectionColumn + "_NODATA";
                        valToDisplay = this.bundle.getString(valToDisplay);
                    } else {
                        trimValue = colValue.toString().trim();
                        valToDisplay = compliantReportType + "_" + section + "_DataListDisplayString_" + sectionColumn;
                        valToDisplay = this.bundle.getString(valToDisplay);
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Calendar cal = Calendar.getInstance();
                        String endDate = dateFormat.format(cal.getTime());
                        DataObject resDO = this.getResDO(rID);
                        String resName = null;
                        String resIP = null;
                        if (!resDO.isEmpty()) {
                            resName = (String)resDO.getFirstValue("Resources", "RESOURCENAME");
                            resIP = (String)resDO.getFirstValue("Resources", "IPADDRESS");
                        }
                        String resDetails = "&resourceName=" + resName + "&displayName=" + displayName + "&resIP=" + resIP;
                        String url = null;
                        StringBuilder sb = new StringBuilder();
                        if (sectionColumn.equals("MODIFIED_TIME")) {
                            sb.append("mindex.do?url=firereport&changeMgmtRelated=true&reportId=");
                            sb.append(reportID.toString());
                            sb.append("&tab=report&subTab=top10&resourceType=Firewall&RBBGID=");
                            sb.append(this.getRBBGID("Change_Mgmt Report"));
                            sb.append(resDetails);
                            sb.append("&show=block&flushCache=true&DateRange=true&startDate=");
                            sb.append(trimValue);
                            sb.append("&endDate=");
                            sb.append(endDate);
                            url = sb.toString();
                        } else if (sectionColumn.equals("TO_ADDRESS")) {
                            String[] tt = trimValue.split("##");
                            trimValue = tt[0];
                        } else if (sectionColumn.equals("Available_From")) {
                            sb.append("mindex.do?url=report&showExport=true&reportId=");
                            sb.append(reportID.toString());
                            sb.append("&tab=report&subTab=top10&resourceType=Firewall&RBBGID=");
                            sb.append(this.getRBBGID("Firewall Management Report"));
                            sb.append(resDetails);
                            sb.append("&show=block&flushCache=true&DateRange=true&startDate=");
                            sb.append(trimValue);
                            sb.append("&endDate=");
                            sb.append(endDate);
                            url = sb.toString();
                        } else if (sectionColumn.equals("GEN_COMP_RPT")) {
                            if ("true".equals(trimValue)) {
                                trimValue = "here";
                                sb.append("addDevCrd.do?mode=genCompRpt&FORMAT=html&report=last&resID=");
                                sb.append(rID.toString());
                                url = sb.toString();
                            } else {
                                valToDisplay = compliantReportType + "_" + section + "_DataListDisplayString_" + sectionColumn + "_NODATA";
                                valToDisplay = this.bundle.getString(valToDisplay);
                                status = "UserCall";
                                sectionJsonObj.remove("Status");
                                sectionJsonObj.put("Status", (Object)status);
                                sectionVsStatusMap.put(section, status);
                            }
                        } else {
                            Object taskName;
                            if (sectionColumn.equals("TASKNAME")) {
                                taskName = "ComplianceSTDReport_" + rID + "_" + compliantReportType + "_schtask";
                                if (!((String)taskName).equals(trimValue)) continue;
                                tempVal = "schExists";
                                continue;
                            }
                            if (sectionColumn.equals("TASK_DETAILS_INFO") && !"schExists".equals(tempVal)) {
                                taskName = new JSONArray();
                                return taskName;
                            }
                            if (sectionColumn.equals("CONF_NAME")) {
                                tempVal = trimValue;
                                continue;
                            }
                            if (sectionColumn.equals("CONF_VALUE")) {
                                if (tempVal.equalsIgnoreCase("archiveEncryption")) {
                                    if ("true".equals(trimValue)) {
                                        sectionJsonObj.put("Status", (Object)"Pass");
                                        sectionVsStatusMap.put(section, "Pass");
                                        status = "Pass";
                                        valToDisplay = this.bundle.getString("LogEnc_" + tempVal + "_Pass");
                                    } else {
                                        sectionJsonObj.put("Status", (Object)"Fail");
                                        sectionVsStatusMap.put(section, "Fail");
                                        status = "Fail";
                                        valToDisplay = this.bundle.getString("LogEnc_" + tempVal + "_Fail");
                                    }
                                } else {
                                    int intVal = Integer.parseInt(trimValue);
                                    if (intVal > 0 && intVal < 90) {
                                        sectionJsonObj.remove("Status");
                                        sectionJsonObj.put("Status", (Object)"UserCall");
                                        sectionVsStatusMap.put(section, "UserCall");
                                        status = "UserCall";
                                        valToDisplay = this.bundle.getString("NERC-CIP_" + tempVal + "_Fail");
                                    } else {
                                        valToDisplay = this.bundle.getString("NERC-CIP_" + tempVal + "_Pass");
                                    }
                                }
                            }
                        }
                        if (url != null) {
                            sb = new StringBuilder();
                            sb.append("<a href=\"javascript:showReportData('");
                            sb.append(url);
                            sb.append("')\">");
                            sb.append(trimValue);
                            sb.append("</a>");
                            trimValue = sb.toString();
                        }
                        valToDisplay = valToDisplay.replaceAll("<data>", trimValue);
                    }
                    sectionColumn = this.bundle.getString("Details");
                    rowData.put(sectionColumn, (Object)valToDisplay);
                    sectionColumn = this.bundle.getString("STATUS");
                    rowData.put(sectionColumn, (Object)status);
                    rowDataList.add(rowData);
                }
            }
            JSONArray jSONArray = new JSONArray(rowDataList);
            return jSONArray;
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Inside resultSetToJsonArray...exception while processing resultset::" + rs + " for the firewall::" + displayName, ee);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private String processObjForTreeView(String str, String displayName) throws Exception {
        try {
            String[] objs = str.split("<br>");
            StringBuffer strBuff = new StringBuffer();
            Pattern pat = Pattern.compile("(\\s+)\\S+");
            boolean groupStarted = false;
            String baseSpace = null;
            String ss = null;
            for (String obj : objs) {
                Matcher mat;
                if (obj.indexOf("(Group):") > -1) {
                    mat = pat.matcher(obj);
                    if (mat.find()) {
                        baseSpace = mat.group(1);
                    }
                    if (groupStarted) {
                        strBuff.append("@nd");
                    }
                    strBuff.append("#");
                    strBuff.append(obj.trim());
                    groupStarted = true;
                    continue;
                }
                if (groupStarted) {
                    mat = pat.matcher(obj);
                    ss = mat.find() ? mat.group(1) : "";
                    if (ss.length() > baseSpace.length()) {
                        strBuff.append("&");
                        strBuff.append(obj.trim());
                        continue;
                    }
                    strBuff.append("#");
                    strBuff.append("@nd");
                    strBuff.append(obj.trim());
                    strBuff.append("@nd");
                    groupStarted = false;
                    continue;
                }
                strBuff.append(obj.trim());
                strBuff.append("@nd");
            }
            return strBuff.toString();
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Inside processObjForTreeView link for detail object::" + str + " for the firewall::" + displayName, ee);
        }
    }

    public String generateLink(String value, String detailedValue, Long rID, String displayName, String sectionColumn, String deviceType) throws Exception {
        try {
            boolean linkExists;
            String resID = "" + rID;
            value = value != null ? value.trim() : "";
            detailedValue = detailedValue != null ? detailedValue.trim() : detailedValue;
            boolean bl = linkExists = value != null && detailedValue != null && !value.equals(detailedValue);
            if ("SERVICE".equals(sectionColumn) && "Cisco".equals(deviceType)) {
                Matcher mat = this.ciscoSrcAndDstObjExtractPatternFromRuleService.matcher(value);
                if (mat.matches()) {
                    StringBuilder sb = new StringBuilder();
                    String srcObj = mat.group(1);
                    String dstObj = mat.group(2);
                    sb.append("Source:");
                    sb.append("<a href=\"javascript:showObjectDetails('");
                    sb.append(srcObj);
                    sb.append("','Service','");
                    sb.append(resID);
                    sb.append("','true','true',this.target)\">");
                    sb.append(srcObj);
                    sb.append("</a>");
                    if (dstObj != null) {
                        sb.append("<br>");
                        sb.append("Destination:");
                        sb.append("<a href=\"javascript:showObjectDetails('");
                        sb.append(dstObj);
                        sb.append("','Service','");
                        sb.append(resID);
                        sb.append("','false','true',this.target)\">");
                        sb.append(dstObj);
                        sb.append("</a>");
                    }
                    return sb.toString();
                }
                if (linkExists) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<a href=\"javascript:showObjectDetails('");
                    sb.append(value);
                    sb.append("','");
                    sb.append(detailedValue);
                    sb.append("','");
                    sb.append(resID);
                    sb.append("','false','false',this.target)\">");
                    sb.append(value);
                    sb.append("</a>");
                    return sb.toString();
                }
                if (value.contains("|_|")) {
                    value = value.replaceAll(" \\|_\\| ", " and ");
                    value = value.replaceAll("<", "&lt;");
                    value = value.replaceAll(">", "&gt;");
                    return value;
                }
                value = value.replaceAll("<", "&lt;");
                value = value.replaceAll(">", "&gt;");
                return value;
            }
            if (linkExists) {
                StringBuilder sb = new StringBuilder();
                String[] objs = value.split("<br>");
                String valForTreeView = this.processObjForTreeView(detailedValue, displayName);
                String[] objDetails = valForTreeView.split("@nd");
                String objName = null;
                String objValue = null;
                boolean subLink = false;
                boolean queryDB = false;
                for (int z = 0; z < objs.length; ++z) {
                    queryDB = false;
                    if (z > 0) {
                        sb.append("<br>");
                    }
                    boolean bl2 = subLink = !(objName = objs[z]).equalsIgnoreCase(objValue = objDetails[z]);
                    if (subLink) {
                        queryDB = objValue.indexOf("Group") > -1;
                        sb.append("<a href=\"javascript:showObjectDetails('");
                        sb.append(objName);
                        sb.append("','");
                        if (queryDB) {
                            sb.append(objName);
                            sb.append("','");
                            sb.append(resID);
                            sb.append("','false','true',this.target)\">");
                        } else {
                            sb.append(objValue);
                            sb.append("','");
                            sb.append(resID);
                            sb.append("','false','false',this.target)\">");
                        }
                        sb.append(objName);
                        sb.append("</a>");
                        continue;
                    }
                    sb.append(objName);
                }
                return sb.toString();
            }
            return value;
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while generating link for object::" + value + " for the firewall::" + displayName, ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getQueryResultIntoJSONArray(Long rID, Long reportID, String rbb, String query, String section, String displayName, String compliantReportType, JSONObject sectionJsonObj, HashMap<String, String> sectionVsStatusMap) {
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            try {
                LOGGER.fine("ComplianceGenerator::::Executing the query:::::" + query + " for RBB:::" + rbb);
                conn = RelationalAPI.getInstance().getConnection();
                stat = conn.createStatement();
                rs = stat.executeQuery(query);
            }
            catch (Exception ee) {
                LOGGER.info("ComplianceGenerator::::Problem while executing the query:::::" + query);
                ee.printStackTrace();
                JSONArray jSONArray = null;
                try {
                    if (stat != null) {
                        stat.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ee2) {
                    ee2.printStackTrace();
                }
                return jSONArray;
            }
            String sectionColList = this.rbbVsColList.get(rbb);
            String displayType = this.rbbVsDataDisplayType.get(rbb);
            String sectionColListToHightlight = this.rbbVsHighlightColList.get(rbb);
            JSONArray jSONArray = this.resultSetToJsonArray(rs, rID, reportID, section, sectionColList, displayName, sectionColListToHightlight, displayType, compliantReportType, sectionJsonObj, sectionVsStatusMap);
            return jSONArray;
        }
        catch (Exception e) {
            LOGGER.info("ComplianceGenerator::::Problem while getting Query Result Into JSONArray for the resource..." + displayName + " and for the query::" + query);
            e.printStackTrace();
            JSONArray jSONArray = null;
            return jSONArray;
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private DataObject getResDO(Long rID) {
        try {
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)rID, 0);
            return DataAccess.get((String)"Resources", (Criteria)crit);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private Long getRBBGID(String rbbgName) {
        try {
            Criteria crit = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgName, 0);
            DataObject rbbgDO = DataAccess.get((String)"ReportBuildingBlockGroup", (Criteria)crit);
            if (!rbbgDO.isEmpty()) {
                return (Long)rbbgDO.getFirstValue("ReportBuildingBlockGroup", "RBBGID");
            }
            return null;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private void loadQueriesIntoMemory(Long rptID, String rbbgName, String displayName) throws Exception {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("ReportConfigToRBBMapping"));
            sql.addSelectColumn(new Column("ReportConfigToRBBMapping", "*"));
            String[] jCols1 = new String[]{"RBBNAME"};
            String[] jCols2 = new String[]{"RBBGID"};
            Join j1 = new Join("ReportConfigToRBBMapping", "ReportBuildingBlock", jCols1, jCols1, 2);
            sql.addJoin(j1);
            sql.addSelectColumn(new Column("ReportBuildingBlock", "*"));
            Join j2 = new Join("ReportBuildingBlock", "ReportBuildingBlockGroup", jCols2, jCols2, 2);
            sql.addJoin(j2);
            sql.addSelectColumn(new Column("ReportBuildingBlockGroup", "*"));
            Criteria crit = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgName, 0);
            crit = crit.and(new Criteria(new Column("ReportConfigToRBBMapping", "REPORTID"), (Object)rptID, 0));
            sql.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            if (!doo.isEmpty()) {
                Row row;
                Iterator itr = doo.getRows("ReportConfigToRBBMapping");
                String key = null;
                String value = null;
                while (itr.hasNext()) {
                    row = (Row)itr.next();
                    key = (String)row.get("RBBNAME");
                    value = (String)row.get("GENSQL");
                    if (key == null || value == null) continue;
                    this.rbbVsQuery.put(key, value);
                }
                itr = doo.getRows("ReportBuildingBlock");
                while (itr.hasNext()) {
                    row = (Row)itr.next();
                    key = (String)row.get("RBBNAME");
                    value = (String)row.get("TITLE");
                    value = this.bundle.getString(value);
                    if (key == null || value == null) continue;
                    this.rbbVsTitle.put(key, value);
                }
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while loading queries into Memory..for the firewall " + displayName, ee);
        }
    }

    public void loadSectionVsRBBMap(String complianceReportName, String displayName) throws Exception {
        try {
            List<String> noExplictDenySectionList = Arrays.asList(NO_EXPLICIT_DENY_RULE_SECTION_ARRAY);
            SelectQueryImpl sql = new SelectQueryImpl(new Table("FWAComplianceSectionDetails"));
            sql.addSelectColumn(new Column("FWAComplianceSectionDetails", "*"));
            sql.addSortColumn(new SortColumn("FWAComplianceSectionDetails", "FWA_SECTION_ID", true));
            Criteria crit = new Criteria(new Column("FWAComplianceSectionDetails", "COMPLIANCE_TYPE"), (Object)complianceReportName, 0);
            crit = crit.and(new Criteria(new Column("FWAComplianceSectionDetails", "ENABLE"), (Object)Boolean.TRUE, 0));
            sql.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            if (!doo.isEmpty()) {
                Iterator itr = doo.getRows("FWAComplianceSectionDetails");
                String sectionName = null;
                String sectionRBBs = null;
                String sectionBriefDesc = null;
                String sectionGenericIDs = null;
                String rbbDetailString = null;
                String checklistDisplayType = null;
                boolean isStatusSpecificString = false;
                String appendTo = null;
                String linkDetails = null;
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    sectionName = (String)row.get("SECTION_NAME");
                    Long fwaSectionID = (Long)row.get("FWA_SECTION_ID");
                    sectionRBBs = (String)row.get("RBBNAME");
                    sectionGenericIDs = (String)row.get("GENERIC_SECTION_ID_LIST");
                    sectionBriefDesc = (String)row.get("DESCRIPTION");
                    rbbDetailString = (String)row.get("RBB_DETAILS_TO_DISPLAY");
                    checklistDisplayType = (String)row.get("CHECKLIST_DISPLAY_TYPE");
                    isStatusSpecificString = (Boolean)row.get("STATUS_SPECIFIC_DESC");
                    appendTo = (String)row.get("TO_APPEND");
                    linkDetails = (String)row.get("LINK_DETAILS");
                    if (sectionName == null) continue;
                    this.sectionVsFWASectionID.put(sectionName, fwaSectionID);
                    if (sectionRBBs != null && !"".equals(sectionRBBs.trim())) {
                        this.sectionVsRBBs.put(sectionName, sectionRBBs);
                    }
                    if (sectionBriefDesc != null) {
                        this.sectionVsBriefDesc.put(sectionName, sectionBriefDesc);
                    }
                    if (sectionGenericIDs != null && !"".equals(sectionGenericIDs.trim())) {
                        this.sectionVsGenericIDs.put(sectionName, sectionGenericIDs);
                    }
                    if (rbbDetailString != null && !"".equals(rbbDetailString.trim())) {
                        String[] rbbArray = sectionRBBs.split(",");
                        String[] rbbDetailsArray = rbbDetailString.split("\\|\\_\\|");
                        String rbb = null;
                        String rbbDetails = null;
                        String rbbColList = null;
                        String rbbStatusDecider = null;
                        String rbbDataDisplayType = null;
                        String highlightCols = null;
                        for (int i = 0; i < rbbArray.length; ++i) {
                            rbb = rbbArray[i];
                            rbbDetails = rbbDetailsArray[i];
                            String[] detailsArray = rbbDetails.split("&&");
                            rbbColList = detailsArray[0].trim();
                            rbbStatusDecider = detailsArray[1].trim();
                            rbbDataDisplayType = detailsArray[2].trim();
                            this.rbbVsColList.put(rbb, rbbColList);
                            this.rbbVsStatusDeciderMap.put(rbb, rbbStatusDecider);
                            this.rbbVsDataDisplayType.put(rbb, rbbDataDisplayType);
                            if (detailsArray.length <= 3) continue;
                            highlightCols = detailsArray[3].trim();
                            this.rbbVsHighlightColList.put(rbb, highlightCols);
                        }
                    }
                    if ("Data".equals(checklistDisplayType)) {
                        this.genericSecurityAuditDataDisplayList.add(sectionName);
                    }
                    if (isStatusSpecificString) {
                        this.statusBasedSectionDescList.add(sectionName);
                    }
                    if (appendTo != null && !"".equals(appendTo.trim())) {
                        this.sectionAppendMap.put(sectionName, appendTo);
                    }
                    if (linkDetails == null || "".equals(linkDetails.trim())) continue;
                    this.sectionVsLinkDetailsMap.put(sectionName, linkDetails);
                }
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while getting section Specific RBBs Info for the firewall " + displayName, ee);
        }
    }

    public void loadCheckListDetails() throws Exception {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("FWAConfigCheckListDetails"));
            sql.addSelectColumn(new Column("FWAConfigCheckListDetails", "*"));
            DataObject doo = DataAccess.get((SelectQuery)sql);
            if (!doo.isEmpty()) {
                Iterator itr = doo.getRows("FWAConfigCheckListDetails");
                Long genericID = null;
                boolean isEnable = true;
                String service = null;
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    genericID = (Long)row.get("GENERIC_SECTION_ID");
                    isEnable = (Boolean)row.get("ENABLE");
                    if (!isEnable) {
                        this.disabledGenericIDList.add(genericID);
                    }
                    if ((service = (String)row.get("SERVICENAME")) == null) continue;
                    this.genericIDVsServiceMap.put(genericID.toString(), service);
                }
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while loading details from FWAConfigCheckListDetails table..", ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseNow(Long rID, String displayName, Long versionNo) throws Exception {
        try {
            byte[] byArray = SYNCOBJ;
            synchronized (SYNCOBJ) {
                FwConfigMgmt configMgmt = FwConfigMgmt.getInstance();
                FAServerUtil.setFlagForPolicyProcess(rID, Boolean.TRUE);
                configMgmt.initiatePolicyProcessing(rID, this.deviceType, this.dbConfigData, "running", versionNo, null);
                try {
                    Object waitLock;
                    Object object = waitLock = DynamicLocks.getLockFor(rID + "_parseNow");
                    synchronized (object) {
                        waitLock.wait();
                    }
                }
                catch (Exception ee) {
                    throw new Exception("ComplianceGenerator:::Exception while acquiring lock during onDemand parse and compliance generation..for the firewall " + displayName, ee);
                }
                FAServerUtil.setFlagForPolicyProcess(rID, Boolean.FALSE);
                DataObject rulesDO = this.csu.getRuleDetailsDO(rID, displayName);
                if (!rulesDO.isEmpty()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while parsing the config..for the firewall " + displayName, ee);
        }
        {
            return false;
        }
    }

    private JSONArray getExcludeServicesJSONArray(ArrayList<String> failedGenericIDList, StringBuilder insecureServiceBuilder) {
        JSONArray excludeServiceJSONArray = null;
        try {
            if (failedGenericIDList != null && !failedGenericIDList.isEmpty()) {
                ArrayList<String> excludeServiceList = new ArrayList<String>();
                for (String genericID : failedGenericIDList) {
                    String serviceName;
                    if (!SERVICEBASED_FALSEPOSITIVE_GENERIC_CHECKLIST.contains(genericID) || (serviceName = this.genericIDVsServiceMap.get(genericID)) == null) continue;
                    excludeServiceList.add(serviceName);
                    insecureServiceBuilder.append(serviceName);
                    insecureServiceBuilder.append(",");
                }
                if (!excludeServiceList.isEmpty()) {
                    excludeServiceJSONArray = new JSONArray(excludeServiceList);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return excludeServiceJSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLatestConfigIntoMemory(Long rID, String displayName, Long latestConfigVersionNo) throws Exception {
        block7: {
            try {
                Criteria crit = new Criteria(new Column("ConfigVersions", "RID"), (Object)rID, 0);
                crit = crit.and(new Criteria(new Column("ConfigVersions", "CONFIG_TYPE"), (Object)"running", 0));
                crit = crit.and(new Criteria(new Column("ConfigVersions", "VERSION_NO"), (Object)latestConfigVersionNo, 0));
                DataObject configDO = DataAccess.get((String)"ConfigVersions", (Criteria)crit);
                if (configDO.isEmpty()) break block7;
                InputStream dbConfigDataStream = (InputStream)configDO.getFirstValue("ConfigVersions", "FILE_CONTENTS");
                if (dbConfigDataStream != null) {
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[1024];
                    try {
                        int n;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        dbConfigDataStream.close();
                    }
                    this.dbConfigData = ((Object)writer).toString();
                }
                this.dbConfigData = this.decryptionObj.decryptLog(this.dbConfigData);
            }
            catch (Exception ee) {
                throw new Exception("ComplianceGenerator:::Exception while getting latestconfig for the firewall " + displayName, ee);
            }
        }
    }

    private Properties getDeviceDetailsToFetchTheConfig(Long rID) {
        Properties props = null;
        try {
            DeviceConnection dCon = DeviceConnection.getInstance();
            DeviceCommandParser dcp = DeviceCommandParser.getInstance();
            Criteria crit = new Criteria(new Column("DeviceDetails", "RID"), (Object)rID, 0);
            DataObject devRuleDO = DataAccess.get((String)"DeviceDetails", (Criteria)crit);
            if (!devRuleDO.isEmpty()) {
                Long ddid = (Long)devRuleDO.getFirstValue("DeviceDetails", "DDID");
                boolean isProfileBased = (Boolean)devRuleDO.getFirstValue("DeviceDetails", "ISPROFILEBASED");
                DataObject doo = isProfileBased ? dCon.getProfileDO(ddid, true) : dCon.getDO(ddid);
                List tableNames = doo.getTableNames();
                String tableName = tableNames.contains("DIPCredentials") ? "DIPCredentials" : "DeviceCredentials";
                props = dCon.getPropertiesFromDO(doo, tableName);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConfigByconnectingToDevice(Long rID, Properties props) {
        CLISession cli = null;
        DeviceConnection dCon = DeviceConnection.getInstance();
        try {
            String configFromDevice;
            DeviceCommandParser dcp = DeviceCommandParser.getInstance();
            List vdomList = FAServerUtil.getVdomDevicesList();
            String ip = (String)LaCacheManager.getInstance().getResourceIp(rID);
            boolean isVdom = vdomList.contains(ip);
            List complianceCmds = isVdom ? dcp.getVdomRunningComplianceCommands(this.deviceType) : dcp.getRunningComplianceCommands(this.deviceType);
            Boolean isVDOM = isVdom ? Boolean.TRUE : Boolean.FALSE;
            cli = dCon.createSession(props);
            String string = configFromDevice = dCon.reteriveConfigurationData(props, "auto", complianceCmds, rID, "running", Boolean.FALSE, cli, isVDOM);
            dCon.cleanUp(cli, rID);
            return string;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            dCon.cleanUp(cli, rID);
        }
        return null;
    }

    private void cleanupMemory() {
        this.sectionVsRBBs = null;
        this.sectionVsBriefDesc = null;
        this.sectionVsFWASectionID = null;
        this.sectionVsGenericIDs = null;
        this.rbbVsQuery = null;
        this.rbbVsTitle = null;
        this.rbbVsColList = null;
        this.rbbVsStatusDeciderMap = null;
        this.rbbVsDataDisplayType = null;
        this.rbbVsHighlightColList = null;
        this.genericSecurityAuditDataDisplayList = null;
        this.statusBasedSectionDescList = null;
        this.sectionAppendMap = null;
        this.sectionVsLinkDetailsMap = null;
        this.sectionList = null;
        this.disabledGenericIDList = null;
        this.genericIDVsServiceMap = null;
        this.mainJson = null;
    }
}

