/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.ad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.ad.AbstractUserIPHandler;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.HashMap;
import java.util.logging.Logger;

public class DHCPUserIPHandler
extends AbstractUserIPHandler {
    private static final Logger LOGGER = Logger.getLogger(DHCPUserIPHandler.class.getName());

    @Override
    public synchronized void init() {
        this.configTableName = "DHCPConfigurations";
        this.dataColumnName = "MACADDRESS";
        this.configurationMap = new HashMap();
        this.dataMap = new FixedHashMap(50000);
        this.loadConfigurationDetails();
    }

    @Override
    protected void handleEmptyServer(Object serverId, String serverName) {
    }

    @Override
    protected String getServerName(DataObject resDO, Object server) {
        return (String)server;
    }

    @Override
    protected boolean updateExistingMACData(String serverName, String ipAddress, String value) {
        if (!this.dataMap.containsValue((Object)value)) {
            return false;
        }
        try {
            String oldIPAddress = null;
            SelectQueryImpl select = new SelectQueryImpl(new Table("UserMACDetails"));
            Criteria crit1 = new Criteria(new Column("UserMACDetails", "SERVERNAME"), (Object)serverName, 0);
            Criteria crit2 = new Criteria(new Column("UserMACDetails", "MACADDRESS"), (Object)value, 0);
            Criteria crit = crit1.and(crit2);
            select.setCriteria(crit);
            select.addSelectColumn(new Column("UserMACDetails", "*"));
            DataObject dobj = DataAccess.get((SelectQuery)select);
            if (dobj.isEmpty()) {
                return false;
            }
            Row row = dobj.getRow("UserMACDetails");
            oldIPAddress = (String)row.get("IPADDRESS");
            row.set("IPADDRESS", (Object)ipAddress);
            dobj.updateRow(row);
            DataAccess.update((DataObject)dobj);
            this.dataMap.remove((Object)oldIPAddress);
            this.dataMap.put((Object)(serverName + "#" + ipAddress), (Object)value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

