/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dataCollection;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Report
implements Cloneable {
    private List<String> dcList = Arrays.asList("telnet", "ssh");
    private Properties prop;
    private String name;
    private String mode;
    protected Long rbbgId;
    private String protocol;
    protected int interval = 0;

    public Report(String name, Long rbbgId, String protocol) {
        this.name = name;
        this.rbbgId = rbbgId;
        this.protocol = protocol;
        this.mode = this.dcList.contains(protocol) ? "dc" : protocol;
    }

    void setProperties(Properties prop) {
        this.prop = prop;
    }

    String getProperty(String key) {
        if (this.prop == null) {
            return null;
        }
        return this.prop.getProperty(key);
    }

    public int hashCode() {
        return this.rbbgId.hashCode();
    }

    public boolean equals(Object obj) {
        Report temp;
        boolean equals = false;
        if (obj instanceof Report && this.rbbgId.equals((temp = (Report)obj).getRbbgId()) && this.mode.equals(temp.getMode())) {
            equals = true;
        }
        return equals;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n Report Name: " + this.name);
        sb.append("\n RBBGId: " + this.rbbgId + "    Interval : " + this.interval);
        sb.append("\n Protocol: " + this.protocol + "     Mode: " + this.mode);
        if (this.prop != null) {
            sb.append("\n Properties " + this.prop.toString());
        } else {
            sb.append("\n Properties is NULL");
        }
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String proto) {
        this.protocol = proto;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getMode() {
        return this.mode;
    }

    public Long getRbbgId() {
        return this.rbbgId;
    }
}

