/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.ProtocolUtility;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.fa.server.dc.DataConsolidator;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserEngineHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLogUnifier
implements ParserEngineHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractLogUnifier.class.getName());
    protected HashSet mailProtocols = new HashSet();
    private FACacheManager fCache = FACacheManager.getInstance();
    private LaCacheManager cache = LaCacheManager.getInstance();
    private String dbType = System.getProperty("DBType", "mysql");
    private HashMap l3ProtocolMap = new HashMap();

    public abstract Hashtable unifyData(String var1, Hashtable var2);

    public AbstractLogUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
    }

    public String getStringL3Protocol(String l3ProtoNumber) {
        String temp = (String)this.l3ProtocolMap.get(l3ProtoNumber);
        if (temp == null) {
            return l3ProtoNumber;
        }
        return temp;
    }

    public Hashtable recordParsed(ParserEngineContext context, String host, Hashtable data) {
        if ((data = this.unifyData(host, data)) != null) {
            if (data.size() == 1) {
                return data;
            }
            this.assignName(data);
            this.contentFilter(data);
            if (data.get("CATEGORY") != null) {
                this.fCache.getCategoryId((String)data.get("CATEGORY"));
            }
        }
        this.fCache.populateIPNumber(data);
        this.findCountryId(data);
        if (data != null && data.get("SYSLOGIP") == null) {
            data.put("SYSLOGIP", host);
        }
        this.fCache.updateSyslogToFWMap(data);
        this.checkPriority(data);
        if (data != null) {
            this.consolidateData(context, data);
            this.handleEventTypeForDenied(data);
            this.handleSpecialChars(data, new String[]{"USERNAME", "USER"});
            this.fCache.addUser(data);
            if (data.get("TIME") == null) {
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
            }
            this.handleUserIPIntegration(host, data);
        }
        return data;
    }

    private void handleEventTypeForDenied(Hashtable data) {
        String status = (String)data.get("STATUS");
        Integer eventType = (Integer)data.get("EVENT_TYPE");
        if (status == null) {
            return;
        }
        if ((eventType == null || eventType.intValue() == PureFirewallConstants.TRAFFIC_LOG.intValue()) && (status.equalsIgnoreCase("deny") || status.equalsIgnoreCase("denied"))) {
            if (data.get("REQUEST") != null) {
                data.put("EVENT_TYPE", PureFirewallConstants.CONTENT_FILTERING_DENY);
                data.put("li", "1");
            } else {
                data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
            }
        }
    }

    private void contentFilter(Hashtable data) {
        String recordType = (String)data.get("RECORD_TYPE");
        if ("webfilter".equals(recordType)) {
            String status = (String)data.get("STATUS");
            if ("deny".equalsIgnoreCase(status) || "denied".equalsIgnoreCase(status) || "block".equalsIgnoreCase(status) || "blocked".equalsIgnoreCase(status)) {
                data.put("li", "1");
                data.put("EVENT_TYPE", PureFirewallConstants.CONTENT_FILTERING_DENY);
                if (data.get("RULE") == null && data.get("DEST_NAME") != null) {
                    data.put("RULE", "default");
                }
            } else {
                data.remove("RULE");
            }
        }
    }

    private void consolidateData(ParserEngineContext context, Hashtable data) {
        if (context == null) {
            return;
        }
        DataConsolidator consolidator = (DataConsolidator)context.getParameter("DATA_CONSOLIDATOR");
        if (consolidator != null) {
            consolidator.consolidateData(data, context);
        }
    }

    public Map getLiveData(String host) {
        return new HashMap();
    }

    public void strToInt(String[] strToInt, Hashtable data) {
        for (String attribute : strToInt) {
            Object toBeChangedObj = data.get(attribute);
            if (toBeChangedObj == null) {
                data.put(attribute, new Integer(0));
                continue;
            }
            if (!(toBeChangedObj instanceof String)) continue;
            String toBeChanged = (String)toBeChangedObj;
            if (toBeChanged.trim().length() <= 0 || !toBeChanged.matches("\\d*")) {
                data.put(attribute, new Long(0L));
                continue;
            }
            if (toBeChanged == null) continue;
            Integer changed = null;
            try {
                changed = new Integer(Integer.parseInt(toBeChanged));
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.FINER, " Unable to parse as Int {0} :: {1}", new Object[]{attribute, toBeChanged});
            }
            if (changed == null) continue;
            data.put(attribute, changed);
        }
    }

    public void strToLong(String[] strToLong, Hashtable data) {
        for (String attribute : strToLong) {
            Object toBeChangedObj = data.get(attribute);
            if (toBeChangedObj == null) {
                data.put(attribute, new Long(0L));
                continue;
            }
            if (!(toBeChangedObj instanceof String)) continue;
            String toBeChanged = (String)toBeChangedObj;
            Long changed = null;
            if (toBeChanged != null) {
                try {
                    changed = new Long(Long.parseLong(toBeChanged));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.INFO, " Unable to parse as Long {0} :: {1}", new Object[]{attribute, toBeChanged});
                }
            }
            if (changed == null) {
                changed = new Long(0L);
            }
            data.put(attribute, changed);
        }
    }

    public void assignPreParserTime(Hashtable data) {
        if (data.get("TIME_ZONE") != null) {
            this.handleTimeZone(data);
            return;
        }
        String dateString = (String)data.get("DATE_STRING");
        String dateFormat = (String)data.get("DATE_FORMAT");
        if (dateString == null || dateFormat == null) {
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
            return;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            if (data.get("NO_YEAR") != null) {
                GregorianCalendar cal = new GregorianCalendar();
                int year = cal.get(1);
                cal.setTime(format.parse(dateString));
                cal.set(1, year);
                data.put("TIME", new Timestamp(cal.getTime().getTime()));
            } else {
                data.put("TIME", new Timestamp(format.parse(dateString).getTime()));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            LOGGER.log(Level.FINER, " Exception while parsing Cisco Date String :: {0} Date Format ::{1}", new Object[]{dateString, dateFormat});
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
        }
    }

    public void handleTimeZone(Hashtable data) {
        String dateString = (String)data.get("DATE_STRING");
        String dateFormat = (String)data.get("DATE_FORMAT");
        if (dateString == null || dateFormat == null) {
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
            return;
        }
        try {
            String timeZone = (String)data.get("TIME_ZONE");
            long offsetTime = 0L;
            if (data.get("TIME_OFFSET") != null) {
                try {
                    String offsetSign = (String)data.get("OFFSET_SIGN");
                    String offsetHour = (String)data.get("OFFSET_HOUR");
                    String offsetMin = (String)data.get("OFFSET_MIN");
                    if ("-".equals(offsetSign)) {
                        offsetHour = offsetSign + offsetHour;
                    }
                    offsetTime = Integer.parseInt(offsetHour) * 3600000 + Integer.parseInt(offsetMin) * 60000;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            dateString = dateString + " " + timeZone;
            dateFormat = dateFormat + " z";
            SimpleDateFormat simDateFormat = null;
            if (data.get("NO_YEAR") != null) {
                GregorianCalendar cal = new GregorianCalendar();
                int year = cal.get(1);
                simDateFormat = new SimpleDateFormat("yyyy " + dateFormat);
                dateString = year + " " + dateString;
                Date d = simDateFormat.parse(dateString);
                long msTime = d.getTime();
                data.put("TIME", new Timestamp(msTime += offsetTime));
                return;
            }
            simDateFormat = new SimpleDateFormat(dateFormat);
            long msTime = simDateFormat.parse(dateString).getTime();
            data.put("TIME", new Timestamp(msTime += offsetTime));
        }
        catch (Exception ee) {
            ee.printStackTrace();
            LOGGER.log(Level.FINER, "Exception while parsing Time Zone String:::{0}:::Date Format:::{1}", new Object[]{dateString, dateFormat});
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
        }
    }

    public void checkSrcDstInterfaces(Hashtable data, String device) {
        if (data.get("SRC_INTERFACE") != null) {
            boolean isResAvailable;
            String devName = (String)data.get(device);
            String srcInt = (String)data.get("SRC_INTERFACE");
            String dstInt = (String)data.get("DST_INTERFACE");
            String srcKey = devName + "_" + srcInt;
            String dstKey = devName + "_" + dstInt;
            if (this.fCache.checkDeviceInterfaceIndexMap(srcKey)) {
                data.put("SRC_INT", this.fCache.getInterfaceIndex(srcKey));
            } else {
                if (!this.fCache.checkIdentifiedInterfaceMap(devName, srcInt) && dstInt != null && !srcInt.equals(dstInt) && (isResAvailable = this.fCache.updateInterfaceDetails(devName, null, srcInt, null, null, null, null))) {
                    this.fCache.addToIdentifiedInterfaceMap(devName, srcInt);
                }
                data.put("SRC_INT", new Long(0L));
            }
            if (this.fCache.checkDeviceInterfaceIndexMap(dstKey)) {
                data.put("DST_INT", this.fCache.getInterfaceIndex(dstKey));
            } else {
                if (!this.fCache.checkIdentifiedInterfaceMap(devName, dstInt) && !srcInt.equals(dstInt) && (isResAvailable = this.fCache.updateInterfaceDetails(devName, null, dstInt, null, null, null, null))) {
                    this.fCache.addToIdentifiedInterfaceMap(devName, dstInt);
                }
                data.put("DST_INT", new Long(0L));
            }
        }
    }

    public void checkForLearnMe(Hashtable data) {
        if (PureFirewallConstants.getPerlVM()) {
            return;
        }
        String protocol = (String)data.get("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
            data.put("PROTOCOL", protocol);
        }
        data.put("PORT_INFO", protocol);
        String result = ProtocolUtility.doYouKnow(protocol);
        if (result != null) {
            data.put("LEARNME", result);
            data.put("PROTOCOL", result);
        } else if (protocol.indexOf("/icmp") > -1) {
            data.put("PROTOCOL", "ICMP");
            data.put("LEARNME", protocol);
        } else {
            String newProtocol;
            data.put("PROTOCOL", "Unknown");
            data.put("LEARNME", protocol);
            data.put("uli", "1");
            int sPort = 0;
            int dPort = 0;
            try {
                sPort = (Integer)data.get("SRC_PORT");
                dPort = (Integer)data.get("DEST_PORT");
            }
            catch (ClassCastException cc) {
                LOGGER.log(Level.FINER, " Unable to convert ports from String to Integer in strToInt method so here we are not able to get int value for src and dst ports");
            }
            String l3Proto = (String)data.get("L3_PROTOCOL");
            if (l3Proto != null && sPort != 0 && dPort != 0 && (newProtocol = ProtocolUtility.doYouKnow(protocol = dPort < sPort ? dPort + "/" + l3Proto : sPort + "/" + l3Proto)) != null) {
                data.put("LEARNME", newProtocol);
                data.put("PROTOCOL", newProtocol);
                data.remove("uli");
            }
        }
    }

    public void checkPriority(Hashtable data) {
        int intValue;
        String value;
        if (PureFirewallConstants.getPerlVM()) {
            return;
        }
        if (data == null) {
            return;
        }
        String pri = (String)data.get("PRIORITY");
        if (pri == null) {
            pri = "Unknown";
        }
        if (Character.isDigit((value = this.fCache.getPriority(pri)).charAt(0)) && (intValue = Integer.parseInt(value)) < 5) {
            data.put("li", "1");
        }
        data.put("PRIORITY", value);
    }

    protected boolean dropInfoEvents(Hashtable data) {
        if (data.get("DROP_LOG") != null) {
            int pri = 6;
            try {
                pri = Integer.parseInt((String)data.get("PRIORITY"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (pri > 4) {
                return true;
            }
        }
        return false;
    }

    protected void handleDest(Hashtable data) {
        String src = (String)data.get("SRC");
        String des = (String)data.get("DEST");
        if (src != null) {
            String[] a = src.split(":");
            data.put("SRC", a[0]);
            if (a.length == 2) {
                data.put("SRC_PORT", a[1]);
            }
        }
        if (des != null) {
            String[] b = des.split(":");
            data.put("DEST", b[0]);
            if (b.length == 2) {
                data.put("DEST_PORT", b[1]);
            }
        }
    }

    public void assignNameForAttack(Hashtable data, String pattern) {
        String msg = (String)data.get("MSG");
        if (msg == null) {
            return;
        }
        pattern = pattern == null ? "portscan" : pattern;
        String type = (String)data.get("RECORD_TYPE");
        if ("ATTACK".equalsIgnoreCase(type) && msg.toLowerCase().indexOf(pattern) >= 0) {
            data.put("VIRUS", "PortScan");
            data.put("EVENT_TYPE", PureFirewallConstants.ATTACK_LOG);
        }
    }

    protected void populateMailProtocols() {
        try {
            Table resourceTable = new Table("SystemConfigurations");
            SelectQueryImpl sqlImpl = new SelectQueryImpl(resourceTable);
            sqlImpl.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria migCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"mailProtocols", 0);
            sqlImpl.setCriteria(migCrit);
            DataObject obj = DataAccess.get((SelectQuery)sqlImpl);
            Iterator itr = obj.getRows("SystemConfigurations");
            while (itr.hasNext()) {
                String confValue = (String)((Row)itr.next()).get("CONF_VALUE");
                if (confValue == null) continue;
                String[] array = confValue.split(",");
                for (int i = 0; i < array.length; ++i) {
                    this.mailProtocols.add(array[i]);
                }
            }
        }
        catch (Exception ee) {
            LOGGER.log(Level.WARNING, " Error while Loading Mail Protocols");
            ee.printStackTrace();
        }
        if (this.mailProtocols.size() == 0) {
            this.mailProtocols.add("smtp");
            this.mailProtocols.add("smtps");
        }
        LOGGER.log(Level.INFO, " Mail Protocol in CiscoPIX Log :::" + this.mailProtocols);
    }

    protected void handleMail(Hashtable data) {
        String protocol = (String)data.get("PROTOCOL");
        if (protocol != null && this.mailProtocols.contains(protocol)) {
            Object recd = data.get("RCVD");
            data.put("SENT", recd);
            data.put("RCVD", new Long(0L));
            data.put("RECEIVED", new Long(0L));
        }
    }

    private void assignName(Hashtable data) {
        String ip = (String)data.get("SRC");
        String string = ip = ip == null ? (String)data.get("SRC_NAME") : ip;
        if (data.get("SRCNAME") == null && ip != null) {
            data.put("SRCNAME", ip);
        }
        String string2 = ip = (ip = (String)data.get("DST")) == null ? (String)data.get("DEST") : ip;
        if (data.get("DEST_NAME") == null && ip != null) {
            data.put("DEST_NAME", ip);
        }
    }

    protected void populateSquidCodes(Hashtable data) {
        int slashIndex;
        String peerStatus;
        Object id;
        if (data == null) {
            return;
        }
        String code = null;
        Object codeObject = data.get("STATUS_CODE");
        if (codeObject != null) {
            code = codeObject.toString();
        }
        if ((id = this.fCache.getHttpStatusID(code)) != null) {
            data.put("STATUS_CODE", id);
        }
        code = (code = (String)data.get("HIERARCHYCODE_HOST")) == null ? (String)data.get("HIERARCHY_CODE") : code;
        String string = code = code != null ? code : "Unknown";
        if (code != null && (id = this.fCache.getPeerStatusID(peerStatus = (slashIndex = code.indexOf("/")) <= 0 ? code : code.substring(0, slashIndex))) != null) {
            data.put("HIERARCHY_CODE", id);
        }
        if ((code = (String)data.get("RESULT_CODE")) != null) {
            if ("TCP_DENIED".equals(code) || "UDP_DENIED".equals(code)) {
                data.put("STATUS", "deny");
            } else {
                data.put("STATUS", "permit");
            }
        }
        if ((id = this.fCache.getSquidStatusID(code)) != null) {
            data.put("RESULT_CODE", id);
        }
    }

    public void flushMemory(String host) {
    }

    public String getQuotesTrimmed(String value) {
        return value.replaceAll("\"", "");
    }

    public String getHeader(String host) {
        return null;
    }

    protected void handleSpecialChars(Hashtable data, String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            String temp = (String)data.get(fields[i]);
            if (temp == null) continue;
            if ("mysql".equals(this.dbType)) {
                temp = temp.replaceAll("\\\\", "\\\\\\\\");
            }
            data.put(fields[i], temp);
        }
    }

    protected void handleUserIPIntegration(String host, Hashtable data) {
        String resource = (String)data.get("RESOURCE");
        if (resource == null && (resource = (String)data.get("FW")) == null) {
            resource = host;
        }
        if (resource == null) {
            return;
        }
        boolean isUnManagedDevice = FirewallLicenseManager.getInstance().isUnManagedDevice(resource);
        if (isUnManagedDevice) {
            return;
        }
        UserMACHandler userIPHandler = FirewallConstants.getUserMACHandlerInstance();
        if (userIPHandler != null && userIPHandler.isConfiguredResource(resource)) {
            String[] arr = new String[]{"SRCNAME", "DEST_NAME"};
            String ip = null;
            for (int i = 0; i < arr.length; ++i) {
                ip = (String)data.get(arr[i]);
                if (ip == null || "0.0.0.0".equals(ip)) continue;
                String value = userIPHandler.getReplacementValue(resource, ip);
                if ("mysql".equals(this.dbType)) {
                    value = value.replaceAll("\\\\", "\\\\\\\\");
                }
                data.put(arr[i], value);
            }
        }
    }

    protected void aggregateSentAndRcvd(PIXVPNObject vpnObj, Hashtable data) {
        try {
            long old = 0L;
            if (vpnObj.getSentBytes() != null) {
                old = vpnObj.getSentBytes();
            }
            long temp = data.get("SENT") != null ? Long.parseLong(data.get("SENT").toString()) : new Long(0L);
            long total = old + temp;
            Long totalSent = new Long(total);
            vpnObj.setSentBytes(totalSent);
            old = vpnObj.getRcvdBytes() != null ? vpnObj.getRcvdBytes() : 0L;
            temp = data.get("RECEIVED") != null ? Long.parseLong(data.get("RECEIVED").toString()) : new Long(0L);
            total = old + temp;
            Long totalRcvd = new Long(total);
            vpnObj.setRcvdBytes(totalRcvd);
            data.put("li", "1");
            data.put("SUBTYPE", "7");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findCountryId(Hashtable data) {
        try {
            if (data == null) {
                return;
            }
            Object srcCntryId = data.get("SRC_CNTRY") != null ? data.get("SRC_CNTRY") : data.get("SRC_ID");
            Object dstCntryId = data.get("DST_CNTRY") != null ? data.get("DST_CNTRY") : data.get("DST_ID");
            data.put("SRC_CNTRYID", this.fCache.getCountryId(srcCntryId));
            data.put("DST_CNTRYID", this.fCache.getCountryId(dstCntryId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

