/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.LEALogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckPointUnifier
extends LEALogUnifier {
    private static final Logger LOGGER = Logger.getLogger(CheckPointUnifier.class.getName());
    private static final Integer TYPE = new Integer(2);
    private String DATE_FORMAT = "ddMMMyyyyHH:mm:ss";
    private Hashtable cpFirewalls = new Hashtable();
    private Hashtable delimiters = new Hashtable();
    private Pattern urlPattern = Pattern.compile("resource:\\s(\\S*);");

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("DELIMITER") != null) {
            this.identifyParams(host, data);
            return null;
        }
        if (!this.getRealData(host, data)) {
            return null;
        }
        return super.unifyData(host, data);
    }

    private boolean getRealData(String host, Hashtable data) {
        String delimiter = (String)this.delimiters.get(host);
        Vector parameters = (Vector)this.cpFirewalls.get(host);
        String log = (String)data.remove("LOG");
        if (log == null) {
            return false;
        }
        if (delimiter == null) {
            return false;
        }
        String[] tokens = log.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            String key;
            String value = this.getTrimmedData(tokens[i]);
            if (parameters.size() <= i || (key = (String)parameters.get(i)) == null || value == null || value.trim().length() == 0) continue;
            data.put(key, value);
        }
        if (data.get("ATTACK") != null) {
            data.put("EVENT_TYPE", PureFirewallConstants.ATTACK_LOG);
        } else if (data.get("STATUS") != null) {
            String status = (String)data.get("STATUS");
            if ("Accept".equalsIgnoreCase(status)) {
                data.put("STATUS", "permit");
            } else if ("DropReject".indexOf(status) > -1) {
                data.put("STATUS", "deny");
                data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
            } else if (status.equalsIgnoreCase("block")) {
                data.put("STATUS", "deny");
            }
        }
        this.identifyURL(data);
        if ("URL Filtering".equals(data.get("FW_TYPE"))) {
            data.remove("TRAN_PORT");
            Object cat = data.remove("POLICY_ID");
            if (data.get("REQUEST") != null) {
                data.put("CATEGORY", cat);
            }
        }
        return true;
    }

    private void identifyURL(Hashtable data) {
        Matcher m;
        String message = (String)data.get("MSG");
        if (message != null && (m = this.urlPattern.matcher(message)).find()) {
            String url = m.group(1);
            data.put("REQUEST", url);
        }
    }

    private void identifyParams(String host, Hashtable data) {
        String delimiter = (String)data.get("DELIMITER");
        if (delimiter == null) {
            return;
        }
        String log = (String)data.remove("LOG");
        if (log == null) {
            return;
        }
        LOGGER.log(Level.INFO, " IMPORTANT DELIMITER RESULT ::: {0} :: Log :::  {1}", new Object[]{delimiter, log});
        Vector<String> parameters = new Vector<String>();
        String[] tokens = log.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            String param = tokens[i];
            parameters.add(this.getDatabaseParam(param));
        }
        this.cpFirewalls.put(host, parameters);
        this.delimiters.put(host, delimiter);
        LOGGER.log(Level.INFO, " PARAMETERS ::: {0} :: SIZE :::  {1}", new Object[]{parameters, parameters.size() + ""});
    }

    private String getDatabaseParam(String param) {
        String result = this.getTrimmedData(param);
        if (result.equalsIgnoreCase("date")) {
            return "DATE";
        }
        if (result.equalsIgnoreCase("time")) {
            return "TIME";
        }
        if (result.equalsIgnoreCase("orig") || result.equalsIgnoreCase("origin")) {
            return "FW";
        }
        if (result.equalsIgnoreCase("type")) {
            return "TYPE";
        }
        if (result.equalsIgnoreCase("action")) {
            return "STATUS";
        }
        if (result.equalsIgnoreCase("alert")) {
            return "ALERT";
        }
        if (result.equalsIgnoreCase("i/f_name") || result.equalsIgnoreCase("i/f_name")) {
            return "INTERFACE";
        }
        if (result.equalsIgnoreCase("i/f_dir")) {
            return "IF_DIRECTION";
        }
        if (result.equalsIgnoreCase("product")) {
            return "FW_TYPE";
        }
        if (result.equalsIgnoreCase("src") || result.equalsIgnoreCase("source")) {
            return "SRC";
        }
        if (result.equalsIgnoreCase("dst") || result.equalsIgnoreCase("destination")) {
            return "DEST";
        }
        if (result.equalsIgnoreCase("proto") || result.equalsIgnoreCase("protocol")) {
            return "PROTOCOL";
        }
        if (result.equalsIgnoreCase("rule name")) {
            return "RULE_NAME";
        }
        if (result.equalsIgnoreCase("service")) {
            return "SERVICE";
        }
        if (result.equalsIgnoreCase("s_port") || result.equalsIgnoreCase("Source Port")) {
            return "SRC_PORT";
        }
        if (result.equalsIgnoreCase("rule")) {
            return "RULE";
        }
        if (result.equalsIgnoreCase("bytes")) {
            return "BYTES";
        }
        if (result.equalsIgnoreCase("elapsed")) {
            return "DURATION";
        }
        if (result.equalsIgnoreCase("client_inbound_bytes") || result.equalsIgnoreCase("Client Inbound Bytes")) {
            return "CLIENT_INBOUND_BYTES";
        }
        if (result.equalsIgnoreCase("client_outbound_bytes") || result.equalsIgnoreCase("Client Outbound Bytes")) {
            return "CLIENT_OUTBOUND_BYTES";
        }
        if (result.equalsIgnoreCase("server_inbound_bytes") || result.equalsIgnoreCase("Server Inbound Bytes")) {
            return "SERVER_INBOUND_BYTES";
        }
        if (result.equalsIgnoreCase("server_outbound_bytes") || result.equalsIgnoreCase("Server Outbound Bytes")) {
            return "SERVER_OUTBOUND_BYTES";
        }
        if (result.equalsIgnoreCase("Attack Info")) {
            return "ATTACK_INFO";
        }
        if (result.equalsIgnoreCase("attack") || result.equalsIgnoreCase("Attack Name")) {
            return "ATTACK";
        }
        if (result.equalsIgnoreCase("user")) {
            return "USERNAME";
        }
        if (result.equalsIgnoreCase("message") || result.equalsIgnoreCase("Information")) {
            return "MSG";
        }
        if (result.equalsIgnoreCase("vpn feature")) {
            return "VPN";
        }
        if (result.equalsIgnoreCase("vpn user")) {
            return "USERNAME";
        }
        if (result.equalsIgnoreCase("vpn peer gateway")) {
            return "GATEWAY";
        }
        if (result.equalsIgnoreCase("resource")) {
            return "REQUEST";
        }
        if (result.equalsIgnoreCase("Application / Site")) {
            return "TRAN_PORT";
        }
        if (result.equalsIgnoreCase("Matched Category")) {
            return "POLICY_ID";
        }
        return result;
    }

    @Override
    protected void handleTime(Hashtable data) {
        String date = (String)data.get("DATE");
        String time = (String)data.get("TIME");
        if (time == null || date == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        try {
            data.put("TIME", new Timestamp(sdf.parse(date + time).getTime()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getData(String key, Hashtable data) {
        String value = (String)data.get(key);
        if (value == null) {
            return null;
        }
        return this.getTrimmedData(value);
    }

    private String getTrimmedData(String value) {
        return value.replaceAll("\"", "");
    }
}

