/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.ResourceDetails;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.CiscoIOSUnifier;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.persistence.DataAccess;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CiscoPIXUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(CiscoPIXUnifier.class.getName());
    private Hashtable firewalls = new Hashtable();
    private Map twinsTable = null;
    private Map mappingTwinsTable = null;
    private Map vpnFirewallTable = null;
    private String vpnCreationFirewallIp = null;
    private String vpnDeletionFirewallIp = null;
    private long lastVPNCreationTime = 0L;
    private long lastVPNDeletionTime = 0L;
    private Map ipSecTable = null;
    private Map ipSecUserTable = null;
    private Map aclDevMap = null;
    private Map aclMap = null;
    private SimpleDateFormat monthConvertor = new SimpleDateFormat("MMM");
    private static final Integer TYPE = new Integer(3);
    private boolean handleVPN = true;
    private boolean destByPort = false;
    public static final String GET_OR_PUT_STRING = "retrieved";
    public static final String GET_OR_PUT_PROTOCOL = "ftp";
    public static final String POINT_TO_POINT_TUNNEL_CREATION = "pc";
    public static final String POINT_TO_POINT_TUNNEL_DELETION = "pd";
    public static final String SA_CREATION = "sac";
    public static final String SA_DELETION = "sad";
    public static final String SA7_CREATION = "sac7";
    public static final String SA7_DELETION = "sad7";
    public static final String NO_VPN_CREATION = "novc";
    public static final String WEB_VPN = "wv";
    public static final String USER_AUTHENTICATION_SUCCESS = "uas";
    public static final String USER_AUTHENTICATION_FAILED = "uaf";
    public static final String BUILT_CONNECTION = "B";
    public static final String TEARDOWN_CONNECTION = "T";
    public static final String CONNECTION_IDENTIFIER = "cid";
    private CiscoIOSUnifier ios = null;
    private FwConfigMgmt configMgmt = FwConfigMgmt.getInstance();
    public static long packetCount = 0L;

    public CiscoPIXUnifier() {
        if ("false".equals(System.getProperty("handleVPN"))) {
            this.handleVPN = false;
        }
        try {
            String strDstByPort = FirewallConstants.getDestByPort();
            this.destByPort = strDstByPort == null || "".equals(strDstByPort) ? Boolean.valueOf(System.getProperty("destByPort")).booleanValue() : Boolean.valueOf(strDstByPort).booleanValue();
        }
        catch (Exception e) {
            this.destByPort = Boolean.valueOf(System.getProperty("destByPort"));
        }
        this.twinsTable = Collections.synchronizedMap(new FixedHashMap(10000));
        this.vpnFirewallTable = Collections.synchronizedMap(new FixedHashMap());
        this.ipSecTable = Collections.synchronizedMap(new FixedHashMap(200));
        this.ipSecUserTable = Collections.synchronizedMap(new FixedHashMap(500));
        this.mappingTwinsTable = Collections.synchronizedMap(new FixedHashMap(10000));
        this.aclDevMap = Collections.synchronizedMap(new FixedHashMap(100));
        this.populateMailProtocols();
        this.ios = new CiscoIOSUnifier();
        LOGGER.log(Level.INFO, " HANDLE VPN IN CISCO PIX set to :: " + this.handleVPN + " :: FixedHashMap implementation done. DestinationByPort set to " + this.destByPort);
    }

    private void printSize() {
        System.out.println(" ########################################################################");
        System.out.println(" Firewalls Table Size ::" + this.firewalls.size());
        for (Map.Entry entry : this.firewalls.entrySet()) {
            String res = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            System.out.println(" connection table size for ::" + res + " is ::" + value.size());
        }
        System.out.println(" Twins Table Size ::" + this.twinsTable.size());
        System.out.println(" VpnFirewall Table Size ::" + this.vpnFirewallTable.size());
        System.out.println(" IPSec Table Size ::" + this.ipSecTable.size());
        Runtime runtime = Runtime.getRuntime();
        System.out.println(" Total Memory ::" + runtime.totalMemory() + " :: Free Memory ::" + runtime.freeMemory() + " :: Max Memory ::" + runtime.maxMemory());
        System.out.println(" ########################################################################");
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String statusInfo;
        String status;
        String sc;
        int index;
        Object dropString;
        Map connectionTable;
        String resource;
        String dPort = (String)data.get("DST_PORT");
        if (dPort != null) {
            data.put("DEST_PORT", dPort);
        }
        if (data.get("ios") != null) {
            return this.ios.unifyData(host, data);
        }
        if (data.get("CSC") != null) {
            String sourceTrim;
            int slaSrcIndex;
            String dest;
            int slaDstIndex;
            String spamStatus;
            String sev = (String)data.remove("PRI");
            if (sev != null) {
                int priority = Integer.parseInt(sev);
                try {
                    data.put("PRI", "" + (priority %= 8));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((spamStatus = (String)data.get("STATUS")) != null && (spamStatus.indexOf("Reject") > -1 || spamStatus.indexOf("blocked") > -1)) {
                data.put("STATUS", "Deny");
            }
            if (data.get("DST") == null) {
                data.put("DST", host);
            }
            if ((slaDstIndex = (dest = data.get("DST").toString()).indexOf("/")) > -1) {
                dest = dest.substring(0, slaDstIndex);
                data.put("DST", dest);
            }
            if ((slaSrcIndex = (sourceTrim = data.get("SRC").toString()).indexOf("/")) > -1) {
                sourceTrim = sourceTrim.substring(0, slaSrcIndex);
                data.put("SRC", sourceTrim);
            }
            String user = (String)data.get("USER");
            String userName = (String)data.get("USERNAME");
            if (user == null && userName != null) {
                data.put("USER", userName);
            }
            if (data.get("DATE_STRING") == null) {
                String dateFormat = (String)data.get("DATE") + (String)data.get("TIME");
                data.put("DATE_STRING", dateFormat);
            }
            if ("6".equals((String)data.get("EVENT_TYPE")) && "passed".equalsIgnoreCase((String)data.get("STATUS"))) {
                data.remove("EVENT_TYPE");
            }
        }
        data.put("ResourceType", "CiscoPIX");
        data.put("SYSLOGIP", host);
        data.put("rtype", TYPE);
        this.assignPreParserTime(data);
        String considerAsVdom = (String)data.remove("considerAsVdom");
        if (!"false".equals(considerAsVdom)) {
            String resName = this.getResourceName(data, host);
            data.put("RESOURCE", resName);
            data.put("FW", resName);
        }
        if ((resource = (String)data.get("RESOURCE")) == null) {
            resource = host;
            data.put("RESOURCE", resource);
            data.put("FW", resource);
        }
        if (!this.discoverInOrOut(data, connectionTable = this.getConnectionTable(resource, data)) && !this.assignSentOrRcvd(data, connectionTable)) {
            this.assignDestByPort(data, new Properties());
        }
        data.put("FW_TYPE", "Cisco");
        data.put("LOG_FORMAT", "Cisco");
        if (data.get("DROP_LOG") != null) {
            int pri = 6;
            try {
                pri = Integer.parseInt((String)data.get("PRI"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (pri > 4) {
                data.clear();
                data.put("FW", resource);
                return data;
            }
            data.put("EVENT_TYPE", PureFirewallConstants.HIGH_SEVERITY_LOG);
        }
        if ((dropString = data.get("DST")) != null && (index = dropString.toString().indexOf(":")) > -1) {
            data.put("DST", dropString.toString().substring(0, index));
        }
        String recordType = (String)data.get("RECORD_TYPE");
        dropString = data.get("SRC");
        if (dropString == null && !"mgmt".equals(recordType)) {
            data.clear();
            data.put("FW", resource);
            return data;
        }
        if (data.get("SENT") == null) {
            data.put("SENT", new Long(0L));
        }
        if (data.get("RCVD") == null) {
            data.put("RCVD", new Long(0L));
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "DURATION", "SENT_PKT", "RECEIVED_PKT", "RCVD"};
        this.strToLong(strToLong, data);
        this.checkForLearnMe(data);
        this.checkPriority(data);
        this.handleMail(data);
        this.handleRequest(data);
        if (this.handleVPNCreation(data, host)) {
            data.clear();
            data.put("FW", resource);
            return data;
        }
        this.handleIntermittant(data);
        this.checkSrcDstInterfaces(data, "RESOURCE");
        if ("mgmt".equals((String)data.get("RECORD_TYPE"))) {
            String subType = (String)data.get("SUBTYPE");
            if ("login".equalsIgnoreCase(subType)) {
                String pixId = (String)data.get("PIXID");
                if ("611101".equals(pixId) || "605005".equals(pixId)) {
                    data.put("SUBTYPE", "1");
                } else if (("611103".equals(pixId) || "315011".equals(pixId)) && !"true".equals((String)data.get("fromLoadArchive"))) {
                    data.put("SUBTYPE", "2");
                    try {
                        String changedBy = (String)data.get("USER");
                        Long rID = (Long)LaCacheManager.getInstance().getFirewallId(resource);
                        this.configMgmt.initiateConfigFetching("Cisco", resource, changedBy, rID);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if ("605004".equals(pixId) || "611102".equals(pixId)) {
                    data.put("SUBTYPE", "3");
                }
            }
            LOGGER.log(Level.FINE, " unifyDate called with data {0} ", data);
        }
        if ("1".equals(sc = (String)data.get("sc")) && (status = (String)data.get("STATUS")) != null && !"permitted".equals(status)) {
            data.put("STATUS", "deny");
            data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
            data.put("li", "1");
        }
        if (!"deny".equalsIgnoreCase(statusInfo = (String)data.get("STATUS")) && !"denied".equalsIgnoreCase(statusInfo)) {
            data.put("STATUS", "permit");
        }
        this.luceneIndex(data);
        data.put("FW", data.get("RESOURCE"));
        return data;
    }

    private String getResourceName(Hashtable data, String host) {
        String resource = (String)data.get("RESOURCE");
        if (resource == null) {
            resource = host;
            return resource;
        }
        if (!"false".equals((String)data.remove("considerAsVdom"))) {
            String resName = null;
            Hashtable dnsToIPMap = FAServerUtil.getPhysicalDevToIPMap();
            ResourceDetails resObj = FAServerUtil.getResObject(host);
            if (resObj != null) {
                resName = resObj.getModResName(resource);
                data.put("physicalDeviceName", resObj.getPhysicalDevName());
                return resName;
            }
            String newDNSName = FAServerUtil.resolveDNSNow(host);
            data.put("physicalDeviceName", newDNSName);
            if (dnsToIPMap.containsKey(newDNSName)) {
                String oldIP = (String)dnsToIPMap.get(newDNSName);
                resObj = FAServerUtil.getResObject(oldIP);
                resObj.setIPAddress(host);
                resName = resObj.getModResName(resource);
                this.updateIPRelatedStuff(oldIP, host, resName, newDNSName);
                return resName;
            }
            List resList = FAServerUtil.getResList();
            if (resList.contains(resource) && !newDNSName.equals(host)) {
                resource = newDNSName + "-" + resource;
                return resource;
            }
            return resource;
        }
        return resource;
    }

    private void updateIPRelatedStuff(String oldIP, String newIP, String resName, String dnsName) {
        LOGGER.log(Level.INFO, "Firewall IP Got Changed : \t Firewall Name: \"{0}\"\t Old IP : \"{1}\"\t New IP: \"{2}\"\t MainDevname : \"{3}\"", new Object[]{resName, oldIP, newIP, dnsName});
        String resourcesWithIP = FAServerUtil.getIPResMap(oldIP);
        FAServerUtil.updateIPResMap(oldIP, newIP);
        FAServerUtil.updatePhysicalDevToIPMap(newIP, dnsName);
        FAServerUtil.updateResObjHashForCisco(oldIP, newIP);
        List vdomList = FAServerUtil.getVdomDevicesList();
        if (vdomList.contains(oldIP)) {
            FAServerUtil.removeDeviceFromVdomDevicesList(oldIP);
            FAServerUtil.addDeviceToVdomDevicesList(newIP);
        } else {
            List nonVdomList = FAServerUtil.getExcludedDevList();
            if (nonVdomList.contains(oldIP)) {
                FAServerUtil.removeDevFrmExcludeList(oldIP);
                FAServerUtil.addToExcludedDevicesList(newIP);
                FAServerUtil.updateSysConf();
            }
        }
        try {
            UpdateQueryImpl update = new UpdateQueryImpl("Resources");
            Criteria crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)oldIP, 0);
            update.setCriteria(crit);
            update.setUpdateColumn("IPADDRESS", (Object)newIP);
            DataAccess.update((UpdateQuery)update);
            update = new UpdateQueryImpl("Resources");
            crit = new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)oldIP, 0);
            update.setCriteria(crit);
            update.setUpdateColumn("PHYSICALDEVIP", (Object)newIP);
            DataAccess.update((UpdateQuery)update);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        LaCacheManager lac = LaCacheManager.getInstance();
        String[] rids = resourcesWithIP.split(",");
        for (int i = 0; i < rids.length; ++i) {
            String rid = rids[i];
            String resource = (String)lac.getResourceName(new Long(rid));
            lac.updateIpToResource(newIP, resource);
            lac.removeFromMem(Long.valueOf(rid));
        }
    }

    private void handleRequest(Hashtable data) {
        String request = (String)data.get("REQUEST");
        if (request != null && request.startsWith("/")) {
            String req = (String)data.get("REQUEST");
            data.put("REQUEST", data.get("DST") + req);
            data.put("PROTOCOL", "http");
        }
    }

    private void luceneIndex(Hashtable data) {
        if (data.get("li") != null) {
            return;
        }
        if (data.get("MSG") != null || data.get("VPN") != null) {
            data.put("li", "1");
            return;
        }
    }

    private boolean handleVPNCreation(Hashtable data, String host) {
        Map fwIpSecMap;
        Hashtable vpnTable;
        PIXVPNObject obj;
        Map fwIpSecMap2;
        if (!this.handleVPN) {
            return false;
        }
        String vpnConfig = (String)data.get("VPN_CONFIG");
        if (vpnConfig == null) {
            return false;
        }
        String resource = (String)data.get("RESOURCE");
        String user = (String)data.get("USER");
        if (data.get("GROUP_VPN") != null) {
            fwIpSecMap2 = (Map)this.ipSecTable.get(resource);
            if (fwIpSecMap2 == null) {
                fwIpSecMap2 = Collections.synchronizedMap(new FixedHashMap(1000));
                this.ipSecTable.put(resource, fwIpSecMap2);
            }
            obj = new PIXVPNObject(data);
            fwIpSecMap2.put(user, obj);
            if ("113009".equals((String)data.get("PIX_ID"))) {
                return true;
            }
        }
        if (POINT_TO_POINT_TUNNEL_DELETION.equals(vpnConfig)) {
            vpnTable = (Hashtable)this.vpnFirewallTable.get(resource);
            if ("EZVPN".equalsIgnoreCase((String)data.get("VPN"))) {
                if (vpnTable != null) {
                    String source = (String)data.get("SRC");
                    PIXVPNObject vpnObj = (PIXVPNObject)vpnTable.remove(source);
                    if (vpnObj == null) {
                        return false;
                    }
                    long duration = 0L;
                    Timestamp startTime = vpnObj.getVPNTime();
                    if (startTime == null) {
                        return false;
                    }
                    duration = (((Timestamp)data.get("TIME")).getTime() - startTime.getTime()) / 1000L;
                    this.putString("DURATION", new Long(duration), data);
                }
            } else {
                String tunnelid = (String)data.get("TUNNEL_ID");
                if (tunnelid == null) {
                    return false;
                }
                if (vpnTable != null) {
                    PIXVPNObject vpnObj = (PIXVPNObject)vpnTable.remove(tunnelid);
                    if (vpnObj == null) {
                        return false;
                    }
                    vpnTable.remove(vpnObj.getSource());
                }
            }
        } else if (POINT_TO_POINT_TUNNEL_CREATION.equals(vpnConfig)) {
            vpnTable = (Hashtable)this.vpnFirewallTable.get(resource);
            if (vpnTable == null) {
                vpnTable = new Hashtable();
                this.vpnFirewallTable.put(resource, vpnTable);
            }
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            if (!"EZVPN".equalsIgnoreCase((String)data.remove("VPN"))) {
                vpnObj.setVPNName("pptp");
                vpnTable.put(vpnObj.getTunnelId(), vpnObj);
            }
            vpnTable.put(vpnObj.getSource(), vpnObj);
        } else if (SA_CREATION.equals(vpnConfig)) {
            if (this.vpnCreationFirewallIp == null) {
                this.vpnCreationFirewallIp = (String)data.get("SRC");
                this.lastVPNCreationTime = ((Timestamp)data.get("TIME")).getTime();
            } else {
                long logTime = ((Timestamp)data.get("TIME")).getTime();
                if (logTime - this.lastVPNCreationTime < 2000L) {
                    Map<String, PIXVPNObject> fwIpSecMap3 = (Map<String, PIXVPNObject>)this.ipSecTable.get(resource);
                    if (fwIpSecMap3 == null) {
                        fwIpSecMap3 = Collections.synchronizedMap(new FixedHashMap(1000));
                        this.ipSecTable.put(resource, fwIpSecMap3);
                    }
                    PIXVPNObject obj2 = new PIXVPNObject(data);
                    String twins = (String)data.get("SRC") + this.vpnCreationFirewallIp;
                    String usr = (String)this.ipSecUserTable.remove(twins);
                    if (usr != null) {
                        obj2.setUser(usr);
                    } else {
                        obj2.setUser("N/A");
                    }
                    obj2.setVPNName("IPSec");
                    fwIpSecMap3.put(obj2.getSource(), obj2);
                    this.vpnCreationFirewallIp = null;
                    this.lastVPNCreationTime = 0L;
                } else {
                    this.vpnCreationFirewallIp = (String)data.get("SRC");
                    this.lastVPNCreationTime = ((Timestamp)data.get("TIME")).getTime();
                }
            }
        } else if (SA_DELETION.equals(vpnConfig)) {
            if (this.vpnDeletionFirewallIp == null) {
                this.vpnDeletionFirewallIp = (String)data.get("SRC");
                this.lastVPNDeletionTime = ((Timestamp)data.get("TIME")).getTime();
            } else {
                long logTime = ((Timestamp)data.get("TIME")).getTime();
                if (logTime - this.lastVPNDeletionTime < 2000L) {
                    String src = (String)data.get("SRC");
                    Map fwIpSecMap4 = (Map)this.ipSecTable.get(resource);
                    if (fwIpSecMap4 == null) {
                        return false;
                    }
                    PIXVPNObject obj3 = (PIXVPNObject)fwIpSecMap4.remove(src);
                    if (obj3 == null) {
                        return false;
                    }
                    long duration = 0L;
                    Timestamp startTime = obj3.getVPNTime();
                    if (startTime != null) {
                        duration = (logTime - startTime.getTime()) / 1000L;
                    }
                    this.putString("USER", obj3.getUser(), data);
                    this.putString("VPN", obj3.getVPNName(), data);
                    this.putString("DST", this.vpnDeletionFirewallIp, data);
                    this.putString("DURATION", new Long(duration), data);
                    this.vpnDeletionFirewallIp = null;
                    this.lastVPNDeletionTime = 0L;
                } else {
                    this.vpnDeletionFirewallIp = (String)data.get("SRC");
                    this.lastVPNDeletionTime = ((Timestamp)data.get("TIME")).getTime();
                }
            }
        } else if (USER_AUTHENTICATION_SUCCESS.equals(vpnConfig)) {
            String src = (String)data.get("SRC");
            String uName = (String)data.get("USER");
            if (uName != null) {
                PIXVPNObject obj4;
                String temp = (String)data.get("SRC") + (String)data.get("DST");
                Map fwIpSecMap5 = (Map)this.ipSecTable.get(resource);
                if (fwIpSecMap5 != null && (obj4 = (PIXVPNObject)fwIpSecMap5.get(src)) != null) {
                    obj4.setUser(uName);
                }
                if (this.ipSecUserTable.get(temp) == null) {
                    this.ipSecUserTable.put(temp, uName);
                }
            }
        } else if (SA7_CREATION.equals(vpnConfig)) {
            PIXVPNObject obj5;
            fwIpSecMap = (Map)this.ipSecTable.get(resource);
            if (fwIpSecMap == null) {
                fwIpSecMap = Collections.synchronizedMap(new FixedHashMap(1000));
                this.ipSecTable.put(resource, fwIpSecMap);
            }
            if (fwIpSecMap.containsKey(user)) {
                obj5 = (PIXVPNObject)fwIpSecMap.get(user);
                obj5.setSource((String)data.get("SRC"));
                if (obj5.getGroupVpn() != null) {
                    data.put("GROUP_VPN", obj5.getGroupVpn());
                }
            } else {
                obj5 = new PIXVPNObject(data);
            }
            if (data.get("VPN") == null) {
                obj5.setVPNName("IPSec");
            } else {
                obj5.setVPNName((String)data.get("VPN"));
            }
            data.remove("VPN");
            if (!fwIpSecMap.containsKey(user)) {
                fwIpSecMap.put(user, obj5);
            }
        } else if (SA7_DELETION.equals(vpnConfig)) {
            fwIpSecMap2 = (Map)this.ipSecTable.get(resource);
            if (fwIpSecMap2 == null) {
                return false;
            }
            obj = (PIXVPNObject)fwIpSecMap2.get(user);
            if (obj == null) {
                return false;
            }
            long duration = 0L;
            Timestamp startTime = obj.getVPNTime();
            if (startTime == null) {
                return false;
            }
            duration = (((Timestamp)data.get("TIME")).getTime() - startTime.getTime()) / 1000L;
            this.putString("DURATION", new Long(duration), data);
        } else if (USER_AUTHENTICATION_FAILED.equals(vpnConfig)) {
            data.put("EVENT_TYPE", PureFirewallConstants.FAILED_VPN_LOG);
        } else if (NO_VPN_CREATION.equals(vpnConfig)) {
            this.assignDuration(data);
            fwIpSecMap2 = (Map)this.ipSecTable.get(resource);
            if (fwIpSecMap2 == null) {
                return false;
            }
            obj = (PIXVPNObject)fwIpSecMap2.remove(user);
            if (obj == null) {
                return false;
            }
            this.putString("TRAN_IP", obj.getTranIp(), data);
            this.putString("GROUP_VPN", obj.getGroupVpn(), data);
        } else if (WEB_VPN.equals(vpnConfig)) {
            String pix_id = (String)data.get("PIX_ID");
            fwIpSecMap = (Map)this.ipSecTable.get(resource);
            if (fwIpSecMap == null) {
                return true;
            }
            PIXVPNObject obj6 = (PIXVPNObject)fwIpSecMap.get(user);
            if (obj6 == null) {
                return true;
            }
            if ("722051".equals(pix_id) || "713228".equals(pix_id)) {
                String tran_ip = (String)data.get("TRAN_IP");
                obj6.setTranIp(tran_ip);
                return true;
            }
            if ("722030".equals(pix_id)) {
                Long bytes = (Long)data.get("SENT");
                obj6.setSentBytes(bytes);
                return true;
            }
            if ("722031".equals(pix_id)) {
                data.put("DST", host);
                fwIpSecMap.remove(user);
                long duration = 0L;
                Timestamp startTime = obj6.getVPNTime();
                duration = (((Timestamp)data.get("TIME")).getTime() - startTime.getTime()) / 1000L;
                this.putString("DURATION", new Long(duration), data);
                data.put("TRAN_IP", obj6.getTranIp());
                data.put("SENT", obj6.getSentBytes());
                data.put("VPN", "webvpn");
            }
        } else {
            return false;
        }
        this.handleSpecialChars(data, new String[]{"USER"});
        return false;
    }

    private void handleIntermittant(Hashtable data) {
        PIXVPNObject obj;
        Map fwIpSecMap;
        if (TEARDOWN_CONNECTION.equals(data.get(CONNECTION_IDENTIFIER)) && data.get("USER") != null && (fwIpSecMap = (Map)this.ipSecTable.get((String)data.get("RESOURCE"))) != null && (obj = (PIXVPNObject)fwIpSecMap.get(data.get("USER"))) != null) {
            data.put("TRAN_IP", data.get("SRC"));
            data.put("SRC", obj.getSource());
            data.put("li", "1");
            data.put("SUBTYPE", "7");
            if (obj.getVPNName() != null) {
                data.put("VPN", obj.getVPNName());
            }
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap liveVPNUserMap = new TreeMap();
        this.populateMasterVPNMap(resource, this.vpnFirewallTable, liveVPNUserMap);
        this.populateMasterVPNMap(resource, this.ipSecTable, liveVPNUserMap);
        return liveVPNUserMap;
    }

    private void populateMasterVPNMap(String resource, Map vpnMap, Map liveVPNUserMap) {
        Map vpnObjMap = (Map)vpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
    }

    private Map getConnectionTable(String resource, Hashtable data) {
        Map connectionTable = (Map)this.firewalls.get(resource);
        if (connectionTable == null) {
            connectionTable = Collections.synchronizedMap(new FixedHashMap());
            this.firewalls.put(resource, connectionTable);
        }
        return connectionTable;
    }

    private void assignAtLeastProtocol(Hashtable data) {
        if (data.get("PROTOCOL") != null) {
            return;
        }
        String appProtocol = (String)data.get("L3_PROTOCOL");
        if (appProtocol == null) {
            return;
        }
        String portString = (String)data.get("DST_PORT");
        if (portString != null) {
            appProtocol = portString + "/" + appProtocol;
        }
        data.put("PROTOCOL", appProtocol);
    }

    private void assignDestByPort(Hashtable data, Properties transProp) {
        Object bytes = data.get("BYTES");
        if (bytes != null) {
            block12: {
                if (data.get("LOCAL_IP") != null) {
                    String srcPort = (String)data.get("FOREIGN_PORT");
                    String src = (String)data.get("FOREIGN_IP");
                    String dstPort = (String)data.get("LOCAL_PORT");
                    String dst = (String)data.get("LOCAL_IP");
                    try {
                        int sPort = Integer.parseInt(srcPort);
                        int dPort = Integer.parseInt(dstPort);
                        if (sPort < dPort) {
                            this.putString("DST_PORT", srcPort, data);
                            this.putString("DST", src, data);
                            this.putString("SRC_PORT", dstPort, data);
                            this.putString("SRC", dst, data);
                            break block12;
                        }
                        this.putString("SRC_PORT", srcPort, data);
                        this.putString("SRC", src, data);
                        this.putString("DST_PORT", dstPort, data);
                        this.putString("DST", dst, data);
                    }
                    catch (Exception ee) {
                        this.putString("SRC_PORT", srcPort, data);
                        this.putString("SRC", src, data);
                        this.putString("DST_PORT", dstPort, data);
                        this.putString("DST", dst, data);
                    }
                } else {
                    String srcInt = (String)data.get("SRC_INTERFACE");
                    String srcPort = (String)data.get("SRC_PORT");
                    String src = (String)data.get("SRC");
                    String dstInt = (String)data.get("DST_INTERFACE");
                    String dstPort = (String)data.get("DST_PORT");
                    String dst = (String)data.get("DST");
                    int sPort = 0;
                    int dPort = 0;
                    try {
                        if (srcPort != null && dstPort != null) {
                            sPort = Integer.parseInt(srcPort);
                            dPort = Integer.parseInt(dstPort);
                        }
                        if (sPort < dPort) {
                            this.putString("DST_PORT", srcPort, data);
                            this.putString("DST", src, data);
                            this.putString("DST_INTERFACE", srcInt, data);
                            this.putString("SRC_PORT", dstPort, data);
                            this.putString("SRC", dst, data);
                            this.putString("SRC_INTERFACE", dstInt, data);
                        } else {
                            this.putString("SRC_PORT", srcPort, data);
                            this.putString("SRC", src, data);
                            this.putString("SRC_INTERFACE", srcInt, data);
                            this.putString("DST_PORT", dstPort, data);
                            this.putString("DST", dst, data);
                            this.putString("DST_INTERFACE", dstInt, data);
                        }
                    }
                    catch (Exception ee) {
                        this.putString("SRC_PORT", srcPort, data);
                        this.putString("SRC", src, data);
                        this.putString("SRC_INTERFACE", srcInt, data);
                        this.putString("DST_PORT", dstPort, data);
                        this.putString("DST", dst, data);
                        this.putString("DST_INTERFACE", dstInt, data);
                    }
                }
            }
            this.identifyMe(data, transProp);
        } else {
            this.assignAtLeastProtocol(data);
        }
    }

    private void assignProtocolName(Hashtable data, boolean in, Properties transProp) {
        String l3Protocol = (String)data.get("L3_PROTOCOL");
        if (l3Protocol == null) {
            return;
        }
        if (this.destByPort) {
            this.assignDestByPort(data, transProp);
            return;
        }
        if (in) {
            Object bytes = data.get("BYTES");
            if (bytes != null) {
                if (data.get("LOCAL_IP") != null) {
                    String srcPort = (String)data.get("FOREIGN_PORT");
                    this.putString("SRC_PORT", srcPort, data);
                    String src = (String)data.get("FOREIGN_IP");
                    this.putString("SRC", src, data);
                    String dstPort = (String)data.get("LOCAL_PORT");
                    this.putString("DST_PORT", dstPort, data);
                    String dst = (String)data.get("LOCAL_IP");
                    this.putString("DST", dst, data);
                }
                this.identifyMe(data, transProp);
            }
        } else {
            Object bytes = data.get("BYTES");
            if (bytes != null) {
                if (data.get("LOCAL_IP") != null) {
                    String srcPort = (String)data.get("LOCAL_PORT");
                    this.putString("SRC_PORT", srcPort, data);
                    String src = (String)data.get("LOCAL_IP");
                    this.putString("SRC", src, data);
                    String dstPort = (String)data.get("FOREIGN_PORT");
                    this.putString("DST_PORT", dstPort, data);
                    String dst = (String)data.get("FOREIGN_IP");
                    this.putString("DST", dst, data);
                } else {
                    String srcInt = (String)data.get("DST_INTERFACE");
                    String srcPort = (String)data.get("DST_PORT");
                    String src = (String)data.get("DST");
                    this.putString("DST", data.get("SRC"), data);
                    this.putString("DST_PORT", data.get("SRC_PORT"), data);
                    this.putString("DST_INTERFACE", data.get("SRC_INTERFACE"), data);
                    this.putString("SRC", src, data);
                    this.putString("SRC_INTERFACE", srcInt, data);
                    this.putString("SRC_PORT", srcPort, data);
                }
                this.identifyMe(data, transProp);
            }
        }
    }

    private void identifyMe(Hashtable data, Properties transProp) {
        String resource;
        Hashtable vpnTable;
        String mapTwins;
        Object bytes = data.get("BYTES");
        String source = (String)data.get("SRC");
        String twins = source + (String)data.get("DST");
        Properties twinsProp = (Properties)this.twinsTable.remove(twins);
        String getOrPut = null;
        if (twinsProp == null && (mapTwins = (String)transProp.get("MAP")) != null) {
            twinsProp = (Properties)this.twinsTable.remove(mapTwins);
        }
        if (twinsProp != null) {
            getOrPut = twinsProp.getProperty("GET");
            data.putAll(twinsProp);
        }
        boolean knownProtocol = false;
        if (null == getOrPut) {
            data.put("RCVD", bytes);
            data.put("SENT", new Long(0L));
        } else if (GET_OR_PUT_STRING.equalsIgnoreCase(getOrPut)) {
            data.put("RCVD", bytes);
            data.put("SENT", new Long(0L));
            data.put("PROTOCOL", GET_OR_PUT_PROTOCOL);
            knownProtocol = true;
        } else {
            data.put("SENT", bytes);
            data.put("RCVD", new Long(0L));
            data.put("PROTOCOL", GET_OR_PUT_PROTOCOL);
            knownProtocol = true;
        }
        if (!knownProtocol && data.get("PROTOCOL") == null) {
            String portString = (String)data.get("DST_PORT");
            String appProtocol = (String)data.get("L3_PROTOCOL");
            if (portString != null) {
                appProtocol = portString + "/" + appProtocol;
            }
            data.put("PROTOCOL", appProtocol);
        }
        if (this.handleVPN && (vpnTable = (Hashtable)this.vpnFirewallTable.get(resource = (String)data.get("RESOURCE"))) != null) {
            PIXVPNObject vpnObj = (PIXVPNObject)vpnTable.get(source);
            if (vpnObj == null) {
                return;
            }
            data.put("VPN", vpnObj.getVPNName());
            data.put("TRAN_IP", vpnObj.getTranIp());
            data.put("USER", vpnObj.getUser());
        }
    }

    private void interchangeSRCAndPort(Hashtable data) {
        String src = (String)data.get("SRC");
        String srcPort = (String)data.get("SRC_PORT");
        String srcInterface = (String)data.get("SRC_INTERFACE");
        String dst = (String)data.get("DST");
        String dstPort = (String)data.get("DST_PORT");
        String dstInterface = (String)data.get("SRC_INTERFACE");
        if (src != null) {
            data.put("DST", src);
        }
        if (srcPort != null) {
            data.put("DST_PORT", srcPort);
        }
        if (srcInterface != null) {
            data.put("DST_INTERFACE", srcInterface);
        }
        if (dst != null) {
            data.put("SRC", dst);
        }
        if (dstPort != null) {
            data.put("SRC_PORT", dstPort);
        }
        if (dstInterface != null) {
            data.put("SRC_INTERFACE", dstInterface);
        }
    }

    private void putString(Object key, Object value, Hashtable data) {
        if (key == null || value == null) {
            LOGGER.log(Level.FINER, " REJECTION SRC DST SWAP REQUESTS ==={0} VALUE {1} DATA =={2}", new Object[]{key, value, data});
            return;
        }
        data.put(key, value);
    }

    private boolean discoverInOrOut(Hashtable data, Map connectionTable) {
        String twins = (String)data.get("SRC") + (String)data.get("DST");
        String cid = (String)data.get(CONNECTION_IDENTIFIER);
        if (BUILT_CONNECTION.equals(cid)) {
            Properties tranProp = new Properties();
            String inOrOut = (String)data.get("IN_OR_OUT");
            String connectionId = (String)data.get("CONNECTION_ID");
            if (connectionId == null) {
                connectionId = this.getFwsmBuggyConnectionId(data);
            }
            if (inOrOut == null) {
                inOrOut = "outbound";
                String srcPort = (String)data.get("SRC_PORT");
                String dstPort = (String)data.get("DST_PORT");
                int sPort = 0;
                int dPort = 0;
                try {
                    if (srcPort != null && dstPort != null) {
                        sPort = Integer.parseInt(srcPort);
                        dPort = Integer.parseInt(dstPort);
                    }
                    if (sPort > dPort) {
                        inOrOut = "inbound";
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            tranProp.setProperty("IN_OR_OUT", inOrOut);
            connectionTable.put(connectionId, tranProp);
            if (twins != null) {
                String mapSrc = (String)data.get("MAP_SRC");
                String mapDst = (String)data.get("MAP_DST");
                if (mapSrc != null) {
                    if ("inbound".equals(inOrOut)) {
                        tranProp.put("MAP", mapSrc + mapDst);
                    } else {
                        tranProp.put("MAP", mapDst + mapSrc);
                    }
                }
                if (data.get("USER") != null) {
                    tranProp.put("USER", (String)data.get("USER"));
                }
            }
            return true;
        }
        String get = (String)data.get("GET");
        String request = (String)data.get("REQUEST");
        if (twins != null && (get != null || request != null)) {
            Properties prop = new Properties();
            String user = (String)data.get("USER");
            if (get != null) {
                prop.put("GET", get);
            }
            if (request != null) {
                if ("deny".equals(data.get("STATUS"))) {
                    this.twinsTable.remove(twins);
                    return false;
                }
                prop.put("REQUEST", request);
            }
            if (user != null) {
                prop.put("USER", user);
            }
            this.twinsTable.put(twins, prop);
        }
        if (data.get("sc") != null && "permitted".equals(data.get("STATUS"))) {
            Map aclMap = (Map)this.aclDevMap.get(data.get("RESOURCE"));
            if (aclMap == null) {
                aclMap = Collections.synchronizedMap(new FixedHashMap(10000));
                this.aclDevMap.put(data.get("RESOURCE"), aclMap);
            }
            String key = this.getFwsmBuggyConnectionId(data);
            aclMap.put(key, data.get("RULE"));
            data.put("SUBTYPE", "7");
        }
        return false;
    }

    private String getFwsmBuggyConnectionId(Hashtable data) {
        String connectionid = (String)data.get("SRC") + (String)data.get("SRC_PORT") + (String)data.get("DST") + (String)data.get("DST_PORT");
        return connectionid;
    }

    private boolean assignSentOrRcvd(Hashtable data, Map connectionTable) {
        Map aclMap;
        String inOrOut;
        Properties tranProp;
        this.assignDuration(data);
        String cid = (String)data.get(CONNECTION_IDENTIFIER);
        if (!TEARDOWN_CONNECTION.equals(cid)) {
            return false;
        }
        String connectionId = (String)data.get("CONNECTION_ID");
        if (connectionId == null) {
            connectionId = this.getFwsmBuggyConnectionId(data);
        }
        if ((tranProp = (Properties)connectionTable.get(connectionId)) == null) {
            return false;
        }
        if ((data.get("USER") == null || ((String)data.get("USER")).trim().length() == 0) && tranProp.get("USER") != null) {
            data.put("USER", (String)tranProp.get("USER"));
        }
        if ((inOrOut = tranProp.getProperty("IN_OR_OUT")) == null) {
            return false;
        }
        if ("inbound".equalsIgnoreCase(inOrOut)) {
            this.assignProtocolName(data, true, tranProp);
        } else {
            this.assignProtocolName(data, false, tranProp);
        }
        if (this.aclDevMap != null && (aclMap = (Map)this.aclDevMap.get(data.get("RESOURCE"))) != null && aclMap.get(this.getFwsmBuggyConnectionId(data)) != null) {
            data.put("RULE", aclMap.remove(this.getFwsmBuggyConnectionId(data)));
        }
        connectionTable.remove(connectionId);
        String twinsString = (String)data.get("SRC") + (String)data.get("DST");
        this.twinsTable.remove(twinsString);
        this.mappingTwinsTable.remove(twinsString);
        return true;
    }

    private void assignDuration(Hashtable data) {
        String dhour = (String)data.get("DURATION_HOUR");
        if (dhour == null) {
            data.put("DURATION", new Long(0L));
            return;
        }
        String dDay = (String)data.get("DURATION_DAY");
        dDay = dDay == null ? "0" : dDay;
        String dmin = (String)data.get("DURATION_MIN");
        String dsec = (String)data.get("DURATION_SEC");
        try {
            long duration = Integer.parseInt(dDay) * 86400 + Integer.parseInt(dhour) * 3600 + Integer.parseInt(dmin) * 60 + Integer.parseInt(dsec);
            if (duration == 0L) {
                duration = 1L;
            }
            data.put("DURATION", new Long(duration));
            return;
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " EXCEPTION WHILE PARSING DURATION TIME dhour =={0} dmin {1} dsec {2}", new Object[]{dhour, dmin, dsec});
            ee.printStackTrace();
            data.put("DURATION", new Long(0L));
            return;
        }
    }
}

