/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.dc.CacheManager;
import com.adventnet.fa.server.dc.DataConsolidator;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.persistence.Row;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsolidatorTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ConsolidatorTask.class.getName());
    private DataConsolidator dc = null;
    private Hashtable data = null;
    private ParserEngineContext context = null;
    private ThreadLocal dateFormatter = new ThreadLocal(){

        public synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public ConsolidatorTask(DataConsolidator dc, Hashtable unifiedData, ParserEngineContext context) {
        this.dc = dc;
        this.data = unifiedData;
        this.context = context;
    }

    public ConsolidatorTask() {
    }

    @Override
    public void run() {
        if (this.data == null) {
            return;
        }
        Row row = this.getRowForResourceType(this.data);
        this.addRecord(row);
        this.cleanup();
    }

    public Row getRowForResourceType(Hashtable data) {
        int type = (Integer)data.get("rtype");
        Row row = null;
        switch (type) {
            case 6: {
                row = this.createRow(data, "SquidRecords");
                break;
            }
            case 4: {
                row = this.createRow(data, "RadiusRecords");
                break;
            }
            case 5: {
                row = this.createRow(data, "RadiusSyslogRecords");
                break;
            }
            case 3: {
                row = this.createCiscoPIXRow(data, "FirewallRecords");
                break;
            }
            case 1: 
            case 18: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 2: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 10: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 11: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 12: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 13: {
                row = this.createRow(data, "SquidRecords");
                break;
            }
            case 14: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 15: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 16: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 17: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 22: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 24: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 23: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 34: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 25: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 36: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 38: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            case 42: {
                row = this.createRow(data, "FirewallRecords");
                break;
            }
            default: {
                if (!"true".equals((String)data.get("UnParsed"))) break;
                row = new Row("UnParsedRecords");
                row.set("RESOURCE", data.get("RESOURCE"));
                row.set("RECORD", data.get("RECORD"));
                row.set("SYSLOG_SERVER", data.get("SYSLOG_SERVER"));
            }
        }
        return row;
    }

    private void addRecord(List rowList) {
        this.dc.addToDO(rowList);
    }

    private void addRecord(Row record) {
        this.dc.addToDO(record);
    }

    private Row createCiscoPIXRow(Hashtable data, String tableName) {
        Row record = new Row(tableName);
        record.set("PIX_LOG_ID", data.get("PIX_LOG_ID"));
        record.set("RESOURCE", data.get("RESOURCE"));
        record.set("LOG_FORMAT", data.get("LOG_FORMAT"));
        record.set("GROUP_VPN", data.get("GROUP_VPN"));
        record.set("FW_TYPE", data.get("FW_TYPE"));
        String temp = (String)data.get("USER");
        if (temp == null || temp.trim().length() <= 0) {
            temp = "Unknown";
        }
        record.set("USER", (Object)temp);
        record.set("TIME", data.get("TIME"));
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        record.set("PROTOCOL", (Object)protocol);
        record.set("LEARNME", data.get("LEARNME"));
        String priority = (String)data.remove("PRI");
        if (priority == null) {
            priority = "Unknown";
        }
        record.set("PRI", (Object)priority);
        record.set("SRC", data.get("SRC"));
        record.set("SRCNAME", data.get("SRCNAME"));
        record.set("SRC_PORT", data.get("SRC_PORT"));
        record.set("DST", data.get("DST"));
        record.set("DSTNAME", data.get("DEST_NAME"));
        record.set("DST_PORT", data.get("DST_PORT"));
        record.set("DURATION", data.get("DURATION"));
        record.set("REQUEST", (Object)((String)data.get("REQUEST")));
        record.set("STATUS", (Object)((String)data.get("STATUS")));
        record.set("RULE", data.get("RULE"));
        record.set("TYPE", data.get("RECORD_TYPE"));
        record.set("SUBTYPE", data.get("SUBTYPE"));
        String fName = (String)data.get("FILENAME");
        if (fName != null) {
            record.set("FILENAME", (Object)fName);
        }
        record.set("SENT", (Object)((Long)data.get("SENT")));
        record.set("RCVD", (Object)((Long)data.get("RCVD")));
        Integer eventType = (Integer)data.get("EVENT_TYPE");
        if (eventType != null) {
            record.set("EVENT_TYPE", (Object)eventType);
        } else {
            record.set("EVENT_TYPE", (Object)new Integer(0));
        }
        record.set("MSG", (Object)((String)data.get("MSG")));
        record.set("VPN", (Object)((String)data.get("VPN")));
        record.set("VIRUS", (Object)((String)data.get("VIRUS")));
        record.set("CATEGORY", (Object)((String)data.get("CATEGORY")));
        record.set("SRC_ID", (Object)((Long)data.get("SRC_ID")));
        record.set("DST_ID", (Object)((Long)data.get("DST_ID")));
        this.populateSrcDstInt(record, data);
        record.set("TRAN_IP", (Object)((String)data.get("TRAN_IP")));
        record.set("FROM_EMAIL", (Object)((String)data.get("FROM_EMAIL")));
        record.set("TO_EMAIL", (Object)((String)data.get("TO_EMAIL")));
        record.set("MAIL_SUBJECT", (Object)((String)data.get("EMAIL_SUBJECT")));
        record.set("SRC_CNTRYID", data.get("SRC_CNTRYID"));
        record.set("DST_CNTRYID", data.get("DST_CNTRYID"));
        this.setStartTime(record);
        this.handleEmptyValueColumns(record, data);
        this.setEventCode(record);
        return record;
    }

    private Row createRow(Hashtable data, String tableName) {
        Row record = new Row(tableName);
        if ("FirewallRecords".equals(tableName)) {
            this.getFWRecord(record, data);
        } else if ("SquidRecords".equals(tableName)) {
            this.getSQRecord(record, data);
        } else if ("RadiusRecords".equals(tableName)) {
            this.getRaRecord(record, data);
        } else if ("RadiusSyslogRecords".equals(tableName)) {
            this.getRaSysRecord(record, data);
        } else {
            record = null;
        }
        return record;
    }

    private void getFWRecord(Row record, Hashtable data) {
        record.set("RESOURCE", data.get("FW"));
        record.set("FW_TYPE", data.get("FW_TYPE"));
        record.set("LOG_FORMAT", data.get("LOG_FORMAT"));
        record.set("GROUP_VPN", data.get("GROUP_VPN"));
        record.set("TIME", data.get("TIME"));
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        record.set("PROTOCOL", (Object)protocol);
        record.set("LEARNME", data.get("LEARNME"));
        String priority = (String)data.remove("PRIORITY");
        if (priority == null) {
            priority = "Unknown";
        }
        record.set("PRI", (Object)priority);
        record.set("TYPE", data.get("RECORD_TYPE"));
        record.set("SUBTYPE", data.get("SUBTYPE"));
        record.set("SRC", data.get("SRC"));
        record.set("SRCNAME", data.get("SRCNAME"));
        record.set("SRC_PORT", data.get("SRC_PORT"));
        record.set("PIX_LOG_ID", data.get("LOG_ID"));
        String userName = (String)data.get("USERNAME");
        if (userName == null || userName.trim().length() <= 0 || "-".equals(userName)) {
            userName = "Unknown";
        }
        record.set("USER", (Object)userName);
        record.set("SRC_PORT", data.get("SRC_PORT"));
        record.set("DST", data.get("DEST"));
        record.set("DSTNAME", data.get("DEST_NAME"));
        record.set("DST_PORT", data.get("DEST_PORT"));
        record.set("DURATION", data.get("DURATION"));
        record.set("REQUEST", data.get("REQUEST"));
        record.set("OP", data.get("OPERATION"));
        record.set("STATUS", data.get("STATUS"));
        record.set("FILENAME", data.get("FILENAME"));
        record.set("SENT", data.get("SENT"));
        record.set("RCVD", data.get("RECEIVED"));
        record.set("HTTPSTATUS", data.get("STATUS_CODE"));
        record.set("RULE", data.get("RULE"));
        record.set("EVENT_CODE", data.get("EVENT_CODE"));
        Integer eventType = (Integer)data.get("EVENT_TYPE");
        if (eventType != null) {
            record.set("EVENT_TYPE", (Object)eventType);
        } else {
            record.set("EVENT_TYPE", (Object)new Integer(0));
        }
        record.set("MSG", data.get("MSG"));
        record.set("VPN", data.get("VPN"));
        record.set("GATEWAY", data.get("GATEWAY"));
        record.set("VIRUS", data.get("VIRUS"));
        record.set("CATEGORY", data.get("CATEGORY"));
        if (data.get("POLICY_ID") == null) {
            data.put("POLICY_ID", "N/A");
        }
        record.set("POLICY_ID", data.get("POLICY_ID"));
        record.set("SRC_ID", (Object)((Long)data.get("SRC_ID")));
        record.set("DST_ID", (Object)((Long)data.get("DST_ID")));
        this.populateSrcDstInt(record, data);
        String temp = (String)data.get("TRAN_IP");
        if (temp == null) {
            temp = "Unknown";
        }
        record.set("TRAN_IP", (Object)temp);
        if (data.get("TRAN_PORT") == null) {
            data.put("TRAN_PORT", "N/A");
        }
        record.set("TRAN_PORT", data.get("TRAN_PORT"));
        record.set("FROM_EMAIL", (Object)((String)data.get("FROM_EMAIL")));
        record.set("TO_EMAIL", (Object)((String)data.get("TO_EMAIL")));
        record.set("MAIL_SUBJECT", (Object)((String)data.get("EMAIL_SUBJECT")));
        record.set("SRC_CNTRYID", data.get("SRC_CNTRYID"));
        record.set("DST_CNTRYID", data.get("DST_CNTRYID"));
        this.setStartTime(record);
        this.handleEmptyValueColumns(record, data);
        this.setEventCode(record);
    }

    private void populateSrcDstInt(Row record, Hashtable data) {
        if (data.get("SRC_INT") != null) {
            record.set("SRC_INT", (Object)((Long)data.get("SRC_INT")));
            record.set("DST_INT", (Object)((Long)data.get("DST_INT")));
        } else {
            record.set("SRC_INT", (Object)new Long(0L));
            record.set("DST_INT", (Object)new Long(0L));
        }
    }

    private void handleEmptyValueColumns(Row record, Hashtable data) {
        String type = (String)data.get("RECORD_TYPE");
        boolean isMySQL = "mysql".equals(System.getProperty("DBType", "mysql"));
        String emptyVal = "N/A";
        if (type != null && "spam".equals(type)) {
            String sender = (String)data.get("FROM_EMAIL");
            String recipient = (String)data.get("TO_EMAIL");
            String subject = (String)data.get("EMAIL_SUBJECT");
            if (sender == null || "".equals(sender)) {
                record.set("FROM_EMAIL", (Object)emptyVal);
            }
            if (recipient == null || "".equals(recipient)) {
                record.set("TO_EMAIL", (Object)emptyVal);
            }
            if (subject == null || "".equals(subject)) {
                record.set("MAIL_SUBJECT", (Object)emptyVal);
            }
        }
    }

    private void setEventCode(Row record) {
        if (DepartmentUtil.isInIntranetRange((Object)((String)record.get("RESOURCE")), (String)((String)record.get("SRC")))) {
            record.set("EVENT_CODE", (Object)"0");
        } else {
            record.set("EVENT_CODE", (Object)"1");
        }
    }

    private void setStartTime(Row record) {
        Object endTime = record.get("TIME") != null ? record.get("TIME") : new Date();
        Long duration = (Long)record.get("DURATION");
        if (duration == null) {
            duration = new Long(0L);
        }
        Date endDate = null;
        if (endTime instanceof Date) {
            endDate = (Date)endTime;
        } else if (endTime instanceof String) {
            String timeString = (String)endTime;
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                endDate = format.parse(timeString);
            }
            catch (Exception ee) {
                endDate = new Date();
                ee.printStackTrace();
            }
        }
        long seconds = endDate.getTime() / 1000L;
        Long startTime = new Long(seconds - duration);
        record.set("STARTTIME", (Object)startTime);
    }

    private static void setStartTime(Hashtable data) {
        Date endTime = data.get("TIME") != null ? data.get("TIME") : new Date();
        Long duration = (Long)data.get("DURATION");
        if (duration == null) {
            duration = new Long(0L);
        }
        Date endDate = null;
        if (endTime instanceof Date) {
            endDate = endTime;
        } else if (endTime instanceof String) {
            String timeString = (String)((Object)endTime);
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                endDate = format.parse(timeString);
            }
            catch (Exception ee) {
                endDate = new Date();
                ee.printStackTrace();
            }
        }
        long seconds = endDate.getTime() / 1000L;
        Long startTime = new Long(seconds - duration);
        data.put("STARTTIME", startTime);
    }

    private void getSQRecord(Row record, Hashtable data) {
        record.set("SRC_ID", (Object)((Long)data.get("SRC_ID")));
        record.set("DST_ID", (Object)((Long)data.get("DST_ID")));
        record.set("RESOURCE", data.get("RESOURCE"));
        record.set("TIME", data.get("TIME"));
        record.set("DURATION", data.get("DURATION"));
        record.set("SRC", data.get("SRC"));
        record.set("RESULT_CODE", data.get("RESULT_CODE"));
        record.set("HTTPSTATUS", data.get("STATUS_CODE"));
        record.set("BYTES", data.get("BYTES"));
        record.set("OPERATION", data.get("OPERATION"));
        record.set("REQUEST", data.get("REQUEST"));
        String userName = (String)data.get("USERNAME");
        if (userName == null || "-".equals(userName) || userName.trim().length() <= 0) {
            userName = "Unknown";
        }
        record.set("AUTHUSER", (Object)userName);
        record.set("HIERARCHY_CODE", data.get("HIERARCHY_CODE"));
        record.set("DST", data.get("DEST"));
        record.set("CATEGORY", data.get("CATEGORY"));
        record.set("CONTENT_TYPE", data.get("CONTENT_TYPE"));
        record.set("VIRUS", data.get("VIRUS"));
        record.set("STATUS", data.get("STATUS"));
        record.set("TIMEOUT", data.get("TIMEOUT"));
        record.set("PROTOCOL", data.get("PROTOCOL"));
        this.setStartTime(record);
    }

    private void getRaRecord(Row record, Hashtable data) {
        record.set("SYSLOGIP", data.get("SYSLOGIP"));
        record.set("SYSLOG_SERVER", data.get("SYSLOG_SERVER"));
        record.set("RESOURCE", data.get("Host"));
        record.set("TIME", data.get("DATE"));
        record.set("PROTOCOL", (Object)(data.get("TYPE") == null ? "Unknown" : data.get("TYPE")));
        record.set("USER", (Object)(data.get("USERNAME") == null ? "Unknown" : data.get("USERNAME")));
        record.set("TYPE", data.get("TYPE"));
        record.set("SRC", data.get("SRC"));
        record.set("DST", data.get("DEST"));
        record.set("OPERATION", data.get("OPERATION"));
        record.set("RECEIVED", data.get("RECEIVED"));
        record.set("RECEIVED_PKT", data.get("RECEIVED_PKT"));
        record.set("SENT", data.get("SENT"));
        record.set("SENT_PKT", data.get("SENT_PKT"));
        record.set("SESSIONID", data.get("SESSIONID"));
        record.set("IDLETIMEOUT", data.get("IDLETIME"));
        record.set("SESSIONTIMEOUT", data.get("SESSIONTIMEOUT"));
        record.set("FRAMEDIP", data.get("SRC"));
        record.set("FRAMEDNETMASK", data.get("FRAMEDNM"));
        record.set("FRAMEDIPXNW", data.get("FRAMEDIPXNET"));
        record.set("FRAMEDIPXNODE", data.get("FRAMEDIPXNODE"));
        record.set("ACTLINKCOUNT", data.get("LINKCOUNT"));
        record.set("ACTDELAYTIME", data.get("DELAYTIME"));
        record.set("ACTSESSIONTIME", data.get("SESSIONTIME"));
        record.set("DROPPEDOCT", data.get("DROPPEDOCTETS"));
        record.set("DROPPEDPACK", data.get("DROPPEDPACKETS"));
        record.set("BANDWIDTH", data.get("BANDWIDTH"));
    }

    private void getRaSysRecord(Row record, Hashtable data) {
        record.set("RESOURCE", data.get("Host"));
        record.set("HOUR", data.get("DATE"));
        record.set("SEVERITY", data.get("SEVERITY"));
        record.set("MODULE", data.get("MODULE"));
        record.set("SOURCE", data.get("SOURCE"));
        record.set("TYPE", data.get("TYPE"));
        record.set("OPERATION", data.get("OPERATION"));
        record.set("PROTOCOL", (Object)(data.get("PROTOCOL") == null ? "Unknown" : data.get("PROTOCOL")));
        record.set("USER", (Object)(data.get("USERNAME") == null ? "Unknown" : data.get("USERNAME")));
        record.set("EXTENSION", data.get("EXTENSION"));
    }

    private void normalizeData(Hashtable data) {
        String rType = (String)data.get("ResourceType");
        if ("Squid".equals(rType)) {
            this.normalizeSquidData(data);
        } else if (!"Radius".equals(rType) && !"RadiusSys".equals(rType)) {
            this.normalizeFwData(data);
        }
    }

    private void normalizeFwData(Hashtable data) {
        data.put("HOUR", CacheManager.getInstance().getTimeID((Calendar)data.remove("TIME")));
        String fw = (String)data.get("FW");
        String fw_ip = (String)data.get("FW");
        String format = (String)data.remove("LOG_FORMAT");
        String type = (String)data.remove("FW_TYPE");
        String syslogServer = (String)data.remove("SYSLOG_SERVER");
        Object fwKey = CacheManager.getInstance().getFirewallID(fw, fw_ip, format, type, syslogServer);
        data.put("FW", fwKey);
        this.setHostId(data, fwKey, "Firewall");
        this.setDestinationId(data);
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        data.put("PROTOCOL", CacheManager.getInstance().getProtocolID(protocol));
        String priority = (String)data.remove("PRIORITY");
        if (priority == null) {
            priority = "Unknown";
        }
        data.put("PRIORITY_ID", CacheManager.getInstance().getPriorityID(priority));
    }

    private void setHostId(Hashtable data, Object fwKey, String type) {
        String srcName = (String)data.remove("SRC_NAME");
        String src = (String)data.get("SRC");
        String userName = (String)data.get("USERNAME");
        if (userName == null) {
            userName = (String)data.get("RFC931");
        }
        Object crId = null;
        try {
            if (src != null || srcName != null) {
                crId = CacheManager.getInstance().getCrunchIdentifier(fwKey, srcName, src, userName, type);
                data.put("CR_ID", crId);
            } else if (data.get("LOC_IP") != null) {
                src = (String)data.get("LOC_IP");
                crId = CacheManager.getInstance().getCrunchIdentifier(fwKey, src, src, userName, type);
                data.put("CR_ID", crId);
            } else {
                LOGGER.log(Level.FINER, "ConsolidatorTask: SRC || SRCNAME NULL ");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void setDestinationId(Hashtable data) {
        String destName = (String)data.remove("DEST_NAME");
        String dest = (String)data.get("DEST");
        if (dest != null || destName != null) {
            data.put("DEST", CacheManager.getInstance().getHostID(destName, dest));
        } else if (data.get("REM_IP") != null) {
            dest = (String)data.get("REM_IP");
            data.put("DEST", CacheManager.getInstance().getHostID(dest, dest));
        }
    }

    private void normalizeSquidData(Hashtable data) {
        data.put("HOUR", CacheManager.getInstance().getTimeID((Calendar)data.remove("TIME")));
        String syslogServer = (String)data.remove("SYSLOG_SERVER");
        String host = (String)data.get("Host");
        Object fwKey = CacheManager.getInstance().getSquidID(host, syslogServer);
        data.put("SquidID", fwKey);
        data.put("FW", fwKey);
        this.setHostId(data, fwKey, "Squid");
        this.setDestinationId(data);
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        data.put("PROTOCOL", CacheManager.getInstance().getProtocolID(protocol));
        String temp = (String)data.get("URL");
        String dest = null;
        if (temp.indexOf("//") > 0) {
            String te = temp.substring(temp.indexOf(":") + 3, temp.length());
            dest = te.substring(0, te.indexOf("/"));
            if (dest.indexOf(":") > 0) {
                dest = dest.substring(0, dest.indexOf(":"));
            }
        } else {
            dest = temp.substring(0, temp.indexOf(":"));
        }
        Object destId = CacheManager.getInstance().getHostID(dest, dest);
        data.put("DEST", destId);
    }

    public static void checkCisco(Hashtable data, String tableName) {
        Integer eventType;
        String fName;
        ConsolidatorTask.setStartTime(data);
        ConsolidatorTask.handleEmptyValueColumns(data);
        ConsolidatorTask.setEventCode(data);
        String temp = (String)data.get("USER");
        if (temp == null || temp.trim().length() <= 0) {
            temp = (String)data.get("USERNAME") == null ? "Unknown" : (String)data.get("USERNAME");
        }
        data.put("USER", temp);
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        data.put("PROTOCOL", protocol);
        String priority = (String)data.remove("PRI");
        if (priority == null) {
            priority = data.get("PRIORITY") != null ? (String)data.remove("PRIORITY") : "Unknown";
        }
        data.put("PRI", priority);
        if (data.get("DEST_NAME") != null) {
            data.put("DSTNAME", data.get("DEST_NAME"));
        }
        if (data.get("DEST") != null) {
            data.put("DST", data.get("DEST"));
        }
        if (data.get("RECEIVED") != null) {
            data.put("RCVD", data.get("RECEIVED"));
        }
        if (data.get("DEST_PORT") != null) {
            data.put("DST_PORT", data.get("DEST_PORT"));
        }
        if (data.get("RECORD_TYPE") != null) {
            data.put("TYPE", data.get("RECORD_TYPE"));
        }
        if (data.get("MSG") != null && ((String)data.get("MSG")).length() > 100) {
            data.remove("MSG");
        }
        if ((fName = (String)data.get("FILENAME")) != null) {
            data.put("FILENAME", fName);
        }
        if ((eventType = (Integer)data.get("EVENT_TYPE")) != null) {
            data.put("EVENT_TYPE", eventType);
        } else {
            data.put("EVENT_TYPE", new Integer(0));
        }
        if (data.get("SRC_INT") != null) {
            data.put("SRC_INT", (Long)data.get("SRC_INT"));
            data.put("DST_INT", (Long)data.get("DST_INT"));
        } else {
            data.put("SRC_INT", new Long(0L));
            data.put("DST_INT", new Long(0L));
        }
        if (data.get("EMAIL_SUBJECT") != null) {
            data.put("MAIL_SUBJECT", (String)data.get("EMAIL_SUBJECT"));
        }
    }

    private static void handleEmptyValueColumns(Hashtable data) {
        String type = (String)data.get("RECORD_TYPE");
        boolean isMySQL = "mysql".equals(System.getProperty("DBType", "mysql"));
        String emptyVal = "N/A";
        if (type != null && "spam".equals(type)) {
            String sender = (String)data.get("FROM_EMAIL");
            String recipient = (String)data.get("TO_EMAIL");
            String subject = (String)data.get("EMAIL_SUBJECT");
            if (sender == null || "".equals(sender)) {
                data.put("FROM_EMAIL", emptyVal);
            }
            if (recipient == null || "".equals(recipient)) {
                data.put("TO_EMAIL", emptyVal);
            }
            if (subject == null || "".equals(subject)) {
                data.put("MAIL_SUBJECT", emptyVal);
            }
        }
    }

    private static void setEventCode(Hashtable data) {
        if (DepartmentUtil.isInIntranetRange((Object)((String)data.get("RESOURCE")), (String)((String)data.get("SRC")))) {
            data.put("EVENT_CODE", "0");
        } else {
            data.put("EVENT_CODE", "1");
        }
    }

    private void setCountryForIntranetIP(Hashtable data) {
        if (DepartmentUtil.isInIntranet(data.get("RESOURCE"), (Long)((Long)data.get("SRC_ID")))) {
            data.put("SRC_CNTRYID", FACacheManager.getInstance().getCountryId("Reserved"));
        }
        if (DepartmentUtil.isInIntranet(data.get("RESOURCE"), (Long)((Long)data.get("DST_ID")))) {
            data.put("DST_CNTRYID", FACacheManager.getInstance().getCountryId("Reserved"));
        }
    }

    public static void checkBeforeInsert(Hashtable data) {
        ConsolidatorTask.checkCisco(data, (String)data.get("tableName"));
    }

    private void cleanup() {
        this.dc = null;
        this.data = null;
        this.context = null;
    }

    public Hashtable gethashtableForResourceType(Hashtable data) {
        int type = (Integer)data.get("rtype");
        switch (type) {
            case 6: {
                data.put("tableName", "SquidRecords");
                data = this.createRow(data);
                break;
            }
            case 4: {
                data.put("FORMAT", "RadiusRecords");
                data = this.createRow(data);
                break;
            }
            case 5: {
                data.put("FORMAT", "RadiusSyslogRecords");
                data = this.createRow(data);
                break;
            }
            case 3: {
                data = this.createCiscoPIXRow(data);
                break;
            }
            case 1: 
            case 18: {
                data = this.createRow(data);
                break;
            }
            case 2: {
                data = this.createRow(data);
                break;
            }
            case 10: {
                data = this.createRow(data);
                break;
            }
            case 11: {
                data = this.createRow(data);
                break;
            }
            case 12: {
                data = this.createRow(data);
                break;
            }
            case 13: {
                data.put("tableName", "SquidRecords");
                data = this.createRow(data);
                break;
            }
            case 14: {
                data = this.createRow(data);
                break;
            }
            case 15: {
                data = this.createRow(data);
                break;
            }
            case 16: {
                data = this.createRow(data);
                break;
            }
            case 17: {
                data = this.createRow(data);
                break;
            }
            case 22: {
                data = this.createRow(data);
                break;
            }
            case 24: {
                data = this.createRow(data);
                break;
            }
            case 23: {
                data = this.createRow(data);
                break;
            }
            case 34: {
                data = this.createRow(data);
                break;
            }
            case 25: {
                data = this.createRow(data);
                break;
            }
            case 36: {
                data = this.createRow(data);
                break;
            }
            case 38: {
                data = this.createRow(data);
                break;
            }
            case 42: {
                data = this.createRow(data);
                break;
            }
            default: {
                if (!"true".equals((String)data.get("UnParsed"))) break;
                LOGGER.log(Level.INFO, "[ConsolidatedRecords] UNPARSED RECORD IS   ------->    " + data);
            }
        }
        return data;
    }

    private Hashtable createRow(Hashtable data) {
        if ("FirewallRecords".equals(data.get("tableName"))) {
            data.put("PK", "LRID");
            this.getFWRecord(data);
        } else if ("SquidRecords".equals(data.get("tableName"))) {
            data.put("PK", "SQID");
            this.getSQRecord(data);
        } else {
            return null;
        }
        data.remove("MSG");
        if (data.get("DEST_NAME") != null) {
            data.put("DSTNAME", data.get("DEST_NAME"));
        }
        if (data.get("FILENAME") == null) {
            data.put("FILENAME", "N/A");
        }
        if (data.get("DURATION") != null && data.get("DURATION").toString().matches("\\d{8}")) {
            return null;
        }
        return data;
    }

    private void getFWRecord(Hashtable data) {
        Integer eventType;
        String userName;
        data.put("RESOURCE", data.get("FW"));
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        data.put("PROTOCOL", protocol);
        String priority = (String)data.remove("PRIORITY");
        if (priority == null) {
            priority = "Unknown";
        }
        data.put("PRI", priority);
        if (data.get("RECORD_TYPE") != null) {
            data.put("TYPE", data.get("RECORD_TYPE"));
        }
        if (data.get("DEST") != null) {
            data.put("DST", data.get("DEST"));
        }
        if (data.get("LOG_ID") != null) {
            data.put("PIX_LOG_ID", data.get("LOG_ID"));
        }
        if ((userName = (String)data.get("USERNAME")) == null || userName.trim().length() <= 0 || "-".equals(userName)) {
            userName = "Unknown";
        }
        data.put("USER", userName);
        data.put("DST_PORT", data.get("DEST_PORT"));
        if (data.get("OPERATION") != null) {
            data.put("OP", data.get("OPERATION"));
        }
        data.put("RCVD", data.get("RECEIVED"));
        if (data.get("STATUS_CODE") != null) {
            data.put("HTTPSTATUS", data.get("STATUS_CODE"));
        }
        if ((eventType = (Integer)data.get("EVENT_TYPE")) != null) {
            data.put("EVENT_TYPE", eventType);
        } else {
            data.put("EVENT_TYPE", new Integer(0));
        }
        if (data.get("POLICY_ID") == null) {
            data.put("POLICY_ID", "N/A");
        }
        data.put("POLICY_ID", data.get("POLICY_ID"));
        this.populateSrcDstInt(data);
        String temp = (String)data.get("TRAN_IP");
        if (temp == null) {
            temp = "Unknown";
        }
        data.put("TRAN_IP", temp);
        if (data.get("TRAN_PORT") == null) {
            data.put("TRAN_PORT", "N/A");
        }
        data.put("TRAN_PORT", data.get("TRAN_PORT"));
        if (data.get("EMAIL_SUBJECT") != null) {
            data.put("MAIL_SUBJECT", (String)data.get("EMAIL_SUBJECT"));
        }
        ConsolidatorTask.setStartTime(data);
        ConsolidatorTask.handleEmptyValueColumns(data);
        ConsolidatorTask.setEventCode(data);
        this.setCountryForIntranetIP(data);
    }

    private void getSQRecord(Hashtable data) {
        String userName;
        if (data.get("STATUS_CODE") != null) {
            data.put("HTTPSTATUS", data.get("STATUS_CODE"));
        }
        if ((userName = (String)data.get("USERNAME")) == null || "-".equals(userName) || userName.trim().length() <= 0) {
            userName = "Unknown";
        }
        data.put("AUTHUSER", userName);
        data.put("DST", data.get("DEST"));
        ConsolidatorTask.setStartTime(data);
    }

    private void populateSrcDstInt(Hashtable data) {
        if (data.get("SRC_INT") != null) {
            data.put("SRC_INT", (Long)data.get("SRC_INT"));
            data.put("DST_INT", (Long)data.get("DST_INT"));
        } else {
            data.put("SRC_INT", new Long(0L));
            data.put("DST_INT", new Long(0L));
        }
    }

    private Hashtable createCiscoPIXRow(Hashtable data) {
        String fName;
        data.put("PK", "LRID");
        String temp = (String)data.get("USER");
        if (temp == null || temp.trim().length() <= 0) {
            temp = "Unknown";
        }
        data.put("USER", temp);
        String protocol = (String)data.remove("PROTOCOL");
        if (protocol == null) {
            protocol = "Unknown";
        }
        data.put("PROTOCOL", protocol);
        String priority = (String)data.remove("PRI");
        if (priority == null) {
            priority = "Unknown";
        }
        data.put("PRI", priority);
        if (data.get("DEST_NAME") != null) {
            data.put("DSTNAME", data.get("DEST_NAME"));
        }
        if (data.get("RECORD_TYPE") != null) {
            data.put("TYPE", data.get("RECORD_TYPE"));
        }
        if ((fName = (String)data.get("FILENAME")) != null) {
            data.put("FILENAME", fName);
        }
        data.put("SENT", (Long)data.get("SENT"));
        data.put("RCVD", (Long)data.get("RCVD"));
        Integer eventType = (Integer)data.get("EVENT_TYPE");
        if (eventType != null) {
            data.put("EVENT_TYPE", eventType);
        } else {
            data.put("EVENT_TYPE", new Integer(0));
        }
        this.populateSrcDstInt(data);
        if (data.get("EMAIL_SUBJECT") != null) {
            data.put("MAIL_SUBJECT", (String)data.get("EMAIL_SUBJECT"));
        }
        ConsolidatorTask.setStartTime(data);
        ConsolidatorTask.handleEmptyValueColumns(data);
        ConsolidatorTask.setEventCode(data);
        this.setCountryForIntranetIP(data);
        if (data.get("MSG") != null && ((String)data.get("MSG")).length() > 100) {
            data.remove("MSG");
        }
        return data;
    }
}

