/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.dc.WELFLogUnifier;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DLinkLogUnifier
extends WELFLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(DLinkLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(22);
    private HashMap l3ProtocolMap = new HashMap();
    private Map tempMem = null;
    private Map vpnIPMapping = null;
    private int tempCount = 0;
    private ArrayList rulesList = new ArrayList();
    private Map connTable = Collections.synchronizedMap(new FixedHashMap());
    private Map vpnConnTable = Collections.synchronizedMap(new FixedHashMap());

    public DLinkLogUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
        this.tempMem = Collections.synchronizedMap(new FixedHashMap(20000));
        this.vpnIPMapping = Collections.synchronizedMap(new FixedHashMap(10000));
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String module = (String)data.get("MODULE");
        LOGGER.log(Level.FINE, " the module is:::  " + module);
        if (module == null) {
            return null;
        }
        if ("true".equals((String)data.get("DROP_LOG"))) {
            LOGGER.log(Level.FINE, "DLinkLogUnifier ::: DROP_LOG is set to true, hence dropping ::::: " + data);
            return null;
        }
        String subType = (String)data.get("SUBTYPE");
        if (subType == null || "".equals(subType)) {
            data.put("SUBTYPE", "100");
        }
        String action = (String)data.get("STATUS");
        String connectionStatus = (String)data.get("ConnStatus");
        String logType = (String)data.remove("LOG_TYPE");
        String logID = (String)data.get("LOG_ID");
        String src = (String)data.get("SRC");
        this.handlePriority(data);
        this.assignPreParserTime(data);
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        boolean dropLog = false;
        if (module.equalsIgnoreCase("CONN")) {
            dropLog = this.handleConnection(data, connectionStatus, src);
            if (dropLog) {
                return null;
            }
        } else {
            if (module.equalsIgnoreCase("ALG")) {
                if ("request_url".equalsIgnoreCase(logType)) {
                    String srcPort = (String)data.get("SRC_PORT");
                    String dummyKey = src + srcPort;
                    String urlKey = dummyKey + "url";
                    String categoryKey = dummyKey + "category";
                    String statusKey = dummyKey + "status";
                    this.tempMem.put(urlKey, (String)data.get("REQUEST"));
                    this.tempMem.put(categoryKey, (String)data.get("CATEGORY"));
                    this.tempMem.put(statusKey, (String)data.get("STATUS"));
                }
                return null;
            }
            if (module.equalsIgnoreCase("VPN")) {
                LOGGER.log(Level.FINE, " inside VPN module...");
                dropLog = this.handleVPN(data, src, logType);
                if (dropLog) {
                    return null;
                }
            } else if (module.equalsIgnoreCase("RULE")) {
                if (!("drop".equalsIgnoreCase(action) || "reject".equalsIgnoreCase(action) || "block".equalsIgnoreCase(action))) {
                    return null;
                }
            } else {
                int intVal;
                String priority;
                if (module.equalsIgnoreCase("ANTISPAM")) {
                    if ("05900814".equals(logID)) {
                        String resultKey = src + "result";
                        this.tempMem.put(resultKey, (String)data.remove("RESULT"));
                    }
                    return null;
                }
                if (module.equalsIgnoreCase("ANTIVIRUS")) {
                    data.put("EVENT_TYPE", "4");
                    data.put("RECORD_TYPE", "virus");
                    if (data.get("VIRUS") == null) {
                        String filename = (String)data.get("FILENAME");
                        data.put("VIRUS", filename);
                    }
                    data.put("li", "1");
                } else if (module.equalsIgnoreCase("SYSTEM")) {
                    if (logType.indexOf("admin") > -1) {
                        data.put("EVENT_TYPE", "1");
                        data.put("li", "1");
                        if (logType.equalsIgnoreCase("admin_login")) {
                            data.put("SUBTYPE", "1");
                            data.put("STATUS", "Success");
                        } else if (logType.equalsIgnoreCase("admin_logout") || logType.equalsIgnoreCase("admin_timeout")) {
                            data.put("SUBTYPE", "2");
                            data.put("STATUS", "Success");
                        } else {
                            data.put("SUBTYPE", "3");
                            data.put("STATUS", "Failed");
                        }
                    } else {
                        priority = (String)data.get("PRIORITY");
                        intVal = Integer.parseInt(priority);
                        if (src == null) {
                            data.put("SRC", "0.0.0.0");
                        }
                        data.put("EVENT_TYPE", "9");
                        data.put("li", "1");
                    }
                } else if (module.equalsIgnoreCase("IDP")) {
                    if (logType.indexOf("virus") > -1) {
                        data.put("RECORD_TYPE", "virus");
                        data.put("EVENT_TYPE", "4");
                        data.put("li", "1");
                    } else if (logType.indexOf("intrusion") > -1) {
                        data.put("RECORD_TYPE", "attack");
                        data.put("EVENT_TYPE", "3");
                        data.put("li", "1");
                    } else if (logType.indexOf("evasion") > -1) {
                        data.put("RECORD_TYPE", "attack");
                        data.put("EVENT_TYPE", "3");
                        data.put("li", "1");
                    }
                } else if (module.equalsIgnoreCase("HA") || module.equalsIgnoreCase("THRESHOLD")) {
                    priority = (String)data.get("PRIORITY");
                    intVal = Integer.parseInt(priority);
                    if (src == null) {
                        data.put("SRC", "0.0.0.0");
                    }
                    data.put("EVENT_TYPE", "9");
                    data.put("li", "1");
                } else if (module.equalsIgnoreCase("IDPUPDATE")) {
                    if (src == null) {
                        data.put("SRC", "0.0.0.0");
                    }
                } else {
                    if (module.equalsIgnoreCase("APPCONTROL")) {
                        if ("application_end".equalsIgnoreCase(logType)) {
                            String srcPort = (String)data.get("SRC_PORT");
                            String dummyKey = src + srcPort;
                            String appKey = dummyKey + "appl";
                            this.tempMem.put(appKey, (String)data.get("APPLICATION"));
                        }
                        return null;
                    }
                    return null;
                }
            }
        }
        this.checkForStatus(data, module);
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        this.checkProtocolSyntax(data);
        data.put("FW_TYPE", "Clavister Firewall");
        data.put("LOG_FORMAT", "Clavister Firewall");
        this.checkPriority(data);
        this.checkSrcDstInterfaces(data, "FW");
        if ("true".equals(System.getProperty("printMemStatus"))) {
            this.printMemStatus();
        }
        return data;
    }

    private void printMemStatus() {
        System.out.println("Size of L3 Protocol Map is :::: " + this.l3ProtocolMap.size());
        System.out.println("Size of tempMem hash is :::::::::: " + this.tempMem.size());
        System.out.println("Content of tempMem hash is :::::::::: " + this.tempMem);
        System.out.println("Size of vpnIPMapping hash is ::::::: " + this.vpnIPMapping.size());
        System.out.println("Content of vpnIPMapping hash is ::::::: " + this.vpnIPMapping);
        System.out.println("Size of connTable is ::::::::::: " + this.connTable.size());
        System.out.println("Content of connTable is ::::::::::: " + this.connTable);
        System.out.println("Size of VPNconnTable is :::::::::::" + this.vpnConnTable.size());
        System.out.println("Content of VPNconnTable is :::::::::::" + this.vpnConnTable);
    }

    private void handlePriority(Hashtable data) {
        String pri = (String)data.get("PRIORITY");
        int actualPri = Integer.parseInt(pri);
        int standardPri = 7 - actualPri;
        pri = Integer.toString(standardPri);
        data.put("PRIORITY", pri);
    }

    private boolean handleConnection(Hashtable data, String connectionStatus, String src) {
        boolean dropLog = false;
        try {
            String resource = (String)data.get("FW");
            String srcPort = (String)data.get("SRC_PORT");
            if (srcPort == null) {
                srcPort = (String)data.get("CONN_ID");
            }
            String dummyKey = src + srcPort;
            String srcIntKey = dummyKey + "srcInt";
            String destIntKey = dummyKey + "destInt";
            String vpnIPMapKey = resource + src;
            String origIP = (String)this.vpnIPMapping.get(vpnIPMapKey);
            LOGGER.log(Level.FINER, " vpnipmap key is ::::  " + vpnIPMapKey);
            LOGGER.log(Level.FINER, " original ip is  ::::  " + origIP);
            if ("open".equalsIgnoreCase(connectionStatus)) {
                Map<String, PIXVPNObject> connMap;
                if (origIP != null) {
                    LOGGER.log(Level.FINER, " origIP is not null and hence it is vpn open ORIGINAL IP is <----->" + origIP);
                    data.put("TRAN_IP", src);
                }
                if ((connMap = (Map<String, PIXVPNObject>)this.connTable.get(resource)) == null) {
                    connMap = Collections.synchronizedMap(new FixedHashMap(10000));
                    this.connTable.put(resource, connMap);
                }
                PIXVPNObject obj = new PIXVPNObject(data);
                connMap.put(dummyKey, obj);
                this.tempMem.put(srcIntKey, (String)data.get("SRC_INTERFACE"));
                this.tempMem.put(destIntKey, (String)data.get("DST_INTERFACE"));
                dropLog = true;
            } else if ("close".equalsIgnoreCase(connectionStatus)) {
                if (origIP == null) {
                    PIXVPNObject obj;
                    LOGGER.log(Level.FINER, " origIP is null and hence it is normal conn close ");
                    String log = (String)data.get("LOG");
                    if (log.indexOf("origDROP") > 0) {
                        dropLog = true;
                        return dropLog;
                    }
                    Map connMap = (Map)this.connTable.get(resource);
                    PIXVPNObject pIXVPNObject = obj = connMap != null ? (PIXVPNObject)connMap.remove(dummyKey) : null;
                    if (obj != null) {
                        Timestamp startTime = obj.getVPNTime();
                        long duration = 0L;
                        duration = (((Timestamp)data.get("TIME")).getTime() - startTime.getTime()) / 1000L;
                        data.put("DURATION", new Long(duration));
                        String urlKey = dummyKey + "url";
                        String categoryKey = dummyKey + "category";
                        String statusKey = dummyKey + "status";
                        String resultKey = src + "result";
                        if (this.tempMem.get(srcIntKey) != null) {
                            data.put("SRC_INTERFACE", this.tempMem.remove(srcIntKey));
                            data.put("DST_INTERFACE", this.tempMem.remove(destIntKey));
                        }
                        String request = (String)this.tempMem.remove(urlKey);
                        String result = (String)this.tempMem.remove(resultKey);
                        String app = (String)this.tempMem.remove(dummyKey + "appl");
                        if (request != null) {
                            data.put("REQUEST", request);
                            data.put("CATEGORY", this.tempMem.remove(categoryKey));
                            String status = (String)this.tempMem.remove(statusKey);
                            if ("block".equalsIgnoreCase(status)) {
                                data.put("li", "1");
                                data.put("EVENT_TYPE", PureFirewallConstants.CONTENT_FILTERING_DENY);
                            }
                        } else if (result != null) {
                            data.put("STATUS", result);
                            data.put("RECORD_TYPE", "spam");
                            data.put("li", "1");
                        }
                        if (app != null) {
                            data.put("TRAN_PORT", app);
                        }
                    }
                } else {
                    LOGGER.log(Level.FINER, " origIP is not null and hence it is vpn close ....." + origIP);
                    String userKey = origIP + "user";
                    String vpnKey = origIP + "VPN";
                    String userName = (String)this.tempMem.get(userKey);
                    String vpn = (String)this.tempMem.get(vpnKey);
                    data.put("USERNAME", userName);
                    data.put("VPN", vpn);
                    String originalSRC = (String)data.get("ORIG_SRC");
                    LOGGER.log(Level.FINER, " original src is::: " + originalSRC);
                    if (originalSRC != null) {
                        data.put("SRC", originalSRC);
                        data.put("TRAN_IP", src);
                    }
                    data.put("li", "1");
                    data.put("SUBTYPE", "7");
                }
            } else {
                dropLog = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dropLog;
    }

    private void checkForStatus(Hashtable data, String module) {
        this.handleAllowedStatus(data);
        String action = (String)data.get("STATUS");
        if (action != null && action.indexOf("block") > 0) {
            action = "block";
        }
        if (!module.equalsIgnoreCase("SYSTEM") && ("drop".equalsIgnoreCase(action) || "reject".equalsIgnoreCase(action) || "block".equalsIgnoreCase(action))) {
            data.put("li", "1");
            data.put("STATUS", "deny");
            data.put("EVENT_TYPE", "5");
        }
    }

    @Override
    public void checkProtocolSyntax(Hashtable data) {
        String l3Proto = (String)data.get("L3_PROTOCOL");
        if (l3Proto != null) {
            Object destPort = data.get("DEST_PORT");
            if (destPort != null) {
                l3Proto = destPort.toString() + "/" + l3Proto;
            }
            data.put("PROTOCOL", l3Proto);
        }
        super.checkProtocolSyntax(data);
    }

    private boolean handleVPN(Hashtable data, String src, String logType) {
        LOGGER.log(Level.FINE, " the logtype is::::" + logType);
        boolean dropLog = false;
        String vpnType = (String)data.get("VPNTYPE");
        String tunnelID = (String)data.get("TUNNEL_ID");
        if (src == null && "L2TP".equalsIgnoreCase(vpnType)) {
            LOGGER.log(Level.FINER, " inside getting IP from memory....");
            String srcFrmMem = (String)this.tempMem.remove(tunnelID);
            data.put("SRC", srcFrmMem);
            src = srcFrmMem;
        }
        data.put("li", "1");
        String tranIPKey = src + "tran_ip";
        String userKey = src + "user";
        String vpnKey = src + "VPN";
        String resource = (String)data.get("FW");
        if ("vc".equalsIgnoreCase(logType)) {
            LOGGER.log(Level.FINER, " inside add vpn obj. src is::: " + src);
            String user = (String)data.get("USERNAME");
            data.put("USER", user);
            if ("L2TP".equalsIgnoreCase(vpnType)) {
                data.put("VPN", "IPSEC/L2TP");
                this.tempMem.put(vpnKey, "IPSEC/L2TP");
            } else {
                data.put("VPN", "PPTP");
                this.tempMem.put(vpnKey, "PPTP");
            }
            this.addVPNObject(data, src, resource);
            String assignedIP = (String)data.get("TRAN_IP");
            String vpnIPMapKey = resource + assignedIP;
            LOGGER.log(Level.FINER, " the ipmap key is ::: " + vpnIPMapKey);
            this.vpnIPMapping.put(vpnIPMapKey, src);
            LOGGER.log(Level.FINER, " the userkey in pc is::: " + userKey);
            this.tempMem.put(tranIPKey, (String)data.get("TRAN_IP"));
            this.tempMem.put(userKey, user);
        } else if ("vd".equalsIgnoreCase(logType)) {
            LOGGER.log(Level.FINE, " inside pptp vpn deletion...");
            String dest = (String)data.get("DEST");
            if ("L2TP".equalsIgnoreCase(vpnType)) {
                data.put("VPN", "IPSEC/L2TP");
            } else {
                data.put("VPN", "PPTP");
            }
            this.removeVPNObject(data, resource);
        } else if ("ltu".equalsIgnoreCase(logType)) {
            LOGGER.log(Level.FINER, " inside before add L2TP vpn obj...tunnelID and IP map::::: " + src);
            this.tempMem.put(tunnelID, src);
            dropLog = true;
        } else {
            dropLog = true;
        }
        return dropLog;
    }

    private void addVPNObject(Hashtable data, String src, String resource) {
        Map<String, PIXVPNObject> VPNconnMap = (Map<String, PIXVPNObject>)this.vpnConnTable.get(resource);
        if (VPNconnMap == null) {
            VPNconnMap = Collections.synchronizedMap(new FixedHashMap(1000));
            this.vpnConnTable.put(resource, VPNconnMap);
        }
        PIXVPNObject obj = new PIXVPNObject(data);
        obj.setVPNName((String)data.remove("VPN"));
        src = src.trim();
        VPNconnMap.put(src, obj);
    }

    private void removeVPNObject(Hashtable data, String resource) {
        Map VPNconnMap = (Map)this.vpnConnTable.get(resource);
        String dest = (String)data.get("DEST");
        String src = (String)data.get("SRC");
        dest = dest.trim();
        src = src.trim();
        String tranIPKey = null;
        String userKey = null;
        String vpnKey = null;
        if (VPNconnMap != null) {
            PIXVPNObject obj = (PIXVPNObject)VPNconnMap.remove(dest);
            if (obj != null) {
                LOGGER.log(Level.FINER, " the vpn obj isn't null for dest:::" + dest);
                tranIPKey = dest + "tran_ip";
                userKey = dest + "user";
                vpnKey = dest + "VPN";
            } else {
                obj = (PIXVPNObject)VPNconnMap.remove(src);
                if (obj != null) {
                    LOGGER.log(Level.FINER, " the vpn obj isn't null for src:::" + src);
                    tranIPKey = src + "tran_ip";
                    userKey = src + "user";
                    vpnKey = src + "VPN";
                }
            }
            Timestamp startTime = obj.getVPNTime();
            long duration = 0L;
            duration = (((Timestamp)data.get("TIME")).getTime() - startTime.getTime()) / 1000L;
            data.put("DURATION", new Long(duration));
            data.put("TRAN_IP", this.tempMem.remove(tranIPKey));
            data.put("USERNAME", this.tempMem.get(userKey));
            data.remove("DEST");
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.vpnConnTable.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }
}

