/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RadiusSysLogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(RadiusSysLogUnifier.class.getName());
    String DATE_FORMAT = "MMM dd HH:mm:ss yyyy";
    private static final Integer TYPE = new Integer(5);

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("ResourceType", "RadiusSys");
        data.put("rtype", TYPE);
        this.handleTime(data);
        for (String attribute : new String[]{}) {
            String toBeChanged = (String)data.get(attribute);
            if (toBeChanged == null) continue;
            Integer changed = null;
            try {
                changed = new Integer(Integer.parseInt(toBeChanged));
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.FINER, " Unable to parse {0} :: {1}", new Object[]{attribute, toBeChanged});
                nfe.printStackTrace();
            }
            if (changed == null) continue;
            data.put(attribute, changed);
        }
        for (String attribute : new String[]{}) {
            String toBeChanged = (String)data.get(attribute);
            Long changed = null;
            if (toBeChanged != null) {
                try {
                    changed = new Long(Long.parseLong(toBeChanged));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.FINER, " Unable to parse {0} :: {1}", new Object[]{attribute, toBeChanged});
                    nfe.printStackTrace();
                }
            }
            if (changed == null) {
                changed = new Long(0L);
            }
            data.put(attribute, changed);
        }
        data.put("Host", host);
        return data;
    }

    private void handleTime(Hashtable data) {
        String time = (String)data.remove("DATE");
        if (time == null) {
            return;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        SimpleDateFormat sdf = new SimpleDateFormat(this.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        try {
            data.put("DATE", sdf.parse(time + " " + Calendar.getInstance().get(1)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

