/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.imp;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.imp.ImportLogTask;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportLogManager {
    private static final Logger LOGGER = Logger.getLogger(ImportLogManager.class.getName());
    public static final int IMPORT_STARTED = 1000;
    public static final int LOCALLY_AVAILABLE = 1001;
    public static final int NOT_MODIFIED = 1002;
    public static final int MARKER_FOUND = 1003;
    public static final int PARSING_WHOLE_FILE = 1004;
    public static final int BATCH_PROCESS = 1005;
    public static final int BATCH_REPORTS = 1006;
    public static final int IMPORT_COMPLETE = 1007;
    public static final int MODIFIED = 1008;
    public static final int IMPORT_FAILED = 1009;
    public static final int FTP_FAILED = 1016;
    public static final int YET_TO_PARSE_NEWFILE = 1015;
    public static final int ENABLED = 1010;
    public static final int DISABLED = 1011;
    public static final int ALREADY_STOPPED = 1012;
    public static final int ALREADY_RUNNING = 1013;
    public static final int NO_SUCH_TASK = 1014;
    public static final int SIGNATURE_VERIFIED = 1017;
    public static final int SIGNATURE_MISMATCHED = 1018;
    public static final int SIGNATURE_EXCEPTION = 1019;
    public static final int IMPORT_COMPLETE_WITH_SIGN = 1020;
    private static ImportLogManager logMgr = null;
    private ClockDaemon scheduler = null;
    private ScheduledThreadPoolExecutor ss = null;
    private HashMap statmap = new HashMap();
    private Hashtable taskHash = new Hashtable();

    private ImportLogManager() {
        this.startScheduler();
        this.initializeTasks();
    }

    public static synchronized ImportLogManager getInstance() {
        if (logMgr != null) {
            return logMgr;
        }
        logMgr = new ImportLogManager();
        return logMgr;
    }

    public int enableImport(Long il_id) throws Exception {
        if (this.taskHash.get(il_id) != null) {
            return 1013;
        }
        DataObject dobj = this.getConfiguration(il_id);
        if (dobj == null) {
            return 1014;
        }
        Row row = dobj.getFirstRow("ImportedLogs");
        this.importLog(this.getProperties(row));
        this.updateStatus(il_id, 1010, "MESSAGE", "Successfully enabled");
        return 1010;
    }

    private Hashtable getProperties(Row row) {
        List list = row.getColumns();
        Hashtable<String, Object> doHash = new Hashtable<String, Object>();
        for (String name : list) {
            if (row.get(name) == null) continue;
            doHash.put(name, row.get(name));
        }
        return doHash;
    }

    public int disableImport(Long il_id) throws Exception {
        if (this.taskHash.get(il_id) == null) {
            return 1012;
        }
        ImportLogTask tsk = (ImportLogTask)this.statmap.remove(il_id);
        tsk.abort = true;
        Object taskHandle = this.taskHash.remove(il_id);
        try {
            ClockDaemon.cancel(taskHandle);
        }
        catch (Exception e) {
            this.ss.remove((Runnable)taskHandle);
        }
        this.updateStatus(il_id, 1011, "MESSAGE", "Successfully disabled");
        return 1011;
    }

    public void importLog(Hashtable hash) throws Exception {
        this.updateDB(hash);
        LOGGER.log(Level.FINER, "ImportLogMgr:import log request<->{0}", hash);
        long timeInMilliSec = -1L;
        long delayTime = -1L;
        Object timeTostart = null;
        try {
            Long tempLong = null;
            if (hash.get("TIME_INTERVAL") != null) {
                Object tObj = hash.get("TIME_INTERVAL");
                if (tObj != null && tObj instanceof Long) {
                    tempLong = (Long)tObj;
                    timeInMilliSec = tempLong * 60L * 1000L;
                } else if (tObj != null && !"".equalsIgnoreCase((String)tObj)) {
                    tempLong = Long.valueOf((String)tObj);
                    timeInMilliSec = tempLong * 60L * 1000L;
                }
                hash.put("TIME_INTERVAL", tempLong);
            }
            if (tempLong != null && tempLong > 0L && hash.get("DELAY_TIME") != null) {
                delayTime = (Long)hash.get("DELAY_TIME");
            }
        }
        catch (Exception e) {
            timeInMilliSec = -1L;
            LOGGER.log(Level.INFO, "Invalid time format<->{0}<->", hash.get("TIME_INTERVAL"));
            e.printStackTrace();
        }
        ImportLogTask task = new ImportLogTask(hash);
        this.statmap.put((Long)hash.get("IL_ID"), task);
        ScheduledFuture<?> taskHandle = null;
        if (timeInMilliSec == -1L || timeInMilliSec == 0L) {
            taskHandle = this.scheduler.executeAfterDelay(1L, (Runnable)task);
        } else if (delayTime > 0L) {
            taskHandle = this.ss.scheduleWithFixedDelay(task, delayTime, timeInMilliSec / 1000L, TimeUnit.SECONDS);
            LOGGER.log(Level.WARNING, "New scheduler, delay is " + delayTime + " scheduleInter " + timeInMilliSec / 1000L);
        } else {
            taskHandle = this.scheduler.executePeriodically(timeInMilliSec, (Runnable)task, true);
        }
        this.taskHash.put((Long)hash.get("IL_ID"), taskHandle);
    }

    public void updateDB(Hashtable hash) {
        LOGGER.log(Level.FINER, "ImportLogMgr:updateDB request<->{0}", hash);
        if (hash.containsKey("IL_ID")) {
            return;
        }
        LOGGER.log(Level.FINER, "ImportLogMgr:adding new entry <->{0}", hash);
        String fileName = (String)hash.get("FILE_NAME");
        if (fileName == null) {
            int indexOfSlash;
            String loc = (String)hash.get("remotefilelocation");
            int n = indexOfSlash = loc != null ? loc.lastIndexOf("/") : -1;
            if (indexOfSlash > 0) {
                fileName = loc.substring(indexOfSlash + 1, loc.length());
                hash.put("FILE_NAME", fileName);
            }
        }
        Object obj = hash.get("LOCATION");
        String location = null;
        location = obj instanceof File ? ((File)obj).getPath() : obj.toString();
        String[] params = new String[]{"FILE_NAME", "LOG_TYPE", "REMOTE_CLIENT", "SIZE", "PROTOCOL", "REMOTE_HOSTNAME", "REMOTE_USERNAME", "REMOTE_PASSWORD", "REMOTE_DIR", "TIME_INTERVAL"};
        Row row = new Row("ImportedLogs");
        row.set("LOCATION", (Object)location);
        row.set("STATUS", (Object)new Long(1000L));
        row.set("MESSAGE", (Object)"Importing of log records started...");
        if (hash.containsKey("FTPPORT")) {
            int port = Integer.parseInt((String)hash.get("FTPPORT"));
            row.set("FTPPORT", (Object)port);
        }
        for (int i = 0; i < params.length; ++i) {
            String key = params[i];
            String val = (String)hash.get(key);
            if (val == null && !key.equals("TIME_INTERVAL")) {
                val = "-";
            }
            if (val == null) continue;
            row.set(key, (Object)val);
        }
        String importedTime = null;
        if (hash.get("IMPORTED_TIME") instanceof Long) {
            Long time = (Long)hash.get("IMPORTED_TIME");
            String DATE_FORMAT = "dd MMM yyyy HH:mm:ss";
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            importedTime = df.format(new Date(time));
        } else {
            importedTime = (String)hash.get("IMPORTED_TIME");
        }
        row.set("IMPORTED_TIME", (Object)importedTime);
        LOGGER.log(Level.FINER, " IMPORTED_TIME :: {0}", importedTime);
        try {
            DataObject dobj = DataAccess.constructDataObject();
            dobj.addRow(row);
            dobj = DataAccess.add((DataObject)dobj);
            hash.put("IL_ID", dobj.getFirstValue("ImportedLogs", "IL_ID"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.log(Level.INFO, "Failed to get IL_ID");
        }
    }

    private void shutdownScheduler() {
        this.scheduler.shutDown();
    }

    public static void shutdown() {
        if (logMgr != null) {
            logMgr.shutdownScheduler();
        }
    }

    private void startScheduler() {
        this.scheduler = new ClockDaemon();
        this.ss = new ScheduledThreadPoolExecutor(2);
    }

    private void initializeTasks() {
        try {
            Table expTable = new Table("ImportedLogs");
            SelectQueryImpl sql = new SelectQueryImpl(expTable);
            Column col = new Column("ImportedLogs", "*");
            sql.addSelectColumn(col);
            Criteria crit = new Criteria(new Column("ImportedLogs", "STATUS"), (Object)new Integer(1011), 1);
            Criteria crit2 = new Criteria(new Column("ImportedLogs", "STATUS"), (Object)new Integer(1007), 1);
            crit = crit.and(crit2);
            Criteria crit4 = new Criteria(new Column("ImportedLogs", "STATUS"), (Object)new Integer(1018), 7);
            crit = crit.and(crit4);
            Criteria crit3 = new Criteria(new Column("ImportedLogs", "TIME_INTERVAL"), (Object)new Long(0L), 5);
            crit = crit.or(crit3);
            sql.setCriteria(crit);
            DataObject dobj = DataAccess.get((SelectQuery)sql);
            Iterator it = dobj.getRows("ImportedLogs");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String type = (String)row.get("LOG_TYPE");
                String enddat = (String)row.get("ENDDATE");
                long timeInter = (Long)row.get("TIME_INTERVAL");
                int status = Integer.parseInt(row.get("STATUS").toString());
                int delayStart = type.lastIndexOf("!-");
                LOGGER.log(Level.FINER, "Initializing task {0}", row);
                if (status == 1011) continue;
                Hashtable hash = this.getProperties(row);
                if (delayStart > -1) {
                    type = type.substring(delayStart + 2);
                    String[] time = type.split(":");
                    if (enddat == null) {
                        hash.put("timeTostartHour", time[0]);
                        hash.put("timeTostartMins", time[1]);
                        FAServerUtil.calculateTimeGap(hash);
                    } else {
                        hash.put("DELAY_TIME", ImportLogManager.logicalDelay(time, timeInter));
                    }
                    LOGGER.log(Level.WARNING, "on start up" + time[0] + " mins is " + time[1]);
                }
                this.importLog(hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "unable to intialize task ");
        }
    }

    public DataObject getConfiguration(Long il_id) {
        if (il_id == null) {
            return null;
        }
        try {
            DataObject dobj = null;
            Row row = new Row("ImportedLogs");
            row.set("IL_ID", (Object)il_id);
            dobj = DataAccess.get((String)"ImportedLogs", (Row)row);
            return dobj;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Failed to get RECORD_MARKER");
            return null;
        }
    }

    private void updateStatus(Long il_id, int type, Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        this.updateStatus(il_id, type, map);
    }

    public void cleanInvalidEntry(Long il_id) {
        LOGGER.log(Level.INFO, "Unable to fetch import log entry so disabling:{0}", il_id);
        try {
            ImportLogManager.getInstance().disableImport(il_id);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Unable to disable import log task:{0}", il_id);
        }
    }

    public void updateStatus(Long il_id, int type, HashMap hash) {
        try {
            DataObject dobj = ImportLogManager.getInstance().getConfiguration(il_id);
            if (dobj == null) {
                this.cleanInvalidEntry(il_id);
                return;
            }
            Row row = dobj.getFirstRow("ImportedLogs");
            row.set("STATUS", (Object)new Long(type));
            LOGGER.log(Level.FINER, "Import complete debug{0}<->{1}", new Object[]{dobj, hash});
            if (hash != null) {
                Long l = (Long)hash.remove("RECORDS");
                if (l != null) {
                    Long rowLong = (Long)row.get("RECORDS");
                    if (type == 1004) {
                        row.set("RECORDS", (Object)new Long(0L));
                    } else {
                        row.set("RECORDS", (Object)new Long(rowLong != null ? rowLong + l : l));
                    }
                }
                for (String key : hash.keySet()) {
                    row.set(key, hash.get(key));
                }
                if (!hash.containsKey("MESSAGE")) {
                    row.set("MESSAGE", (Object)"");
                }
                if (hash.get("IMPORTED_TIME") != null && hash.get("IMPORTED_TIME") instanceof Long) {
                    Long time = (Long)hash.get("IMPORTED_TIME");
                    String DATE_FORMAT = "dd MMM yyyy HH:mm:ss";
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                    String importedtime = df.format(new Date(time));
                    row.set("IMPORTED_TIME", (Object)importedtime);
                }
            }
            dobj.updateRow(row);
            LOGGER.log(Level.FINER, "Final data object...<->{0}", dobj);
            DataAccess.update((DataObject)dobj);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Exception while updating import log status :{0}", new Integer(type));
        }
    }

    public static long logicalDelay(String[] arr, long interval) {
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        int hourofDay = calendar.get(11) * 60;
        int minofHour = calendar.get(12);
        int hour = Integer.parseInt(arr[0]) * 60;
        int mins = Integer.parseInt(arr[1]);
        int presentTime = hourofDay + minofHour;
        int startTime = hour + mins;
        long delay = 0L;
        if (interval > 1440L && (interval %= 1440L) == 0L) {
            interval = 1440L;
        }
        if (presentTime > startTime) {
            delay = presentTime - startTime;
            delay %= interval;
            delay = interval - delay;
        } else {
            delay = startTime - presentTime;
            delay %= interval;
        }
        LOGGER.log(Level.WARNING, " PresentTime :: " + presentTime + " StartTime :: " + startTime + " delayinMins " + delay);
        return delay * 60L;
    }
}

