/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.imp;

import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.imp.FTPUtil;
import com.adventnet.fa.server.imp.ImportLogManager;
import com.adventnet.fa.server.imp.SFTPUtil;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.RecordHandler;
import com.adventnet.fa.server.lc.TriggerTasks;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.MultiMemberGZIPInputStream;
import com.adventnet.la.util.TimeStampingAPI;
import com.adventnet.la.util.pe.DataArchiverInterface;
import com.adventnet.la.util.pe.Record;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.enterprisedt.net.ftp.FTPClient;
import com.sshtools.sftp.SftpClient;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ImportLogTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ImportLogTask.class.getName());
    private Hashtable hash = null;
    private long batch_size = 20000L;
    private Long il_id = null;
    private DataObject dobj = null;
    public boolean abort = false;
    private boolean ignoreUnParsedRecords = true;
    private Boolean considerAsVdom = Boolean.FALSE;
    private String vdomIPAddress = null;
    private boolean isEncryptedFile = false;
    private static boolean highFlow = "true".equals(System.getProperty("highFlow", "false"));

    public ImportLogTask(Hashtable hash) {
        LOGGER.log(Level.FINE, "ImportLogTask: new task created...");
        this.hash = hash;
        this.il_id = (Long)hash.get("IL_ID");
        if (System.getProperty("batch_size") != null) {
            try {
                this.batch_size = Long.valueOf(System.getProperty("batch_size"));
            }
            catch (Exception e) {
                this.batch_size = 20000L;
                LOGGER.log(Level.INFO, "Invalid parameter resetting to default<->{0}", new Long(this.batch_size));
            }
        }
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, "ImportLogTask Modified Called.");
        this.dobj = ImportLogManager.getInstance().getConfiguration(this.il_id);
        if (this.dobj == null) {
            ImportLogManager.getInstance().cleanInvalidEntry(this.il_id);
            return;
        }
        String fileName = (String)this.hash.get("FILE_NAME");
        String logType = (String)this.hash.get("LOG_TYPE");
        String pattern = null;
        if (logType != null) {
            String[] temp = logType.split("!");
            String[] temp1 = logType.split("!-");
            logType = temp[0];
            if (temp1.length > 1 && temp.length > 2 || temp1.length == 1 && temp.length > 1) {
                pattern = temp[1];
                LOGGER.log(Level.WARNING, " the pattern is " + pattern + logType);
            }
        } else {
            logType = "";
        }
        this.processFile(fileName, logType, false);
        Object obj = this.hash.get("LOCATION");
        String locationForPattern = null;
        locationForPattern = obj instanceof File ? ((File)obj).getPath() : obj.toString();
        if (pattern != null) {
            String[] result = this.getTodaysFileName(new String[]{fileName, locationForPattern}, pattern);
            String todayFileName = result[0];
            String location = result[1];
            if (!fileName.equalsIgnoreCase(todayFileName)) {
                if (logType.equals("remote")) {
                    todayFileName = todayFileName.replaceAll("\\\\", "\\\\\\\\");
                    location = location.replaceAll("\\\\", "\\\\\\\\");
                }
                LOGGER.log(Level.FINE, "FileName changed processing <->old file:: {0} new file:: {1}", new Object[]{fileName, todayFileName});
                this.hash.put("FILE_NAME", todayFileName);
                this.hash.put("LOCATION", location);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("FILE_NAME", todayFileName);
                map.put("LOCATION", location);
                this.updateStatus(1015, map);
                this.processFile(todayFileName, logType, true);
            }
        }
        this.dobj = null;
    }

    private String[] getTodaysFileName(String[] fileNames, String pattern) {
        String fileName = fileNames[0];
        String location = fileNames[1];
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String currentFormat = format.format(new java.util.Date());
        StringBuffer regex = new StringBuffer();
        if (fileName.indexOf(currentFormat) < 0) {
            if (pattern.equals("EEE")) {
                regex.append("(Mon|Tue|Wed|Thu|Fri|Sat|Sun)");
            } else {
                int length = pattern.length();
                block4: for (int i = 0; i < length; ++i) {
                    char c = pattern.charAt(i);
                    switch (c) {
                        case 'E': 
                        case 'M': {
                            regex.append("[A-Za-z0-9]");
                            continue block4;
                        }
                        case 'D': 
                        case 'F': 
                        case 'H': 
                        case 'K': 
                        case 'S': 
                        case 'W': 
                        case 'd': 
                        case 'h': 
                        case 'k': 
                        case 'm': 
                        case 's': 
                        case 'w': 
                        case 'y': {
                            regex.append("\\d");
                            continue block4;
                        }
                        default: {
                            regex.append(c);
                        }
                    }
                }
            }
            fileName = fileName.replaceAll(regex.toString(), currentFormat);
            location = location.replaceAll(regex.toString(), currentFormat);
            fileNames[0] = fileName;
            fileNames[1] = location;
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processFile(String fileName, String logType, boolean isDynamicFile) {
        String host;
        File fileToDelete;
        File location;
        boolean runSplitter;
        long intime;
        block110: {
            block111: {
                String remoteHost;
                block106: {
                    String size;
                    String remoteDir;
                    int ftpPort;
                    String remotePwd;
                    String remoteUser;
                    String protocol;
                    block112: {
                        FTPClient client;
                        block105: {
                            String f;
                            block109: {
                                intime = System.currentTimeMillis();
                                runSplitter = false;
                                LOGGER.log(Level.FINE, "ImportLogTask: started...");
                                protocol = (String)this.hash.get("PROTOCOL");
                                this.updateStatus(1000, "IMPORTED_TIME", intime);
                                location = null;
                                fileToDelete = null;
                                host = null;
                                LOGGER.log(Level.FINE, "ImportLogTask HASHMAP IS {0}  ", this.hash);
                                LOGGER.log(Level.FINE, "ImportLogTask FILE NAME IS {0}  ", fileName);
                                if (!logType.equals("local")) break block109;
                                Object toDelete = this.hash.get("LOCATION");
                                if (this.hash.get("TIME_INTERVAL") != null) {
                                    String locString = (String)this.hash.get("FILE_NAME");
                                    location = new File(locString);
                                } else {
                                    location = toDelete instanceof File ? (File)toDelete : new File((String)toDelete);
                                    fileToDelete = location;
                                }
                                host = (String)this.hash.get("REMOTE_CLIENT");
                                this.ignoreUnParsedRecords = new Boolean((String)this.hash.get("ignoreUnParsedRecords"));
                                this.considerAsVdom = Boolean.valueOf((String)this.hash.get("considerAsVdom"));
                                this.vdomIPAddress = (String)this.hash.get("vdomIPAddress");
                                LOGGER.log(Level.FINE, "ImportLogTask ignoreUnParsedRecords value is [{0}] considerAsVdom value is [{1}] vdomIpAddress value is [{2}]", new Object[]{this.ignoreUnParsedRecords, this.considerAsVdom, this.vdomIPAddress});
                                if ("true".equals(this.hash.get("RUN_SPLITTER"))) {
                                    runSplitter = true;
                                }
                                break block110;
                            }
                            if (!logType.equals("remote")) break block111;
                            remoteHost = URLDecoder.decode((String)this.hash.get("REMOTE_HOSTNAME"));
                            remoteUser = URLDecoder.decode((String)this.hash.get("REMOTE_USERNAME"));
                            remotePwd = URLDecoder.decode((String)this.hash.get("REMOTE_PASSWORD"));
                            ftpPort = Integer.parseInt(this.hash.get("FTPPORT") + "");
                            remoteDir = (String)this.hash.get("REMOTE_DIR");
                            if (fileName == null) {
                                int atIndex;
                                int indexOfSlash;
                                String loc = (String)this.hash.get("remotefilelocation");
                                int n = indexOfSlash = loc != null ? loc.lastIndexOf("/") : -1;
                                if (indexOfSlash > 0) {
                                    fileName = loc.substring(indexOfSlash + 1, loc.length());
                                }
                                if (remoteDir == null && (atIndex = loc.indexOf("@")) > 0) {
                                    int remoteDirStartIndex = atIndex + remoteHost.length() + 2;
                                    if (remoteDirStartIndex < indexOfSlash) {
                                        remoteDir = loc.substring(remoteDirStartIndex, loc.length());
                                    } else if (remoteDirStartIndex == indexOfSlash) {
                                        remoteDir = "";
                                    }
                                }
                            }
                            LOGGER.log(Level.FINE, "ImportLogTask  FILE_NAME is  {0} and REMOTE_DIR is {1}  ", new String[]{fileName, remoteDir});
                            String tempUnparsed = (String)this.hash.get("remoteIgnoreUnParsedRecords");
                            this.considerAsVdom = Boolean.valueOf((String)this.hash.get("remoteConsiderAsVdom"));
                            this.vdomIPAddress = (String)this.hash.get("remoteVdomIPAddress");
                            if (tempUnparsed != null) {
                                this.ignoreUnParsedRecords = new Boolean(tempUnparsed);
                            }
                            LOGGER.log(Level.FINER, "ImportLogTask remote import values:::ignoreUnParsedRecords value is [{0}] considerAsVdom value is [{1}] vdomIpAddress value is [{2}]", new Object[]{this.ignoreUnParsedRecords, this.considerAsVdom, this.vdomIPAddress});
                            if (!"ftp".equalsIgnoreCase(protocol) || !"sftp".equalsIgnoreCase(protocol)) {
                                LOGGER.log(Level.INFO, "Unsupported protocol{0}", this.hash);
                                location = null;
                            }
                            if (!protocol.equals("FTP")) break block112;
                            client = null;
                            client = fileName.endsWith(".gz") || fileName.endsWith(".zip") ? FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (client == null || (f = FTPUtil.doFTP(client, null, remoteDir, fileName)) == null) break block105;
                            fileToDelete = location = new File(f);
                            long sizeInBytes = location.length();
                            if (sizeInBytes > 0x80000000L) {
                                runSplitter = true;
                            }
                            size = null;
                            size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
                            this.updateStatus(1001, "SIZE", size);
                        }
                        try {
                            FTPUtil.logOut(client);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, "Exception while FTP logout");
                        }
                        break block106;
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                String errorMessage = e.getMessage();
                                int index = errorMessage.indexOf(":");
                                String trimmedErrMsg = errorMessage.substring(index + 1);
                                this.updateStatus(1016, "MESSAGE", trimmedErrMsg);
                                LOGGER.log(Level.INFO, "ImportLogTask:unable to ftp{0}", remoteHost);
                            }
                            catch (Throwable throwable) {
                                try {
                                    FTPUtil.logOut(client);
                                }
                                catch (Exception e2) {
                                    LOGGER.log(Level.INFO, "Exception while FTP logout");
                                }
                                throw throwable;
                            }
                            try {
                                FTPUtil.logOut(client);
                            }
                            catch (Exception e3) {
                                LOGGER.log(Level.INFO, "Exception while FTP logout");
                            }
                            break block106;
                        }
                    }
                    if (protocol.equals("SFTP")) {
                        SftpClient sftpClient;
                        block107: {
                            sftpClient = null;
                            sftpClient = fileName.endsWith(".gz") || fileName.endsWith(".zip") ? SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (sftpClient == null) break block107;
                            String f = SFTPUtil.doSFTP(sftpClient, null, remoteDir, fileName);
                            LOGGER.log(Level.FINE, f);
                            if (f == null) break block107;
                            fileToDelete = location = new File(f);
                            long sizeInBytes = location.length();
                            size = null;
                            size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
                            LOGGER.log(Level.INFO, "got file with size" + size);
                            this.updateStatus(1001, "SIZE", size);
                        }
                        try {
                            SFTPUtil.logOut(sftpClient);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, "Exception while SFTP logout");
                        }
                        break block106;
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                LOGGER.log(Level.INFO, "Unable to SFTP {0}", remoteHost);
                            }
                            catch (Throwable throwable) {
                                try {
                                    SFTPUtil.logOut(sftpClient);
                                }
                                catch (Exception e4) {
                                    LOGGER.log(Level.INFO, "Exception while SFTP logout");
                                }
                                throw throwable;
                            }
                            try {
                                SFTPUtil.logOut(sftpClient);
                            }
                            catch (Exception e5) {
                                LOGGER.log(Level.INFO, "Exception while SFTP logout");
                            }
                        }
                    }
                }
                if (location == null) {
                    LOGGER.log(Level.FINE, "ImportLogTask:failed to fetch file<->{0}", this.hash);
                }
                host = remoteHost;
                break block110;
            }
            if (!logType.equals("archive")) {
                LOGGER.log(Level.FINE, "No log type mentioned for Import{0}", this.hash);
            }
        }
        if (location != null) {
            BufferedReader reader = null;
            ZipFile zipFile = null;
            Enumeration<? extends ZipEntry> enu = null;
            try {
                if (!location.exists()) {
                    LOGGER.log(Level.WARNING, "No log file found in location:{0}", location);
                    return;
                }
                if (!"local".equals((String)this.hash.get("LOG_TYPE")) && !this.isFileUpdated(location)) {
                    this.updateStatus(1002);
                    LOGGER.log(Level.FINE, "File not modified :{0} in location ", new Object[]{fileName, location});
                    return;
                }
                this.updateStatus(1008, "LAST_MODIFIED_TIME", new Timestamp(location.lastModified()));
                String record = null;
                String syslog_name = "1";
                int recordCount = 0;
                boolean noStartTime = true;
                boolean markReached = false;
                Object gzFileLocation = null;
                Object zipFileLocation = null;
                String zipFileName = null;
                File tempGZFileName = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "tmp" + File.separator + "importFile.zip");
                if (fileName.endsWith(".gz")) {
                    this.loadGUNZipContent(location, tempGZFileName);
                    try {
                        zipFile = new ZipFile(tempGZFileName);
                        zipFileName = tempGZFileName.getName();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Imported a normal gunzip file & is not our archived gunzip file.");
                        zipFile = null;
                        reader = new BufferedReader(new FileReader(tempGZFileName));
                    }
                } else if (fileName.endsWith(".zip")) {
                    zipFile = new ZipFile(location);
                    zipFileName = fileName;
                } else {
                    if (location.getName().endsWith(".enc")) {
                        this.isEncryptedFile = true;
                    }
                    reader = new BufferedReader(new FileReader(location));
                }
                boolean signatureVerified = false;
                if (zipFile != null) {
                    String fName = new File(zipFileName).getName();
                    String signatureFileName = fName.substring(0, fName.lastIndexOf(".zip")) + ".sgn";
                    ZipEntry signZipEntry = zipFile.getEntry(signatureFileName);
                    if (signZipEntry != null) {
                        int status = TimeStampingAPI.getInstance().verify(zipFile, signatureFileName, zipFileName, -1L);
                        HashMap<String, String> map = new HashMap<String, String>();
                        if (status != 0) {
                            int statusTobeUpdated = 1019;
                            if (status == 1) {
                                statusTobeUpdated = 1018;
                                map.put("MESSAGE", "Zip Data might be altered");
                            }
                            this.updateStatus(1018, map);
                            this.deleteFiles(fileToDelete, tempGZFileName, location);
                            return;
                        }
                        this.updateStatus(1017, map);
                        signatureVerified = true;
                    }
                    enu = zipFile.entries();
                    reader = this.getReaderObj(enu, zipFile);
                }
                DataArchiverInterface darch = FwParserEngine.getInstance().getDataArchiver();
                String recordMarker = (String)this.dobj.getFirstValue("ImportedLogs", "RECORD_MARKER");
                String headerLog = (String)this.dobj.getFirstValue("ImportedLogs", "HEADER");
                LOGGER.log(Level.FINE, "RecordMarker log[{0}] headerLog[{1}]", new Object[]{recordMarker, headerLog});
                boolean isNewFile = true;
                if (isDynamicFile) {
                    markReached = false;
                } else if (recordMarker != null) {
                    isNewFile = false;
                    while (reader != null) {
                        record = this.getRecord(reader);
                        if (record == null) {
                            this.closeReaderObj(reader);
                            if (zipFile == null) break;
                            reader = this.getReaderObj(enu, zipFile);
                            continue;
                        }
                        if (!record.equals(recordMarker)) continue;
                        markReached = true;
                        this.updateStatus(1003);
                        LOGGER.log(Level.FINE, "RecordMarker reached[{0}] record is [{1}]", new Object[]{new Boolean(markReached), record});
                        break;
                    }
                }
                if (!markReached && !isNewFile) {
                    this.closeReaderObj(reader);
                    HashMap<String, Long> tempmap = new HashMap<String, Long>();
                    tempmap.put("RECORDS", new Long(0L));
                    this.updateStatus(1004, tempmap);
                    LOGGER.log(Level.FINE, "no matching record marker creating a new reader");
                    if (zipFile != null) {
                        enu = zipFile.entries();
                        reader = this.getReaderObj(enu, zipFile);
                    } else {
                        if (location.getName().endsWith(".enc")) {
                            this.isEncryptedFile = true;
                        }
                        reader = new BufferedReader(new FileReader(location));
                    }
                }
                int batch_count = 1;
                if (headerLog != null) {
                    Record rec = new Record(host, syslog_name, headerLog);
                    RecordHandler handler = new RecordHandler(rec, null, this.ignoreUnParsedRecords, Boolean.TRUE, this.considerAsVdom, this.vdomIPAddress);
                    handler.setDO(DataAccess.constructDataObject());
                    handler.run();
                }
                if ((record = this.getRecord(reader)) == null && zipFile != null) {
                    this.closeReaderObj(reader);
                    reader = this.getReaderObj(enu, zipFile);
                    record = this.getRecord(reader);
                }
                String startTime = new String();
                while (record != null) {
                    LOGGER.log(Level.FINER, "processing record[{0}]", record);
                    if (record.trim().equals("")) {
                        record = this.getRecord(reader);
                        if (record != null || zipFile == null) continue;
                        this.closeReaderObj(reader);
                        reader = this.getReaderObj(enu, zipFile);
                        record = this.getRecord(reader);
                        continue;
                    }
                    recordMarker = record;
                    Record rec = new Record(host, syslog_name, record);
                    RecordHandler handler = new RecordHandler(rec, darch, this.ignoreUnParsedRecords, Boolean.TRUE, this.considerAsVdom, this.vdomIPAddress);
                    handler.setDO(DataAccess.constructDataObject());
                    record = null;
                    record = this.getRecord(reader);
                    if (record == null && zipFile != null) {
                        this.closeReaderObj(reader);
                        reader = this.getReaderObj(enu, zipFile);
                        record = this.getRecord(reader);
                    }
                    handler.run();
                    if (noStartTime && recordCount < 7 && (startTime = handler.getTime()) != null) {
                        noStartTime = false;
                    }
                    rec = null;
                    handler = null;
                    if ((long)(++recordCount) != this.batch_size && record != null) continue;
                    if (this.abort) break;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("RECORDS", new Long(recordCount));
                    headerLog = FAServerUtil.getHeader(host);
                    if (headerLog != null) {
                        map.put("HEADER", headerLog);
                    }
                    map.put("RECORD_MARKER", recordMarker);
                    map.put("MESSAGE", "Imported [" + recordCount + "] records");
                    map.put("TIME_TAKEN", new Long(System.currentTimeMillis() - intime));
                    LOGGER.log(Level.FINER, "Imported log[{0}] processed records[{1}]", new Object[]{location.getName(), new Integer(recordCount)});
                    this.updateStatus(1005, map);
                    map = null;
                    this.updateStatus(1006, "MESSAGE", "Generated reports for batch[" + batch_count + "] of [" + recordCount + "] records");
                    recordCount = 0;
                    ++batch_count;
                }
                if (fileToDelete != null) {
                    this.closeReaderObj(reader);
                    this.deleteFiles(fileToDelete, tempGZFileName, location);
                }
                String[] tasks = null;
                LOGGER.log(Level.INFO, "Inside ImportLogTask ... about to call the tasks for populating data into report tables.");
                if (highFlow) {
                    LOGGER.log(Level.INFO, "Inside ImportLogTask inside highFlow condition. About to start awake the PacketUtil's high flow rate trigger task.");
                    PacketUtil.initHFTask();
                    LOGGER.log(Level.INFO, "Inside ImportLogTask after creating a new instance of TriggerTask to populate the data in Dy/Mo/Yearly tables");
                } else {
                    LOGGER.log(Level.INFO, "Inside ImportLogTask inside else condition of high flow rate handling ");
                    tasks = runSplitter ? new String[]{"ConfigurationTablePopulator-2", "ConfigurationTablePopulator-3", "ConfigurationTablePopulator-4", "ConfigurationTablePopulator-5", "ConfigurationTablePopulator-6", "ConfigurationTablePopulator-7", "RawTableSplitter"} : new String[]{"ConfigurationTablePopulator-2", "ConfigurationTablePopulator-3", "ConfigurationTablePopulator-4", "ConfigurationTablePopulator-5", "ConfigurationTablePopulator-6", "ConfigurationTablePopulator-7"};
                    new TriggerTasks("generating reports after import:", 1, tasks, true).start();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RECORDS", new Long(recordCount));
                headerLog = FAServerUtil.getHeader(host);
                if (headerLog != null) {
                    map.put("HEADER", headerLog);
                }
                map.put("RECORD_MARKER", recordMarker);
                map.put("TIME_TAKEN", new Long(System.currentTimeMillis() - intime));
                Date dtSql = new Date(System.currentTimeMillis());
                String endTime = dtSql.toString();
                if (!"".equals(startTime)) {
                    map.put("STARTDATE", startTime);
                }
                map.put("ENDDATE", endTime);
                FirewallConstants.fFlushLogFiles();
                if (!this.abort) {
                    this.updateStatus(signatureVerified ? 1020 : 1007, map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.log(Level.INFO, "ImportLogTask:unable to parse file{0}", location);
                this.updateStatus(1009, "TIME_TAKEN", new Long(System.currentTimeMillis() - intime));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOGGER.log(Level.INFO, "unable to close Import reader handle");
                    }
                }
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    this.isEncryptedFile = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.log(Level.INFO, "unable to close Import Scanner and zipFile handle");
                }
            }
        }
    }

    private void deleteFiles(File fileToDelete, File tempGZFileName, File location) {
        boolean deleted = false;
        try {
            if (location.getName().matches("upload_\\d+.tmp")) {
                deleted = fileToDelete.delete();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        LOGGER.log(Level.FINE, "Imported log[{0}]<->[{1}] clean up status[{2}]", new Object[]{location.getName(), location.canWrite(), deleted});
        if (tempGZFileName.exists()) {
            tempGZFileName.delete();
        }
    }

    private BufferedReader getReaderObj(Enumeration enu, ZipFile zipFile) {
        BufferedReader readerObj = null;
        try {
            while (enu.hasMoreElements()) {
                InputStream in;
                ZipEntry entry = (ZipEntry)enu.nextElement();
                if (entry.getName().endsWith(".sgn") || !(readerObj = new BufferedReader(new InputStreamReader(in = zipFile.getInputStream(entry)))).ready()) continue;
                if (entry.getName().endsWith(".enc")) {
                    this.isEncryptedFile = true;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return readerObj;
    }

    private void closeReaderObj(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isEncryptedFile = false;
    }

    private String getRecord(BufferedReader br) throws IOException {
        String record = null;
        if (br == null) {
            return record;
        }
        if (this.isEncryptedFile) {
            record = EncryptionAPI.readEncryptedLine((BufferedReader)br);
            if (record != null) {
                record = EncryptionAPI.getDecryptionObj().decryptLog(record);
            }
        } else {
            record = br.readLine();
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGUNZipContent(File inputGZFile, File tempZipFile) {
        MultiMemberGZIPInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new MultiMemberGZIPInputStream((InputStream)new FileInputStream(inputGZFile));
            out = new FileOutputStream(tempZipFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getZipFileContent(File inputFile, File outputFile) {
        FileInputStream fIn = null;
        ZipInputStream zIn = null;
        FilterOutputStream bOut = null;
        FileOutputStream fOut = null;
        try {
            byte[] buff = new byte[1024];
            fIn = new FileInputStream(inputFile);
            zIn = new ZipInputStream(fIn);
            ZipEntry zipEntry = zIn.getNextEntry();
            if (zipEntry != null) {
                fOut = new FileOutputStream(outputFile);
                bOut = new BufferedOutputStream(fOut);
            } else {
                System.out.println("This is direct binary gunzip file.... Not ours of Archived Zipped GunZip File......So return directly...");
                String string = inputFile.toString();
                return string;
            }
            while (zipEntry != null) {
                int toRead = zIn.available();
                if (toRead > 0) {
                    int len;
                    while ((len = zIn.read(buff)) > 0) {
                        ((BufferedOutputStream)bOut).write(buff, 0, len);
                    }
                }
                zIn.closeEntry();
                zipEntry = zIn.getNextEntry();
            }
            if (bOut != null) {
                ((BufferedOutputStream)bOut).flush();
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, " Exception while processing getZipFileContent() ", exp);
        }
        finally {
            try {
                if (bOut != null) {
                    bOut.close();
                }
                if (zIn != null) {
                    zIn.close();
                }
                if (fIn != null) {
                    fIn.close();
                }
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (Exception ee) {
                bOut = null;
                zIn = null;
                fIn = null;
                fOut = null;
                ee.printStackTrace();
            }
        }
        return outputFile.toString();
    }

    private boolean isFileUpdated(File location) {
        try {
            java.util.Date tstamp = (java.util.Date)this.dobj.getFirstValue("ImportedLogs", "LAST_MODIFIED_TIME");
            if (tstamp == null) {
                return true;
            }
            long dbModTime = tstamp.getTime();
            long fileModTime = location.lastModified();
            if (fileModTime == dbModTime) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "File updation failed...");
        }
        return true;
    }

    private void updateStatus(int type, Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        this.updateStatus(type, map);
    }

    private void updateStatus(int type) {
        this.updateStatus(type, null);
    }

    private void updateStatus(int type, HashMap hash) {
        ImportLogManager.getInstance().updateStatus(this.il_id, type, hash);
    }
}

