/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.lc.LogCollectionListener;
import com.adventnet.fa.server.lc.LogFetcherInterface;
import com.adventnet.la.util.pe.Record;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LogCollector {
    private static final Logger LOGGER = Logger.getLogger(LogCollector.class.getName());
    public static final int SYSLOG_COLLECTOR = 1;
    public static final int LEA_SERVER = 2;
    public static final int TCP_FETCHER = 3;
    Hashtable logFetchers = new Hashtable(2);
    Vector listeners = new Vector(2);
    Object waiter = new Object();

    public void shutdown() {
        this.stopLogFetchers();
        this.removeAllListeners();
    }

    public abstract void start();

    public void addLogFetcher(String key, LogFetcherInterface lfi) {
        this.logFetchers.put(key, lfi);
        LOGGER.log(Level.FINER, " addLogFetcher :: {0}", lfi);
        lfi.initializeLogFetcher(this);
    }

    public void removeLogFetcher(String key) {
        this.logFetchers.remove(key);
    }

    public void startLogFetcher(LogFetcherInterface lfi) {
        LOGGER.log(Level.FINER, " LogCollector.startLogFetcher()");
        lfi.startLogFetcher();
    }

    public void startLogFetcher(String key) {
        LOGGER.log(Level.FINER, " LogCollector.startLogFetcher()");
        LogFetcherInterface lfi = (LogFetcherInterface)this.logFetchers.get(key);
        if (lfi != null) {
            this.startLogFetcher(lfi);
        }
    }

    public void startLogFetchers() {
        LOGGER.log(Level.FINER, " startLogFetchers :: {0}", this.logFetchers);
        Iterator e = this.logFetchers.values().iterator();
        while (e.hasNext()) {
            this.startLogFetcher((LogFetcherInterface)e.next());
        }
    }

    public void stopLogFetcher(String key) {
        LOGGER.log(Level.FINER, " LogCollector.stopLogFetcher()");
        LogFetcherInterface lfi = (LogFetcherInterface)this.logFetchers.get(key);
        if (lfi != null) {
            this.stopLogFetcher(lfi);
        }
    }

    public void stopLogFetcher(LogFetcherInterface lfi) {
        lfi.shutdownLogFetcher();
    }

    public void stopLogFetchers() {
        Iterator e = this.logFetchers.values().iterator();
        while (e.hasNext()) {
            this.stopLogFetcher((LogFetcherInterface)e.next());
        }
    }

    public boolean enableLogFetcher(String key) {
        LOGGER.log(Level.INFO, " LogCollector.enableLogFetcher() called for :::::: {0}  ", key);
        boolean toReturn = false;
        LogFetcherInterface lfi = (LogFetcherInterface)this.logFetchers.get(key);
        if (lfi != null) {
            toReturn = lfi.restartLogFetcher();
        }
        return toReturn;
    }

    public boolean disableLogFetcher(String key) {
        LOGGER.log(Level.INFO, " LogCollector.disableLogFetcher() called for ::::: {0} ", key);
        boolean toReturn = false;
        LogFetcherInterface lfi = (LogFetcherInterface)this.logFetchers.get(key);
        if (lfi != null) {
            toReturn = lfi.stopLogFetcher();
        }
        return toReturn;
    }

    public void addListener(LogCollectionListener lcl) {
        this.listeners.addElement(lcl);
    }

    public void removeListener(LogCollectionListener lcl) {
        this.listeners.remove(lcl);
    }

    public void removeAllListeners() {
        this.listeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(Record record) {
        try {
            Object object = this.waiter;
            synchronized (object) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((LogCollectionListener)this.listeners.elementAt(i)).recordReceived(record);
                }
            }
        }
        catch (Exception ie) {
            System.err.println(" Error while synchronizing ");
            ie.printStackTrace();
            this.waiter.notify();
        }
    }
}

