/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.la.util.pe.Record;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordStore {
    private static final Logger LOGGER = Logger.getLogger(RecordStore.class.getName());
    private long key;
    private Object[] filesList = new Object[25];
    private int fileCount = 0;
    private int actualSize = 0;
    private ArrayList recordHolder = new ArrayList();
    private int min_files_to_load = 5;
    private Object syncObj = new Object();
    private Object obj = new Object();
    private long recordCount = 0L;
    private String baseDir = System.getProperty("server.home") + File.separator + "server" + File.separator + "records";
    private String pattern = null;
    private String fileName = null;
    private boolean shutdown = false;
    private SaveToFile save2File = null;
    private static final int MAX_LOGS_IN_MEMORY = Integer.valueOf(System.getProperty("maxRecords", "5000"));
    private ReentrantLock rLock = new ReentrantLock();
    private ReentrantLock lockArrayList = new ReentrantLock();

    public RecordStore(long sysLogPort) {
        this.key = sysLogPort;
        File f = new File(this.baseDir);
        if (!f.exists()) {
            f.mkdir();
        }
        this.save2File = new SaveToFile("Save2File_for_" + sysLogPort);
    }

    private void loadFileNames(File location) {
        try {
            if (location == null) {
                return;
            }
            File[] fNames = location.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("dat");
                }
            });
            if (fNames != null) {
                int count = fNames.length;
                for (int i = 0; i < count; ++i) {
                    this.addToFileList(fNames[i].getAbsolutePath());
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    void addToFileList(String name) {
        this.rLock.lock();
        this.ensureCapacity();
        this.filesList[this.actualSize++] = name;
        ++this.fileCount;
        LOGGER.log(Level.FINER, "[RecordStore.addToFileList()]  FileName to add is *************  {0}", name);
        this.rLock.unlock();
    }

    private void ensureCapacity() {
        int needed = this.actualSize + 1;
        int oldCapacity = this.filesList.length;
        if (needed > oldCapacity) {
            Object[] oldData = this.filesList;
            int newCapacity = oldCapacity + 25;
            this.filesList = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.filesList, 0, oldCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRecord(Object[] data) throws Exception {
        if (data[2] == null) {
            return;
        }
        ++this.recordCount;
        this.lockArrayList.lock();
        this.recordHolder.add(data);
        this.lockArrayList.unlock();
        if (this.recordCount >= (long)MAX_LOGS_IN_MEMORY) {
            LOGGER.log(Level.FINER, "[RecordStore] Exceeded my limit of " + MAX_LOGS_IN_MEMORY);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notifyAll();
            }
        }
        LOGGER.log(Level.FINER, "RS Count {0}", new Long(this.recordCount));
    }

    public void shutdown() {
        this.shutdown = true;
        this.save2File.store(this.recordHolder);
    }

    List getRecordsToProcess() throws Exception {
        Object[] toReturn = null;
        int size = this.filesList.length;
        if (this.actualSize > 0) {
            if (this.actualSize <= 5) {
                this.rLock.lock();
                toReturn = new Object[this.actualSize];
                System.arraycopy(this.filesList, 0, toReturn, 0, this.actualSize);
                this.filesList = new Object[25];
                this.actualSize = 0;
                this.rLock.unlock();
            } else {
                this.rLock.lock();
                if (size == 0) {
                    LOGGER.log(Level.FINER, "SIZE OF THE FILELIST ARRAY IS ZERO **** ");
                    return null;
                }
                int copySize = size > this.min_files_to_load ? this.min_files_to_load : size;
                toReturn = new Object[copySize];
                System.arraycopy(this.filesList, 0, toReturn, 0, copySize);
                Object[] temp = this.filesList;
                int newArraySize = temp.length - copySize > 0 ? temp.length - copySize : 0;
                this.filesList = new Object[newArraySize];
                if (newArraySize > 0) {
                    System.arraycopy(temp, copySize, this.filesList, 0, temp.length - copySize);
                }
                this.actualSize = this.actualSize - copySize > 0 ? this.actualSize - copySize : 0;
                this.rLock.unlock();
            }
            return this.loadRecords(toReturn);
        }
        ArrayList recordsInMemory = null;
        this.lockArrayList.lock();
        if (this.recordHolder.size() > 0) {
            recordsInMemory = this.recordHolder;
            this.recordHolder = new ArrayList();
        }
        this.lockArrayList.unlock();
        return recordsInMemory;
    }

    List loadRecords(Object[] fileNames) throws Exception {
        if (fileNames == null) {
            return null;
        }
        ArrayList records = new ArrayList();
        int size = fileNames.length;
        for (int i = 0; i < size; ++i) {
            String fName = (String)fileNames[i];
            LOGGER.log(Level.FINER, "[RecordStore.loadRecords()] Abt 2 load record frm file --> {0}", fName);
            if (fName == null) continue;
            File toLoad = new File(fName);
            FileInputStream ostream = new FileInputStream(toLoad);
            ObjectInputStream p = new ObjectInputStream(ostream);
            List temp = (List)p.readObject();
            records.addAll(temp);
            p.close();
            ostream.close();
            toLoad.delete();
        }
        return records.size() > 0 ? records : null;
    }

    public static void main(String[] args) throws Exception {
        RecordStore rs = new RecordStore(514L);
        for (int i = 0; i < 2000; ++i) {
            Record record = new Record("192.168.117.193", "q", "" + i);
        }
    }

    class SaveToFile
    extends Thread {
        public SaveToFile(String name) {
            super(name);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.log(Level.FINER, "[SaveToFile.run()] Inside run() method");
            while (!RecordStore.this.shutdown) {
                try {
                    ArrayList toProcess = null;
                    RecordStore.this.lockArrayList.lock();
                    toProcess = RecordStore.this.recordHolder;
                    RecordStore.this.recordHolder = new ArrayList();
                    RecordStore.this.recordCount = 0L;
                    RecordStore.this.lockArrayList.unlock();
                    this.store(toProcess);
                    Object object = RecordStore.this.obj;
                    synchronized (object) {
                        RecordStore.this.obj.wait();
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void store(List toStore) {
            FileOutputStream ostream = null;
            ObjectOutputStream p = null;
            try {
                RecordStore.this.fileName = RecordStore.this.baseDir + File.separator + "sys_" + RecordStore.this.key + "_" + RecordStore.this.fileCount + ".dat";
                LOGGER.log(Level.FINER, "[RecordStore.SaveToFile().store()] FILENAME IS ********* {0}", RecordStore.this.fileName);
                File dest = new File(RecordStore.this.fileName);
                dest.createNewFile();
                ostream = new FileOutputStream(dest);
                p = new ObjectOutputStream(ostream);
                p.writeObject(toStore);
                RecordStore.this.addToFileList(RecordStore.this.fileName);
                p.close();
                ostream.close();
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                p = null;
                ostream = null;
            }
        }
    }
}

