/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.lc.AbstractLogFetcher;
import com.adventnet.fa.server.lc.NetflowToSyslogConvertor;
import com.adventnet.fa.server.lc.RecordReader;
import com.adventnet.fa.server.lc.RecordStore;
import com.adventnet.fa.server.lc.StoreRepository;
import com.adventnet.la.util.pe.Record;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyslogServer
extends AbstractLogFetcher {
    private static final Logger LOGGER = Logger.getLogger(SyslogServer.class.getName());
    private static Persistence persistence = null;
    private static final int IN_BUF_SZ = 8192;
    private static long logCount;
    private int port = 514;
    private boolean socketOpen;
    private DatagramSocket inSock;
    private DatagramPacket inGram;
    private byte[] inBuffer;
    private String name = "";
    public static ConcurrentLinkedQueue<Record> freeQueue;
    private boolean dump = new Boolean(System.getProperty("useReceiverFallback", "true"));
    static final boolean MULTI_THREAD_READER;
    private Long id = null;
    private RecordStore store = null;
    private RecordReader reader = null;
    private NetflowToSyslogConvertor netflow = null;

    public SyslogServer(String name, int port) {
        this.name = name;
        this.port = port;
        this.netflow = new NetflowToSyslogConvertor(name);
        try {
            this.id = Long.valueOf(name);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.FINER, " Unable to parse ID :: {0}", name);
            nfe.printStackTrace();
        }
        try {
            Criteria crt = new Criteria(new Column("SyslogCollectors", "PORT"), (Object)new Long(port), 0);
            DataObject doo = SyslogServer.getPersistence().get("SyslogCollectors", crt);
            String status = (String)doo.getFirstValue("SyslogCollectors", "STATUS");
            if (this.dump && !"FAILED".equals(status)) {
                this.store = StoreRepository.getInstance().getRecordStore(port);
                LOGGER.log(Level.INFO, "[SyslogServer]Successfully Created Storage Buffer {0} for port {1}", new Object[]{this.store, new Integer(port)});
                this.reader = new RecordReader(port);
                LOGGER.log(Level.INFO, "[SyslogServer] Successfully Created Reader {0} for port {1}", new Object[]{this.reader, new Integer(port)});
            }
            if (!"UP".equals(status)) {
                this.processLogs = false;
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Exception occured while reterving STATUS for SysLog Server ", exp);
        }
    }

    public SyslogServer() {
    }

    public void setSylogPort(int port) {
        this.port = port;
    }

    @Override
    public boolean startLogFetcher() {
        LOGGER.log(Level.FINER, " From SyslogServer ::");
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            InetAddress[] allIPAddresses = InetAddress.getAllByName(hostName);
            boolean yetToFind = true;
            int length = allIPAddresses.length;
            String userSpecifiedIP = System.getProperty("specific.bind.address");
            if (userSpecifiedIP != null) {
                for (int i = 0; i < length && yetToFind; ++i) {
                    String hostBoundIp;
                    String tempIp = allIPAddresses[i].toString();
                    int pos = tempIp.indexOf("/");
                    if (!userSpecifiedIP.equals(hostBoundIp = tempIp.substring(++pos))) continue;
                    yetToFind = false;
                }
            }
            if (yetToFind) {
                this.inSock = new DatagramSocket(this.port);
            } else {
                InetAddress specificIP = InetAddress.getByName(userSpecifiedIP);
                this.inSock = new DatagramSocket(this.port, specificIP);
            }
            this.inBuffer = new byte[8192];
            this.socketOpen = true;
        }
        catch (SocketException se) {
            this.updateStatus(this.id, "FAILED");
            LOGGER.log(Level.FINER, " SyslogServer : FATAL ERROR !!! could not create input socket on port '{0}'\n", new Integer(this.port));
            se.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            this.updateStatus(this.id, "DOWN");
            LOGGER.log(Level.FINER, " SyslogServer : ERROR !!! could not start syslog server on port '{0}'\n", new Integer(this.port));
            ex.printStackTrace();
            return false;
        }
        this.updateStatus(this.id, "UP");
        this.inGram = new DatagramPacket(this.inBuffer, this.inBuffer.length);
        return super.startLogFetcher();
    }

    @Override
    public boolean shutdownLogFetcher() {
        this.processLogs = false;
        if (!this.running) {
            return false;
        }
        super.shutdownLogFetcher();
        if (this.socketOpen) {
            this.socketOpen = false;
            this.inSock.close();
        }
        LOGGER.log(Level.FINE, "SyslogServer: shutdownLogFetcher() called ");
        try {
            if (this.store != null) {
                this.store.shutdown();
            }
            if (this.reader != null) {
                this.reader.shutdown();
            }
            LOGGER.log(Level.FINE, "Successfully called Shutdown on RecordStore and RecordReader ");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.dump = false;
        return true;
    }

    @Override
    public boolean stopLogFetcher() {
        LOGGER.log(Level.INFO, "Called stopLogFetcher() with SysLogServer status as :: {0} and process log status is {1}", new Object[]{this.running, this.processLogs});
        if (this.running && this.processLogs) {
            this.processLogs = false;
        }
        return true;
    }

    @Override
    public boolean restartLogFetcher() {
        LOGGER.log(Level.INFO, "Called restartLogFetcher() with SysLogServer status as :: {0} and process log status is {1}", new Object[]{this.running, this.processLogs});
        if (!this.processLogs && this.running) {
            this.processLogs = true;
        }
        return true;
    }

    @Override
    protected Record fetchLogRecord() throws Exception {
        if (!this.processLogs) {
            return null;
        }
        try {
            this.inGram.setData(this.inBuffer);
            this.inSock.receive(this.inGram);
        }
        catch (SocketException sExp) {
            if (!this.socketOpen) {
                LOGGER.log(Level.FINER, "SyslogServer: SocketException called during closing Socket: {0}  ", new Object[]{new Integer(this.port)});
                return null;
            }
            LOGGER.log(Level.WARNING, "SyslogServer: ERROR reading input socket: {0} ", new Object[]{new Integer(this.port)});
            throw sExp;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "SyslogServer: ERROR reading input socket: {0}  ", new Object[]{new Integer(this.port)});
            throw ex;
        }
        boolean syslogFormat = true;
        byte[] packet = this.inGram.getData();
        if (packet[0] == 0 && (packet[1] == 9 || packet[1] == 10)) {
            syslogFormat = false;
        }
        String hostName = this.inGram.getAddress().getHostAddress();
        String msgBuf = "";
        int len = this.inGram.getLength();
        if (syslogFormat) {
            msgBuf = new String(packet, 0, len);
            ++logCount;
        } else {
            int processedFlows = this.netflow.flowToSyslog(hostName, packet, len, this.store);
            logCount += (long)processedFlows;
            return null;
        }
        msgBuf = msgBuf.trim();
        if ("".equals(msgBuf)) {
            return null;
        }
        Object[] syslogArr = new Object[]{hostName, this.name, msgBuf};
        if (this.dump) {
            this.store.saveRecord(syslogArr);
            return null;
        }
        return new Record(hostName, this.name, msgBuf);
    }

    public void updateStatus(Long id, String status) {
        UpdateQueryImpl query = new UpdateQueryImpl("SyslogCollectors");
        Column col = new Column("SyslogCollectors", "SYSLOGCOLLECTOR_ID");
        Criteria ct = new Criteria(col, (Object)id, 0);
        Criteria crt = new Criteria(new Column("SyslogCollectors", "STATUS"), (Object)"STOPPED", 1);
        query.setCriteria(ct.and(crt));
        query.setUpdateColumn("STATUS", (Object)status);
        try {
            SyslogServer.getPersistence().update((UpdateQuery)query);
        }
        catch (Exception exc) {
            LOGGER.log(Level.FINER, " Error occured while updating the syslog server status: {0}", exc);
        }
    }

    public static Persistence getPersistence() {
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return persistence;
    }

    public static long getAndResetLogCount() {
        long count = logCount;
        logCount = 0L;
        return count;
    }

    static {
        freeQueue = new ConcurrentLinkedQueue();
        MULTI_THREAD_READER = Boolean.valueOf(System.getProperty("multiThreadReader", "false"));
        logCount = 0L;
    }
}

