/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.lc.RecordWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriterRepository {
    private static final Logger LOGGER = Logger.getLogger(WriterRepository.class.getName());
    private HashMap writers = new HashMap();
    private static WriterRepository repo;

    private WriterRepository() {
    }

    public static synchronized WriterRepository getInstance() {
        if (repo == null) {
            repo = new WriterRepository();
        }
        return repo;
    }

    public synchronized RecordWriter getWriter(String tableName) {
        RecordWriter obj = (RecordWriter)this.writers.get(tableName);
        if (obj == null) {
            obj = new RecordWriter(tableName);
            this.writers.put(tableName, obj);
        }
        return obj;
    }

    public synchronized void flushWriters() {
        for (Map.Entry entry : this.writers.entrySet()) {
            RecordWriter writer = (RecordWriter)entry.getValue();
            writer.flush();
        }
    }

    public void shutdown() {
        for (Map.Entry entry : this.writers.entrySet()) {
            RecordWriter writer = (RecordWriter)entry.getValue();
            LOGGER.log(Level.INFO, "WriterRepository ShutDown called fr {0} ", new Object[]{writer});
            writer.shutdown();
        }
    }
}

