/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.cli.CLIMessage;
import com.adventnet.cli.CLIResourceManager;
import com.adventnet.cli.CLISession;
import com.adventnet.cli.MaxConnectionException;
import com.adventnet.cli.transport.CLIProtocolOptions;
import com.adventnet.cli.transport.ConnectException;
import com.adventnet.cli.transport.LoginException;
import com.adventnet.cli.transport.TelnetProtocolOptionsImpl;
import com.adventnet.cli.transport.ssh.SshProtocolOptionsImpl;
import com.adventnet.cli.util.CLILogMgr;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.DynamicLocks;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.lc.V9Template;
import com.adventnet.fa.server.rules.DeviceCommandParser;
import com.adventnet.fa.server.rules.FWAPolicyParserRulesLoader;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.DNSResolverThread;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.pe.Attribute;
import com.adventnet.la.util.pe.ParserRule;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceConnection {
    private static final Logger LOGGER = Logger.getLogger(DeviceConnection.class.getName());
    String[] prompts = new String[]{"$", ">", "#", "%", ":"};
    String[] policyParsingSupportedDevArray = FWAPolicyParserRulesLoader.getInstance().getPolicyParsingSupportedDevices().split(",");
    ArrayList<String> policyParsingSupportedDevList = null;
    private static DeviceConnection dv = null;
    private DeviceCommandParser dcp = null;
    private Pattern p = Pattern.compile("([^\\,]+)(,0x([^\\,]+))?,([^\\n]+)");
    private Pattern noHitRulesDescPattern = Pattern.compile("access-list\\s([^\\s]+)\\s(line(.)*hitcnt=0\\).*)");
    private Timer timer = null;
    private int sessionOpened = 0;
    private int sessionclosed = 0;
    private HashMap<Long, Integer> deviceSessionCountMap = null;
    private String baseStoreDir = System.getProperty("server.dir") + File.separator + "server";
    private static String command = System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "nipper";
    private boolean nipperInitialized = false;
    private String from = "firewallreport@localdomain.com";
    private String mailHost = "smtp";
    private String mailPort = "25";
    private String user = null;
    private String password = null;
    private String tls = "no";
    private String smsPort = "COM1";
    private String runningConfig = null;
    private String startupConfig = null;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private EncryptionAPI encryptionObj = null;
    private DNSResolverThread dnsThread = DNSResolverThread.getInstance();
    private HashMap<Long, HashMap> ridVsNoHitRulesDescMap = new HashMap();
    private static boolean debug = false;
    private HashMap<CLISession, Boolean> sessionVsEnableStatusMap = new HashMap();

    private DeviceConnection() {
        this.dcp = DeviceCommandParser.getInstance();
        this.encryptionObj = EncryptionAPI.getEncryptionObj();
        this.deviceSessionCountMap = new HashMap();
        this.timer = new Timer();
        this.intializeNipper();
        this.policyParsingSupportedDevList = new ArrayList<String>(Arrays.asList(this.policyParsingSupportedDevArray));
    }

    public static synchronized DeviceConnection getInstance() {
        if (dv == null) {
            dv = new DeviceConnection();
        }
        return dv;
    }

    public void setEnableModeStatus(CLISession cli, Boolean status) {
        this.sessionVsEnableStatusMap.put(cli, status);
    }

    public void intializeNipper() {
        this.nipperInitialized = false;
        String os = System.getProperty("os.name");
        if (os == null) {
            this.nipperInitialized = false;
            return;
        }
        if ((os = os.toLowerCase()).indexOf("windows") == -1) {
            try {
                SelectQueryImpl sql = new SelectQueryImpl(new Table("SystemConfigurations"));
                sql.addSelectColumn(new Column("SystemConfigurations", "*"));
                sql.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"nipperLocation", 0));
                DataObject dobj = DataAccess.get((SelectQuery)sql);
                if (!dobj.isEmpty()) {
                    command = (String)dobj.getFirstValue("SystemConfigurations", "CONF_VALUE");
                    this.nipperInitialized = true;
                }
            }
            catch (DataAccessException dExp) {
                this.nipperInitialized = false;
                dExp.printStackTrace();
            }
        } else {
            this.nipperInitialized = true;
        }
    }

    public boolean isNipperInitialized() {
        return this.nipperInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map validateCredentials(Properties prop) {
        LOGGER.fine(" the prop iside validatecredentials is:::::::" + prop);
        if (prop == null) {
            LOGGER.log(Level.WARNING, "Error: Properties object is NULL.So return.");
            return null;
        }
        String deviceType = (String)prop.get("deviceType");
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        HashMap credentialStatus = new HashMap();
        ArrayList<String> sentCommands = new ArrayList<String>();
        responseMap.put("commandsExecuted", sentCommands);
        ArrayList<String> deviceResponse = new ArrayList<String>();
        responseMap.put("deviceResponse", deviceResponse);
        responseMap.put("credentialStatus", credentialStatus);
        String[] keys = new String[]{"protocol", "hostName", "loginName", "password", "prompt", "loginPrompt", "passwordPrompt", "port"};
        CLISession cli = null;
        try {
            cli = this.createSession(prop);
            this.updateCredentialStatus(keys, "true", credentialStatus);
            LOGGER.fine("DODO: Created Session .......");
        }
        catch (Exception exp) {
            this.updateCredentialStatus(keys, "false", credentialStatus);
            responseMap.put("status", "failure");
            responseMap.put("errorString", "TDC.ErrorString1");
            responseMap.put("exception", exp);
            return responseMap;
        }
        try {
            if (this.dcp.isEnableModeRequired(deviceType)) {
                keys = new String[]{"enableUsername", "enablePassword", "enablePrompt", "enableUserPrompt", "enablePasswordPrompt"};
                if (!this.enterEnableMode(cli, prop, responseMap)) {
                    this.updateCredentialStatus(keys, "false", credentialStatus);
                    responseMap.put("status", "failure");
                    responseMap.put("errorString", "TDC.ErrorString2");
                    HashMap<String, Object> exp = responseMap;
                    return exp;
                }
                this.updateCredentialStatus(keys, "true", credentialStatus);
            }
            CLIMessage msg = null;
            try {
                List vdomList = FAServerUtil.getVdomDevicesList();
                String ip = (String)prop.get("hostName");
                boolean isVdom = vdomList.contains(ip);
                msg = this.sendCommand(cli, prop, deviceType, isVdom);
            }
            catch (Exception exp) {
                responseMap.put("status", "failure");
                responseMap.put("errorString", "TDC.ErrorString3");
                keys = new String[]{"loginName", "password", "enableUsername", "enablePassword", "enablePrompt", "enableUserPrompt", "enablePasswordPrompt", "command"};
                this.updateCredentialStatus(keys, "false", credentialStatus);
                HashMap<String, Object> ip = responseMap;
                try {
                    this.closeSession(cli, null);
                }
                catch (Exception exp2) {
                    exp2.printStackTrace();
                }
                return ip;
            }
            String rules = msg != null ? msg.getData() : "null";
            String cmd = prop.getProperty("command");
            sentCommands.add(cmd);
            String invalidCmdMsg = this.dcp.getInvalidCmdMsg(deviceType);
            boolean validOutput = true;
            if (invalidCmdMsg != null) {
                String[] errorString = invalidCmdMsg.split(",");
                int size = errorString != null ? errorString.length : -1;
                for (int i = 0; i < size; ++i) {
                    String tempString = errorString[i];
                    if (rules.indexOf(tempString) < 0) continue;
                    validOutput = false;
                    break;
                }
            }
            if (validOutput) {
                this.updateCredentialStatus(new String[]{"command"}, "true", credentialStatus);
                responseMap.put("status", "valid");
                rules = this.trimString(cmd, rules);
                int length = rules.length();
                if (length > 400) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(rules.substring(0, 150));
                    sb.append("\n ............ \n");
                    sb.append(rules.substring(length - 100, length));
                    rules = sb.toString();
                }
            } else {
                rules = this.trimString(cmd, rules);
                deviceResponse.add(rules);
                throw new Exception(" Problem while executing command :::" + cmd);
            }
            deviceResponse.add(rules);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            this.updateCredentialStatus(new String[]{"command"}, "false", credentialStatus);
            responseMap.put("status", "failure");
            responseMap.put("exception", exp);
            responseMap.put("errorString", "Error while executing the given command !!");
            HashMap<String, Object> hashMap = responseMap;
            return hashMap;
        }
        finally {
            try {
                this.closeSession(cli, null);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return responseMap;
    }

    public void fetchAndUpdateRules(DataObject doo, String hostName, boolean isProfileBased) throws Exception {
        if (isProfileBased) {
            try {
                DataObject dobj;
                Row deviceDetailsRow = doo.getFirstRow("DeviceDetails");
                Long rid = (Long)deviceDetailsRow.get("RID");
                boolean overridden = (Boolean)deviceDetailsRow.get("PROF_VAL_OVERWRITTEN");
                SelectQueryImpl sql = new SelectQueryImpl(new Table("Resources"));
                sql.addSelectColumn(new Column("Resources", "*"));
                sql.setCriteria(new Criteria(new Column("Resources", "RESOURCEID"), (Object)rid, 0));
                String[] jCols = new String[]{"RID"};
                Join j1 = new Join("Resources", "DIPToResourcesMapping", new String[]{"RESOURCEID"}, jCols, 2);
                sql.addJoin(j1);
                sql.addSelectColumn(new Column("DIPToResourcesMapping", "*"));
                String[] jCols2 = new String[]{"DDID"};
                Join j2 = new Join("DIPToResourcesMapping", "DeviceDetails", jCols2, jCols2, 2);
                sql.addJoin(j2);
                sql.addSelectColumn(new Column("DeviceDetails", "*"));
                String[] jCols3 = new String[]{"DIPID"};
                Join j3 = new Join("DIPToResourcesMapping", "DeviceInfoProfiles", jCols3, jCols3, 2);
                sql.addJoin(j3);
                sql.addSelectColumn(new Column("DeviceInfoProfiles", "*"));
                String[] jCols4 = new String[]{"DIPID"};
                Join j4 = new Join("DeviceInfoProfiles", "DIPCredentials", jCols4, jCols4, 2);
                sql.addJoin(j4);
                sql.addSelectColumn(new Column("DIPCredentials", "*"));
                if (overridden) {
                    String[] jCols5 = new String[]{"DDID"};
                    Join j5 = new Join("DeviceDetails", "DeviceCredentials", jCols5, jCols5, 2);
                    sql.addJoin(j5);
                    sql.addSelectColumn(new Column("DeviceCredentials", "*"));
                }
                if ((dobj = DataAccess.get((SelectQuery)sql)).isEmpty()) {
                    LOGGER.log(Level.INFO, "DeviceConnection ..... DataObject is EMPTY while trying to fetch details ... for :::: " + hostName);
                } else {
                    doo = dobj;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        this.fetchAndUpdateRules(doo, hostName);
    }

    public void fetchAndUpdateRules(DataObject doo, String hostName) throws Exception {
        if (doo == null) {
            return;
        }
        try {
            FetcherTask ft = new FetcherTask(doo, hostName);
            this.timer.schedule((TimerTask)ft, 1000L);
            Row deviceDetails = doo.getFirstRow("DeviceDetails");
            deviceDetails.set("STATUS", (Object)new Integer(0));
            doo.updateRow(deviceDetails);
            DataAccess.update((DataObject)doo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw exp;
        }
    }

    public Map fetchFromDevice(Properties prop, Long rid, Map rulesVsHash, CLISession cli, Boolean isVirDom) throws Exception {
        Map rulesVsDescriptionMap = null;
        try {
            String rules = this.fetchRules(prop, cli, isVirDom);
            if (rules == null) {
                throw new Exception("Unable to obtaine rules from device:::" + rid);
            }
            String deviceType = (String)prop.get("deviceType");
            String invalidCmdMsg = this.dcp.getInvalidCmdMsg(deviceType);
            boolean validOutput = true;
            if (invalidCmdMsg != null) {
                String[] errorString = invalidCmdMsg.split(",");
                int size = errorString != null ? errorString.length : -1;
                for (int i = 0; i < size; ++i) {
                    String tempString = errorString[i];
                    if (rules.indexOf(tempString) < 0) continue;
                    validOutput = false;
                    break;
                }
            }
            if (!validOutput) {
                throw new Exception("Invalid Command provided for fetching rules/access control list for rid ::" + rid);
            }
            rulesVsDescriptionMap = this.parseRules(rules, deviceType, rulesVsHash, rid);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw exp;
        }
        return rulesVsDescriptionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetchRules_dummy(Properties prop, CLISession cli, Boolean isVirtualDom) throws Exception {
        String rid = prop.getProperty("resourceID");
        String inputFile = System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "Rules_" + rid + ".txt";
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        StringBuilder sb = new StringBuilder();
        try {
            String line = br.readLine();
            String lineSeparator = System.getProperty("line.separator");
            while (line != null) {
                sb.append(line);
                sb.append(lineSeparator);
                line = br.readLine();
            }
            String everything = sb.toString();
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    public String fetchRules(Properties prop, CLISession cli, Boolean isVirtualDom) throws Exception {
        if (prop == null) {
            return null;
        }
        String deviceType = (String)prop.get("deviceType");
        String device = (String)prop.get("hostName");
        String toReturn = null;
        if (this.dcp.isEnableModeRequired(deviceType) && !this.enterEnableMode(cli, prop, null)) {
            LOGGER.info("Error: Unable to ENTER ENABLE MODE ");
            return null;
        }
        CLIMessage msg = this.sendCommand(cli, prop, deviceType, isVirtualDom);
        toReturn = msg != null ? msg.getData() : null;
        return toReturn;
    }

    public Map fetchRulesFromFile(String location, Map rulesVsHash) throws Exception {
        HashMap rulesVsDescriptionMap = new HashMap();
        BufferedReader bRead = null;
        InputStreamReader fRead = null;
        try {
            File f = new File(location);
            fRead = new FileReader(f);
            bRead = new BufferedReader(fRead);
            String line = bRead.readLine();
            if (!this.validate(line, rulesVsDescriptionMap, rulesVsHash)) {
                throw new Exception("Invalid Format supplied for RulesFile Import");
            }
            while ((line = bRead.readLine()) != null) {
                Matcher m = this.p.matcher(line);
                if (!m.matches()) continue;
                String name = m.group(1);
                String hash = m.group(3);
                String description = m.group(4);
                if (hash != null) {
                    rulesVsHash.put(name, hash);
                }
                this.populateRulesDescMap(name, description, rulesVsDescriptionMap);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw exp;
        }
        finally {
            try {
                if (fRead != null) {
                    fRead.close();
                }
                if (bRead != null) {
                    bRead.close();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                fRead = null;
                bRead = null;
            }
        }
        return rulesVsDescriptionMap;
    }

    public DataObject getDO(Long frid) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceDetails"));
        String[] fridCol = new String[]{"DDID"};
        Join fri2Resources = new Join("DeviceDetails", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
        Join fri2DeviceCredentials = new Join("DeviceDetails", "DeviceCredentials", fridCol, fridCol, 1);
        Join fri2RulesFileInfo = new Join("DeviceDetails", "FileDetails", fridCol, fridCol, 1);
        Join fri2FRSchedules = new Join("DeviceDetails", "DDSchedules", fridCol, fridCol, 1);
        Join fri2FRCMSchedules = new Join("DeviceDetails", "ChangeMgmtSchedules", fridCol, fridCol, 1);
        Join fri2FRCM2RprCnfg = new Join("DeviceDetails", "ChangeMgmt2RptConfig", fridCol, fridCol, 1);
        Join fri2Notifications = new Join("DeviceDetails", "DDNotifications", fridCol, fridCol, 1);
        sql.addJoin(fri2Resources);
        sql.addJoin(fri2DeviceCredentials);
        sql.addJoin(fri2RulesFileInfo);
        sql.addJoin(fri2FRSchedules);
        sql.addJoin(fri2FRCMSchedules);
        sql.addJoin(fri2FRCM2RprCnfg);
        sql.addJoin(fri2Notifications);
        sql.addSelectColumn(new Column("DeviceDetails", "*"));
        sql.addSelectColumn(new Column("Resources", "*"));
        sql.addSelectColumn(new Column("DeviceCredentials", "*"));
        sql.addSelectColumn(new Column("FileDetails", "*"));
        sql.addSelectColumn(new Column("DDSchedules", "*"));
        sql.addSelectColumn(new Column("ChangeMgmtSchedules", "*"));
        sql.addSelectColumn(new Column("ChangeMgmt2RptConfig", "*"));
        sql.addSelectColumn(new Column("DDNotifications", "*"));
        Criteria crt = new Criteria(new Column("DeviceDetails", "DDID"), (Object)frid, 0);
        sql.setCriteria(crt);
        return DataAccess.get((SelectQuery)sql);
    }

    public DataObject getProfileDO(Long dipid, boolean isEdit) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceInfoProfiles"));
        sql.addSelectColumn(new Column("DeviceInfoProfiles", "*"));
        String[] joinColumn = new String[]{"DIPID"};
        Join dipTodipCred = new Join("DeviceInfoProfiles", "DIPCredentials", joinColumn, joinColumn, 2);
        sql.addJoin(dipTodipCred);
        sql.addSelectColumn(new Column("DIPCredentials", "*"));
        String tableName = "DeviceInfoProfiles";
        String columnName = "DIPID";
        if (isEdit) {
            String[] j1Cols = new String[]{"DIPID"};
            Join j1 = new Join("DeviceInfoProfiles", "DIPToResourcesMapping", j1Cols, j1Cols, 2);
            sql.addJoin(j1);
            sql.addSelectColumn(new Column("DIPToResourcesMapping", "*"));
            String[] j2Cols = new String[]{"DDID"};
            Join j2 = new Join("DIPToResourcesMapping", "DeviceDetails", j2Cols, j2Cols, 2);
            sql.addJoin(j2);
            sql.addSelectColumn(new Column("DeviceDetails", "*"));
            Join j3 = new Join("DIPToResourcesMapping", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
            sql.addJoin(j3);
            sql.addSelectColumn(new Column("Resources", "*"));
            Join j4 = new Join("DeviceDetails", "DDSchedules", j2Cols, j2Cols, 1);
            sql.addJoin(j4);
            sql.addSelectColumn(new Column("DDSchedules", "*"));
            Join j5 = new Join("DeviceDetails", "DeviceCredentials", j2Cols, j2Cols, 1);
            sql.addJoin(j5);
            sql.addSelectColumn(new Column("DeviceCredentials", "*"));
            Join j6 = new Join("DeviceDetails", "DDNotifications", j2Cols, j2Cols, 1);
            sql.addJoin(j6);
            sql.addSelectColumn(new Column("DDNotifications", "*"));
            Join j7 = new Join("DeviceDetails", "ChangeMgmtSchedules", j2Cols, j2Cols, 1);
            sql.addJoin(j7);
            sql.addSelectColumn(new Column("ChangeMgmtSchedules", "*"));
            Join j8 = new Join("DeviceDetails", "ChangeMgmt2RptConfig", j2Cols, j2Cols, 1);
            sql.addJoin(j8);
            sql.addSelectColumn(new Column("ChangeMgmt2RptConfig", "*"));
            tableName = "DeviceDetails";
            columnName = "DDID";
        }
        sql.setCriteria(new Criteria(new Column(tableName, columnName), (Object)dipid, 0));
        return DataAccess.get((SelectQuery)sql);
    }

    public DataObject getProfileDO(Long dipid) throws Exception {
        return this.getProfileDO(dipid, false);
    }

    public void updateDB(Long rID, Long frid, Map rulesVsDescriptionMap) {
        this.updateDB(rID, frid, rulesVsDescriptionMap, new HashMap(0));
    }

    public void updateDB(DataObject doo, Map rulesVsDescriptionMap) {
        this.updateDB(doo, rulesVsDescriptionMap, new HashMap(0));
    }

    private void updateDB(DataObject doo, Map rulesVsDescriptionMap, Map rulesVsHash) {
        if (rulesVsDescriptionMap == null) {
            LOGGER.warning("rulesVsDescriptionMap is NULL ");
            return;
        }
        try {
            Long rID = (Long)doo.getFirstValue("DeviceDetails", "RID");
            Long frid = (Long)doo.getFirstValue("DeviceDetails", "DDID");
            this.updateDB(rID, frid, rulesVsDescriptionMap, rulesVsHash);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void updateDB(Long rID, Long frid, Map rulesVsDescriptionMap, Map rulesVsHash) {
        DataObject absRulesDO = null;
        try {
            DataAccess.delete((Criteria)new Criteria(new Column("DeviceRules", "RID"), (Object)rID, 0));
            HashMap noHitRulesVsDescMap = this.ridVsNoHitRulesDescMap.remove(rID);
            absRulesDO = DataAccess.constructDataObject();
            Integer type = new Integer(1);
            for (Map.Entry entry : rulesVsDescriptionMap.entrySet()) {
                List noHitRuleDescription;
                String ruleName = (String)entry.getKey();
                List descriptions = (List)entry.getValue();
                String ruleDesc = null;
                String deviceType = this.getDeviceType(rID);
                ruleDesc = deviceType.equals("PaloAlto") ? this.modifiedDescription(descriptions, false) : this.modifiedDescription(descriptions, true);
                String noHitRuleDesc = null;
                if (noHitRulesVsDescMap != null && (noHitRuleDescription = (List)noHitRulesVsDescMap.get(ruleName)) != null) {
                    noHitRuleDesc = this.modifiedDescription(noHitRuleDescription, false);
                }
                Row r = new Row("DeviceRules");
                r.set("RID", (Object)rID);
                r.set("DDID", (Object)frid);
                r.set("RULE", (Object)ruleName);
                if (rulesVsHash.containsKey(ruleName)) {
                    r.set("RULEHASH", rulesVsHash.get(ruleName));
                }
                r.set("DESCRIPTION", (Object)ruleDesc);
                r.set("NOHITCOUNTDESC", (Object)noHitRuleDesc);
                absRulesDO.addRow(r);
            }
            DataAccess.add((DataObject)absRulesDO);
        }
        catch (DataAccessException dExp) {
            dExp.printStackTrace();
        }
    }

    private String modifiedDescription(List descriptions, boolean noFirstBreak) {
        StringBuffer sb = new StringBuffer();
        int size = descriptions.size();
        for (int i = 0; i < size; ++i) {
            sb.append((String)descriptions.get(i));
            if (noFirstBreak && i == 0) continue;
            sb.append("<br>");
        }
        return sb.toString();
    }

    public CLISession createSession_dummy(Properties prop) throws Exception {
        return null;
    }

    public CLISession createSession(Properties prop) throws Exception {
        String bannerInput;
        String password;
        String loginName;
        String expMsg = "Error while establishing connection to device. UserName/Password Field is empty";
        String protocol = prop.getProperty("protocol");
        String mode = prop.getProperty("mode");
        boolean isVdom = "4".equals(mode);
        int type = protocol.indexOf("TELNET") > -1 ? 1 : 2;
        int port = 23;
        try {
            port = Integer.parseInt(prop.getProperty("port", "23"));
        }
        catch (NumberFormatException nfe) {
            LOGGER.info("Error: Unable to convert the port information. So defaulting to 23");
            port = type == 1 ? 23 : 22;
        }
        TelnetProtocolOptionsImpl options = null;
        if (type == 1) {
            String bannerPrompt;
            options = new TelnetProtocolOptionsImpl();
            options.setRemotePort(port);
            options.setRemoteHost(prop.getProperty("hostName"));
            loginName = prop.getProperty("loginName");
            loginName = loginName != null ? loginName : null;
            options.setLoginName(loginName);
            password = prop.getProperty("password", "n/a");
            if ("n/a".equals(password.trim())) {
                Exception exp = new Exception(expMsg);
                throw exp;
            }
            options.setPassword(password);
            options.setLoginPrompt(prop.getProperty("loginPrompt", "ogin:"));
            options.setPasswdPrompt(prop.getProperty("passwordPrompt", "word:"));
            bannerInput = prop.getProperty("bannerInput");
            if (bannerInput != null && (bannerPrompt = prop.getProperty("bannerPrompt")) != null && !Arrays.asList(this.prompts).contains(bannerPrompt)) {
                this.prompts = Arrays.copyOf(this.prompts, this.prompts.length + 1);
                this.prompts[this.prompts.length - 1] = bannerPrompt;
            }
            options.setPromptList(this.prompts);
        } else {
            options = new SshProtocolOptionsImpl();
            ((SshProtocolOptionsImpl)options).setRemotePort(port);
            ((SshProtocolOptionsImpl)options).setRemoteHost(prop.getProperty("hostName"));
            loginName = prop.getProperty("loginName");
            loginName = loginName != null ? loginName : null;
            ((SshProtocolOptionsImpl)options).setLoginName(loginName);
            password = prop.getProperty("password", "n/a");
            if ("n/a".equals(password)) {
                Exception exp = new Exception(expMsg);
                throw exp;
            }
            ((SshProtocolOptionsImpl)options).setPassword(password);
            bannerInput = prop.getProperty("bannerInput");
            String promptToMatch = bannerInput != null && !"".equals(bannerInput.trim()) ? prop.getProperty("bannerPrompt") : prop.getProperty("prompt");
            String string = promptToMatch = promptToMatch == null || "".equals(promptToMatch.trim()) ? prop.getProperty("prompt") : promptToMatch;
            if (debug) {
                LOGGER.info("bannerInput::" + bannerInput + " and bannerPrompt:::" + prop.getProperty("bannerPrompt"));
                LOGGER.info("finally PromptToMatchAfterLogin is:::" + promptToMatch);
            }
            ((SshProtocolOptionsImpl)options).setPrompt(promptToMatch);
        }
        CLISession cli = null;
        try {
            String multiPromptAction;
            cli = new CLISession((CLIProtocolOptions)options);
            if (type == 1) {
                cli.setTransportProviderClassName("com.adventnet.cli.transport.TelnetTransportImpl");
            } else {
                cli.setTransportProviderClassName("com.adventnet.cli.transport.ssh.SshTransportProviderImpl");
            }
            String deviceType = prop.getProperty("deviceType");
            Map configs = this.dcp.getConfigForType(deviceType);
            String string = multiPromptAction = configs != null ? (String)configs.get("multiPromptAction") : null;
            if (multiPromptAction != null) {
                String prompt = prop.getProperty("enablePrompt");
                prompt = prompt == null || "".equals(prompt) ? prop.getProperty("prompt", "#") : prompt;
                Properties p = new Properties();
                p.setProperty(multiPromptAction, " ");
                p.setProperty(prompt, "");
                cli.setCLIPromptAction(p);
            }
            cli.setKeepAliveTimeout(60);
            int timeoutConfiguredIs = this.dcp.getTimeout(deviceType);
            LOGGER.log(Level.FINE, " Value of timeout configured in the xml is ::::::: {0} ", new Long(timeoutConfiguredIs));
            if (isVdom && timeoutConfiguredIs < 120) {
                timeoutConfiguredIs = 120;
            } else if (("TELNET".equals(protocol) || "SSH".equals(protocol)) && "No".equals(prop.getProperty("adminPriv")) && timeoutConfiguredIs < 30) {
                timeoutConfiguredIs = 30;
            }
            LOGGER.log(Level.FINE, " Finally timeout configured is ::::::: {0} ", new Long(timeoutConfiguredIs));
            cli.setRequestTimeout(timeoutConfiguredIs * 60 * 1000);
            LOGGER.log(Level.FINE, " Value of timeout configured in session is ::::::::::: {0} ", new Long(cli.getRequestTimeout()));
            cli.open();
            this.sessionVsEnableStatusMap.put(cli, Boolean.FALSE);
            this.handleBanner(cli, prop);
            Long rID = null;
            if (prop.getProperty("resourceID") != null) {
                rID = new Long(prop.getProperty("resourceID"));
            }
            rID = rID != null ? rID : new Long(0L);
            LOGGER.log(Level.INFO, " Session Opened for rid ::::::: {0} , and the session NO: is --> {1}", new Object[]{rID, new Integer(++this.sessionOpened)});
            int connCount = 0;
            Integer devSessionCnt = this.deviceSessionCountMap.remove(rID);
            if (devSessionCnt != null) {
                connCount = devSessionCnt;
            }
            this.deviceSessionCountMap.put(rID, ++connCount);
            LOGGER.info("No of sessions alive in the device with rid ::: " + rID + " is --> " + this.deviceSessionCountMap.get(rID));
        }
        catch (LoginException lExp) {
            LOGGER.warning("Error: Unable to Login device with the LoginName/Password provided.");
            throw lExp;
        }
        catch (ConnectException cExp) {
            LOGGER.warning("Error: Unable to Connect to device ");
            throw cExp;
        }
        catch (Exception ee) {
            LOGGER.warning("Error: UnKnown Exception while connecting to device ");
            throw ee;
        }
        return cli;
    }

    private void handleBanner(CLISession session, Properties prop) throws Exception {
        String bannerInput = prop.getProperty("bannerInput");
        String promptToMatch = prop.getProperty("prompt");
        if (bannerInput != null && !"".equals(bannerInput.trim()) && promptToMatch != null && !"".equals(promptToMatch.trim())) {
            try {
                this.executeCommand(session, bannerInput, promptToMatch);
            }
            catch (Exception exp) {
                throw new Exception("Error occured while executing banner input for the device:::" + prop.getProperty("resourceName"), exp);
            }
        }
    }

    private CLIMessage executeCommand(CLISession session, String command, String promptToMatch) throws Exception {
        LOGGER.fine("*** inside execute cmd...cmd is-->" + command + "@@nd promptToMatch is:::" + promptToMatch);
        if (session == null) {
            LOGGER.warning("Error in executeCommand(), CLISession is NULL");
            return null;
        }
        CLIMessage msg = null;
        try {
            msg = new CLIMessage(command);
            msg.setRequestTimeout(0);
            if (promptToMatch.indexOf(",") > -1) {
                String[] promptToMatchList = promptToMatch.split(",");
                msg.setCLIPromptList(promptToMatchList);
            } else {
                msg.setCLIPrompt(promptToMatch);
            }
            msg = session.syncSend(msg);
        }
        catch (MaxConnectionException mExp) {
            LOGGER.warning("Error: MaxConnectionException while executing command .... ");
            mExp.printStackTrace();
            throw mExp;
        }
        catch (Exception exp) {
            LOGGER.warning("Error: Exception while executig command ::" + command);
            exp.printStackTrace();
            throw exp;
        }
        return msg;
    }

    private CLIMessage executeVdomCommands(CLISession session, String command, String promptToMatch, Properties prop) throws Exception {
        LOGGER.fine("*** inside execute vdom cmds...cmd is-->" + command + "@@nd promptToMatch is:::" + promptToMatch);
        LOGGER.log(Level.FINE, "the vdomname is:::" + (String)prop.get("vdomName"));
        if (session == null) {
            LOGGER.warning("Error in executeCommand(), CLISession is NULL");
            return null;
        }
        boolean changeToContextCmd = false;
        if (command.indexOf("@@vdom_name@@") > 0) {
            String vdomName = (String)prop.get("vdomName");
            String ipAddress = (String)prop.get("hostName");
            String deviceType = (String)prop.get("deviceType");
            vdomName = this.getVdomName(ipAddress, vdomName);
            LOGGER.fine("finally vdom name going to replace is:::" + vdomName);
            command = this.replaceVdomName(command, vdomName, deviceType, ipAddress);
            changeToContextCmd = true;
        }
        CLIMessage msg = null;
        try {
            msg = new CLIMessage(command);
            msg.setRequestTimeout(0);
            if (promptToMatch.indexOf(",") > -1) {
                String[] promptToMatchList = promptToMatch.split(",");
                msg.setCLIPromptList(promptToMatchList);
            } else {
                msg.setCLIPrompt(promptToMatch);
            }
            msg = session.syncSend(msg);
            if (changeToContextCmd) {
                String output = msg.getData();
                if (output.indexOf("error") > -1 || output.indexOf("ERROR") > -1) {
                    throw new Exception("Context " + (String)prop.get("vdomName") + " doesn't exist");
                }
                changeToContextCmd = false;
            }
        }
        catch (MaxConnectionException mExp) {
            LOGGER.warning("Error: MaxConnectionException while executing command .... ");
            mExp.printStackTrace();
            throw mExp;
        }
        catch (Exception exp) {
            LOGGER.warning("Error: Exception while executig command ::" + command);
            exp.printStackTrace();
            throw exp;
        }
        return msg;
    }

    public String getVdomName(String ipAddress, String vdomName) {
        String physicalDevName;
        if (vdomName.indexOf("-") > 0 && vdomName.indexOf((physicalDevName = FAServerUtil.getPhysicalDeviceName(ipAddress)) + "-") > -1) {
            String[] splitValues = vdomName.split(physicalDevName + "-");
            vdomName = splitValues[1];
        }
        vdomName = vdomName.trim();
        return vdomName;
    }

    private String replaceVdomName(String command, String vdomName, String deviceType, String ipAddress) {
        String baseDeviceResName = "FortiGate".equalsIgnoreCase(deviceType) ? this.getBaseDeviceResName(ipAddress) : "";
        String findPattern = "@@(\\w+)@@";
        Pattern p = Pattern.compile(findPattern);
        StringBuffer sb = new StringBuffer();
        Matcher m = p.matcher(command);
        while (m.find()) {
            vdomName = vdomName.equals(baseDeviceResName) ? "root" : vdomName;
            m.appendReplacement(sb, vdomName);
        }
        m.appendTail(sb);
        command = sb.toString();
        LOGGER.fine("Modified command<->" + command);
        return command;
    }

    private String getBaseDeviceResName(String ip) {
        String resName = "";
        try {
            Criteria tempCrit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0);
            tempCrit = tempCrit.and(new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)"", 0));
            DataObject tempDO = DataAccess.get((String)"Resources", (Criteria)tempCrit);
            if (!tempDO.isEmpty()) {
                resName = (String)tempDO.getFirstValue("Resources", "RESOURCENAME");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return resName;
    }

    private CLIMessage sendCommand(CLISession cli, Properties prop, String deviceType, Boolean isVirtualDom) throws Exception {
        LOGGER.fine("the devicetype is-->" + deviceType);
        boolean isVdom = isVirtualDom;
        int keyCmdIndex = 0;
        int size = 0;
        boolean isEnablePrompt = false;
        if ("Cisco".equalsIgnoreCase(deviceType) || "SRX Log Format".equalsIgnoreCase(deviceType)) {
            isEnablePrompt = true;
        }
        String promptToMatch = prop.getProperty("enablePrompt");
        promptToMatch = isEnablePrompt && !"".equals(promptToMatch) ? promptToMatch : prop.getProperty("prompt");
        CLIMessage msg = null;
        if (isVdom) {
            List ruleCmdList = this.dcp.getVdomRuleCmds(deviceType);
            size = ruleCmdList.size();
            keyCmdIndex = this.dcp.getVdomKeyCmdIndex(deviceType);
            String command = "";
            for (int i = 0; i < size; ++i) {
                command = (String)ruleCmdList.get(i);
                if (i != keyCmdIndex) {
                    this.executeVdomCommands(cli, command, promptToMatch, prop);
                    continue;
                }
                msg = this.executeVdomCommands(cli, command, promptToMatch, prop);
                if (msg != null) continue;
                throw new Exception("Exception while fetching vdom rules...");
            }
        } else {
            List ruleCmdList = this.dcp.getRuleCmds(deviceType);
            size = ruleCmdList.size();
            keyCmdIndex = this.dcp.getKeyCmdIndex(deviceType);
            for (int i = 0; i < size; ++i) {
                if (i != keyCmdIndex) {
                    this.executeCommand(cli, (String)ruleCmdList.get(i), promptToMatch);
                    continue;
                }
                msg = this.executeCommand(cli, (String)ruleCmdList.get(i), promptToMatch);
                if (msg != null) continue;
                throw new Exception("Exception while fetching rules..");
            }
        }
        return msg;
    }

    public void closeSession(CLISession session, Long rID) throws Exception {
        if (session == null) {
            LOGGER.warning("Error: CLISession is NULL ");
            return;
        }
        this.sessionVsEnableStatusMap.remove(session);
        session.close();
        rID = rID != null ? rID : new Long(0L);
        LOGGER.log(Level.INFO, " Session closed for rid ::::: {0} , and the closed session NO: is --> {1}", new Object[]{rID, new Integer(++this.sessionclosed)});
        int connCount = 0;
        Integer devSessionCnt = this.deviceSessionCountMap.remove(rID);
        if (devSessionCnt != null) {
            connCount = devSessionCnt;
            --connCount;
        }
        this.deviceSessionCountMap.put(rID, connCount);
        LOGGER.info("After closing the session, No of sessions alive in the device with rid ::: " + rID + " is --> " + this.deviceSessionCountMap.get(rID));
    }

    private boolean enterEnableMode(CLISession cli, Properties prop, Map responseMap) {
        if (this.sessionVsEnableStatusMap.get(cli).booleanValue()) {
            LOGGER.info("Already in enable mode...hence skipping enable section..");
            return true;
        }
        LOGGER.fine("** inside enablemode...prop is::::" + prop + "@@and responsemap is:::" + responseMap);
        boolean credentialsValid = true;
        ArrayList sentCommands = responseMap != null ? (ArrayList)responseMap.get("commandsExecuted") : null;
        ArrayList commandResponse = responseMap != null ? (ArrayList)responseMap.get("deviceResponse") : null;
        CLIMessage msg = null;
        String promptToMatch = null;
        String data = null;
        String cmdToExecute = null;
        boolean isEnableUserName = false;
        boolean isEnablePassword = false;
        boolean noEnableCredentials = false;
        String enableCMD = prop.getProperty("enableCommand");
        String enableUserName = prop.getProperty("enableUserName");
        String enablePassword = prop.getProperty("enablePassword");
        if (enableUserName != null) {
            isEnableUserName = true;
        } else if (enablePassword != null) {
            isEnablePassword = true;
        } else {
            noEnableCredentials = true;
        }
        try {
            if (noEnableCredentials) {
                promptToMatch = prop.getProperty("enablePrompt");
                cmdToExecute = enableCMD;
                msg = this.executeCommand(cli, enableCMD, promptToMatch);
                data = msg != null ? msg.getData() : "null";
                LOGGER.fine("** the result of command executed is-->" + data);
                if (responseMap != null) {
                    sentCommands.add(enableCMD);
                    data = this.trimString(enableCMD, data);
                    LOGGER.fine("** the result after trimmed is-->" + data);
                    commandResponse.add(data);
                }
            } else {
                promptToMatch = isEnableUserName ? prop.getProperty("enableUserPrompt", ":") : prop.getProperty("enablePasswordPrompt", ":");
                cmdToExecute = enableCMD;
                msg = this.executeCommand(cli, enableCMD, promptToMatch);
                data = msg != null ? msg.getData() : "null";
                LOGGER.fine("** the result of execute command is-->" + data);
                if (responseMap != null) {
                    sentCommands.add(enableCMD);
                    data = this.trimString(enableCMD, data);
                    LOGGER.fine("** the result after trimmed is-->" + data);
                    commandResponse.add(data);
                }
                if (data != null && data.indexOf("sername:") >= 0) {
                    promptToMatch = prop.getProperty("enablePasswordPrompt", ":");
                    cmdToExecute = enableUserName;
                    msg = this.executeCommand(cli, enableUserName, promptToMatch);
                    data = msg != null ? msg.getData() : "null";
                    LOGGER.fine("** the result of execute command is-->" + data);
                    if (responseMap != null) {
                        sentCommands.add(enableUserName);
                        data = this.trimString(enableUserName, data);
                        LOGGER.fine("** the result after trimmed is-->" + data);
                        commandResponse.add(data);
                    }
                }
                if (data != null && data.indexOf("assword:") >= 0) {
                    promptToMatch = prop.getProperty("enablePrompt");
                    cmdToExecute = enablePassword;
                    msg = this.executeCommand(cli, enablePassword, promptToMatch);
                    data = msg != null ? msg.getData() : "null";
                    LOGGER.fine("** the result of execute command is-->" + data);
                    if (responseMap != null) {
                        sentCommands.add(enablePassword.replaceAll(".", "*"));
                        data = this.trimString(enablePassword.replaceAll(".", "*"), data);
                        LOGGER.fine("** the result after trimmed is-->" + data);
                        commandResponse.add(data);
                    }
                    if (data != null && data.indexOf("Invalid password") >= 0) {
                        return false;
                    }
                } else if (responseMap != null) {
                    commandResponse.add(data);
                }
            }
            return credentialsValid;
        }
        catch (Exception ee) {
            LOGGER.info("** Error while executing the command:::" + cmdToExecute);
            ee.printStackTrace();
            return false;
        }
    }

    private void updateCredentialStatus(String[] keys, String value, Map credentialStatus) {
        if (keys != null && value != null) {
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                credentialStatus.put(keys[i], value);
            }
        }
    }

    public Map parseRules(String rules, String deviceType, Long rid) {
        HashMap rulesVsHash = new HashMap();
        return this.parseRules(rules, deviceType, rulesVsHash, rid);
    }

    private Map parseRules(String rules, String deviceType, Map rulesVsHash, Long rid) {
        boolean isCisco = deviceType.equals("Cisco");
        HashMap rulesVsDescriptionMap = new HashMap();
        HashMap noHitRulesVsDescMap = new HashMap();
        Map configs = this.dcp.getConfigForType(deviceType);
        if (configs == null) {
            LOGGER.warning("Error: Unable to fetch parser configurations for device type " + deviceType);
            return null;
        }
        ParserRule rnPR = (ParserRule)configs.get("rnp");
        ParserRule rdPR = (ParserRule)configs.get("rdp");
        Vector rdPRSet = (Vector)configs.get("rdpSet");
        if (rdPRSet != null) {
            this.parseRulesWithMultipleDesc(rules, rnPR, rdPRSet, rulesVsDescriptionMap);
            return rulesVsDescriptionMap;
        }
        Pattern ruleNamePattern = rnPR.getPattern();
        Pattern ruleDescPattern = rdPR != null ? rdPR.getPattern() : null;
        String[] rulesArray = rules.split("\n");
        int length = rulesArray.length;
        String ruleName = null;
        for (int i = 0; i < length; ++i) {
            String str = rulesArray[i];
            if (str == null) continue;
            Matcher m = ruleNamePattern.matcher(str = str.trim());
            boolean matches = m.matches();
            if (matches) {
                ArrayList list = rnPR.getAttributes();
                int size = list.size();
                StringBuffer ruleDescription = new StringBuffer();
                for (int j = 0; j < size; ++j) {
                    Attribute atr = (Attribute)list.get(j);
                    String groupName = atr.getGroupName();
                    String value = m.group(atr.getGroupNumber());
                    if (value == null) continue;
                    if (j == 0) {
                        ruleName = value;
                        this.populateRulesDescMap(ruleName, null, rulesVsDescriptionMap);
                        continue;
                    }
                    if (isCisco) {
                        String ruleHash = m.group(atr.getGroupNumber());
                        LOGGER.log(Level.FINE, "ruleHash in netflow is {0} its name is : {1} ", new Object[]{ruleHash, ruleName});
                        rulesVsHash.put(ruleName, ruleHash);
                        continue;
                    }
                    String desc = m.group(atr.getGroupNumber());
                    ruleDescription.append(desc);
                }
                this.populateRulesDescMap(ruleName, ruleDescription.toString(), rulesVsDescriptionMap);
                continue;
            }
            if (ruleDescPattern != null) {
                int attrbuteListSize;
                m = ruleDescPattern.matcher(str);
                boolean descriptionMatches = m.matches();
                if (!descriptionMatches) continue;
                ArrayList list = rdPR.getAttributes();
                int n = attrbuteListSize = list != null ? list.size() : 0;
                if (attrbuteListSize == 1) {
                    String description = m.group(((Attribute)list.get(0)).getGroupNumber());
                    this.populateRulesDescMap(ruleName, description, rulesVsDescriptionMap);
                    continue;
                }
                if (attrbuteListSize > 1) {
                    String name = m.group(1);
                    String description = m.group(2);
                    this.populateRulesDescMap(name, description, rulesVsDescriptionMap);
                    if (!isCisco) continue;
                    this.populateNoHitRulesDescMap(str, noHitRulesVsDescMap);
                    continue;
                }
                LOGGER.info("WARNING: ERROR CONDITION AttributeList size is NOT 1 OR 2 !!");
                continue;
            }
            if (deviceType.equals("Netscreen Native") || ruleName == null || str == null || "next".equals(str) && "end".equals(str)) continue;
            this.populateRulesDescMap(ruleName, str.trim(), rulesVsDescriptionMap);
        }
        this.ridVsNoHitRulesDescMap.put(rid, noHitRulesVsDescMap);
        return rulesVsDescriptionMap;
    }

    private void parseRulesWithMultipleDesc(String rules, ParserRule rnPR, Vector<ParserRule> rdPRSet, Map rulesVsDescriptionMap) {
        Pattern ruleNamePattern = rnPR.getPattern();
        String[] rulesArray = rules.split("\n");
        String ruleName = null;
        ArrayList<String> ruleDesc = new ArrayList<String>();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String rule : rulesArray) {
            String ruleDescStr;
            Matcher mat = ruleNamePattern.matcher(rule);
            boolean matches = mat.find();
            if (matches) {
                resultMap.clear();
                ArrayList list = rnPR.getAttributes();
                for (int i = 0; i < list.size(); ++i) {
                    Attribute atr = (Attribute)list.get(i);
                    String groupName = atr.getGroupName();
                    String value = mat.group(atr.getGroupNumber());
                    resultMap.put(groupName, value);
                }
                String data = (String)resultMap.get("ruleName");
                if (data == null) continue;
                if ((data = data.trim()).indexOf("\"") > -1) {
                    if (ruleName != null) {
                        rulesVsDescriptionMap.put(ruleName, ruleDesc);
                        ruleDesc = new ArrayList();
                    }
                    ruleName = data = data.replaceAll("\"", "");
                    continue;
                }
                if (ruleName == null) continue;
                data = (String)resultMap.get("ruleConfigLine");
                data = data.trim();
                ruleDesc.add(data);
                continue;
            }
            if (ruleName == null || (ruleDescStr = this.executeParserRuleList(rule, rdPRSet)) == null) continue;
            if ((ruleDescStr = ruleDescStr.trim()).equals("}")) {
                ruleDesc.add("};");
                continue;
            }
            ruleDesc.add(ruleDescStr);
        }
        if (ruleName != null && !ruleDesc.isEmpty()) {
            rulesVsDescriptionMap.put(ruleName, ruleDesc);
        }
    }

    private String executeParserRuleList(String ruleConfigLine, Vector<ParserRule> rdPRSet) {
        for (ParserRule pr : rdPRSet) {
            Pattern pattern;
            ArrayList attributes;
            String expression = pr.getRegex();
            String parseResult = this.executeParserRule(ruleConfigLine, expression, attributes = pr.getAttributes(), pattern = pr.getPattern());
            if (parseResult == null) continue;
            return parseResult;
        }
        return null;
    }

    private String executeParserRule(String ruleConfigLine, String expression, ArrayList groups, Pattern pattern) {
        Matcher m;
        boolean found;
        if (pattern == null) {
            pattern = Pattern.compile(expression);
        }
        if (found = (m = pattern.matcher(ruleConfigLine)).find()) {
            Attribute attr = (Attribute)groups.get(0);
            String groupName = attr.getGroupName();
            String result = m.group(attr.getGroupNumber());
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private void populateNoHitRulesDescMap(String str, HashMap noHitRulesVsDescMap) {
        Matcher noHitMatcher = this.noHitRulesDescPattern.matcher(str);
        if (noHitMatcher.matches()) {
            String noHitRuleName = noHitMatcher.group(1);
            String ruleDesc = noHitMatcher.group(2);
            if (noHitRuleName != null) {
                ArrayList<String> rd = (ArrayList<String>)noHitRulesVsDescMap.get(noHitRuleName);
                if (rd == null) {
                    rd = new ArrayList<String>();
                    noHitRulesVsDescMap.put(noHitRuleName, rd);
                }
                if (ruleDesc != null) {
                    LOGGER.fine("Adding norule desc............................. " + ruleDesc);
                    rd.add(ruleDesc.trim());
                }
            }
        }
    }

    private void populateRulesDescMap(String ruleName, String description, Map rulesVsDescriptionMap) {
        if (ruleName != null) {
            ArrayList<String> rd = (ArrayList<String>)rulesVsDescriptionMap.get(ruleName);
            if (rd == null) {
                rd = new ArrayList<String>();
                rulesVsDescriptionMap.put(ruleName, rd);
            }
            if (description != null) {
                rd.add(description.trim());
            }
        }
    }

    private boolean validate(String line, Map rulesVsDescriptionMap, Map rulesVsHash) {
        if (line == null || "".equals(line)) {
            return false;
        }
        Matcher m = this.p.matcher(line);
        if (m.matches()) {
            String name = m.group(1);
            String hash = m.group(3);
            String description = m.group(4);
            if (hash != null) {
                rulesVsHash.put(name, hash);
            }
            this.populateRulesDescMap(name, description, rulesVsDescriptionMap);
            return true;
        }
        return false;
    }

    public Properties getPropertiesFromDO(DataObject doo) throws Exception {
        return this.getPropertiesFromDO(doo, "DeviceCredentials");
    }

    public Properties getPropertiesFromDO(DataObject doo, String tableName) throws Exception {
        Boolean profileOverridden;
        Properties toReturn = new Properties();
        List tableNames = doo.getTableNames();
        if (tableNames.contains("Resources")) {
            String device = (String)doo.getFirstValue("Resources", "IPADDRESS");
            toReturn.put("hostName", device);
            String type = (String)doo.getFirstValue("Resources", "VENDOR_TYPE");
            toReturn.put("deviceType", type);
            String resName = (String)doo.getFirstValue("Resources", "RESOURCENAME");
            toReturn.put("resourceName", resName);
        }
        Iterator itr = doo.getRows(tableName);
        while (itr.hasNext()) {
            Row dcRow = (Row)itr.next();
            String key = (String)dcRow.get("CREDENTIAL_NAME");
            String value = (String)dcRow.get("CREDENTIAL_VALUE");
            if (key == null || value == null) continue;
            toReturn.put(key, value);
        }
        Boolean bl = profileOverridden = doo.getTableNames().contains("DeviceCredentials") ? (Boolean)doo.getFirstValue("DeviceDetails", "PROF_VAL_OVERWRITTEN") : Boolean.FALSE;
        if (profileOverridden.booleanValue()) {
            itr = doo.getRows("DeviceCredentials");
            while (itr.hasNext()) {
                Row dcRow = (Row)itr.next();
                String key = (String)dcRow.get("CREDENTIAL_NAME");
                String value = (String)dcRow.get("CREDENTIAL_VALUE");
                if (key == null || value == null) continue;
                toReturn.put(key, value);
            }
        }
        if (tableNames.contains("DeviceDetails")) {
            String genCompRpt = ((Boolean)doo.getFirstValue("DeviceDetails", "GEN_COMP_RPT")).toString();
            toReturn.put("genCompRpt", genCompRpt);
            String genConfMgmtReport = ((Boolean)doo.getFirstValue("DeviceDetails", "GEN_CONF_MGMT_RPT")).toString();
            toReturn.put("genConfMgmtReport", genConfMgmtReport);
            String fetchRules = ((Boolean)doo.getFirstValue("DeviceDetails", "FETCH_RULES")).toString();
            toReturn.put("fetchRules", fetchRules);
            Long rID = (Long)doo.getFirstValue("DeviceDetails", "RID");
            toReturn.setProperty("resourceID", rID.toString());
            Long ddID = (Long)doo.getFirstValue("DeviceDetails", "DDID");
            toReturn.put("DDID", ddID);
            Integer mode = (Integer)doo.getFirstValue("DeviceDetails", "MODE");
            String ddMode = Integer.toString(mode);
            toReturn.put("mode", ddMode);
        }
        if (tableNames.contains("DDNotifications")) {
            String toMailId = (String)doo.getFirstValue("DDNotifications", "TO_ADDRESS");
            String toNo = (String)doo.getFirstValue("DDNotifications", "TO_NUMBER");
            String alertType = (String)doo.getFirstValue("DDNotifications", "ALERTTYPE");
            String enabled = ((Boolean)doo.getFirstValue("DDNotifications", "ENABLED")).toString();
            toReturn.put("toMailId", toMailId);
            toReturn.put("toNo", toNo);
            toReturn.put("alertType", alertType);
            toReturn.put("enableNotify", enabled);
        }
        return toReturn;
    }

    public String execCmds(Properties props, String mode, List<String> complianceCmds, int keyCmdIndex) throws Exception {
        String toReturn = null;
        if ("auto".equals(mode)) {
            CLISession session = null;
            Long rID = new Long(props.getProperty("resourceID"));
            try {
                session = this.createSession(props);
                String deviceType = props.getProperty("deviceType");
                boolean isCisco = deviceType.startsWith("Cisco");
                String promptToMatch = props.getProperty("enablePrompt");
                String string = promptToMatch = isCisco ? promptToMatch : props.getProperty("prompt");
                if (this.dcp.isEnableModeRequired(deviceType) && !this.enterEnableMode(session, props, null)) {
                    throw new Exception("Exception while logging into enable mode");
                }
                CLIMessage msg = null;
                int size = complianceCmds.size();
                for (int i = 0; i < complianceCmds.size(); ++i) {
                    if (i != keyCmdIndex) {
                        this.executeCommand(session, complianceCmds.get(i), promptToMatch);
                        continue;
                    }
                    msg = this.executeCommand(session, complianceCmds.get(i), promptToMatch);
                    if (msg != null) continue;
                    throw new Exception("Exception while fetching cmd-output from device");
                }
                toReturn = msg.getData();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                this.cleanUp(session, rID);
                throw new Exception("Exception while fetching cmd-output from device");
            }
            finally {
                String dummyKey = rID.toString() + props.getProperty("loginName");
                LOGGER.fine("@@DeviceConnection:::: ExecCmds method :::: before closing session, updating the lastFetchTimeMap for the key:::" + dummyKey);
                FwConfigMgmt.updateConfigFetcherMap(dummyKey);
                this.cleanUp(session, rID);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reteriveConfigurationData_dummy(Properties props, String mode, List complianceCmds, Long rID, String configType, Boolean isFrmCM, CLISession session, Boolean isVirtualDom) throws Exception {
        String inputFile = null;
        inputFile = configType.equals("running") ? System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "Config_" + rID + ".txt" : System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "Config_" + rID + ".txt";
        boolean isVdom = isVirtualDom;
        if (isVdom) {
            String vdomName = (String)props.get("vdomName");
            String ipAddress = (String)props.get("hostName");
            vdomName = this.getVdomName(ipAddress, vdomName);
            inputFile = System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "Config_" + vdomName + ".txt";
        }
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        StringBuilder sb = new StringBuilder();
        try {
            String line = br.readLine();
            String lineSeparator = System.getProperty("line.separator");
            while (line != null) {
                sb.append(line);
                sb.append(lineSeparator);
                line = br.readLine();
            }
            String everything = sb.toString();
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    public String reteriveConfigurationData(Properties props, String mode, List complianceCmds, Long rID, String configType, Boolean isFrmCM, CLISession session, Boolean isVirtualDom) throws Exception {
        String toReturn = null;
        boolean changeMgmtCall = isFrmCM;
        String dummyKey = rID.toString() + configType;
        String date = this.format.format(new Date());
        long timeNow = this.format.parse(date).getTime();
        if ("auto".equals(mode)) {
            try {
                String deviceType = props.getProperty("deviceType");
                boolean isEnablePrompt = false;
                if ("Cisco".equalsIgnoreCase(deviceType) || "SRX Log Format".equalsIgnoreCase(deviceType)) {
                    isEnablePrompt = true;
                }
                String promptToMatch = props.getProperty("enablePrompt");
                String string = promptToMatch = isEnablePrompt ? promptToMatch : props.getProperty("prompt");
                if (this.dcp.isEnableModeRequired(deviceType) && !this.enterEnableMode(session, props, null)) {
                    throw new Exception("Problem while logging in to enable mode for rid ::" + rID);
                }
                CLIMessage msg = null;
                String configData = null;
                String protocol = props.getProperty("protocol");
                if (protocol.indexOf("TFTP") > -1 || protocol.indexOf("SCP") > -1) {
                    configData = this.getConfigUsingTFTPOrSCP(session, isVirtualDom, rID, deviceType, configType, props, protocol, promptToMatch);
                } else {
                    int size = complianceCmds.size();
                    int keyCmdIndex = 0;
                    if (size > 0) {
                        boolean isVdom = isVirtualDom;
                        if (isVdom) {
                            keyCmdIndex = this.dcp.getVdomKeyCmdIndex(deviceType);
                            String command = "";
                            for (int i = 0; i < size; ++i) {
                                command = (String)complianceCmds.get(i);
                                if (i != keyCmdIndex) {
                                    this.executeVdomCommands(session, command, promptToMatch, props);
                                    continue;
                                }
                                msg = this.executeVdomCommands(session, command, promptToMatch, props);
                                if (msg != null) continue;
                                throw new Exception("Exception while fetching cmd-output from device for rid :::" + rID);
                            }
                        } else {
                            keyCmdIndex = this.dcp.getKeyCmdIndex(deviceType);
                            for (int i = 0; i < complianceCmds.size(); ++i) {
                                if (i != keyCmdIndex) {
                                    this.executeCommand(session, (String)complianceCmds.get(i), promptToMatch);
                                    continue;
                                }
                                msg = this.executeCommand(session, (String)complianceCmds.get(i), promptToMatch);
                                if (msg != null) continue;
                                throw new Exception("Exception while fetching cmd-output from device for rid ::" + rID);
                            }
                        }
                    } else {
                        throw new Exception("Problem while processing commands for rid :::" + rID);
                    }
                    configData = msg.getData();
                }
                if (configData.length() < 700) {
                    LOGGER.info("The faulty configuration is::::" + configData);
                    throw new Exception("Unable to fetch the Configuration from device :::" + rID + ". Try again");
                }
                if ("FortiGate".equalsIgnoreCase(deviceType) || "true".equals(System.getProperty("replaceConfig"))) {
                    configData = configData.replaceAll("<", "&lt;");
                    configData = configData.replaceAll(">", "&gt;");
                }
                toReturn = configData;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                throw new Exception("Problem while fetching configuration from device :::" + rID);
            }
        }
        return toReturn;
    }

    public String getConfigUsingTFTPOrSCP(CLISession session, Boolean isVirtualDom, Long rID, String deviceType, String configType, Properties props, String protocol, String promptToMatch) throws Exception {
        boolean isVdom = isVirtualDom;
        ArrayList<String> complianceCmds = null;
        String fileName = configType + "_" + rID + ".txt";
        if (isVdom) {
            String vdomName = (String)props.get("vdomName");
            fileName = configType + "_" + vdomName + ".txt";
            if (protocol.indexOf("TFTP") > -1) {
                complianceCmds = "startup".equals(configType) ? this.dcp.getVdomTFTPStartupCommands(deviceType) : this.dcp.getVdomTFTPRunningCommands(deviceType);
            } else if (protocol.indexOf("SCP") > -1) {
                complianceCmds = "startup".equals(configType) ? this.dcp.getVdomSCPStartupCommands(deviceType) : this.dcp.getVdomSCPRunningCommands(deviceType);
            }
            for (String cmd : complianceCmds) {
                if (cmd.indexOf("UserInput") > -1) {
                    cmd = this.getModifiedCommand(cmd, protocol, fileName);
                }
                this.executeVdomCommands(session, cmd, promptToMatch, props);
            }
        } else {
            if (protocol.indexOf("TFTP") > -1) {
                complianceCmds = "startup".equals(configType) ? this.dcp.getTFTPStartupCommands(deviceType) : this.dcp.getTFTPRunningCommands(deviceType);
            } else if (protocol.indexOf("SCP") > -1) {
                complianceCmds = "startup".equals(configType) ? this.dcp.getSCPStartupCommands(deviceType) : this.dcp.getSCPRunningCommands(deviceType);
            }
            for (String cmd : complianceCmds) {
                if (cmd.indexOf("UserInput") > -1) {
                    cmd = this.getModifiedCommand(cmd, protocol, fileName);
                }
                this.executeCommand(session, cmd, promptToMatch);
            }
        }
        return this.readConfigFromFile(fileName);
    }

    private String getModifiedCommand(String cmd, String protocol, String fileName) throws Exception {
        String serverIP = FAServerUtil.getServerIPAddress();
        if (protocol.indexOf("TFTP") > -1) {
            cmd = cmd.replaceAll("\\$\\{UserInput:tftp_server_address\\}", serverIP);
            cmd = cmd.replaceAll("\\$\\{UserInput:file_name\\}", fileName);
        } else if (protocol.indexOf("SCP") > -1) {
            cmd = cmd.replaceAll("\\$\\{UserInput:scp_server_address\\}", serverIP);
            cmd = cmd.replaceAll("\\$\\{UserInput:scp_username\\}", "FWASCPUser");
            cmd = cmd.replaceAll("\\$\\{UserInput:scp_password\\}", "FWASCPPwd");
            cmd = cmd.replaceAll("\\$\\{UserInput:file_name\\}", fileName);
        }
        return cmd;
    }

    private String readConfigFromFile(String fileName) throws Exception {
        String inputFile = System.getProperty("server.dir") + File.separator + "tftp_files" + File.separator + fileName;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new FileReader(inputFile));
            String line = br.readLine();
            String lineSeparator = System.getProperty("line.separator");
            while (line != null) {
                sb.append(line);
                sb.append(lineSeparator);
                line = br.readLine();
            }
            String everything = sb.toString();
        }
        catch (Exception ee) {
            throw new Exception("Problem while reading the config from file...");
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    public boolean checkInConfigurationData(Properties props, String mode, List complianceCmds, String configType, Long rID, CLISession cli, Boolean isVirtualDom, Boolean isPolicyParsingDone, String configData) throws Exception {
        block8: {
            try {
                if (configData == null) {
                    configData = this.reteriveConfigurationData(props, "auto", complianceCmds, rID, configType, Boolean.TRUE, cli, isVirtualDom);
                }
                if (configData != null) {
                    if ("running".equals(configType)) {
                        this.runningConfig = configData;
                    } else {
                        this.startupConfig = configData;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date = format.format(new Date());
                    long time = format.parse(date).getTime();
                    Timestamp timestamp = new Timestamp(time);
                    FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
                    Long versionNo = confMgmt.getMaxConfigVersion(rID, configType);
                    if (!versionNo.equals(new Long(0L))) {
                        confMgmt.checkInNewVersionIfDiffExists(configData, rID, configType, "N/A", props, Boolean.FALSE, versionNo);
                        return false;
                    }
                    String encryptedConfigFile = this.encryptionObj.encryptLog(configData);
                    ByteArrayInputStream is = new ByteArrayInputStream(encryptedConfigFile.getBytes("UTF-8"));
                    long newVersion = versionNo;
                    versionNo = new Long(++newVersion);
                    Row confRow = new Row("ConfigVersions");
                    confRow.set("VERSION_NO", (Object)versionNo);
                    confRow.set("RID", (Object)rID);
                    confRow.set("FILE_CONTENTS", (Object)is);
                    confRow.set("CHANGED_BY", (Object)"N/A");
                    confRow.set("ANNOTATION", (Object)"-");
                    confRow.set("CONFIG_TYPE", (Object)configType);
                    confRow.set("MODIFIED_TIME", (Object)timestamp);
                    confRow.set("DIFF_CONTENTS", (Object)"-");
                    confRow.set("DIFF_COUNT", (Object)new Integer(0));
                    DataObject confDo = DataAccess.constructDataObject();
                    confDo.addRow(confRow);
                    DataAccess.add((DataObject)confDo);
                    Row latestConfRow = new Row("LatestConfig");
                    latestConfRow.set("RID", (Object)rID);
                    latestConfRow.set("VERSION_NO", (Object)versionNo);
                    latestConfRow.set("CONFIG_TYPE", (Object)configType);
                    DataObject doo = DataAccess.constructDataObject();
                    doo.addRow(latestConfRow);
                    DataAccess.add((DataObject)doo);
                    String deviceType = props.getProperty("deviceType");
                    if (!isPolicyParsingDone.booleanValue() && this.policyParsingSupportedDevList.contains(deviceType)) {
                        FwConfigMgmt configMgmt = FwConfigMgmt.getInstance();
                        configMgmt.initiatePolicyProcessing(rID, deviceType, configData, configType, versionNo, null);
                    }
                    break block8;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return true;
    }

    public void cleanUp(CLISession session, Long rID) {
        try {
            if (session != null) {
                this.closeSession(session, rID);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            session = null;
        }
    }

    private String trimString(String cmd, String response) {
        LOGGER.fine("inside trimstring..cmd is-->" + cmd + "@@response is-->" + response);
        int index = response.indexOf(cmd);
        if (index < 0) {
            return response.trim();
        }
        return response.substring(index + cmd.length(), response.length());
    }

    public String generateCheckPointPolicyReport(Long resourceID, String compRptType) throws Exception {
        if (!this.nipperInitialized) {
            LOGGER.log(Level.WARNING, " Nipper is not initialized, hence returning without creating compliance report");
            return null;
        }
        String outputFile = null;
        BufferedReader errorReader = null;
        try {
            long start = System.currentTimeMillis();
            StringBuffer cmd = new StringBuffer(command);
            cmd.append(" --resource-dir=");
            cmd.append(System.getProperty("server.dir") + File.separator + "Nipper");
            cmd.append(" --auto");
            String reportName = "";
            if (compRptType != null && !compRptType.equals("")) {
                String rptParam = "no-audit --no-bestpractice --excl-general --excl-admin --excl-auth --excl-banner --excl-printer --excl-dns --excl-snmp --excl-logging --excl-ntp --excl-ids --excl-interfaces --excl-nat --excl-protocols --excl-routing --excl-vpn";
                reportName = "ConfigAnalysisReport";
                if (compRptType.equals("securityAudit")) {
                    rptParam = "no-config";
                    reportName = "SecurityAuditReport";
                }
                cmd.append(" --" + rptParam);
            }
            cmd.append(" --input=");
            cmd.append(this.baseStoreDir + File.separator + "configData" + File.separator + resourceID);
            String resourceName = (String)LaCacheManager.getInstance().getResourceName(new Long(resourceID));
            String displayName = FACacheManager.getInstance().getDisplayName(new Long(resourceID));
            String dirPath = this.baseStoreDir + File.separator + "configData" + File.separator + resourceID;
            File dirFilePath = new File(dirPath);
            if (!dirFilePath.exists()) {
                dirFilePath.mkdirs();
            }
            outputFile = this.baseStoreDir + File.separator + "configData" + File.separator + resourceID + File.separator + resourceName + "_ComplianceReport.html";
            if (!reportName.equals("")) {
                outputFile = this.baseStoreDir + File.separator + "configData" + File.separator + resourceID + File.separator + resourceName + "_" + reportName + ".html";
            }
            cmd.append(" --report=");
            cmd.append(outputFile);
            cmd.append("  --force");
            cmd.append(" --company-name=\"");
            String companyName = ProductBundle.getInstance().getRebrandingString("CompanyName");
            companyName = "ZOHO Corp.".equals(companyName) ? "ManageEngine" : companyName;
            companyName = companyName != null ? companyName.replaceAll(" ", "&nbsp;") : companyName;
            cmd.append(companyName);
            cmd.append("\"");
            cmd.append(" --device-name=\"");
            cmd.append(displayName);
            cmd.append("\"");
            if ("analyzeConfig".equals(compRptType)) {
                cmd.append(" --no-appendix --order-by-rating --rule-comments --no-timezones ");
            } else {
                cmd.append(" --no-appendix --bestpractice --order-by-rating --rule-comments --no-timezones ");
            }
            cmd.append(" --stylesheet=");
            cmd.append(System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "NReport.css");
            LOGGER.log(Level.INFO, " CommandLine Options Provided are  {0}", cmd.toString());
            Runtime runtime = Runtime.getRuntime();
            LOGGER.info(" NipperExportAction::::::  Step :::: 2 Start ,...... ");
            Process p = runtime.exec(cmd.toString());
            errorReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String error = errorReader.readLine();
            LOGGER.log(Level.INFO, " Error String received is :::: " + error);
            if (error != null) {
                LOGGER.log(Level.WARNING, " Inside ERROR Processing Block ... ");
                StringBuffer sb = new StringBuffer(error);
                while ((error = errorReader.readLine()) != null) {
                    sb.append(error);
                }
                LOGGER.log(Level.WARNING, "ERROR: Unable to generate compliance reports :::: " + sb.toString());
                throw new Exception("Unable to generate compliance reports for " + resourceID);
            }
            p.waitFor();
            long totalTimeTaken = System.currentTimeMillis() - start;
            LOGGER.info(" Total Time Taken to complete the compliance generation process is :::::: " + totalTimeTaken);
            boolean dontDelete = "true".equals(System.getProperty("dontDeleteCheckPointFiles"));
            if (!dontDelete) {
                String[] fileNames = new String[]{"objects.C", "objects.C_41", "objects_5_0.C", "rules.C", "rulebases.fws", "rulebases_5_0.fws"};
                String fileName = "";
                String completeFilePath = "";
                for (int i = 0; i < fileNames.length; ++i) {
                    fileName = fileNames[i];
                    completeFilePath = dirPath + File.separator + fileName;
                    File fileToDel = new File(completeFilePath);
                    fileToDel.delete();
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw exp;
        }
        finally {
            try {
                if (errorReader != null) {
                    errorReader.close();
                }
            }
            catch (Exception exp) {
                errorReader = null;
                exp.printStackTrace();
            }
        }
        return outputFile;
    }

    public String generateComplianceReport(String configurationFile, Long resourceID) throws Exception {
        return this.generateComplianceReport(configurationFile, resourceID, null, Boolean.TRUE, null);
    }

    public String generateComplianceReport(String configurationFile, Long resourceID, String compRptType) throws Exception {
        return this.generateComplianceReport(configurationFile, resourceID, null, Boolean.TRUE, compRptType);
    }

    public String generateComplianceReport(String configurationFile, Long resourceID, String deviceType, Boolean toDelete) throws Exception {
        return this.generateComplianceReport(configurationFile, resourceID, deviceType, Boolean.TRUE, null);
    }

    public String generateComplianceReport(String configurationFile, Long resourceID, String deviceType, Boolean toDelete, String compRptType) throws Exception {
        if (!this.nipperInitialized) {
            LOGGER.log(Level.WARNING, " Nipper is not initialized, hence returning without creating compliance report");
            return null;
        }
        String outputFile = null;
        BufferedReader errorReader = null;
        try {
            long start = System.currentTimeMillis();
            boolean isZip = configurationFile.endsWith(".zip");
            StringBuffer cmd = new StringBuffer(command);
            cmd.append(" --resource-dir=");
            cmd.append(System.getProperty("server.dir") + File.separator + "Nipper");
            String devTypeForConfig = System.getProperty("devTypeForConfigFetch");
            String string = deviceType = deviceType == null ? this.getDeviceType(resourceID) : deviceType;
            if ("FortiGate".equalsIgnoreCase(deviceType)) {
                cmd.append(" --fortigate");
            } else if ("WatchGuard Firewall".equals(deviceType) && devTypeForConfig != null) {
                cmd.append(" --" + devTypeForConfig);
            } else {
                cmd.append(" --auto");
            }
            String reportName = "";
            if (compRptType != null && !compRptType.equals("")) {
                String rptParam = "no-audit";
                reportName = "ConfigAnalysisReport";
                if (compRptType.equals("securityAudit")) {
                    rptParam = "no-config";
                    reportName = "SecurityAuditReport";
                }
                cmd.append(" --" + rptParam);
            }
            cmd.append(" --input=");
            cmd.append(!isZip ? configurationFile : this.baseStoreDir + File.separator + "configData" + File.separator + resourceID);
            String resourceName = (String)LaCacheManager.getInstance().getResourceName(new Long(resourceID));
            String displayName = FACacheManager.getInstance().getDisplayName(new Long(resourceID));
            String dirPath = this.baseStoreDir + File.separator + "configData" + File.separator + resourceID;
            File dirFilePath = new File(dirPath);
            if (!dirFilePath.exists()) {
                dirFilePath.mkdirs();
            }
            outputFile = this.baseStoreDir + File.separator + "configData" + File.separator + resourceID + File.separator + resourceName + "_ComplianceReport.html";
            if (!reportName.equals("")) {
                outputFile = this.baseStoreDir + File.separator + "configData" + File.separator + resourceID + File.separator + resourceName + "_" + reportName + ".html";
            }
            cmd.append(" --report=");
            cmd.append(outputFile);
            cmd.append("  --force");
            cmd.append(" --company-name=\"");
            String companyName = ProductBundle.getInstance().getRebrandingString("CompanyName");
            companyName = "ZOHO Corp.".equals(companyName) ? "ManageEngine" : companyName;
            companyName = companyName != null ? companyName.replaceAll(" ", "&nbsp;") : companyName;
            cmd.append(companyName);
            cmd.append("\"");
            cmd.append(" --device-name=\"");
            cmd.append(displayName);
            cmd.append("\"");
            cmd.append(" --no-appendix --bestpractice --order-by-rating --rule-comments --no-timezones ");
            cmd.append(" --stylesheet=");
            cmd.append(System.getProperty("server.dir") + File.separator + "Nipper" + File.separator + "NReport.css");
            LOGGER.log(Level.INFO, " CommandLine Options Provided are  {0}", cmd.toString());
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(cmd.toString());
            errorReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String error = errorReader.readLine();
            LOGGER.log(Level.INFO, " Error String received is :::: " + error);
            if (error != null) {
                LOGGER.log(Level.WARNING, " Inside ERROR Processing Block ... ");
                StringBuffer sb = new StringBuffer(error);
                while ((error = errorReader.readLine()) != null) {
                    sb.append(error);
                }
                LOGGER.log(Level.WARNING, "ERROR: Unable to generate compliance reports :::: " + sb.toString());
                throw new Exception("Unable to generate compliance reports for " + resourceID);
            }
            p.waitFor();
            long totalTimeTaken = System.currentTimeMillis() - start;
            if (toDelete.booleanValue()) {
                File configFile = new File(configurationFile);
                boolean delStatus = configFile.delete();
                if (isZip) {
                    String[] fileNames = new String[]{"objects.C", "objects.C_41", "objects_5_0.C", "rules.C", "rulebases.fws", "rulebases_5_0.fws"};
                    String fileName = "";
                    String completeFilePath = "";
                    for (int i = 0; i < fileNames.length; ++i) {
                        fileName = fileNames[i];
                        completeFilePath = dirPath + File.separator + fileName;
                        File fileToDel = new File(completeFilePath);
                        fileToDel.delete();
                    }
                }
            }
            this.takeBackup(outputFile, resourceID, resourceName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw exp;
        }
        finally {
            try {
                if (errorReader != null) {
                    errorReader.close();
                }
            }
            catch (Exception exp) {
                errorReader = null;
                exp.printStackTrace();
            }
        }
        return outputFile;
    }

    private String getDeviceType(Long resourceID) {
        String toReturn = null;
        try {
            Criteria ridCrit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)resourceID, 0);
            DataObject dObj = DataAccess.get((String)"Resources", (Criteria)ridCrit);
            if (!dObj.isEmpty()) {
                toReturn = (String)dObj.getFirstValue("Resources", "VENDOR_TYPE");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return toReturn;
    }

    private void takeBackup(String srFile, Long resourceID, String displayName) {
        try {
            int len;
            File f1 = new File(srFile);
            String destDirLoc = System.getProperty("server.dir") + File.separator + "server" + File.separator + "reports" + File.separator + "ComplianceReports" + File.separator + displayName;
            Date currentTime = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM_dd_yyyy_HH_mm_ss");
            String fileName = "ComplianceReport_" + dateFormat.format(currentTime) + ".html";
            File f2 = new File(destDirLoc, fileName);
            if (!f2.exists()) {
                LOGGER.log(Level.FINE, " DeviceConnection: takeBackup:::File does not exists ... creating new one .... !!");
                File destDir = new File(destDirLoc);
                if (!destDir.exists()) {
                    LOGGER.log(Level.FINE, " DeviceConnection: takeBackup:::No Directory exists ... creating new one .... !!");
                    destDir.mkdirs();
                }
                f2.createNewFile();
            }
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            LOGGER.log(Level.WARNING, "ERROR: FileNotFound... Unable to takeBackup of generateed compliance report for resource :::: " + displayName);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.log(Level.WARNING, "ERROR: Unable to takeBackup of generateed compliance report for resource :::: " + displayName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigDataFromFile(String configFileLoc) {
        BufferedReader reader = null;
        StringBuffer fileData = new StringBuffer(1000);
        try {
            reader = new BufferedReader(new FileReader(configFileLoc));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                reader = null;
            }
        }
        return fileData.toString();
    }

    public static void main(String[] args) throws Exception {
        Properties p = new Properties();
        p.put("protocol", "TELNET");
        p.put("hostName", "pix501");
        p.put("loginName", "");
        p.put("password", "advent");
        p.put("enablePassword", "advent");
        p.put("enablePrompt", "#");
        p.put("command", "show access-list");
        DeviceConnection dc = new DeviceConnection();
        Map responseMap = dc.validateCredentials(p);
    }

    static {
        CLIResourceManager.getInstance().setMaxConnections(10);
        CLIResourceManager.getInstance().setSystemWideMaxConnections(50);
        debug = "true".equals(System.getProperty("FWA_CLI_DEBUG"));
        CLILogMgr.setDebugOption((boolean)debug);
    }

    class FetcherTask
    extends TimerTask {
        private DataObject doo = null;
        private String detail = null;
        List complianceCmds = null;

        public FetcherTask(DataObject doo, String detail) {
            this.doo = doo;
            this.detail = detail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block87: {
                Object mode;
                String currentThreadName;
                Properties prop;
                Long rID;
                CLISession cli;
                FileOutputStream fOut;
                String errStr;
                boolean error;
                block85: {
                    error = false;
                    errStr = null;
                    fOut = null;
                    cli = null;
                    rID = null;
                    boolean isPolicyParsingDone = false;
                    prop = null;
                    currentThreadName = Thread.currentThread().getName();
                    Long id = (Long)this.doo.getFirstValue("DeviceDetails", "DDID");
                    mode = (Integer)this.doo.getFirstValue("DeviceDetails", "MODE");
                    Map rulesVsDesc = null;
                    HashMap rulesVsHash = new HashMap();
                    String deviceType = null;
                    String hostName = null;
                    String ip = null;
                    String[] data = null;
                    if (this.detail != null) {
                        data = this.detail.split("\\|_\\|");
                        if (data.length > 1) {
                            deviceType = data[1];
                            hostName = data[0];
                        } else {
                            hostName = this.detail;
                        }
                        ip = LaCacheManager.getInstance().getResourceIp(hostName);
                    }
                    List vdomList = FAServerUtil.getVdomDevicesList();
                    boolean isVdom = vdomList.contains(ip);
                    List tableNames = this.doo.getTableNames();
                    String tableName = tableNames.contains("DIPCredentials") ? "DIPCredentials" : "DeviceCredentials";
                    prop = DeviceConnection.this.getPropertiesFromDO(this.doo, tableName);
                    String resourceID = prop.getProperty("resourceID");
                    rID = new Long(resourceID);
                    if (data.length > 1) {
                        prop.put("deviceType", deviceType);
                        prop.put("hostName", ip);
                    }
                    deviceType = prop.getProperty("deviceType");
                    if (isVdom) {
                        List resList = FAServerUtil.getResForDDID(id);
                        cli = DeviceConnection.this.createSession(prop);
                        for (Long rid : resList) {
                            String vdomName = (String)LaCacheManager.getInstance().getResourceName(rid);
                            prop.put("vdomName", vdomName);
                            this.complianceCmds = DeviceConnection.this.dcp.getVdomRunningComplianceCommands(deviceType);
                            String configData = DeviceConnection.this.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "running", Boolean.FALSE, cli, Boolean.TRUE);
                            DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                            if (configData != null && DeviceConnection.this.policyParsingSupportedDevList.contains(deviceType) && !"true".equals(prop.getProperty("genConfMgmtReport", "false"))) {
                                FwConfigMgmt configMgmt = FwConfigMgmt.getInstance();
                                configMgmt.initiatePolicyProcessing(rID, deviceType, configData, "running", new Long(0L), null);
                                isPolicyParsingDone = true;
                            }
                            try {
                                HashMap conflictContents;
                                if ("true".equals(prop.getProperty("fetchRules", "false"))) {
                                    rulesVsDesc = DeviceConnection.this.fetchFromDevice(prop, rid, rulesVsHash, cli, Boolean.TRUE);
                                    Long frid = (Long)this.doo.getFirstValue("DeviceDetails", "DDID");
                                    DeviceConnection.this.updateDB(rid, frid, rulesVsDesc, rulesVsHash);
                                    DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                }
                                if ("true".equals(prop.getProperty("genCompRpt", "false"))) {
                                    String dirPath = System.getProperty("server.dir") + File.separator + "server" + File.separator + "configData" + File.separator + rid.toString();
                                    String fileName = vdomName + "_ConfigFile.txt";
                                    String storagePath = dirPath + File.separator + fileName;
                                    try {
                                        File f = new File(dirPath, fileName);
                                        if (!f.exists()) {
                                            new File(dirPath).mkdirs();
                                            f.createNewFile();
                                        }
                                        fOut = new FileOutputStream(f, false);
                                        fOut.write(configData.getBytes());
                                        if (fOut != null) {
                                            fOut.close();
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        fOut = null;
                                    }
                                    DeviceConnection.this.generateComplianceReport(storagePath, rid);
                                }
                                if (!"true".equals(prop.getProperty("genConfMgmtReport", "false"))) continue;
                                boolean shouldInsertIntoConflictTable = true;
                                shouldInsertIntoConflictTable = DeviceConnection.this.checkInConfigurationData(prop, "auto", this.complianceCmds, "running", rid, cli, Boolean.TRUE, isPolicyParsingDone, configData);
                                DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                if ("Cisco".equals(deviceType)) {
                                    configData = null;
                                    this.complianceCmds = DeviceConnection.this.dcp.getVdomStartupComplianceCommands(deviceType);
                                    shouldInsertIntoConflictTable = DeviceConnection.this.checkInConfigurationData(prop, "auto", this.complianceCmds, "startup", rid, cli, Boolean.TRUE, isPolicyParsingDone, configData);
                                    DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                }
                                if (!shouldInsertIntoConflictTable || !"Cisco".equals(deviceType)) continue;
                                byte[] startupContents = DeviceConnection.this.startupConfig.getBytes();
                                byte[] runningContents = DeviceConnection.this.runningConfig.getBytes();
                                FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
                                boolean conflictExists = confMgmt.checkForDiff(conflictContents = confMgmt.getDiff(startupContents, runningContents, "Cisco"));
                                if (!conflictExists) continue;
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                String date = format.format(new Date());
                                long time = format.parse(date).getTime();
                                Timestamp timestamp = new Timestamp(time);
                                String conflictContentData = confMgmt.getDiffContentsOnly(conflictContents);
                                String[] dbContents = conflictContentData.split("<->");
                                String dbDiffContents = dbContents[0];
                                String diffCount = dbContents[1];
                                int tempCount = Integer.parseInt(diffCount);
                                Integer diff_count = new Integer(tempCount);
                                try {
                                    DataObject conflictDO = DataAccess.constructDataObject();
                                    Row conflictRow = new Row("StartupRunningConflict");
                                    conflictRow.set("RID", (Object)rid);
                                    conflictRow.set("STARTUP_VNO", (Object)new Long(1L));
                                    conflictRow.set("RUNNING_VNO", (Object)new Long(1L));
                                    conflictRow.set("CHANGED_BY", (Object)"N/A");
                                    conflictRow.set("ANNOTATION", (Object)"-");
                                    conflictRow.set("MODIFIED_TIME", (Object)timestamp);
                                    conflictRow.set("DIFF_CONTENTS", (Object)dbDiffContents);
                                    conflictRow.set("DIFF_COUNT", (Object)diff_count);
                                    conflictDO.addRow(conflictRow);
                                    DataAccess.add((DataObject)conflictDO);
                                }
                                catch (Exception e) {
                                    LOGGER.info("*** Exception while putting an entry in conflict table as conflict table has an entry with resourceID--->" + rID);
                                    e.printStackTrace();
                                }
                            }
                            catch (Exception ee) {
                                error = true;
                                errStr = ee.getMessage();
                                errStr = errStr + " for rid::" + rid.toString();
                                ee.printStackTrace();
                            }
                        }
                    } else {
                        String fileNameInDB;
                        String configData = null;
                        if (this.doo.containsTable("FileDetails")) {
                            String configFileLoc = (String)this.doo.getFirstValue("FileDetails", "CONFIG_FILE_NAME");
                            LOGGER.log(Level.INFO, " FetchRulesAction ConfigFile name in DB is <---> {0} ", configFileLoc);
                            if (configFileLoc != null) {
                                configData = DeviceConnection.this.getConfigDataFromFile(configFileLoc);
                                DeviceConnection.this.generateComplianceReport(configFileLoc, rID, deviceType, Boolean.TRUE);
                            }
                        } else {
                            cli = DeviceConnection.this.createSession(prop);
                            this.complianceCmds = DeviceConnection.this.dcp.getRunningComplianceCommands(deviceType);
                            configData = DeviceConnection.this.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "running", Boolean.FALSE, cli, Boolean.FALSE);
                            DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                        }
                        if (configData != null && DeviceConnection.this.policyParsingSupportedDevList.contains(deviceType) && !"true".equals(prop.getProperty("genConfMgmtReport", "false"))) {
                            FwConfigMgmt configMgmt = FwConfigMgmt.getInstance();
                            if (currentThreadName != null) {
                                FAServerUtil.addToPolicyParsingThreadWaitList(currentThreadName);
                            }
                            configMgmt.initiatePolicyProcessing(rID, deviceType, configData, "running", new Long(0L), currentThreadName);
                            isPolicyParsingDone = true;
                        }
                        if ((Integer)mode == 0) {
                            fileNameInDB = (String)this.doo.getFirstValue("FileDetails", "FILE_NAME");
                            LOGGER.log(Level.INFO, " FetchRulesAction RuleFile name in DB is <---> {0} ", fileNameInDB);
                            if (fileNameInDB != null) {
                                String fileName = data[2];
                                rulesVsDesc = DeviceConnection.this.fetchRulesFromFile(fileName, rulesVsHash);
                                DeviceConnection.this.updateDB(this.doo, rulesVsDesc, rulesVsHash);
                                LOGGER.log(Level.INFO, " DeviceConnection.FetcherTask.run() rulesVsDesc is :: {0}  ", rulesVsDesc);
                            }
                        } else {
                            if (cli == null) {
                                cli = DeviceConnection.this.createSession(prop);
                            }
                            if ((Integer)mode == 1) {
                                if ("true".equals(prop.getProperty("fetchRules", "false"))) {
                                    rulesVsDesc = DeviceConnection.this.fetchFromDevice(prop, rID, rulesVsHash, cli, Boolean.FALSE);
                                    DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                    DeviceConnection.this.updateDB(this.doo, rulesVsDesc, rulesVsHash);
                                }
                                if ("true".equals(prop.getProperty("genCompRpt", "false"))) {
                                    String dirPath = System.getProperty("server.dir") + File.separator + "server" + File.separator + "configData" + File.separator + resourceID;
                                    String resourceName = (String)LaCacheManager.getInstance().getResourceName(rID);
                                    String fileName = resourceName + "_ConfigFile.txt";
                                    String storagePath = dirPath + File.separator + fileName;
                                    try {
                                        File f = new File(dirPath, fileName);
                                        if (!f.exists()) {
                                            new File(dirPath).mkdirs();
                                            f.createNewFile();
                                        }
                                        fOut = new FileOutputStream(f, false);
                                        fOut.write(configData.getBytes());
                                        if (fOut != null) {
                                            fOut.close();
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        fOut = null;
                                    }
                                    DeviceConnection.this.generateComplianceReport(storagePath, rID);
                                }
                                if ("true".equals(prop.getProperty("genConfMgmtReport", "false"))) {
                                    boolean shouldInsertIntoConflictTable = true;
                                    shouldInsertIntoConflictTable = DeviceConnection.this.checkInConfigurationData(prop, "auto", this.complianceCmds, "running", rID, cli, Boolean.FALSE, isPolicyParsingDone, configData);
                                    DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                    if ("Cisco".equals(deviceType)) {
                                        configData = null;
                                        this.complianceCmds = DeviceConnection.this.dcp.getStartupComplianceCommands(deviceType);
                                        shouldInsertIntoConflictTable = DeviceConnection.this.checkInConfigurationData(prop, "auto", this.complianceCmds, "startup", rID, cli, Boolean.FALSE, isPolicyParsingDone, configData);
                                        DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                    }
                                    if (shouldInsertIntoConflictTable && "Cisco".equals(deviceType)) {
                                        HashMap conflictContents;
                                        byte[] startupContents = DeviceConnection.this.startupConfig.getBytes();
                                        byte[] runningContents = DeviceConnection.this.runningConfig.getBytes();
                                        FwConfigMgmt configMgmt = FwConfigMgmt.getInstance();
                                        boolean conflictExists = configMgmt.checkForDiff(conflictContents = configMgmt.getDiff(startupContents, runningContents, "Cisco"));
                                        if (conflictExists) {
                                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                            String date = format.format(new Date());
                                            long time = format.parse(date).getTime();
                                            Timestamp timestamp = new Timestamp(time);
                                            String conflictContentData = configMgmt.getDiffContentsOnly(conflictContents);
                                            String[] dbContents = conflictContentData.split("<->");
                                            String dbDiffContents = dbContents[0];
                                            String diffCount = dbContents[1];
                                            int tempCount = Integer.parseInt(diffCount);
                                            Integer diff_count = new Integer(tempCount);
                                            try {
                                                DataObject conflictDO = DataAccess.constructDataObject();
                                                Row conflictRow = new Row("StartupRunningConflict");
                                                conflictRow.set("RID", (Object)rID);
                                                conflictRow.set("STARTUP_VNO", (Object)new Long(1L));
                                                conflictRow.set("RUNNING_VNO", (Object)new Long(1L));
                                                conflictRow.set("CHANGED_BY", (Object)"N/A");
                                                conflictRow.set("ANNOTATION", (Object)"-");
                                                conflictRow.set("MODIFIED_TIME", (Object)timestamp);
                                                conflictRow.set("DIFF_CONTENTS", (Object)dbDiffContents);
                                                conflictRow.set("DIFF_COUNT", (Object)diff_count);
                                                conflictDO.addRow(conflictRow);
                                                DataAccess.add((DataObject)conflictDO);
                                            }
                                            catch (Exception e) {
                                                LOGGER.log(Level.INFO, "*** Exception while putting an entry in conflict table as conflict table has an entry with resourceID--->" + rID);
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            } else if ((Integer)mode == 2) {
                                fileNameInDB = (String)this.doo.getFirstValue("FileDetails", "FILE_NAME");
                                LOGGER.log(Level.INFO, " MODE 2 FetchRulesAction RuleFile name in DB is <---> {0} ", fileNameInDB);
                                if (fileNameInDB != null) {
                                    String fileName = data[2];
                                    rulesVsDesc = DeviceConnection.this.fetchRulesFromFile(fileName, rulesVsHash);
                                    DeviceConnection.this.updateDB(this.doo, rulesVsDesc, rulesVsHash);
                                    LOGGER.log(Level.INFO, " MODE 2 DeviceConnection.FetcherTask.run() rulesVsDesc is :: {0}  ", rulesVsDesc);
                                }
                                if ("true".equals(prop.getProperty("genCompRpt", "false"))) {
                                    String dirPath = System.getProperty("server.dir") + File.separator + "server" + File.separator + "configData" + File.separator + resourceID;
                                    String resourceName = (String)LaCacheManager.getInstance().getResourceName(rID);
                                    String fileName = resourceName + "_ConfigFile.txt";
                                    String storagePath = dirPath + File.separator + fileName;
                                    try {
                                        File f = new File(dirPath, fileName);
                                        if (!f.exists()) {
                                            LOGGER.log(Level.INFO, " DeviceConnection: File does not exists ... creating new one .... !!");
                                            new File(dirPath).mkdirs();
                                            f.createNewFile();
                                        }
                                        fOut = new FileOutputStream(f, false);
                                        fOut.write(configData.getBytes());
                                        if (fOut != null) {
                                            fOut.close();
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        fOut = null;
                                    }
                                    DeviceConnection.this.generateComplianceReport(storagePath, rID);
                                }
                                if ("true".equals(prop.getProperty("genConfMgmtReport", "false"))) {
                                    DeviceConnection.this.checkInConfigurationData(prop, "auto", this.complianceCmds, "running", rID, cli, Boolean.FALSE, isPolicyParsingDone, configData);
                                    DeviceConnection.this.sessionVsEnableStatusMap.put(cli, Boolean.TRUE);
                                }
                            } else if ((Integer)mode == 3) {
                                if ("true".equals(prop.getProperty("fetchRules", "false"))) {
                                    rulesVsDesc = DeviceConnection.this.fetchFromDevice(prop, rID, rulesVsHash, cli, Boolean.FALSE);
                                    DeviceConnection.this.updateDB(this.doo, rulesVsDesc, rulesVsHash);
                                }
                            } else {
                                fileNameInDB = (String)this.doo.getFirstValue("FileDetails", "FILE_NAME");
                                LOGGER.log(Level.INFO, " FetchRulesAction RuleFile name in DB is <---> {0} ", fileNameInDB);
                                if (fileNameInDB != null) {
                                    String fileName = data[2];
                                    rulesVsDesc = DeviceConnection.this.fetchRulesFromFile(fileName, rulesVsHash);
                                    DeviceConnection.this.updateDB(this.doo, rulesVsDesc, rulesVsHash);
                                    LOGGER.log(Level.INFO, " DeviceConnection.FetcherTask.run() rulesVsDesc is :: {0}  ", rulesVsDesc);
                                }
                            }
                        }
                        if (!rulesVsHash.isEmpty()) {
                            V9Template.populateRuleHashFromDB(ip);
                        }
                        LOGGER.log(Level.INFO, " DeviceConnection.FetcherTask() Completed Parsing of Rules and Configuration file.");
                    }
                    if (prop == null) break block85;
                    String dummyKey = rID.toString() + prop.getProperty("loginName");
                    LOGGER.fine("@@DeviceConnection:::: after creating device rule... before closing session, updating the lastFetchTimeMap for the key:::" + dummyKey);
                    FwConfigMgmt.updateConfigFetcherMap(dummyKey);
                }
                DeviceConnection.this.cleanUp(cli, rID);
                try {
                    if (FAServerUtil.shouldWaitTillPolicyParsing(currentThreadName)) {
                        Object lock;
                        mode = lock = DynamicLocks.getLockFor(currentThreadName);
                        synchronized (mode) {
                            lock.wait();
                        }
                        FAServerUtil.removeFromPolicyParsingThreadWaitList(currentThreadName);
                    }
                    LOGGER.log(Level.FINER, " Starting to update the status .... ");
                    Row dd = this.doo.getFirstRow("DeviceDetails");
                    int statusInt = error ? -1 : 1;
                    LOGGER.fine("Abt: to update the status frm FetcherTask with STATUS VALUE AS " + statusInt);
                    dd.set("STATUS", (Object)new Integer(statusInt));
                    if (errStr != null) {
                        dd.set("ERRORSTRING", (Object)errStr);
                    }
                    if (fOut != null) {
                        fOut.close();
                    }
                    this.doo.updateRow(dd);
                    DataAccess.update((DataObject)this.doo);
                }
                catch (Exception exp) {
                    fOut = null;
                    exp.printStackTrace();
                }
                break block87;
                catch (Exception exp) {
                    block86: {
                        String dummyKey;
                        try {
                            error = true;
                            errStr = exp.getMessage();
                            exp.printStackTrace();
                            if (prop == null) break block86;
                            dummyKey = rID.toString() + prop.getProperty("loginName");
                            LOGGER.fine("@@DeviceConnection:::: after creating device rule... before closing session, updating the lastFetchTimeMap for the key:::" + dummyKey);
                        }
                        catch (Throwable throwable) {
                            if (prop != null) {
                                String dummyKey2 = rID.toString() + prop.getProperty("loginName");
                                LOGGER.fine("@@DeviceConnection:::: after creating device rule... before closing session, updating the lastFetchTimeMap for the key:::" + dummyKey2);
                                FwConfigMgmt.updateConfigFetcherMap(dummyKey2);
                            }
                            DeviceConnection.this.cleanUp(cli, rID);
                            try {
                                if (FAServerUtil.shouldWaitTillPolicyParsing(currentThreadName)) {
                                    Object lock;
                                    Object object = lock = DynamicLocks.getLockFor(currentThreadName);
                                    synchronized (object) {
                                        lock.wait();
                                    }
                                    FAServerUtil.removeFromPolicyParsingThreadWaitList(currentThreadName);
                                }
                                LOGGER.log(Level.FINER, " Starting to update the status .... ");
                                Row dd = this.doo.getFirstRow("DeviceDetails");
                                int statusInt = error ? -1 : 1;
                                LOGGER.fine("Abt: to update the status frm FetcherTask with STATUS VALUE AS " + statusInt);
                                dd.set("STATUS", (Object)new Integer(statusInt));
                                if (errStr != null) {
                                    dd.set("ERRORSTRING", (Object)errStr);
                                }
                                if (fOut != null) {
                                    fOut.close();
                                }
                                this.doo.updateRow(dd);
                                DataAccess.update((DataObject)this.doo);
                            }
                            catch (Exception exp2) {
                                fOut = null;
                                exp2.printStackTrace();
                            }
                            throw throwable;
                        }
                        FwConfigMgmt.updateConfigFetcherMap(dummyKey);
                    }
                    DeviceConnection.this.cleanUp(cli, rID);
                    try {
                        if (FAServerUtil.shouldWaitTillPolicyParsing(currentThreadName)) {
                            Object lock;
                            Object statusInt = lock = DynamicLocks.getLockFor(currentThreadName);
                            synchronized (statusInt) {
                                lock.wait();
                            }
                            FAServerUtil.removeFromPolicyParsingThreadWaitList(currentThreadName);
                        }
                        LOGGER.log(Level.FINER, " Starting to update the status .... ");
                        Row dd = this.doo.getFirstRow("DeviceDetails");
                        int statusInt = error ? -1 : 1;
                        LOGGER.fine("Abt: to update the status frm FetcherTask with STATUS VALUE AS " + statusInt);
                        dd.set("STATUS", (Object)new Integer(statusInt));
                        if (errStr != null) {
                            dd.set("ERRORSTRING", (Object)errStr);
                        }
                        if (fOut != null) {
                            fOut.close();
                        }
                        this.doo.updateRow(dd);
                        DataAccess.update((DataObject)this.doo);
                    }
                    catch (Exception exp3) {
                        fOut = null;
                        exp3.printStackTrace();
                    }
                }
            }
        }
    }
}

