/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.fa.server.DynamicLocks;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.policyOptimization.Loader;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.fa.server.rules.PolicyProcessor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class PolicyParserManager {
    private static final Logger LOGGER = Logger.getLogger(PolicyParserManager.class.getName());
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(3);
    private static PolicyParserManager policyParserMgr;
    private static final long INIT_DELAY = 120L;

    public static PolicyParserManager getInstance() {
        if (policyParserMgr == null) {
            policyParserMgr = new PolicyParserManager();
        }
        return policyParserMgr;
    }

    private PolicyParserManager() {
    }

    public void createPolicyParserTask(String displayName, Long rID, String deviceType, String configData, Long versionNo, String currentThreadName) {
        LOGGER.info("@@PolicyParserManager::: inside creating new PolicyParserTask for the resource <-> " + displayName + " with RID <-> " + rID);
        PolicyParserTask ppt = new PolicyParserTask(displayName, rID, deviceType, configData, versionNo, currentThreadName);
        ScheduledFuture<?> sf = this.scheduler.schedule(ppt, 1L, TimeUnit.SECONDS);
    }

    class PolicyParserTask
    implements Runnable {
        private String deviceType;
        private String displayName;
        private String configData;
        private Long rID;
        private Long versionNo;
        private String currentThreadName;
        private FwConfigMgmt configMgmt = null;

        PolicyParserTask(String displayName, Long rID, String deviceType, String configData, Long versionNo, String currentThreadName) {
            this.displayName = displayName;
            this.rID = rID;
            this.deviceType = deviceType;
            this.configData = configData;
            this.configMgmt = FwConfigMgmt.getInstance();
            this.versionNo = versionNo;
            this.currentThreadName = currentThreadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PolicyProcessor pp = null;
            Loader load = null;
            try {
                LOGGER.info("@@PolicyParserTask:::: Here goes the Game(Firewall Policy Report) for firewall::" + this.displayName + " of " + this.deviceType + " vendor.....");
                if (FAServerUtil.isPolicyProcessing(this.rID) || FAServerUtil.isUserInputsProcessingNowForDevice(this.rID) || FAServerUtil.isComplianceGeneratingNowForDevice(this.rID) && !FAServerUtil.getFlagForPolicyProcess(this.rID)) {
                    LOGGER.info("PolicyParserTask::: Waiting to parse and process policies for the device " + this.displayName + " because of dependency events have already triggerred..");
                    try {
                        Object policyProcessLock;
                        Object object = policyProcessLock = DynamicLocks.getLockFor(this.rID + "_policyProcess");
                        synchronized (object) {
                            policyProcessLock.wait();
                        }
                    }
                    catch (Exception lockExp) {
                        throw new Exception("PolicyParserTask:::Exception while waiting on rid specific policy process lock...for firewall " + this.displayName, lockExp);
                    }
                    LOGGER.info("PolicyParserTask::: Policy Parsing Wait finished for the device " + this.displayName);
                }
                FAServerUtil.addToCurrentPolicyProcesses(this.rID);
                long start = System.currentTimeMillis();
                pp = this.configMgmt.deleteExistingAndProcessLatestConfig(this.rID, this.deviceType, this.displayName, this.configData, this.versionNo);
                pp.processResultsAndPopulateIntoDB(this.rID, this.deviceType, this.displayName);
                pp.cleanupMemory();
                FAServerUtil.removeFromCurrentPolicyProcesses(this.rID);
                long totalTimeTaken = System.currentTimeMillis() - start;
                LOGGER.info("@@PolicyParserTask:::: Haha Game(Firewall Policy Report) finished with in::::" + totalTimeTaken);
                this.releaseLocks(this.rID, this.displayName, "policyProcess,userInput,compliance,parseNow", this.currentThreadName);
                try {
                    LOGGER.info("@@@PolicyParserManager:::ANOMALY DETECTIONS STARTS!!!");
                    load = new Loader();
                    load.loadRules(this.rID, this.deviceType);
                    load = null;
                    LOGGER.info("@@@PolicyParserManager:::ANOMALY DETECTIONS ENDS!!!");
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            catch (Exception ee) {
                FAServerUtil.removeFromCurrentPolicyProcesses(this.rID);
                ee.printStackTrace();
                if (pp != null) {
                    pp.cleanupMemory();
                }
                this.releaseLocks(this.rID, this.displayName, "policyProcess,userInput,compliance,parseNow", this.currentThreadName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseLocks(Long resID, String displayName, String lockTypes, String currentThreadName) {
            String[] locks;
            LOGGER.info("PolicyParserTask:::Releasing " + lockTypes + " locks for the firewall ..." + displayName);
            for (String lockType : locks = lockTypes.split(",")) {
                try {
                    Object waitLock;
                    Object object = waitLock = DynamicLocks.getLockFor(resID + "_" + lockType);
                    synchronized (object) {
                        waitLock.notifyAll();
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("PolicyParserTask:::Exception while releasing " + lockType + " lock for the firewall ..." + displayName);
                    ee.printStackTrace();
                }
            }
            if (currentThreadName != null) {
                Object threadLock;
                LOGGER.info("PolicyParserTask:::Releasing " + currentThreadName + " lock");
                Object object = threadLock = DynamicLocks.getLockFor(currentThreadName);
                synchronized (object) {
                    threadLock.notifyAll();
                }
            }
        }
    }
}

