/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FWAEnumConstants;
import com.adventnet.fa.server.rules.ChecklistServiceObject;
import com.adventnet.fa.server.rules.FWAPolicyParserRulesLoader;
import com.adventnet.fa.server.rules.FirewallPolicyFormat;
import com.adventnet.fa.server.rules.FirewallPolicyParserRuleAttribute;
import com.adventnet.fa.server.rules.NetworkObject;
import com.adventnet.fa.server.rules.RuleObject;
import com.adventnet.la.util.IPRange;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PolicyProcessorUtilityClass {
    private static final Logger LOGGER = Logger.getLogger(PolicyProcessorUtilityClass.class.getName());
    private static PolicyProcessorUtilityClass policyProcessorUtilityObject = null;
    private HashMap<String, HashMap<String, String>> deviceTypeVsserviceToPortMap = new HashMap();
    private Vector<ChecklistServiceObject> checkListServices = new Vector();
    private ArrayList<Pattern> servicePatternList = new ArrayList();
    private HashMap<String, String> ipNumberToProtocolMap = new HashMap();
    public HashMap<String, String> prioritiesMap = new HashMap();
    private HashMap<String, String> icmpNameVsTypeMap = new HashMap();
    private static Map<Long, HashMap<String, String>> ridVsInterfaceVsZoneMap = Collections.synchronizedMap(new HashMap());
    private String privateIPRange = "10.0.0.0/255.0.0.0,172.16.0.0/255.240.0.0,192.168.0.0/255.255.0.0";
    private String localhostIPRange = "127.0.0.0/255.0.0.0,0.0.0.0/255.255.255.255,169.254.0.0/255.255.0.0";
    private Pattern bracketExtractPattern = Pattern.compile(".*\\(([^\\)]+)\\)");
    private Pattern objNamePattern = Pattern.compile("(\\S+)(?:\\((?:\\S+)\\))?");
    private Pattern objGroupNamePattern = Pattern.compile("(\\S+)\\(Group\\):.*(?:(?:\\S+)\\))?");
    private Pattern ipPattern = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)(?:\\/(\\d+\\.\\d+\\.\\d+\\.\\d+))?");
    private Pattern invalidIPPattern = Pattern.compile("(\\d+)\\.(.*)");
    private Pattern ipCheckPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private Pattern groupPortPattern = Pattern.compile("([^:]+):(?:(dstPort)=([^#]+))?(#)?(?:(srcPort)=([^#]+))?");
    private final String[] anyArray = new String[]{"any", "any4", "any6", "all"};
    public final List<String> anyList = Arrays.asList(this.anyArray);
    public Object firewallObjAutoGenKeyLock = new Object();
    public Object ruleDetailsAutoGenKeyLock = new Object();
    public Object ruleObjMappingAutoGenKeyLock = new Object();
    public Object objOneToNMappingAutoGenKeyLock = new Object();

    public PolicyProcessorUtilityClass() {
        this.loadStartupDetails();
    }

    public static synchronized PolicyProcessorUtilityClass getInstance() {
        if (policyProcessorUtilityObject == null) {
            policyProcessorUtilityObject = new PolicyProcessorUtilityClass();
        }
        return policyProcessorUtilityObject;
    }

    public void loadStartupDetails() {
        FWAPolicyParserRulesLoader.getInstance();
        this.ipNumberToProtocolMap.put("17", "UDP");
        this.ipNumberToProtocolMap.put("6", "TCP");
        this.ipNumberToProtocolMap.put("1", "ICMP");
        this.populateCheckListServiceDetails();
        this.initServiceListPatterns();
        this.loadPriorities();
        this.loadPreDefinedServices();
    }

    private void loadPreDefinedServices() {
        this.icmpNameVsTypeMap.put("ECHO-REPLY", "0");
        this.icmpNameVsTypeMap.put("ALTERNATE-ADDRESS", "6");
        this.icmpNameVsTypeMap.put("CONVERSION-ERROR", "31");
        this.icmpNameVsTypeMap.put("ECHO", "8");
        this.icmpNameVsTypeMap.put("inactive", "0");
        this.icmpNameVsTypeMap.put("INFORMATION-REPLY", "16");
        this.icmpNameVsTypeMap.put("INFORMATION-REQUEST", "15");
        this.icmpNameVsTypeMap.put("LOG", "0");
        this.icmpNameVsTypeMap.put("MASK-REPLY", "18");
        this.icmpNameVsTypeMap.put("MASK-REQUEST", "17");
        this.icmpNameVsTypeMap.put("MOBILE-REDIRECT", "32");
        this.icmpNameVsTypeMap.put("OBJECT-GROUP", "0");
        this.icmpNameVsTypeMap.put("PARAMETER-PROBLEM", "12");
        this.icmpNameVsTypeMap.put("REDIRECT", "5");
        this.icmpNameVsTypeMap.put("ROUTER-ADVERTISEMENT", "9");
        this.icmpNameVsTypeMap.put("ROUTER-SOLICITATION", "10");
        this.icmpNameVsTypeMap.put("SOURCE-QUENCH", "4");
        this.icmpNameVsTypeMap.put("TIME-EXCEEDED", "11");
        this.icmpNameVsTypeMap.put("TIME-RANGE", "0");
        this.icmpNameVsTypeMap.put("TIMESTAMP-REPLY", "14");
        this.icmpNameVsTypeMap.put("TIMESTAMP-REQUEST", "13");
        this.icmpNameVsTypeMap.put("TRACEROUTE", "30");
        this.icmpNameVsTypeMap.put("UNREACHABLE", "3");
        HashMap<String, String> ciscoServiceToPortMap = new HashMap<String, String>();
        ciscoServiceToPortMap.put("AOL", "TCP dstPort=5190");
        ciscoServiceToPortMap.put("BGP", "TCP dstPort=179");
        ciscoServiceToPortMap.put("BIFF", "UDP dstPort=512");
        ciscoServiceToPortMap.put("BOOTPC", "UDP dstPort=68");
        ciscoServiceToPortMap.put("BOOTPS", "UDP dstPort=67");
        ciscoServiceToPortMap.put("CHARGEN", "TCP dstPort=19");
        ciscoServiceToPortMap.put("CITRIX-ICA", "TCP dstPort=1494");
        ciscoServiceToPortMap.put("CMD", "TCP dstPort=514");
        ciscoServiceToPortMap.put("CTIQBE", "TCP dstPort=2748");
        ciscoServiceToPortMap.put("DAYTIME", "TCP dstPort=13");
        ciscoServiceToPortMap.put("DHCP", "UDP dstPort=67 and dstPort=68");
        ciscoServiceToPortMap.put("DISCARD", "TCP dstPort=9 |_| UDP dstPort=9");
        ciscoServiceToPortMap.put("DNSIX", "UDP dstPort=195");
        ciscoServiceToPortMap.put("DOMAIN", "TCP dstPort=53 |_| UDP dstPort=53");
        ciscoServiceToPortMap.put("ECHO", "TCP dstPort=7 |_| UDP dstPort=7");
        ciscoServiceToPortMap.put("EXEC", "TCP dstPort=512");
        ciscoServiceToPortMap.put("FINGER", "TCP dstPort=79");
        ciscoServiceToPortMap.put("FTP", "TCP dstPort=21");
        ciscoServiceToPortMap.put("FTP-DATA", "TCP dstPort=20");
        ciscoServiceToPortMap.put("GOPHER", "TCP dstPort=70");
        ciscoServiceToPortMap.put("H323", "TCP dstPort=1720");
        ciscoServiceToPortMap.put("HOSTNAME", "TCP dstPort=101");
        ciscoServiceToPortMap.put("HTTP", "TCP dstPort=80");
        ciscoServiceToPortMap.put("HTTPS", "TCP dstPort=443");
        ciscoServiceToPortMap.put("IDENT", "TCP dstPort=113");
        ciscoServiceToPortMap.put("IMAP4", "TCP dstPort=143");
        ciscoServiceToPortMap.put("IPSEC OVER UDP(CISCO VPN 3000 SERIES COMPATIBLE)", "UDP dstPort=10000");
        ciscoServiceToPortMap.put("IPSEC OVER UDP(NAT-T)", "UDP dstPort=4500");
        ciscoServiceToPortMap.put("IRC", "TCP dstPort=194");
        ciscoServiceToPortMap.put("ISAKMP", "UDP dstPort=500");
        ciscoServiceToPortMap.put("ISAKMP/IKE", "UDP dstPort=500");
        ciscoServiceToPortMap.put("KERBEROS", "TCP dstPort=750 |_| UDP dstPort=750");
        ciscoServiceToPortMap.put("KLOGIN", "TCP dstPort=543");
        ciscoServiceToPortMap.put("KSHELL", "TCP dstPort=544");
        ciscoServiceToPortMap.put("LDAP", "TCP dstPort=389");
        ciscoServiceToPortMap.put("LDAPS", "TCP dstPort=636");
        ciscoServiceToPortMap.put("LOGIN", "TCP dstPort=513");
        ciscoServiceToPortMap.put("LOTUSNOTES", "TCP dstPort=1352");
        ciscoServiceToPortMap.put("LPD", "TCP dstPort=515");
        ciscoServiceToPortMap.put("MOBILE-IP", "UDP dstPort=434");
        ciscoServiceToPortMap.put("NAMESERVER", "UDP dstPort=42");
        ciscoServiceToPortMap.put("NETBIOS-DGM", "UDP dstPort=138");
        ciscoServiceToPortMap.put("NETBIOS-NS", "UDP dstPort=137");
        ciscoServiceToPortMap.put("NETBIOS-SSN", "TCP dstPort=139");
        ciscoServiceToPortMap.put("NNTP", "TCP dstPort=119");
        ciscoServiceToPortMap.put("NTP", "UDP dstPort=123");
        ciscoServiceToPortMap.put("PCANYWHERE-DATA", "TCP dstPort=5631");
        ciscoServiceToPortMap.put("PCANYWHERE-STATUS", "UDP dstPort=5632");
        ciscoServiceToPortMap.put("PIM-AUTO-RP", "TCP dstPort=496 |_| UDP dstPort=496");
        ciscoServiceToPortMap.put("POP2", "TCP dstPort=109");
        ciscoServiceToPortMap.put("POP3", "TCP dstPort=110");
        ciscoServiceToPortMap.put("PPTP", "TCP dstPort=1723");
        ciscoServiceToPortMap.put("RADIUS", "UDP dstPort=1645");
        ciscoServiceToPortMap.put("RADIUS-ACCT", "UDP dstPort=1646");
        ciscoServiceToPortMap.put("RIP", "UDP dstPort=520");
        ciscoServiceToPortMap.put("RIPV2", "UDP dstPort=520");
        ciscoServiceToPortMap.put("RSH", "TCP dstPort=514");
        ciscoServiceToPortMap.put("SECUREID-UDP", "UDP dstPort=5510");
        ciscoServiceToPortMap.put("SIP", "TCP dstPort=5060 |_| UDP dstPort=5060");
        ciscoServiceToPortMap.put("SMTP", "TCP dstPort=25");
        ciscoServiceToPortMap.put("SNMP", "UDP dstPort=161");
        ciscoServiceToPortMap.put("SNMPTRAP", "UDP dstPort=162");
        ciscoServiceToPortMap.put("SQLNET", "TCP dstPort=1521");
        ciscoServiceToPortMap.put("SSH", "TCP dstPort=22");
        ciscoServiceToPortMap.put("SUNRPC", "TCP dstPort=111 |_| UDP dstPort=111");
        ciscoServiceToPortMap.put("SYSLOG", "UDP dstPort=514");
        ciscoServiceToPortMap.put("TACACS", "TCP dstPort=49 |_| UDP dstPort=49");
        ciscoServiceToPortMap.put("TALK", "TCP dstPort=517 |_| UDP dstPort=517");
        ciscoServiceToPortMap.put("TELNET", "TCP dstPort=23");
        ciscoServiceToPortMap.put("TFTP", "UDP dstPort=69");
        ciscoServiceToPortMap.put("TIME", "UDP dstPort=37");
        ciscoServiceToPortMap.put("UUCP", "TCP dstPort=540");
        ciscoServiceToPortMap.put("VPN INDIVIDUAL USER AUTHENTICATION PROXY", "UDP dstPort=1645 and dstPort=1646");
        ciscoServiceToPortMap.put("VPN LOAD BALANCING", "UDP dstPort=9023");
        ciscoServiceToPortMap.put("WHO", "UDP dstPort=513");
        ciscoServiceToPortMap.put("WHOIS", "TCP dstPort=43");
        ciscoServiceToPortMap.put("WWW", "TCP dstPort=80 |_| UDP dstPort=80");
        ciscoServiceToPortMap.put("XDMCP", "UDP dstPort=177");
        this.deviceTypeVsserviceToPortMap.put("Cisco", ciscoServiceToPortMap);
        HashMap<String, String> fortigateServiceToPortMap = new HashMap<String, String>();
        fortigateServiceToPortMap.put("AFS3", "TCP dstPort=7000 to 7009 |_| UDP dstPort=7000 to 7009");
        fortigateServiceToPortMap.put("AH", "IP dstPort=51");
        fortigateServiceToPortMap.put("ANY", "ALL");
        fortigateServiceToPortMap.put("AOL", "TCP dstPort=5190 to 5194");
        fortigateServiceToPortMap.put("BGP", "TCP dstPort=179");
        fortigateServiceToPortMap.put("CVSPSERVER", "TCP dstPort=2401 |_| UDP dstPort=2401");
        fortigateServiceToPortMap.put("DCE-RPC", "TCP dstPort=135 |_| UDP dstPort=135");
        fortigateServiceToPortMap.put("DHCP", "UDP dstPort=67 to 68");
        fortigateServiceToPortMap.put("DHCP6", "UDP dstPort=546 and dstPort=547");
        fortigateServiceToPortMap.put("DNS", "TCP dstPort=53 |_| UDP dstPort=53");
        fortigateServiceToPortMap.put("ESP", "IP dstPort=50");
        fortigateServiceToPortMap.put("FINGER", "TCP dstPort=79");
        fortigateServiceToPortMap.put("FTP", "TCP dstPort=21");
        fortigateServiceToPortMap.put("FTP_GET", "TCP dstPort=21");
        fortigateServiceToPortMap.put("FTP_PUT", "TCP dstPort=21");
        fortigateServiceToPortMap.put("GOPHER", "TCP dstPort=70");
        fortigateServiceToPortMap.put("GRE", "IP dstPort=47");
        fortigateServiceToPortMap.put("H323", "TCP dstPort=1720 and dstPort=1503 |_| UDP dstPort=1719");
        fortigateServiceToPortMap.put("HTTP", "TCP dstPort=80");
        fortigateServiceToPortMap.put("HTTPS", "TCP dstPort=443");
        fortigateServiceToPortMap.put("ICMP_ANY", "ICMP dstPort=ANY");
        fortigateServiceToPortMap.put("IKE", "UDP dstPort=500 and dstPort=4500");
        fortigateServiceToPortMap.put("IMAP", "TCP dstPort=143");
        fortigateServiceToPortMap.put("INFO_ADDRESS", "ICMP dstPort=17");
        fortigateServiceToPortMap.put("INFO_REQUEST", "ICMP dstPort=15");
        fortigateServiceToPortMap.put("INTERNET-LOCATOR-SERVICE", "TCP dstPort=389");
        fortigateServiceToPortMap.put("IRC", "TCP dstPort=6660 to 6669");
        fortigateServiceToPortMap.put("L2TP", "TCP dstPort=1701 |_| UDP dstPort=1701");
        fortigateServiceToPortMap.put("LDAP", "TCP dstPort=389");
        fortigateServiceToPortMap.put("MGCP", "UDP dstPort=2427 and dstPort=2727");
        fortigateServiceToPortMap.put("MS-SQL", "TCP dstPort=1433 and dstPort=1434");
        fortigateServiceToPortMap.put("MYSQL", "TCP dstPort=3306");
        fortigateServiceToPortMap.put("NETMEETING", "TCP dstPort=1720");
        fortigateServiceToPortMap.put("NFS", "TCP dstPort=111 and dstPort=2049 |_| UDP dstPort=111 and dstPort=2049");
        fortigateServiceToPortMap.put("NNTP", "TCP dstPort=119");
        fortigateServiceToPortMap.put("NTP", "TCP dstPort=123 |_| UDP dstPort=123");
        fortigateServiceToPortMap.put("ONC-RPC", "TCP dstPort=111 |_| UDP dstPort=111");
        fortigateServiceToPortMap.put("OSPF", "IP dstPort=89");
        fortigateServiceToPortMap.put("PC-ANYWHERE", "TCP dstPort=5631 |_| UDP dstPort=5632");
        fortigateServiceToPortMap.put("PING", "ICMP dstPort=8");
        fortigateServiceToPortMap.put("POP3", "TCP dstPort=110");
        fortigateServiceToPortMap.put("PPTP", "IP dstPort=47 |_| TCP dstPort=1723");
        fortigateServiceToPortMap.put("QUAKE", "UDP dstPort=26000 and dstPort=27000 and dstPort=27910 and dstPort=27960");
        fortigateServiceToPortMap.put("RADIUS", "UDP dstPort=1812 and dstPort=1813");
        fortigateServiceToPortMap.put("RAUDIO", "UDP dstPort=7070");
        fortigateServiceToPortMap.put("RDP", "TCP dstPort=3389");
        fortigateServiceToPortMap.put("REXEC", "TCP dstPort=512");
        fortigateServiceToPortMap.put("RIP", "UDP dstPort=520");
        fortigateServiceToPortMap.put("RLOGIN", "TCP dstPort=513");
        fortigateServiceToPortMap.put("RSH", "TCP dstPort=514");
        fortigateServiceToPortMap.put("RTSP", "TCP dstPort=554 and dstPort=7070 and dstPort=8554 |_| UDP dstPort=554");
        fortigateServiceToPortMap.put("SAMBA", "TCP dstPort=139");
        fortigateServiceToPortMap.put("SCCP", "TCP dstPort=2000");
        fortigateServiceToPortMap.put("SIP", "UDP dstPort=5060");
        fortigateServiceToPortMap.put("SIP-MSNMESSENGER", "TCP dstPort=1863");
        fortigateServiceToPortMap.put("SMTP", "TCP dstPort=25");
        fortigateServiceToPortMap.put("SNMP", "TCP dstPort=161 to 162 |_| UDP dstPort=161 to 162");
        fortigateServiceToPortMap.put("SOCKS", "TCP dstPort=1080 |_| UDP dstPort=1080");
        fortigateServiceToPortMap.put("SQUID", "TCP dstPort=3128");
        fortigateServiceToPortMap.put("SSH", "TCP dstPort=22");
        fortigateServiceToPortMap.put("SYSLOG", "UDP dstPort=514");
        fortigateServiceToPortMap.put("TALK", "UDP dstPort=517 to 518");
        fortigateServiceToPortMap.put("TCP", "TCP dstPort=0 to 65535");
        fortigateServiceToPortMap.put("TELNET", "TCP dstPort=23");
        fortigateServiceToPortMap.put("TFTP", "UDP dstPort=69");
        fortigateServiceToPortMap.put("TIMESTAMP", "ICMP dstPort=13");
        fortigateServiceToPortMap.put("TRACEROUTE", "TCP dstPort=33434 |_| UDP dstPort=33434");
        fortigateServiceToPortMap.put("UDP", "UDP dstPort=0 to 65535");
        fortigateServiceToPortMap.put("UUCP", "TCP dstPort=540");
        fortigateServiceToPortMap.put("VDOLIVE", "TCP dstPort=7000 to 7010");
        fortigateServiceToPortMap.put("VNC", "TCP dstPort=5900");
        fortigateServiceToPortMap.put("WAIS", "TCP dstPort=210");
        fortigateServiceToPortMap.put("WINFRAME", "TCP dstPort=1494");
        fortigateServiceToPortMap.put("WINS", "TCP dstPort=1512 |_| UDP dstPort=1512");
        fortigateServiceToPortMap.put("X-WINDOWS", "TCP dstPort=6000 to 6063");
        fortigateServiceToPortMap.put("IMAPS", "TCP dstPort=993");
        fortigateServiceToPortMap.put("POP3S", "TCP dstPort=995");
        fortigateServiceToPortMap.put("SMTPS", "TCP dstPort=465");
        this.deviceTypeVsserviceToPortMap.put("FortiGate", fortigateServiceToPortMap);
        HashMap<String, String> srxServiceToPortMap = new HashMap<String, String>();
        srxServiceToPortMap.put("JUNOS-FTP", "TCP dstPort=21");
        srxServiceToPortMap.put("JUNOS-TFTP", "UDP dstPort=69");
        srxServiceToPortMap.put("JUNOS-RTSP", "TCP dstPort=554");
        srxServiceToPortMap.put("JUNOS-NETBIOS-SESSION", "TCP dstPort=139");
        srxServiceToPortMap.put("JUNOS-SMB-SESSION", "TCP dstPort=445");
        srxServiceToPortMap.put("JUNOS-SSH", "TCP dstPort=22");
        srxServiceToPortMap.put("JUNOS-TELNET", "TCP dstPort=23");
        srxServiceToPortMap.put("JUNOS-SMTP", "TCP dstPort=25");
        srxServiceToPortMap.put("JUNOS-SMTP", "TCP dstPort=25");
        srxServiceToPortMap.put("JUNOS-TACACS", "TCP dstPort=49");
        srxServiceToPortMap.put("JUNOS-TACACS-DS", "TCP dstPort=65");
        srxServiceToPortMap.put("JUNOS-DHCP-CLIENT", "UDP dstPort=68");
        srxServiceToPortMap.put("JUNOS-DHCP-SERVER", "UDP dstPort=67");
        srxServiceToPortMap.put("JUNOS-BOOTPC", "UDP dstPort=68");
        srxServiceToPortMap.put("JUNOS-BOOTPS", "UDP dstPort=67");
        srxServiceToPortMap.put("JUNOS-FINGER", "TCP dstPort=79");
        srxServiceToPortMap.put("JUNOS-HTTP", "TCP dstPort=80");
        srxServiceToPortMap.put("JUNOS-HTTPS", "TCP dstPort=443");
        srxServiceToPortMap.put("JUNOS-POP3", "TCP dstPort=110");
        srxServiceToPortMap.put("JUNOS-IDENT", "TCP dstPort=113");
        srxServiceToPortMap.put("JUNOS-NNTP", "TCP dstPort=119");
        srxServiceToPortMap.put("JUNOS-NTP", "UDP dstPort=123");
        srxServiceToPortMap.put("JUNOS-IMAP", "TCP dstPort=143");
        srxServiceToPortMap.put("JUNOS-IMAPS", "TCP dstPort=993");
        srxServiceToPortMap.put("JUNOS-BGP", "TCP dstPort=179");
        srxServiceToPortMap.put("JUNOS-LDAP", "TCP dstPort=389");
        srxServiceToPortMap.put("JUNOS-SNPP", "TCP dstPort=444");
        srxServiceToPortMap.put("JUNOS-BIFF", "UDP dstPort=512");
        srxServiceToPortMap.put("JUNOS-WHO", "UDP dstPort=513");
        srxServiceToPortMap.put("JUNOS-SYSLOG", "UDP dstPort=514");
        srxServiceToPortMap.put("JUNOS-PRINTER", "TCP dstPort=515");
        srxServiceToPortMap.put("JUNOS-RIP", "UDP dstPort=520");
        srxServiceToPortMap.put("JUNOS-RADIUS", "UDP dstPort=1812");
        srxServiceToPortMap.put("JUNOS-RADACCT", "UDP dstPort=1813");
        srxServiceToPortMap.put("JUNOS-NFSD-TCP", "TCP dstPort=2049");
        srxServiceToPortMap.put("JUNOS-NFSD-UDP", "UDP dstPort=2049");
        srxServiceToPortMap.put("JUNOS-CVSPSERVER", "TCP dstPort=2401");
        srxServiceToPortMap.put("JUNOS-LDP-TCP", "TCP dstPort=646");
        srxServiceToPortMap.put("JUNOS-LDP-UDP", "UDP dstPort=646");
        srxServiceToPortMap.put("JUNOS-XNM-SSL", "TCP dstPort=3220");
        srxServiceToPortMap.put("JUNOS-XNM-CLEAR-TEXT", "TCP dstPort=3221");
        srxServiceToPortMap.put("JUNOS-IKE", "UDP dstPort=500");
        srxServiceToPortMap.put("JUNOS-CHARGEN", "UDP dstPort=19");
        srxServiceToPortMap.put("JUNOS-DHCP-RELAY", "UDP dstPort=67");
        srxServiceToPortMap.put("JUNOS-DISCARD", "UDP dstPort=9");
        srxServiceToPortMap.put("JUNOS-DNS-UDP", "UDP dstPort=53");
        srxServiceToPortMap.put("JUNOS-DNS-TCP", "TCP dstPort=53");
        srxServiceToPortMap.put("JUNOS-ECHO", "UDP dstPort=7");
        srxServiceToPortMap.put("JUNOS-GOPHER", "TCP dstPort=70");
        srxServiceToPortMap.put("JUNOS-GNUTELLA", "UDP dstPort=6346 to 6347");
        srxServiceToPortMap.put("JUNOS-GRE", "IP dstPort=47");
        srxServiceToPortMap.put("JUNOS-HTTP-EXT", "TCP dstPort=7001");
        srxServiceToPortMap.put("JUNOS-ICMP-ALL", "ICMP dstPort=ANY");
        srxServiceToPortMap.put("JUNOS-ICMP-PING", "ICMP dstPort=520");
        srxServiceToPortMap.put("JUNOS-INTERNET-LOCATOR-SERVICE", "TCP dstPort=389");
        srxServiceToPortMap.put("JUNOS-IKE-NAT", "UDP dstPort=4500");
        srxServiceToPortMap.put("JUNOS-IRC", "TCP dstPort=6660 to 6669");
        srxServiceToPortMap.put("JUNOS-L2TP", "UDP dstPort=1701");
        srxServiceToPortMap.put("JUNOS-LPR", "TCP dstPort=515");
        srxServiceToPortMap.put("JUNOS-MAIL", "TCP dstPort=25");
        srxServiceToPortMap.put("JUNOS-H323", "TCP dstPort=1720 and dstPort=1503 and dstPort=389 and dstPort=522 and dstPort=1731 |_| UDP dstPort=1719");
        srxServiceToPortMap.put("JUNOS-MGCP-UA", "UDP dstPort=2427");
        srxServiceToPortMap.put("JUNOS-MGCP-CA", "UDP dstPort=2727");
        srxServiceToPortMap.put("JUNOS-MSN", "UDP dstPort=1863");
        srxServiceToPortMap.put("JUNOS-MS-SQL", "TCP dstPort=1433");
        srxServiceToPortMap.put("JUNOS-NBNAME", "UDP dstPort=137");
        srxServiceToPortMap.put("JUNOS-NBDS", "UDP dstPort=138");
        srxServiceToPortMap.put("JUNOS-NFS", "UDP dstPort=111");
        srxServiceToPortMap.put("JUNOS-NS-GLOBAL", "TCP dstPort=15397");
        srxServiceToPortMap.put("JUNOS-NS-GLOBAL-PRO", "TCP dstPort=15397");
        srxServiceToPortMap.put("JUNOS-NSM", "UDP dstPort=69");
        srxServiceToPortMap.put("JUNOS-OSPF", "89 dstPort=ANY");
        srxServiceToPortMap.put("JUNOS-PC-ANYWHERE", "UDP dstPort=5632");
        srxServiceToPortMap.put("JUNOS-PPTP", "TCP dstPort=1723");
        srxServiceToPortMap.put("JUNOS-SIP", "TCP dstPort=5060 |_| UDP dstPort=5060");
        srxServiceToPortMap.put("JUNOS-RSH", "TCP dstPort=514");
        srxServiceToPortMap.put("JUNOS-SMB", "TCP dstPort=139 and dstPort=445");
        srxServiceToPortMap.put("JUNOS-SQL-MONITOR", "UDP dstPort=1434");
        srxServiceToPortMap.put("JUNOS-TALK", "TCP dstPort=517 |_| UDP dstPort=517");
        srxServiceToPortMap.put("JUNOS-NTALK", "TCP dstPort=518 |_| UDP dstPort=518");
        srxServiceToPortMap.put("JUNOS-TCP-ANY", "TCP dstPort=ANY");
        srxServiceToPortMap.put("JUNOS-UDP-ANY", "UDP dstPort=ANY");
        srxServiceToPortMap.put("JUNOS-UUCP", "UDP dstPort=540");
        srxServiceToPortMap.put("JUNOS-VDO-LIVE", "UDP dstPort=7000 to 7010");
        srxServiceToPortMap.put("JUNOS-VNC", "TCP dstPort=5800");
        srxServiceToPortMap.put("JUNOS-WAIS", "TCP dstPort=210");
        srxServiceToPortMap.put("JUNOS-WHOIS", "TCP dstPort=43");
        srxServiceToPortMap.put("JUNOS-WINFRAME", "TCP dstPort=1494");
        srxServiceToPortMap.put("JUNOS-X-WINDOWS", "TCP dstPort=6000 to 6063");
        srxServiceToPortMap.put("JUNOS-YMSG", "TCP dstPort=5000 to 5010 and dstPort=5050 |_| UDP dstPort=5000 to 5010 and dstPort=5050");
        srxServiceToPortMap.put("JUNOS-WXCONTROL", "TCP dstPort=3578");
        srxServiceToPortMap.put("JUNOS-SNMP-AGENTX", "TCP dstPort=705");
        srxServiceToPortMap.put("JUNOS-STUN", "TCP dstPort=3478 to 3479 |_| UDP dstPort=3478 to 3479");
        srxServiceToPortMap.put("JUNOS-R2CP", "UDP dstPort=28672");
        srxServiceToPortMap.put("JUNOS-SCCP", "TCP dstPort=2000");
        srxServiceToPortMap.put("JUNOS-SUN-RPC-TCP", "TCP dstPort=111");
        srxServiceToPortMap.put("JUNOS-SUN-RPC-UDP", "UDP dstPort=111");
        srxServiceToPortMap.put("JUNOS-SUN-RPC-PORTMAP-TCP", "TCP dstPort=100000");
        srxServiceToPortMap.put("JUNOS-SUN-RPC-PORTMAP-UDP", "UDP dstPort=100000");
        srxServiceToPortMap.put("JUNOS-SQLNET-V1", "TCP dstPort=1525");
        srxServiceToPortMap.put("JUNOS-SQLNET-V2", "TCP dstPort=1521");
        srxServiceToPortMap.put("JUNOS-PING", "ICMP dstPort=ANY");
        this.deviceTypeVsserviceToPortMap.put("SRX Log Format", srxServiceToPortMap);
    }

    public String getICMPType(String icmpName) {
        return this.icmpNameVsTypeMap.get(icmpName);
    }

    public HashMap<String, String> getServiceToPortMap(String deviceType) {
        return this.deviceTypeVsserviceToPortMap.get(deviceType);
    }

    public HashMap<String, String> getIpNumberToProtocolMap() {
        return this.ipNumberToProtocolMap;
    }

    public Vector<ChecklistServiceObject> getCheckListServices() {
        return this.checkListServices;
    }

    public ArrayList<Pattern> getServiceListPatterns() {
        return this.servicePatternList;
    }

    private void initServiceListPatterns() {
        this.servicePatternList.add(Pattern.compile("(?:TCP|UDP|Any):(dstPort)(=|!=|<|>)([^\\#]+)"));
        this.servicePatternList.add(Pattern.compile("(TCP|UDP|Any|\\S+)(\\s+)(\\S+).*"));
    }

    private void populateCheckListServiceDetails() {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("FWAConfigCheckListDetails"));
            sql.addSelectColumn(new Column("FWAConfigCheckListDetails", "*"));
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Row cRow = null;
            if (!doo.isEmpty()) {
                String serName = null;
                String stdPorts = null;
                String stdProto = null;
                String custPorts = null;
                String custProto = null;
                ChecklistServiceObject cklService = null;
                Iterator iter = doo.getRows("FWAConfigCheckListDetails");
                while (iter.hasNext()) {
                    cRow = (Row)iter.next();
                    serName = (String)cRow.get("SERVICENAME");
                    stdPorts = (String)cRow.get("STD_PORTS");
                    stdProto = (String)cRow.get("STD_PROTOCOLS");
                    custPorts = (String)cRow.get("CUST_PORTS");
                    custProto = (String)cRow.get("CUST_PROTOCOLS");
                    cklService = new ChecklistServiceObject(serName);
                    cklService.setStdPorts(stdPorts);
                    cklService.setStdProtocols(stdProto);
                    cklService.setCustPorts(custPorts);
                    cklService.setCustProtocols(custProto);
                    this.checkListServices.add(cklService);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<long[]> getIPLongDetails(String ipZoneDetails) {
        ArrayList<long[]> list = new ArrayList<long[]>();
        if (ipZoneDetails != null && !"".equals(ipZoneDetails)) {
            String[] ipZones;
            for (String val : ipZones = ipZoneDetails.split(",")) {
                long[] array;
                String[] vals;
                if (val.indexOf("-") > -1) {
                    vals = val.split("-");
                    String start = vals[0];
                    String end = vals[1];
                    long[] array2 = new long[]{IPRange.getAddrLong((String)start), IPRange.getAddrLong((String)end)};
                    list.add(array2);
                    continue;
                }
                if (val.indexOf("/") > -1) {
                    vals = val.split("/");
                    String net = vals[0];
                    String mask = vals[1];
                    String network = IPRange.getNetwork((String)mask, (String)net);
                    long[] array3 = IPRange.getMinMaxLong((String)network, (String)mask);
                    list.add(array3);
                    continue;
                }
                array = new long[]{IPRange.getAddrLong((String)val), array[0]};
                list.add(array);
            }
        }
        return list;
    }

    public ArrayList<String> getIPLongList(String ipZoneDetails) {
        ArrayList<String> networkIPList = new ArrayList<String>();
        if (ipZoneDetails != null && !"".equals(ipZoneDetails)) {
            String[] ipZones = ipZoneDetails.split(",");
            String[] vals = null;
            long start = -1L;
            long end = -1L;
            for (String val : ipZones) {
                if (val.indexOf("-") > -1) {
                    vals = val.split("-");
                    start = IPRange.getAddrLong((String)vals[0]);
                    end = IPRange.getAddrLong((String)vals[1]);
                    networkIPList.add(start + "-" + end);
                    continue;
                }
                if (val.indexOf("/") > -1) {
                    vals = val.split("/");
                    String net = vals[0];
                    String mask = vals[1];
                    String network = IPRange.getNetwork((String)mask, (String)net);
                    long[] array = IPRange.getMinMaxLong((String)network, (String)mask);
                    networkIPList.add(array[0] + "-" + array[1]);
                    continue;
                }
                end = start = IPRange.getAddrLong((String)val);
                networkIPList.add(start + "-" + end);
            }
        }
        return networkIPList;
    }

    public ArrayList<String> getBroadCastIPDetails(String ipZoneDetails) {
        ArrayList<String> list = new ArrayList<String>();
        if (ipZoneDetails != null && !"".equals(ipZoneDetails)) {
            String[] ipZones;
            for (String val : ipZones = ipZoneDetails.split(",")) {
                if (val.indexOf("/") <= -1) continue;
                String[] vals = val.split("/");
                String net = vals[0];
                String mask = vals[1];
                long ipLong = IPRange.getAddrLong((String)net);
                long lNetmask = IPRange.getAddrLong((String)mask);
                long bitComplement = lNetmask ^ 0xFFFFFFFFFFFFFFFFL;
                long broadcastIPLong = ipLong | bitComplement;
                list.add(IPRange.convertAddr((long)broadcastIPLong));
            }
        }
        return list;
    }

    public FirewallPolicyFormat getVendorSpecificPolicyFormat(String deviceType) {
        String vendorType = null;
        Vector<FirewallPolicyFormat> allVendoPolicyFormats = FirewallPolicyFormat.getFWAPolicyParserRules();
        for (FirewallPolicyFormat fpf : allVendoPolicyFormats) {
            vendorType = fpf.getDeviceType();
            if (!vendorType.equals(deviceType)) continue;
            return fpf;
        }
        return null;
    }

    public boolean matchPattern(String data, String expression) throws Exception {
        Pattern p = Pattern.compile(expression);
        Matcher m = p.matcher(data);
        if (m.find()) {
            return true;
        }
        LOGGER.log(Level.FINER, " FAILED Expression :: {0}", expression);
        return false;
    }

    public boolean matchPattern(String data, String expression, Pattern pattern) throws Exception {
        block3: {
            try {
                Matcher matcher = pattern.matcher(data);
                if (matcher.find()) {
                    return true;
                }
                LOGGER.log(Level.FINER, " FAILED Expression :: {0}", expression);
            }
            catch (Exception ee) {
                LOGGER.log(Level.INFO, " Recompiling the Pattern :: {0}", expression);
                Pattern p = Pattern.compile(expression);
                Matcher m = p.matcher(data);
                if (!m.find()) break block3;
                return true;
            }
        }
        return false;
    }

    public boolean executeParserRule(String data, String expression, ArrayList<FirewallPolicyParserRuleAttribute> groups, Pattern p, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        Matcher m;
        boolean found;
        resultMap.clear();
        if (p == null) {
            p = Pattern.compile(expression);
            LOGGER.log(Level.FINER, "PolicyProcessorUtilityClass: Inside executeParserRule() Compiling ParserRule ");
        }
        if (found = (m = p.matcher(data)).find()) {
            for (FirewallPolicyParserRuleAttribute attr : groups) {
                FWAEnumConstants.ParserKeys groupName = attr.getGroupName();
                String result = m.group(attr.getGroupNumber());
                if (result == null) continue;
                try {
                    resultMap.put(groupName, result);
                }
                catch (Exception exp) {
                    LOGGER.log(Level.INFO, "Exception: executeParserRule  groupName is --> {0} Result is --> {1}", new Object[]{groupName, result});
                    exp.printStackTrace();
                }
            }
        } else {
            LOGGER.log(Level.FINER, " ########################### FAILED Expression :: " + expression + " for the data:::" + data);
        }
        return found;
    }

    public boolean isDigit(String value) {
        return value.matches("\\d+");
    }

    public String getIPProtocol(String ipNumber) {
        return this.ipNumberToProtocolMap.containsKey(ipNumber) ? this.ipNumberToProtocolMap.get(ipNumber) : ipNumber;
    }

    public boolean isIPInRange(String ipID, ArrayList<long[]> ipLongDetails) throws Exception {
        try {
            if (ipID != null && !"".equals(ipID) && !"null".equals(ipID)) {
                String[] ipIDRange = ipID.split("-");
                long lowerIP = Long.parseLong(ipIDRange[0]);
                long higherIP = Long.parseLong(ipIDRange[1]);
                if (ipLongDetails != null) {
                    for (long[] array : ipLongDetails) {
                        if (array[0] >= lowerIP && array[0] <= higherIP) {
                            return true;
                        }
                        if (array[1] >= lowerIP && array[1] <= higherIP) {
                            return true;
                        }
                        if (lowerIP >= array[0] && lowerIP <= array[1]) {
                            return true;
                        }
                        if (higherIP < array[0] || higherIP > array[1]) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        catch (Exception ee) {
            throw new Exception("Exception while checking the IP in given range...", ee);
        }
    }

    public boolean isIPIDStringInRange(String ip, ArrayList<String> ipIDStringDetails) {
        try {
            if (ip != null && !"".equals(ip) && !"null".equals(ip) && ipIDStringDetails != null) {
                String[] ipIDRange = ip.split("-");
                long lowerIP = Long.parseLong(ipIDRange[0]);
                long higherIP = Long.parseLong(ipIDRange[1]);
                for (String ipID : ipIDStringDetails) {
                    String[] ipIDArr = ipID.split("-");
                    long[] array = new long[]{Long.parseLong(ipIDArr[0]), Long.parseLong(ipIDArr[1])};
                    if (array[0] >= lowerIP && array[0] <= higherIP) {
                        return true;
                    }
                    if (array[1] >= lowerIP && array[1] <= higherIP) {
                        return true;
                    }
                    if (lowerIP >= array[0] && lowerIP <= array[1]) {
                        return true;
                    }
                    if (higherIP < array[0] || higherIP > array[1]) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    public String isIPInSpecialZoneRange(Long rID, String ip) {
        if (rID == null || ip == null || "null".equals(ip)) {
            return "NotKnown";
        }
        long toBeChecked = Long.parseLong(ip);
        if (toBeChecked < 1L) {
            return "NotKnown";
        }
        ArrayList<long[]> privateIPLongList = this.getIPLongDetails(this.privateIPRange);
        for (long[] array : privateIPLongList) {
            if (toBeChecked < array[0] || toBeChecked > array[1]) continue;
            return "PrivateIPZone";
        }
        ArrayList<long[]> localIPLongList = this.getIPLongDetails(this.localhostIPRange);
        for (long[] array : localIPLongList) {
            if (toBeChecked < array[0] || toBeChecked > array[1]) continue;
            return "LocalIPZone";
        }
        return "WAN";
    }

    public String getPreciseObjName(String obj, boolean isGroup) {
        Matcher mat;
        Pattern pat = this.objNamePattern;
        if (isGroup) {
            pat = this.objGroupNamePattern;
        }
        if ((mat = pat.matcher(obj)).find()) {
            return mat.group(1);
        }
        return obj;
    }

    public String convertArrayListToString(ArrayList<String> list, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public String convertHashSetToString(HashSet<String> setObj) throws Exception {
        if (!setObj.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String setElement : setObj) {
                sb.append(setElement);
                sb.append(",");
            }
            return this.removeLastChar(sb, sb.length());
        }
        return null;
    }

    public String removeLastDelimeter(StringBuilder protocolPortBuilder, String delimeter) throws Exception {
        return protocolPortBuilder.length() > 0 ? protocolPortBuilder.substring(0, protocolPortBuilder.lastIndexOf(delimeter)) : "";
    }

    public String removeLastChar(StringBuilder protocolPortBuilder, int length) throws Exception {
        return length > 0 ? protocolPortBuilder.substring(0, length - 1) : "";
    }

    public String getIPNumber(String ip) {
        if (ip == null) {
            return ip;
        }
        String ipValue = null;
        String ipMask = null;
        Matcher mat = this.ipPattern.matcher(ip);
        if (mat.matches()) {
            ipValue = mat.group(1);
            ipMask = mat.group(2);
        }
        if (ipValue != null && ipMask != null) {
            if (this.checkForInvalidIP(ipValue)) {
                return null;
            }
            String network = IPRange.getNetwork((String)ipMask, (String)ipValue);
            long[] minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)ipMask);
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(minMaxIPLong[0]));
            sb.append("-");
            sb.append(String.valueOf(minMaxIPLong[1]));
            return sb.toString();
        }
        if (ipValue != null) {
            long ipNumber = IPRange.getIPNumber((String)ipValue);
            return ipNumber + "-" + ipNumber;
        }
        return ip;
    }

    public boolean checkForInvalidIP(String ipValue) {
        String firstLiteral;
        int firstLiteralVal;
        Matcher mat = this.invalidIPPattern.matcher(ipValue);
        return !mat.matches() || (firstLiteralVal = Integer.parseInt(firstLiteral = mat.group(1))) <= 0 || firstLiteralVal >= 255;
    }

    public boolean checkForValidIP(String ipValue) {
        Matcher mat = this.ipCheckPattern.matcher(ipValue);
        return mat.matches();
    }

    public String getInterfacesForTheZone(String dstZone, HashMap<String, String> interfaceVsZoneMap) {
        try {
            String interfaceZone = null;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Map.Entry<String, String> mapEntry : interfaceVsZoneMap.entrySet()) {
                interfaceZone = mapEntry.getValue();
                if (!interfaceZone.equals(dstZone)) continue;
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(mapEntry.getKey());
                ++i;
            }
            return sb.toString();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    public HashMap<String, String> getInterfaceIPDetails(Long rID, String resourceName) {
        HashMap<String, String> interfaceVsIPMap = new HashMap<String, String>();
        try {
            Criteria crit = new Criteria(new Column("InterfaceDetails", "RID"), (Object)rID, 0);
            DataObject doo = DataAccess.get((String)"InterfaceDetails", (Criteria)crit);
            if (!doo.isEmpty()) {
                Iterator itr = doo.getRows("InterfaceDetails");
                Row interfaceDetailsRow = null;
                String interfaceName = null;
                String interfaceNetwork = null;
                while (itr.hasNext()) {
                    interfaceDetailsRow = (Row)itr.next();
                    interfaceNetwork = (String)interfaceDetailsRow.get("IPADDRESS");
                    if (interfaceNetwork == null) continue;
                    interfaceName = (String)interfaceDetailsRow.get("INTERFACE_NAME");
                    Matcher mat = this.bracketExtractPattern.matcher(interfaceName);
                    if (mat.matches()) {
                        interfaceName = mat.group(1);
                    }
                    interfaceVsIPMap.put(interfaceName, interfaceNetwork);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return interfaceVsIPMap;
    }

    public void updateObjectsWithUsageInfo(Long rID, String deviceType, String resourceName, Set<String> usedObjects) throws Exception {
        try {
            Object[] usedObjs = usedObjects.toArray();
            UpdateQueryImpl uq = new UpdateQueryImpl("FirewallObjects");
            Criteria crit = new Criteria(new Column("FirewallObjects", "NAME"), (Object)usedObjs, 8);
            crit = crit.and(new Criteria(new Column("FirewallObjects", "RID"), (Object)rID, 0));
            uq.setCriteria(crit);
            uq.setUpdateColumn("USED", (Object)new Integer(1));
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            throw new Exception("Problem while Updating Network Objects with Usage status for the firewall " + resourceName + " of " + deviceType + " Vendor..", ee);
        }
    }

    public void updateInterfaceDetailsWithUsageInfo(Long rID, String deviceType, String resourceName, Set<String> usedInterfaces) throws Exception {
        try {
            Object[] usedInts = usedInterfaces.toArray();
            UpdateQueryImpl uq = new UpdateQueryImpl("InterfaceDetails");
            Criteria crit = new Criteria(new Column("InterfaceDetails", "ALIAS_NAME"), (Object)usedInts, 8);
            crit = crit.and(new Criteria(new Column("InterfaceDetails", "RID"), (Object)rID, 0));
            uq.setCriteria(crit);
            uq.setUpdateColumn("USED", (Object)new Integer(1));
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            throw new Exception("Problem while Updating Network Objects with Usage status for the firewall " + resourceName + " of " + deviceType + " Vendor..", ee);
        }
    }

    private void loadPriorities() {
        try {
            Table ent = new Table("Priorities");
            SelectQueryImpl selectquery = new SelectQueryImpl(ent);
            Column selectAtt = new Column("Priorities", "*");
            selectquery.addSelectColumn(selectAtt);
            DataObject prioritiesDO = DataAccess.get((SelectQuery)selectquery);
            if (prioritiesDO.isEmpty()) {
                LOGGER.log(Level.WARNING, "Unable to load Priorities from DB ");
                return;
            }
            Iterator priDoItr = prioritiesDO.getRows("Priorities");
            Row priRow = null;
            while (priDoItr.hasNext()) {
                priRow = (Row)priDoItr.next();
                this.prioritiesMap.put(((String)priRow.get("PRIORITY_NAME")).toLowerCase(), (String)priRow.get("PRIORITY"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public String getPriorityFrmMem(String name) {
        try {
            name = name.toLowerCase();
            if (this.prioritiesMap.containsKey(name)) {
                return this.prioritiesMap.get(name);
            }
            String key = null;
            String value = null;
            for (Map.Entry<String, String> entry : this.prioritiesMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (name.indexOf(key) <= -1) continue;
                return value;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    public String getAllowedChecklistServices(String detailedService) {
        ArrayList list;
        int size;
        String[] detailedServiceArray;
        StringBuilder allowedChecklist = new StringBuilder();
        HashSet<String> checkListSet = new HashSet<String>();
        HashSet<String> portSet = new HashSet<String>();
        HashSet<String> eqProtoSet = new HashSet<String>();
        HashSet<String> notEqProtoSet = new HashSet<String>();
        HashSet<String> nonCheckProtoSet = new HashSet<String>();
        HashSet<String> anyProtoSet = new HashSet<String>();
        for (String service : detailedServiceArray = detailedService.split("&&")) {
            service = service.trim();
            this.getPortProtocolDetails(service, portSet, eqProtoSet, notEqProtoSet, nonCheckProtoSet, anyProtoSet);
        }
        if (!portSet.isEmpty()) {
            String[] serPortArray;
            for (String serPort : serPortArray = portSet.toArray(new String[0])) {
                this.confirmWithCheckListPorts(serPort.trim(), checkListSet);
            }
        }
        if (!eqProtoSet.isEmpty()) {
            String[] serProtoArray;
            for (String serProto : serProtoArray = eqProtoSet.toArray(new String[0])) {
                this.confirmWithCheckListProtocols(serProto.trim(), checkListSet);
            }
        }
        if (!nonCheckProtoSet.isEmpty()) {
            checkListSet.add("comparator");
        }
        if (!anyProtoSet.isEmpty()) {
            if (anyProtoSet.contains("tcp") || anyProtoSet.contains("udp") || anyProtoSet.contains("ip")) {
                checkListSet.addAll(this.getAllCheckListServices());
            } else {
                checkListSet.add("any");
            }
        }
        if (!notEqProtoSet.isEmpty()) {
            checkListSet.addAll(this.getAllCheckListServices());
        }
        if ((size = (list = new ArrayList(checkListSet)).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                String serv = (String)list.get(i);
                allowedChecklist.append(serv.trim());
                if (i == size - 1) continue;
                allowedChecklist.append(",");
            }
        }
        checkListSet = null;
        portSet = null;
        eqProtoSet = null;
        notEqProtoSet = null;
        nonCheckProtoSet = null;
        anyProtoSet = null;
        return allowedChecklist.toString();
    }

    public HashSet<String> getAllCheckListServices() {
        HashSet<String> allCheckListServices = new HashSet<String>();
        for (ChecklistServiceObject cso : this.checkListServices) {
            String serviceName = cso.getCKLServiceName();
            serviceName = serviceName.toLowerCase();
            allCheckListServices.add(serviceName.trim());
        }
        return allCheckListServices;
    }

    private void getPortProtocolDetails(String service, HashSet<String> portSet, HashSet<String> eqProtoSet, HashSet<String> notEqProtoSet, HashSet<String> nonCheckProtoSet, HashSet<String> anyProtoSet) {
        int size = this.servicePatternList.size();
        for (int i = 0; i < size; ++i) {
            Pattern servicePattern = this.servicePatternList.get(i);
            Matcher mat = servicePattern.matcher(service);
            boolean isPatternMatched = mat.find();
            if (isPatternMatched) {
                String[] portArray;
                for (String ports : portArray = mat.group(3).split(",")) {
                    boolean isNumber = this.isDigit(ports.trim());
                    if (isNumber || ports.matches("\\d+-\\d+")) {
                        portSet.add(ports);
                        continue;
                    }
                    if (ports.equalsIgnoreCase("any")) {
                        anyProtoSet.add(ports.toLowerCase());
                        continue;
                    }
                    nonCheckProtoSet.add(ports);
                }
                continue;
            }
            if (service.equalsIgnoreCase("any")) {
                anyProtoSet.add("any");
                continue;
            }
            eqProtoSet.add(service);
        }
    }

    private HashSet<String> confirmWithCheckListProtocols(String inputProtocol, HashSet<String> serviceSet) {
        try {
            for (ChecklistServiceObject cso : this.checkListServices) {
                String[] protocolArray;
                List<String> protoList;
                String serviceName = cso.getCKLServiceName();
                String stdProtocols = cso.getStdProtocols();
                serviceName = serviceName.toLowerCase();
                inputProtocol = inputProtocol.toLowerCase();
                if (serviceSet.contains(serviceName) || !(protoList = Arrays.asList(protocolArray = stdProtocols.split(","))).contains(inputProtocol)) continue;
                serviceSet.add(serviceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceSet;
    }

    private HashSet<String> confirmWithCheckListPorts(String inputPort, HashSet<String> serviceSet) {
        try {
            block2: for (ChecklistServiceObject cso : this.checkListServices) {
                String[] portArray;
                String serviceName = cso.getCKLServiceName();
                String stdPorts = cso.getStdPorts();
                String custPorts = cso.getCustPorts();
                if (serviceSet.contains(serviceName = serviceName.toLowerCase())) continue;
                if (serviceName.indexOf("x11") >= 0 || serviceName.indexOf("high") >= 0) {
                    for (String custRange : portArray = custPorts.split(",")) {
                        String[] portRangeArr = custRange.split("-");
                        int minPort = Integer.parseInt(portRangeArr[0].trim());
                        int maxPort = Integer.parseInt(portRangeArr[1].trim());
                        if (inputPort.indexOf("-") > -1) {
                            String[] tempArray = inputPort.split("-");
                            String rStart = tempArray[0];
                            String rEnd = tempArray[1];
                            char rsChar = rStart.charAt(0);
                            char reChar = rEnd.charAt(0);
                            if (!Character.isDigit(rsChar) || !Character.isDigit(reChar)) {
                                serviceSet.add("comparator");
                                continue;
                            }
                            int lowerPort = Integer.parseInt(rStart);
                            int upperPort = Integer.parseInt(rEnd);
                            boolean isMatched = false;
                            if (lowerPort >= minPort && lowerPort <= maxPort) {
                                isMatched = true;
                            } else if (upperPort >= minPort && upperPort <= maxPort) {
                                isMatched = true;
                            } else if (minPort >= lowerPort && minPort <= upperPort) {
                                isMatched = true;
                            } else if (maxPort >= lowerPort && maxPort <= upperPort) {
                                isMatched = true;
                            }
                            if (!isMatched) continue;
                            serviceSet.add(serviceName);
                            continue block2;
                        }
                        String inPort = inputPort;
                        if (inputPort.startsWith("<") || inputPort.startsWith(">")) {
                            inPort = inputPort.substring(1);
                        } else if (inputPort.startsWith("!=")) {
                            serviceSet.add(serviceName);
                            continue;
                        }
                        int port = Integer.parseInt(inPort);
                        if (port < minPort || port > maxPort) continue;
                        serviceSet.add(serviceName);
                    }
                    continue;
                }
                portArray = stdPorts.split(",");
                List<String> portList = Arrays.asList(portArray);
                if (portList.size() == 1 && "".equals(portList.get(0))) continue;
                if (inputPort.indexOf("-") >= 0) {
                    String[] portRanArr = inputPort.split("-");
                    String rStart = portRanArr[0].trim();
                    String rEnd = portRanArr[1].trim();
                    char rsChar = rStart.charAt(0);
                    char reChar = rEnd.charAt(0);
                    if (!Character.isDigit(rsChar) || !Character.isDigit(reChar)) {
                        serviceSet.add("comparator");
                        continue;
                    }
                    int miPort = Integer.parseInt(rStart);
                    int maPort = Integer.parseInt(rEnd);
                    for (String port : portArray) {
                        int port1 = Integer.parseInt(port);
                        if (port1 < miPort || port1 > maPort) continue;
                        serviceSet.add(serviceName);
                        continue block2;
                    }
                    continue;
                }
                if (inputPort.startsWith("<")) {
                    String inPort = inputPort.substring(1);
                    int lessPortValue = Integer.parseInt(inPort);
                    for (String stdPort : portArray) {
                        int port = Integer.parseInt(stdPort);
                        if (port > lessPortValue) continue;
                        serviceSet.add(serviceName);
                        continue block2;
                    }
                    continue;
                }
                if (inputPort.startsWith(">")) {
                    String inPort = inputPort.substring(1);
                    int greaterPortValue = Integer.parseInt(inPort);
                    for (String stdPort : portArray) {
                        int port = Integer.parseInt(stdPort);
                        if (port < greaterPortValue) continue;
                        serviceSet.add(serviceName);
                        continue block2;
                    }
                    continue;
                }
                if (inputPort.startsWith("!=")) {
                    serviceSet.add(serviceName);
                    continue;
                }
                if (!portList.contains(inputPort)) continue;
                serviceSet.add(serviceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceSet;
    }

    public boolean getNetworkObjectDataFromDB(Long rID, String objName, String[] netObjMetaData) throws Exception {
        Criteria detailsCrit = new Criteria(new Column("FirewallObjects", "RID"), (Object)rID, 0);
        DataObject doo = DataAccess.get((String)"FirewallObjects", (Criteria)(detailsCrit = detailsCrit.and(new Criteria(new Column("FirewallObjects", "NAME"), (Object)objName, 0))));
        if (!doo.isEmpty()) {
            netObjMetaData[0] = (String)doo.getFirstValue("FirewallObjects", "SUBNET");
            netObjMetaData[1] = (String)doo.getFirstValue("FirewallObjects", "SUBNET_MASK");
            netObjMetaData[2] = (String)doo.getFirstValue("FirewallObjects", "IP_RANGE");
            netObjMetaData[3] = (String)doo.getFirstValue("FirewallObjects", "IPRANGE_ID");
            return true;
        }
        return false;
    }

    public String portGroup(String value) {
        String res = "";
        String protocol = "";
        for (String portDetails : value.split("&&")) {
            Matcher m = this.groupPortPattern.matcher(portDetails);
            m.find();
            protocol = m.group(1).equals("TCP") || m.group(1).equals("UDP") || m.group(1).equals("ICMP") || m.group(1).matches("\\d+") ? m.group(1) + ":dstPort=" + this.toGroupPort(m.group(3)) + "#srcPort=" + this.toGroupPort(m.group(6)) + "#" : portDetails;
            res = res + "&&" + protocol;
        }
        res = res.substring(2, res.length());
        return res;
    }

    private String toGroupPort(String value) {
        String[] values = value.split(",");
        String res = "";
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals("Any")) {
                return "Any";
            }
            if (!values[i].contains("-")) {
                values[i] = values[i] + "-" + values[i];
            } else if (values[i].matches("(0|1)-65535")) {
                return "Any";
            }
            res = res + "," + values[i];
        }
        res = res.substring(1, res.length());
        return this.toGroup(res);
    }

    public String toGroup(String value) {
        if (value == null) {
            return null;
        }
        String[] values = value.split(",");
        List<String> vals = Arrays.asList(values);
        ArrayList<String> valsToProcess = this.removeUnWantedValuesFromList(vals);
        if (!valsToProcess.isEmpty()) {
            TreeSet<String> tree = new TreeSet<String>(valsToProcess);
            if (tree.contains("Any")) {
                tree.clear();
                return "Any";
            }
            ArrayList<String> result = new ArrayList<String>(tree);
            Collections.sort(result, new TreeSortComparator());
            result = this.groupingSet(result);
            StringBuilder sb = new StringBuilder();
            for (String s : result) {
                sb.append(s);
                sb.append(",");
            }
            String res = sb.substring(0, sb.length() - 1);
            return res;
        }
        return null;
    }

    public String toGroup(ArrayList<String> values) {
        if (values == null) {
            return null;
        }
        if (!(values = this.removeUnWantedValuesFromList(values)).isEmpty()) {
            TreeSet<String> tree = new TreeSet<String>(values);
            ArrayList<String> result = new ArrayList<String>(tree);
            Collections.sort(result, new TreeSortComparator());
            result = this.groupingSet(result);
            StringBuilder sb = new StringBuilder();
            for (String s : result) {
                sb.append(s);
                sb.append(",");
            }
            String res = sb.substring(0, sb.length() - 1);
            return res;
        }
        return null;
    }

    public ArrayList<String> groupingSet(ArrayList<String> list) {
        Iterator<String> itr = list.iterator();
        String val1 = itr.next();
        ArrayList<String> result = new ArrayList<String>();
        result.add(val1);
        String[] set1 = new String[2];
        String[] set2 = new String[2];
        String min = "";
        String max = "";
        while (itr.hasNext()) {
            String val2 = itr.next();
            if (this.canGroup(val1, val2)) {
                result.remove(val1);
                set1 = val1.split("-");
                set2 = val2.split("-");
                min = Long.parseLong(set1[0]) < Long.parseLong(set2[0]) ? set1[0] : set2[0];
                max = Long.parseLong(set1[1]) > Long.parseLong(set2[1]) ? set1[1] : set2[1];
                val1 = min + "-" + max;
            } else {
                val1 = val2;
            }
            result.add(val1);
        }
        return result;
    }

    private boolean canGroup(String oldValue, String newValue) {
        long min1 = Long.parseLong(oldValue.split("-")[0]);
        long max1 = Long.parseLong(oldValue.split("-")[1]);
        long min2 = Long.parseLong(newValue.split("-")[0]);
        long max2 = Long.parseLong(newValue.split("-")[1]);
        return max1 + 1L >= min2 && min1 <= max2;
    }

    public void deleteConfigCheckListEntry(Long rid, Long genericSectionID) throws Exception {
        Criteria crit = new Criteria(new Column("ConfigCheckListStatusSummary", "RID"), (Object)rid, 0);
        crit = crit.and(new Criteria(new Column("ConfigCheckListStatusSummary", "GENERIC_SECTION_ID"), (Object)genericSectionID, 0));
        DataAccess.delete((Criteria)crit);
    }

    public void addConfigCheckListEntry(Long rid, Long genericSectionID, String data, String status, Long versionNo) throws Exception {
        String parsedOn = new Timestamp(System.currentTimeMillis()).toString();
        DataObject dObj = DataAccess.constructDataObject();
        Row configCheckListStatusSummaryRow = new Row("ConfigCheckListStatusSummary");
        configCheckListStatusSummaryRow.set("RID", (Object)rid);
        configCheckListStatusSummaryRow.set("GENERIC_SECTION_ID", (Object)genericSectionID);
        configCheckListStatusSummaryRow.set("DATA", (Object)data);
        configCheckListStatusSummaryRow.set("STATUS", (Object)status);
        configCheckListStatusSummaryRow.set("VERSION_NO", (Object)versionNo);
        configCheckListStatusSummaryRow.set("LAST_GENERATED", (Object)parsedOn);
        dObj.addRow(configCheckListStatusSummaryRow);
        DataAccess.add((DataObject)dObj);
    }

    public String getIPIDRange(String minIP, String maxIP) {
        long minIPID = IPRange.getIPNumber((String)minIP);
        long maxIPID = IPRange.getIPNumber((String)maxIP);
        return minIPID + "-" + maxIPID;
    }

    public void setIPAndIPIDInNetObj(String subnetMask, String subnet, NetworkObject netObj) {
        String network = IPRange.getNetwork((String)subnetMask, (String)subnet);
        long[] minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)subnetMask);
        if (minMaxIPLong != null) {
            netObj.setIPRangeID(minMaxIPLong[0] + "-" + minMaxIPLong[1]);
            netObj.setIPRange(IPRange.convertAddr((long)minMaxIPLong[0]) + "-" + IPRange.convertAddr((long)minMaxIPLong[1]));
        }
    }

    public static void setResourceSpecificInterfaceVsZoneMap(Long rID, HashMap<String, String> interfaceVsZoneMap) {
        ridVsInterfaceVsZoneMap.put(rID, interfaceVsZoneMap);
    }

    public static HashMap<String, String> getResourceSpecificInterfaceVsZoneMap(Long rID) {
        return ridVsInterfaceVsZoneMap.get(rID);
    }

    public HashMap<String, String> populateInterfaceVsZoneMapFromDB(Long rID) {
        try {
            HashMap<String, String> interfaceZoneInfoMapFromDB = new HashMap<String, String>();
            Criteria crit = new Criteria(new Column("ComplianceUserInputs", "RID"), (Object)rID, 0);
            DataObject doo = DataAccess.get((String)"ComplianceUserInputs", (Criteria)crit);
            if (!doo.isEmpty()) {
                String wanInterfaces;
                String pciInterfaces;
                String dmzInterfaces;
                String lanInterfaces = (String)doo.getFirstValue("ComplianceUserInputs", "LAN_INTERFACE");
                if (lanInterfaces != null) {
                    String[] lanInterfaceArray;
                    for (String interfaceName : lanInterfaceArray = lanInterfaces.split(",")) {
                        interfaceZoneInfoMapFromDB.put(interfaceName, "LAN");
                    }
                }
                if ((dmzInterfaces = (String)doo.getFirstValue("ComplianceUserInputs", "DMZ_INTERFACE")) != null) {
                    String[] dmzInterfaceArray;
                    for (String interfaceName : dmzInterfaceArray = dmzInterfaces.split(",")) {
                        interfaceZoneInfoMapFromDB.put(interfaceName, "DMZ");
                    }
                }
                if ((pciInterfaces = (String)doo.getFirstValue("ComplianceUserInputs", "PCIZone_INTERFACE")) != null) {
                    String[] pciInterfaceArray;
                    for (String interfaceName : pciInterfaceArray = pciInterfaces.split(",")) {
                        interfaceZoneInfoMapFromDB.put(interfaceName, "PCI");
                    }
                }
                if ((wanInterfaces = (String)doo.getFirstValue("ComplianceUserInputs", "WAN_INTERFACE")) != null) {
                    String[] wanInterfaceArray;
                    for (String interfaceName : wanInterfaceArray = wanInterfaces.split(",")) {
                        interfaceZoneInfoMapFromDB.put(interfaceName, "WAN");
                    }
                }
                ridVsInterfaceVsZoneMap.put(rID, interfaceZoneInfoMapFromDB);
                return interfaceZoneInfoMapFromDB;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    public void updatePolicyDetailsMap(DataObject policyDetailsDO, Long rID, String resourceName, HashMap<String, Long> policyNameVsIDMap) {
        try {
            if (!policyDetailsDO.isEmpty()) {
                Iterator policyDetailsItr = policyDetailsDO.getRows("PolicyDetails");
                Row policyDetailsRow = null;
                String policyName = null;
                Long policyID = null;
                while (policyDetailsItr.hasNext()) {
                    policyDetailsRow = (Row)policyDetailsItr.next();
                    policyName = (String)policyDetailsRow.get("POLICYNAME");
                    policyID = (Long)policyDetailsRow.get("POLICYID");
                    policyNameVsIDMap.put(policyName, policyID);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public String converSetToString(HashSet<String> setData) {
        if (setData != null && !setData.isEmpty()) {
            Iterator<String> itr = setData.iterator();
            StringBuilder sb = new StringBuilder();
            while (itr.hasNext()) {
                String val = itr.next();
                if (val == null) continue;
                sb.append(val);
                sb.append(",");
            }
            return sb.length() > 0 ? sb.substring(0, sb.lastIndexOf(",")) : null;
        }
        return null;
    }

    public ArrayList<String> removeUnWantedValuesFromList(List values) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            String val = (String)values.get(i);
            if (val == null || "null".equals(val) || "".equals(val.trim())) continue;
            toReturn.add(val);
        }
        return toReturn;
    }

    public void printRuleObjDetails(RuleObject currentRuleObj) {
        if (currentRuleObj != null) {
            LOGGER.info("Problamatic Rule Object::: ## RuleName --> " + currentRuleObj.getName() + " ## SRC --> " + currentRuleObj.getSrcAddr() + " ## DST --> " + currentRuleObj.getDstAddr() + " ## Service --> " + currentRuleObj.getService() + " ## Protocol --> " + currentRuleObj.getProtocol() + " ## Action --> " + currentRuleObj.getAction());
        }
    }

    public String getFinalUnResolvedObjs(HashSet<String> srcSet, HashSet<String> dstSet, HashSet<String> serviceSet) throws Exception {
        StringBuilder sb = new StringBuilder();
        String unResolvedSRC = this.convertHashSetToString(srcSet);
        String unResolvedDST = this.convertHashSetToString(dstSet);
        String unResolvedService = this.convertHashSetToString(serviceSet);
        if (unResolvedSRC != null) {
            sb.append("SRC:::");
            sb.append(unResolvedSRC);
            sb.append("@@@");
        }
        if (unResolvedDST != null) {
            sb.append("DST:::");
            sb.append(unResolvedDST);
            sb.append("@@@");
        }
        if (unResolvedService != null) {
            sb.append("Service:::");
            sb.append(unResolvedService);
            sb.append("@@@");
        }
        return this.removeLastDelimeter(sb, "@@@");
    }

    class TreeSortComparator
    implements Comparator<String> {
        TreeSortComparator() {
        }

        @Override
        public int compare(String a, String b) {
            String[] arr1 = a.split("-");
            String[] arr2 = b.split("-");
            if (Long.parseLong(arr1[0]) > Long.parseLong(arr2[0])) {
                return 1;
            }
            if (Long.parseLong(arr1[0]) == Long.parseLong(arr2[0])) {
                if (Long.parseLong(arr1[1]) > Long.parseLong(arr2[1])) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }
}

