/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.fa.server.FWAEnumConstants;
import com.adventnet.fa.server.rules.FirewallGroupObject;
import com.adventnet.fa.server.rules.FirewallPolicyFormat;
import com.adventnet.fa.server.rules.FirewallPolicyParserRule;
import com.adventnet.fa.server.rules.FirewallPolicyParserRuleAttribute;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.fa.server.rules.InterfaceDetails;
import com.adventnet.fa.server.rules.NetworkObject;
import com.adventnet.fa.server.rules.PolicyProcessor;
import com.adventnet.fa.server.rules.PolicyProcessorUtilityClass;
import com.adventnet.fa.server.rules.RuleObject;
import com.adventnet.fa.server.rules.ServiceObject;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.IPRange;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SRXPolicyProcessor
implements PolicyProcessor {
    ResourceBundle bundle = ProductBundle.getInstance().getBundle();
    private NetworkObject currentNetworkObject = null;
    private ServiceObject currentServiceObject = null;
    private FirewallGroupObject currentGroupObject = null;
    private String currentServiceProtocol = null;
    private String currentPolicyName = null;
    private RuleObject currentRuleObject = null;
    private boolean duplicateRuleObj = false;
    private Long rID = null;
    private String deviceType = "SRX Log Format";
    private String resourceName = null;
    private String configData = null;
    private Long versionNo = null;
    private LinkedHashMap<String, NetworkObject> netObjMap = null;
    private LinkedHashMap<String, ServiceObject> serviceObjMap = null;
    private LinkedHashMap<String, ServiceObject> icmpObjMap = null;
    private LinkedHashMap<String, Vector<RuleObject>> policyObjMap = null;
    private LinkedHashMap<String, ArrayList<String>> netObjGroupMemberDetailsMap = null;
    private LinkedHashMap<String, HashSet<String>> objGroupUnResolvedMembers = null;
    private HashMap<String, String> netObjInfoMap = null;
    private HashMap<String, String> serviceObjInfoMap = null;
    private HashMap<String, String> protocolObjInfoMap = null;
    private HashMap<String, String> icmpObjInfoMap = null;
    private ArrayList<String> netObjList = null;
    private ArrayList<String> serviceObjList = null;
    private LinkedHashMap<String, FirewallGroupObject> netObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> protoObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> serviceObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> icmpObjGroupMap = null;
    private ArrayList<String> allObjects = null;
    private Set<String> usedObjects = null;
    private HashMap<String, Long> policyNameVsIDMap = null;
    private LinkedHashMap<String, InterfaceDetails> interfaceDetailsObjMap = null;
    private HashMap<String, String> interfaceAliasVsOriginalNamesMap = null;
    private HashMap<String, String> interfaceVsZoneMap = null;
    private HashMap<String, String> interfaceVsIPAddrMap = null;
    private HashMap<String, Integer> interfaceVsSecurityLevel = null;
    private ArrayList<String> allInterfaces = null;
    private Set<String> usedInterfaces = null;
    private HashMap<String, ArrayList<String[]>> staticNATConfig = null;
    private HashMap<String, ArrayList<String[]>> dynamicNATConfig = null;
    private ArrayList<String> natIPPool = null;
    private static final Logger LOGGER = Logger.getLogger(SRXPolicyProcessor.class.getName());
    private EncryptionAPI decryptionObj = null;
    private static byte[] completeSubnetAddr = new byte[]{-1, -1, -1, -1};
    private PolicyProcessorUtilityClass policyProcessorUtilityObject = null;
    private FirewallPolicyFormat fpf = null;
    private static Pattern fwaCustomObjNameExractPattern = Pattern.compile("fwaCreatedCustomObject_(.*)");
    private static Pattern bracketExtractPattern = Pattern.compile(".*\\(([^\\)]+)\\)");
    private static Pattern tcpudpPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?(?i)(tcp|udp|\\d+|icmp)?\\s+(?:srcPort=([^\\,]+)(?:\\,)?)?(?:dstPort=([^\\,^\\)]+))?");
    private static Pattern icmpPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?(?i)(icmp|icmp6)\\s+(\\S+)(?:\\s+(\\S+))?");
    private static Pattern intergerPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?(?i)(\\d+)\\s+(?:srcPort=([^\\,]+)(?:\\,)?)?(?:dstPort=([^\\,^\\)]+))?");
    private static Pattern otherProtocolPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?([^:]+)\\s+(\\S+)");
    private static Pattern justAServiceExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?(\\S+)");
    private ArrayList<Pattern> portExtractPatternList = null;
    private HashMap<String, String> portOperatorMap = null;
    private HashMap<String, String> serviceToPortMap = null;
    private HashSet<String> unFoundDstInterfaceSet = null;
    private HashSet<String> unFoundSrcInterfaceSet = null;
    private HashSet<String> nonAppliedPolicySet = null;
    public HashSet<String> unknownPorts = null;
    private boolean isInDebugMode = false;
    private boolean hasInterfaceVsZoneMap = false;
    private boolean hasUnknownPorts = false;
    private HashSet<String> unResolvedObjectsSet = null;
    HashMap<String, String> ruleDetailsDataMap = null;
    HashMap<String, String> ruleMappingDataMap = null;
    HashMap<String, String> firewallObjDataMap = null;
    HashMap<String, String> objMappingDataMap = null;
    HashMap<String, ArrayList<String>> serviceToTermMap = null;

    public SRXPolicyProcessor(Long rID, String resourceName, String configData, Long versionNo) {
        Level loggerLevel = LOGGER.getLevel();
        if (loggerLevel != null && loggerLevel.intValue() < 0) {
            this.isInDebugMode = true;
        }
        this.initialize();
        this.decryptionObj = EncryptionAPI.getDecryptionObj();
        this.rID = rID;
        this.resourceName = resourceName;
        this.configData = configData;
        this.versionNo = versionNo;
        this.policyProcessorUtilityObject = PolicyProcessorUtilityClass.getInstance();
        this.serviceToPortMap = this.policyProcessorUtilityObject.getServiceToPortMap("SRX Log Format");
        this.fpf = this.policyProcessorUtilityObject.getVendorSpecificPolicyFormat("SRX Log Format");
        this.interfaceVsZoneMap = PolicyProcessorUtilityClass.getResourceSpecificInterfaceVsZoneMap(rID);
        if (this.interfaceVsZoneMap == null) {
            this.interfaceVsZoneMap = this.policyProcessorUtilityObject.populateInterfaceVsZoneMapFromDB(rID);
        }
        if (this.interfaceVsZoneMap != null && !this.interfaceVsZoneMap.isEmpty()) {
            this.hasInterfaceVsZoneMap = true;
        }
        this.portExtractPatternList = new ArrayList();
        this.portExtractPatternList.add(tcpudpPortExtractPattern);
        this.portExtractPatternList.add(icmpPortExtractPattern);
        this.portExtractPatternList.add(intergerPortExtractPattern);
        this.portExtractPatternList.add(otherProtocolPortExtractPattern);
        this.portExtractPatternList.add(justAServiceExtractPattern);
        this.portOperatorMap = new HashMap();
        this.portOperatorMap.put("eq", "=");
        this.portOperatorMap.put("lt", "<");
        this.portOperatorMap.put("gt", ">");
        this.portOperatorMap.put("neq", "!=");
    }

    public SRXPolicyProcessor(Long rID, String resourceName, String configData, Long versionNo, Boolean noDefaultInitialization) {
        this.rID = rID;
        this.resourceName = resourceName;
        this.configData = configData;
        this.versionNo = versionNo;
    }

    private void initialize() {
        this.netObjMap = new LinkedHashMap(50);
        this.serviceObjMap = new LinkedHashMap(50);
        this.icmpObjMap = new LinkedHashMap(20);
        this.policyObjMap = new LinkedHashMap(25);
        this.netObjGroupMemberDetailsMap = new LinkedHashMap(50);
        this.objGroupUnResolvedMembers = new LinkedHashMap();
        this.netObjInfoMap = new HashMap(50);
        this.serviceObjInfoMap = new HashMap(50);
        this.protocolObjInfoMap = new HashMap(50);
        this.icmpObjInfoMap = new HashMap(20);
        this.netObjList = new ArrayList(30);
        this.serviceObjList = new ArrayList(30);
        this.netObjGroupMap = new LinkedHashMap(50);
        this.protoObjGroupMap = new LinkedHashMap(50);
        this.serviceObjGroupMap = new LinkedHashMap(50);
        this.icmpObjGroupMap = new LinkedHashMap(50);
        this.allObjects = new ArrayList(100);
        this.usedObjects = new HashSet<String>(100);
        this.policyNameVsIDMap = new HashMap();
        this.interfaceDetailsObjMap = new LinkedHashMap(25);
        new HashMap(25);
        this.interfaceAliasVsOriginalNamesMap = new HashMap();
        this.interfaceVsZoneMap = new HashMap();
        this.interfaceVsIPAddrMap = new HashMap();
        this.interfaceVsSecurityLevel = new HashMap();
        this.allInterfaces = new ArrayList();
        this.usedInterfaces = new HashSet<String>();
        new ArrayList();
        this.staticNATConfig = new HashMap();
        this.dynamicNATConfig = new HashMap();
        this.natIPPool = new ArrayList();
        this.unFoundDstInterfaceSet = new HashSet();
        this.unFoundSrcInterfaceSet = new HashSet();
        this.nonAppliedPolicySet = new HashSet();
        this.unknownPorts = new HashSet();
        this.unResolvedObjectsSet = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startParsing() throws Exception {
        FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
        if (this.configData == null) {
            Long maxVersion = confMgmt.getMaxConfigVersion(this.rID, "running");
            DataObject confDo = confMgmt.getLatestConfigFromDB(maxVersion, "running", this.rID);
            InputStream dbConfigDataStream = (InputStream)confDo.getFirstValue("ConfigVersions", "FILE_CONTENTS");
            if (dbConfigDataStream != null) {
                BufferedReader reader = null;
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                try {
                    int n;
                    reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                    this.configData = ((Object)writer).toString();
                }
                finally {
                    this.configData = this.decryptionObj.decryptLog(this.configData);
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                        dbConfigDataStream.close();
                        ((Writer)writer).close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            throw new Exception("Unable to Parse the Config as no Config exists....for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor...");
        }
        if (this.fpf == null) {
            throw new Exception("No Policy Format exists for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor...");
        }
        LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap = new LinkedHashMap<FWAEnumConstants.ParserKeys, String>();
        this.parseAndProcessInterfaceDetails(this.configData, resultMap);
        this.parseAndProcessNetworkObjects(this.configData, resultMap);
        this.parseAndProcessNetworkObjectGroups(this.configData, resultMap);
        this.parseAndProcessServiceObjects(this.configData, resultMap);
        this.parseAndProcessServiceObjectGroups(this.configData, resultMap);
        this.parseAndProcessPolicyObjects(this.configData, resultMap);
        this.netObjList = null;
        this.serviceObjList = null;
        StringBuilder resultBuilder = new StringBuilder();
        this.parseAndProcessSnmpConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessHttpConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessTelnetConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessSSHConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessUserAccessConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessNTPConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessSyslogLoggingConfig(this.configData, this.fpf, resultMap, resultBuilder);
        resultMap = null;
        Object var3_3 = null;
    }

    private void parseAndProcessInterfaceDetails(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block12: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nset interfaces ");
                if (startIndex <= -1) break block12;
                String startExpression = this.fpf.getInterfaceStartExpression();
                Pattern startPattern = this.fpf.getInterfaceStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex + 1);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    do {
                        Vector<FirewallPolicyParserRule> interfaceNamePR = this.fpf.getInterfaceNameParserRules();
                        Vector<FirewallPolicyParserRule> interfaceElementsPR = this.fpf.getInterfaceElementsParserRules();
                        boolean patternMatched = false;
                        patternMatched = this.executeParserRuleList(strLine, interfaceNamePR, "interfaceName", resultMap);
                        if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, interfaceElementsPR, "interfaceElements", resultMap)) || !patternMatched) continue;
                        break block12;
                    } while ((strLine = reader.readLine()) != null);
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Interface Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAndProcessNetworkObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        BufferedReader reader = null;
        try {
            int startIndex = -1;
            String configToBeProcessed = configData.substring(configData.indexOf("\nset security zones "));
            if (configToBeProcessed != null) {
                startIndex = configToBeProcessed.lastIndexOf("\n", configToBeProcessed.indexOf(" address-book address "));
            }
            if (startIndex > -1) {
                String startExpression = this.fpf.getNetObjStartExpression();
                Pattern startPattern = this.fpf.getNetObjStartPattern();
                boolean patternMatched = false;
                reader = new BufferedReader(new StringReader(configToBeProcessed = configToBeProcessed.substring(startIndex + 1)));
                String strLine = reader.readLine();
                if (strLine == null) return;
                patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                if (!patternMatched) throw new Exception("Problem while processing Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                Vector<FirewallPolicyParserRule> netObjNamePR = this.fpf.getNetworkObjectNameParserRules();
                Vector<FirewallPolicyParserRule> netObjElementsPR = this.fpf.getNetworkObjectElementsParserRules();
                do {
                    if (patternMatched = this.executeParserRuleList(strLine, netObjElementsPR, "netObjElements", resultMap)) continue;
                    patternMatched = this.executeParserRuleList(strLine, netObjNamePR, "netObjName", resultMap);
                } while ((strLine = reader.readLine()) != null);
                return;
            } else {
                LOGGER.log(Level.INFO, "No Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            return;
        }
        catch (Exception exp) {
            throw new Exception("Problem while processing Firewall Object for the resource " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAndProcessNetworkObjectGroups(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        BufferedReader reader = null;
        try {
            int startIndex = -1;
            String configToBeProcessed = configData.substring(configData.indexOf("\nset groups "));
            if (configToBeProcessed != null) {
                startIndex = configToBeProcessed.lastIndexOf("\n", configToBeProcessed.indexOf(" address-book address-set "));
            }
            if (startIndex > -1) {
                String startExpression = this.fpf.getNetObjGroupStartExpression();
                Pattern startPattern = this.fpf.getNetObjGroupStartPattern();
                boolean patternMatched = false;
                reader = new BufferedReader(new StringReader(configToBeProcessed = configToBeProcessed.substring(startIndex + 1)));
                String strLine = reader.readLine();
                if (strLine == null) return;
                patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                if (!patternMatched) throw new Exception("Problem while processing Network Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                Vector<FirewallPolicyParserRule> netObjGroupNamePR = this.fpf.getNetworkObjectGroupNameParserRules();
                Vector<FirewallPolicyParserRule> netObjGroupElementsPR = this.fpf.getNetworkObjectGroupElementsParserRules();
                do {
                    if (patternMatched = this.executeParserRuleList(strLine, netObjGroupElementsPR, "netObjGroupElements", resultMap)) continue;
                    patternMatched = this.executeParserRuleList(strLine, netObjGroupNamePR, "netObjGroupName", resultMap);
                } while ((strLine = reader.readLine()) != null);
                return;
            } else {
                LOGGER.log(Level.INFO, "No Network Object Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            return;
        }
        catch (Exception exp) {
            throw new Exception("Problem while processing Network Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void parseAndProcessServiceObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("set applications application ");
                if (startIndex > -1) {
                    String startExpression = this.fpf.getServiceObjStartExpression();
                    Pattern startPattern = this.fpf.getServiceObjStartPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block13;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> serviceObjNamePR = this.fpf.getServiceObjectNameParserRules();
                        Vector<FirewallPolicyParserRule> serviceObjElementsPR = this.fpf.getServiceObjectElementsParserRules();
                        do {
                            if ((patternMatched = this.executeParserRuleList(strLine, serviceObjElementsPR, "serviceObjElements", resultMap)) || (patternMatched = this.executeParserRuleList(strLine, serviceObjNamePR, "serviceObjName", resultMap)) || !patternMatched) continue;
                            break block13;
                        } while ((strLine = reader.readLine()) != null);
                        break block13;
                    }
                    throw new Exception("Problem while processing Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Firewall Object for the resource " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessServiceObjectGroups(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block14: {
            BufferedReader reader = null;
            try {
                int startIndex = -1;
                String configToBeProcessed = configData.substring(configData.indexOf("\nset groups "));
                if (configToBeProcessed != null) {
                    startIndex = configToBeProcessed.lastIndexOf("\n", configToBeProcessed.indexOf(" applications application-set "));
                }
                if (startIndex > -1) {
                    String startExpression = this.fpf.getServiceObjGroupStartExpression();
                    Pattern startPattern = this.fpf.getServiceObjGroupStartPattern();
                    boolean patternMatched = false;
                    reader = new BufferedReader(new StringReader(configToBeProcessed = configToBeProcessed.substring(startIndex + 1)));
                    String strLine = reader.readLine();
                    if (strLine == null) break block14;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> serviceObjGroupNamePR = this.fpf.getServiceObjectGroupNameParserRules();
                        Vector<FirewallPolicyParserRule> serviceObjGroupElementsPR = this.fpf.getServiceObjectGroupElementsParserRules();
                        do {
                            if ((patternMatched = this.executeParserRuleList(strLine, serviceObjGroupElementsPR, "serviceObjGroupElements", resultMap)) || (patternMatched = this.executeParserRuleList(strLine, serviceObjGroupNamePR, "serviceObjGroupName", resultMap)) || !patternMatched) continue;
                            break block14;
                        } while ((strLine = reader.readLine()) != null);
                        break block14;
                    }
                    throw new Exception("Problem while processing Service Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Service Object Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Service Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessPolicyObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        String defaultPolicyName;
        BufferedReader reader = null;
        String policyName = defaultPolicyName = this.resourceName + "_Policy";
        try {
            int startIndex = configData.indexOf("set security policies ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = this.fpf.getPolicyStartExpression();
                Pattern startPattern = this.fpf.getPolicyStartPattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (!patternMatched) continue;
                    Vector<FirewallPolicyParserRule> ruleObjNamePR = this.fpf.getRuleNameParserRules();
                    Vector<FirewallPolicyParserRule> ruleObjElementsPR = this.fpf.getRuleElementsParserRules();
                    Vector ruleObjList = new Vector();
                    this.policyObjMap.put(policyName, ruleObjList);
                    this.currentPolicyName = policyName;
                    while (((patternMatched = this.executeParserRuleList(strLine, ruleObjElementsPR, "ruleObjElements", resultMap)) || (patternMatched = this.executeParserRuleList(strLine, ruleObjNamePR, "ruleObjName", resultMap)) || !patternMatched) && (strLine = reader.readLine()) != null) {
                    }
                    break block9;
                }
                if (this.currentRuleObject != null) {
                    Vector<RuleObject> ruleObjList = (Vector<RuleObject>)this.policyObjMap.remove(this.currentPolicyName);
                    if (ruleObjList == null) {
                        ruleObjList = new Vector<RuleObject>();
                    }
                    ruleObjList.add(this.currentRuleObject);
                    this.policyObjMap.put(this.currentPolicyName, ruleObjList);
                }
            } else {
                LOGGER.log(Level.INFO, "No Firewall Policies for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
        }
        catch (Exception exp) {
            throw new Exception("Problem while processing Policy Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSnmpConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        String snmpCommunityStr = null;
        String snmpCommunityConfigLine = null;
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nset snmp ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getSNMPConfigStartExpression();
                Pattern startPattern = fpf.getSNMPConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex + 1);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block18: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> snmpConfigPR = fpf.getSNMPConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, snmpConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block18;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            switch (key) {
                                case SNMPSERVERCONFIGLINE: {
                                    sb.append("<strong>");
                                    sb.append(value);
                                    sb.append("</strong>");
                                    break;
                                }
                                case SNMPACCESSCONFIGLINE: {
                                    sb.append("<strong>");
                                    sb.append(value);
                                    sb.append("</strong>");
                                    break;
                                }
                                case SNMPCOMMUNITYCONFIGLINE: {
                                    snmpCommunityConfigLine = value;
                                    break;
                                }
                                case SNMPCOMMUNITY: {
                                    snmpCommunityStr = value;
                                    if (snmpCommunityStr == null || snmpCommunityConfigLine == null) break;
                                    sb.append("<strong>");
                                    sb.append(snmpCommunityConfigLine);
                                    sb.append("</strong>");
                                    break;
                                }
                                case SNMPMISCELLANEOUS: {
                                    sb.append(value);
                                    break;
                                }
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block18;
                }
            }
            Long genericSectionID = new Long(4L);
            String snmpServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            String status = null;
            if (snmpServerData == null || "".equals(snmpServerData.trim())) {
                snmpServerData = this.bundle.getString("SNMP_NOT_CONFIGURED");
                status = "Pass";
            } else {
                status = snmpServerData.indexOf("public") > 0 ? "Fail" : "Pass";
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, snmpServerData, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessHttpConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        String httpServerStatus = null;
        String httpServerConfigLine = null;
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nset system services web-management http ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getHTTPConfigStartExpression();
                Pattern startPattern = fpf.getHTTPConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> httpConfigPR = fpf.getHTTPConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, httpConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.HTTPACCESSCONFIGLINE) {
                                sb.append(value);
                            } else if (key == FWAEnumConstants.ParserKeys.HTTPSERVERCONFIGLINE) {
                                sb.append(value);
                            } else if (key == FWAEnumConstants.ParserKeys.HTTPSERVERSTATUS) {
                                httpServerStatus = value;
                                if (httpServerConfigLine != null && httpServerStatus != null) {
                                    httpServerConfigLine = httpServerConfigLine.replaceAll(httpServerStatus, "<strong>" + httpServerStatus + "</strong>");
                                    sb.append(httpServerConfigLine);
                                }
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(1L);
            String httpServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            String status = null;
            if (httpServerData == null || "".equals(httpServerData.trim())) {
                httpServerData = this.bundle.getString("HTTP_NOT_CONFIGURED");
                status = "Pass";
            } else {
                String defaultStatus = this.getDefaultCheckListItemStatus(genericSectionID);
                status = httpServerData != null && httpServerData.indexOf("enable") > 0 ? defaultStatus : "Pass";
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, httpServerData, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessTelnetConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nset system services telnet ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getTelnetConfigStartExpression();
                Pattern startPattern = fpf.getTelnetConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> telnetConfigPR = fpf.getTelnetConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, telnetConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.TELNETACCESSCONFIGLINE) {
                                sb.append(value);
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(2L);
            String telnetServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            boolean dataExists = telnetServerData != null && !"".equals(telnetServerData.trim());
            String statusIfData = this.getDefaultCheckListItemStatus(genericSectionID);
            String statusToBeInDB = null;
            if (!dataExists) {
                telnetServerData = this.bundle.getString("TELNET_NOT_CONFIGURED");
                statusToBeInDB = "Pass";
            } else {
                statusToBeInDB = statusIfData;
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, telnetServerData, statusToBeInDB, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSSHConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nset system services ssh");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getSSHConfigStartExpression();
                Pattern startPattern = fpf.getSSHConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> sshConfigPR = fpf.getSSHConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, sshConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.SSHACCESSCONFIGLINE) {
                                sb.append(value);
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(3L);
            String sshServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            boolean dataExists = sshServerData != null && !"".equals(sshServerData.trim());
            String statusIfData = this.getDefaultCheckListItemStatus(genericSectionID);
            String statusToBeInDB = null;
            if (!dataExists) {
                sshServerData = this.bundle.getString("SSH_NOT_CONFIGURED");
                statusToBeInDB = "UserCall";
            } else {
                statusToBeInDB = statusIfData;
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, sshServerData, statusToBeInDB, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public String getDefaultCheckListItemStatus(Long genericSectionID) {
        try {
            Criteria crit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)genericSectionID, 0);
            DataObject complianceCheckListSectionDO = DataAccess.get((String)"FWAConfigCheckListDetails", (Criteria)crit);
            if (!complianceCheckListSectionDO.isEmpty()) {
                String defaultStatus = (String)complianceCheckListSectionDO.getFirstValue("FWAConfigCheckListDetails", "STATUS_DECIDER");
                defaultStatus = "".equals(defaultStatus = defaultStatus.trim()) ? null : defaultStatus;
                return defaultStatus;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessUserAccessConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nset system login user ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getUserAccessConfigStartExpression();
                Pattern startPattern = fpf.getUserAccessConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> userAccessConfigPR = fpf.getUserAccessConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, userAccessConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.USERACCESSCONFIGLINE) {
                                sb.append(value);
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(5L);
            String userAccessServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            String status = null;
            if (userAccessServerData == null || "".equals(userAccessServerData.trim())) {
                userAccessServerData = this.bundle.getString("UserAccess_NOT_CONFIGURED");
                status = "Pass";
            }
            status = "UserCall";
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, userAccessServerData, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessNTPConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        String ntpAuthConfigLine = null;
        String ntpAuthKeyID = null;
        String ntpTrustedKeyConfigLine = null;
        String ntpTrustedKeyID = null;
        String ntpServerConfigLine = null;
        String ntpServerTrustedKeyID = null;
        BufferedReader reader = null;
        try {
            StringBuilder dbDataSB;
            boolean isTrusted = false;
            boolean isAuthName = false;
            int startIndex = configData.indexOf("\nset system ntp ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getNTPConfigStartExpression();
                Pattern startPattern = fpf.getNTPConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block21: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> ntpConfigPR = fpf.getNTPConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, ntpConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block21;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            switch (key) {
                                case NTPAUTHCONFIGLINE: {
                                    ntpAuthConfigLine = value;
                                    break;
                                }
                                case NTPAUTHKEYID: {
                                    ntpAuthKeyID = value;
                                    isTrusted = true;
                                    if (ntpAuthConfigLine != null && ntpAuthKeyID != null) {
                                        ntpAuthConfigLine = ntpAuthConfigLine.replaceAll(ntpAuthKeyID, "x");
                                    }
                                    if (parseResults.containsKey("NTPAuthKeyName")) break;
                                    sb.append(ntpAuthConfigLine);
                                    break;
                                }
                                case NTPAUTHKEYNAME: {
                                    isAuthName = true;
                                    isTrusted = true;
                                    if (ntpAuthConfigLine != null && value != null && !"".equals(value.trim())) {
                                        ntpAuthConfigLine = ntpAuthConfigLine.replaceAll(value, "xxxxx");
                                    }
                                    sb.append(ntpAuthConfigLine);
                                    break;
                                }
                                case NTPTRUSTEDKEYCONFIGLINE: {
                                    ntpTrustedKeyConfigLine = value;
                                    break;
                                }
                                case NTPTRUSTEDKEYID: {
                                    isTrusted = true;
                                    ntpTrustedKeyID = value;
                                    if (ntpTrustedKeyConfigLine != null && ntpTrustedKeyID != null) {
                                        ntpTrustedKeyConfigLine = ntpTrustedKeyConfigLine.replaceAll(ntpTrustedKeyID, "x");
                                    }
                                    sb.append(ntpTrustedKeyConfigLine);
                                    break;
                                }
                                case NTPSERVERCONFIGLINE: {
                                    ntpServerConfigLine = value;
                                    break;
                                }
                                case NTPSERVERTRUSTEDKEYID: {
                                    ntpServerTrustedKeyID = value;
                                    if (ntpServerConfigLine != null && ntpServerTrustedKeyID != null) {
                                        ntpServerConfigLine = ntpServerConfigLine.replaceAll(" " + ntpServerTrustedKeyID + " ", " x ");
                                    }
                                    sb.append(ntpServerConfigLine);
                                    break;
                                }
                                case NTPCONFIGLINE: {
                                    sb.append(value);
                                    break;
                                }
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block21;
                }
            }
            String ntpServerData = sb.toString();
            String dataToPutInToDB = null;
            String status = null;
            if (!"".equals(ntpServerData.trim())) {
                dataToPutInToDB = ntpServerData;
                status = "Pass";
                dbDataSB = new StringBuilder();
                if (!isTrusted) {
                    dbDataSB.append(dataToPutInToDB);
                    dbDataSB.append("<br>");
                    dbDataSB.append("<strong>");
                    dbDataSB.append(this.bundle.getString("NTP_Recommendation_String"));
                    dbDataSB.append("</strong>");
                    dbDataSB.append("<br>");
                    dbDataSB.append(this.bundle.getString("NTP_NO_TRUSTED_KEY_ID"));
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authenticate");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp trusted-key <key_id>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authentication-key <key_id> md5 <key>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp server <ip_address> [key key_id] [source interface_name] [prefer]");
                    dataToPutInToDB = dbDataSB.toString();
                } else if (!isAuthName) {
                    dbDataSB.append(dataToPutInToDB);
                    dbDataSB.append("<br>");
                    dbDataSB.append("<strong>");
                    dbDataSB.append(this.bundle.getString("NTP_Recommendation_String"));
                    dbDataSB.append("</strong>");
                    dbDataSB.append("<br>");
                    dbDataSB.append(this.bundle.getString("NTP_NO_AUTH_KEY"));
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authenticate");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp trusted-key <key_id>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authentication-key <key_id> md5 <key>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp server <ip_address> [key key_id] [source interface_name] [prefer]");
                    dataToPutInToDB = dbDataSB.toString();
                }
            } else {
                status = "UserCall";
                dataToPutInToDB = this.bundle.getString("No_NTP_Generic_Messsage");
                dataToPutInToDB = dataToPutInToDB.replaceAll("Fortigate", this.deviceType);
                dbDataSB = new StringBuilder();
                dbDataSB.append(dataToPutInToDB);
                dbDataSB.append("ntp authenticate");
                dbDataSB.append("<br>");
                dbDataSB.append("ntp trusted-key <key_id>");
                dbDataSB.append("<br>");
                dbDataSB.append("ntp authentication-key <key_id> md5 <key>");
                dbDataSB.append("<br>");
                dbDataSB.append("ntp server <ip_address> [key key_id] [source interface_name] [prefer]");
                dataToPutInToDB = dbDataSB.toString();
            }
            Long genericSectionID = new Long(6L);
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dataToPutInToDB, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSyslogLoggingConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        BufferedReader reader = null;
        try {
            boolean isLoggingEnable = false;
            String severity = null;
            int startIndex = configData.indexOf("\nset system syslog ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getSyslogConfigStartExpression();
                Pattern startPattern = fpf.getSyslogConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> syslogLoggingConfigPR = fpf.getSyslogLoggingConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, syslogLoggingConfigPR, parseResults);
                        itr = parseResults.keySet().iterator();
                        if (parseResults.isEmpty()) break block11;
                        while (itr.hasNext()) {
                            FWAEnumConstants.ParserKeys key = itr.next();
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.LOGENABLE) {
                                isLoggingEnable = true;
                                continue;
                            }
                            if (key != FWAEnumConstants.ParserKeys.LOGSEVERITY) continue;
                            severity = value;
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(8L);
            String status = "Fail";
            String data = this.bundle.getString("No_Logging_Messsage");
            if (isLoggingEnable) {
                status = "Pass";
                data = this.bundle.getString("Logging_Enabled");
                if (severity != null) {
                    String severityNumber = this.policyProcessorUtilityObject.getPriorityFrmMem(severity);
                    int sev = Integer.parseInt(severityNumber);
                    if (sev < 4) {
                        status = "Fail";
                        data = this.bundle.getString("Change_Logging_Severity");
                    } else {
                        data = this.bundle.getString("Logging_Enabled_With_Severity");
                    }
                    data = data.replaceAll("<data>", severity);
                }
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, data, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void executeParserRuleListAndGetResultMap(String data, Vector<FirewallPolicyParserRule> parserRules, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        Pattern pattern;
        ArrayList<FirewallPolicyParserRuleAttribute> attributes;
        FirewallPolicyParserRule rule;
        String expression;
        boolean patternMatched;
        Iterator<FirewallPolicyParserRule> i$ = parserRules.iterator();
        while (i$.hasNext() && !(patternMatched = this.policyProcessorUtilityObject.executeParserRule(data, expression = (rule = i$.next()).getRegex(), attributes = rule.getAttributes(), pattern = rule.getPattern(), parseResults))) {
        }
    }

    private boolean executeParserRuleList(String data, Vector<FirewallPolicyParserRule> parserRules, String parserRuleType, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        boolean patternMatched = false;
        for (FirewallPolicyParserRule rule : parserRules) {
            Pattern pattern;
            ArrayList<FirewallPolicyParserRuleAttribute> attributes;
            String expression = rule.getRegex();
            patternMatched = this.policyProcessorUtilityObject.executeParserRule(data, expression, attributes = rule.getAttributes(), pattern = rule.getPattern(), resultMap);
            if (!patternMatched) continue;
            String objName = null;
            if (parserRuleType.equals("ruleObjName")) {
                if (this.currentRuleObject != null && !this.duplicateRuleObj) {
                    Vector<RuleObject> ruleObjList = (Vector<RuleObject>)this.policyObjMap.remove(this.currentPolicyName);
                    if (ruleObjList == null) {
                        ruleObjList = new Vector<RuleObject>();
                    }
                    ruleObjList.add(this.currentRuleObject);
                    this.policyObjMap.put(this.currentPolicyName, ruleObjList);
                }
                RuleObject ruleObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.RULENAME);
                if (objName != null) {
                    if (this.currentRuleObject != null && objName.equals(this.currentRuleObject.getName())) {
                        if (resultMap.get((Object)FWAEnumConstants.ParserKeys.SRCINT).equals(this.currentRuleObject.getSrcInt()) && resultMap.get((Object)FWAEnumConstants.ParserKeys.DSTINT).equals(this.currentRuleObject.getDstInt())) {
                            ruleObj = this.currentRuleObject;
                            this.duplicateRuleObj = true;
                        } else {
                            ruleObj = new RuleObject();
                            ruleObj.setName(objName);
                            this.currentRuleObject = ruleObj;
                            this.duplicateRuleObj = false;
                        }
                    } else {
                        ruleObj = new RuleObject();
                        ruleObj.setName(objName);
                        this.currentRuleObject = ruleObj;
                        this.duplicateRuleObj = false;
                    }
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        switch (key) {
                            case SRCINT: {
                                ruleObj.setSrcInt(value);
                                break;
                            }
                            case DSTINT: {
                                ruleObj.setDstInt(value);
                                break;
                            }
                            case SRCADDR: {
                                String src = ruleObj.getSrcAddr();
                                src = src != null ? src + "," + value : value;
                                ruleObj.setSrcAddr(src);
                                break;
                            }
                            case DSTADDR: {
                                String dst = ruleObj.getDstAddr();
                                dst = dst != null ? dst + "," + value : value;
                                ruleObj.setDstAddr(dst);
                                break;
                            }
                            case SERVICEOBJ: {
                                String service = ruleObj.getService();
                                service = service != null ? service + "," + value : value;
                                ruleObj.setService(service);
                                break;
                            }
                            case STATUS: {
                                ruleObj.setStatus(value);
                                break;
                            }
                            case ACTION: {
                                ruleObj.setAction(value);
                                break;
                            }
                            case LOGGING: {
                                ruleObj.setLog(value);
                                break;
                            }
                        }
                    }
                    LOGGER.log(Level.FINER, "the current ruleobj name is:::" + this.currentRuleObject.getName());
                    break;
                }
                LOGGER.log(Level.FINER, "No ruleObjName...hence returning false..");
                return false;
            }
            if (parserRuleType.equals("interfaceName")) {
                InterfaceDetails interfaceDetailsObj = null;
                String ipaddr = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    LOGGER.log(Level.FINER, "interfaceName...For attributes...the key is::" + (Object)((Object)key) + " and the val is::" + value);
                    if (key == FWAEnumConstants.ParserKeys.INTERFACENAME) {
                        objName = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.UNITNAME) {
                        if (this.interfaceDetailsObjMap != null && this.interfaceDetailsObjMap.containsKey(objName)) {
                            this.interfaceDetailsObjMap.remove(objName);
                        }
                        objName = objName + "." + value;
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.IPADDRESS) continue;
                    String[] ip = value.split("/");
                    ipaddr = ip[0] + "/" + IPRange.getSubNetMask((String)ip[1]);
                }
                if (objName != null) {
                    interfaceDetailsObj = this.interfaceDetailsObjMap.get(objName);
                    if (interfaceDetailsObj == null) {
                        interfaceDetailsObj = new InterfaceDetails(objName);
                        this.interfaceDetailsObjMap.put(objName, interfaceDetailsObj);
                    }
                    interfaceDetailsObj.setAliasName("-");
                    interfaceDetailsObj.setType("physical");
                    if (ipaddr == null) break;
                    interfaceDetailsObj.setIP(ipaddr);
                    break;
                }
                LOGGER.log(Level.FINER, "No interfaceName...hence returning false..");
                return false;
            }
            if (parserRuleType.equals("interfaceElements")) {
                String zoneName = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    InterfaceDetails interfaceDetailsObj;
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.ZONENAME) {
                        zoneName = value;
                    }
                    if (key != FWAEnumConstants.ParserKeys.LOGICALINTERFACENAME || (interfaceDetailsObj = this.interfaceDetailsObjMap.get(value)) == null) continue;
                    if (this.interfaceAliasVsOriginalNamesMap == null) {
                        this.interfaceAliasVsOriginalNamesMap = new HashMap();
                    }
                    this.interfaceAliasVsOriginalNamesMap.put(zoneName, value);
                    interfaceDetailsObj.setInterfaceName(value);
                    interfaceDetailsObj.setAliasName(zoneName);
                }
                break;
            }
            if (parserRuleType.equals("netObjName")) {
                NetworkObject netObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.NETOBJNAME);
                LOGGER.log(Level.FINER, "inside processing regex results of netObjName for the object::" + objName);
                if (objName != null) {
                    netObj = this.netObjMap.get(objName);
                    if (netObj == null) {
                        netObj = new NetworkObject(objName);
                        this.netObjMap.put(objName, netObj);
                        this.netObjList.add(objName);
                    }
                    this.currentNetworkObject = netObj;
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        switch (key) {
                            case IPADDRESS: {
                                String[] ipAndSubnet = value.split("/");
                                netObj.setSubnet(ipAndSubnet[0]);
                                ipAndSubnet[1] = IPRange.getSubNetMask((String)ipAndSubnet[1]);
                                netObj.setSubnetMask(ipAndSubnet[1]);
                                String[] minAndMaxIP = IPRange.getMinMaxForNetwork((String)ipAndSubnet[0], (String)ipAndSubnet[1], (boolean)true);
                                netObj.setStartIP(minAndMaxIP[0]);
                                netObj.setEndIP(minAndMaxIP[1]);
                                netObj.setIPRange(minAndMaxIP[0] + "-" + minAndMaxIP[1]);
                                netObj.setIPRangeID(IPRange.getIPNumber((String)minAndMaxIP[0]) + "-" + IPRange.getIPNumber((String)minAndMaxIP[1]));
                                break;
                            }
                            case INTERFACENAME: {
                                netObj.setInterfaceName(value);
                                break;
                            }
                            case DNSNAME: {
                                netObj.setValueInConf(value);
                                break;
                            }
                        }
                    }
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("netObjElements")) {
                String subnet = null;
                NetworkObject netObj = this.currentNetworkObject;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case STARTIP: {
                            netObj.setStartIP(value);
                            break;
                        }
                        case ENDIP: {
                            netObj.setEndIP(value);
                            String minIP = netObj.getStartIP();
                            if (minIP == null || netObj.getIPRange() != null) break;
                            netObj.setIPRange(minIP + "-" + value);
                            netObj.setIPRangeID(this.policyProcessorUtilityObject.getIPIDRange(minIP, value));
                            break;
                        }
                        case SUBNET: {
                            subnet = value;
                            break;
                        }
                        case SUBNETMASK: {
                            netObj.setSubnet(subnet);
                            netObj.setSubnetMask(value);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(value, subnet, netObj);
                            break;
                        }
                        case SINGLEIP: {
                            String completeNetwork = InetAddress.getByAddress(completeSubnetAddr).getHostAddress();
                            netObj.setSubnet(value);
                            netObj.setSubnetMask(completeNetwork);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(completeNetwork, value, netObj);
                            break;
                        }
                        case COMMENT: {
                            netObj.setComment(value);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("serviceObjName")) {
                ServiceObject serviceObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.SERVICEOBJNAME);
                String termName = resultMap.get((Object)FWAEnumConstants.ParserKeys.TERM);
                if (objName != null) {
                    serviceObj = this.serviceObjMap.get(objName);
                    if (serviceObj == null) {
                        serviceObj = new ServiceObject(objName);
                        this.serviceObjMap.put(objName, serviceObj);
                        this.serviceObjList.add(objName);
                    } else if (this.serviceObjMap.get(objName + "_" + termName) != null) {
                        serviceObj = this.serviceObjMap.get(objName + "_" + termName);
                    } else if (termName != null && !termName.equals(this.currentServiceObject.getTermName())) {
                        ArrayList<String> list;
                        serviceObj = new ServiceObject(objName);
                        this.serviceObjMap.put(objName + "_" + termName, serviceObj);
                        this.serviceObjList.add(objName + "_" + termName);
                        if (this.serviceToTermMap == null) {
                            this.serviceToTermMap = new HashMap(50);
                        }
                        if ((list = this.serviceToTermMap.get(objName)) == null) {
                            list = new ArrayList();
                        }
                        list.add(objName + "_" + termName);
                        this.serviceToTermMap.put(objName, list);
                    }
                    this.currentServiceObject = serviceObj;
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        switch (key) {
                            case TERM: {
                                serviceObj.setTermName(value);
                                break;
                            }
                            case PROTOCOL: {
                                serviceObj.setProtocol(value);
                                break;
                            }
                            case SRCPORT: {
                                serviceObj.setSRCPort(value);
                                break;
                            }
                            case DSTPORT: {
                                serviceObj.setDSTPort(value);
                                break;
                            }
                            case ICMPTYPE: {
                                serviceObj.setICMPType(value);
                                break;
                            }
                            case ICMPCODE: {
                                String icmpType = serviceObj.getICMPType();
                                icmpType = icmpType != null ? icmpType + " " + value : null;
                                serviceObj.setICMPType(icmpType);
                                break;
                            }
                        }
                    }
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("netObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.NETOBJGROUPNAME);
                if (objName != null) {
                    groupObj = this.netObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.netObjGroupMap.put(objName, groupObj);
                        this.netObjList.add(objName);
                    }
                    this.currentGroupObject = groupObj;
                    String members = null;
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        switch (key) {
                            case MEMBERS: {
                                if ("apply-groups".equals(resultMap.get((Object)FWAEnumConstants.ParserKeys.GROUPTYPE))) {
                                    FirewallGroupObject gObj = this.netObjGroupMap.get(value);
                                    groupObj.setMembers(gObj.getMembers());
                                    break;
                                }
                                members = groupObj.getMembers();
                                members = members != null ? members + "," + value : value;
                                groupObj.setMembers(members);
                                break;
                            }
                            case INTERFACENAME: {
                                groupObj.setInterfaceName(value);
                                break;
                            }
                        }
                    }
                    groupObj.setType("Network");
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("netObjGroupElements")) {
                FirewallGroupObject groupObj = this.currentGroupObject;
                String subnet = "";
                String members = null;
                String tempObjectName = null;
                NetworkObject netObj = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case SINGLEIP: {
                            netObj = this.netObjMap.get("fwaCreatedCustomObject");
                            if (netObj == null) {
                                netObj = new NetworkObject("fwaCreatedCustomObject");
                                this.netObjMap.put("fwaCreatedCustomObject", netObj);
                            }
                            tempObjectName = value + "/255.255.255.255";
                            String completeNetwork = InetAddress.getByAddress(completeSubnetAddr).getHostAddress();
                            netObj.setSubnet(value);
                            netObj.setSubnetMask(completeNetwork);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(completeNetwork, value, netObj);
                            break;
                        }
                        case SUBNET: {
                            subnet = value;
                            break;
                        }
                        case SUBNETMASK: {
                            netObj = this.netObjMap.get("fwaCreatedCustomObject");
                            if (netObj == null) {
                                netObj = new NetworkObject("fwaCreatedCustomObject");
                                this.netObjMap.put("fwaCreatedCustomObject", netObj);
                            }
                            tempObjectName = subnet + "/" + value;
                            netObj.setSubnet(subnet);
                            netObj.setSubnetMask(value);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(value, subnet, netObj);
                            break;
                        }
                        case COMMENT: {
                            groupObj.setComment(value);
                        }
                        case MEMBERS: {
                            members = groupObj.getMembers();
                            members = members != null ? members + "," + value : value;
                            break;
                        }
                    }
                }
                if (tempObjectName != null) {
                    tempObjectName = "fwaCreatedCustomObject_" + tempObjectName;
                    netObj = (NetworkObject)this.netObjMap.remove("fwaCreatedCustomObject");
                    netObj.setFWACreatedStatus(true);
                    this.netObjMap.put(tempObjectName, netObj);
                    members = groupObj.getMembers();
                    members = members != null ? members + "," + tempObjectName : tempObjectName;
                    tempObjectName = null;
                }
                groupObj.setMembers(members);
                groupObj.setType("Network");
                break;
            }
            if (parserRuleType.equals("serviceObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.SERVICEOBJGROUPNAME);
                this.currentServiceProtocol = resultMap.get((Object)FWAEnumConstants.ParserKeys.SERVICEOBJPROTOCOL);
                if (objName != null) {
                    groupObj = this.serviceObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.serviceObjGroupMap.put(objName, groupObj);
                        this.serviceObjList.add(objName);
                    }
                    this.currentGroupObject = groupObj;
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        if (key != FWAEnumConstants.ParserKeys.MEMBERS) continue;
                        if ("apply-groups".equals(resultMap.get((Object)FWAEnumConstants.ParserKeys.GROUPTYPE))) {
                            FirewallGroupObject gObj = this.serviceObjGroupMap.get(value);
                            groupObj.setMembers(gObj.getMembers());
                            continue;
                        }
                        String members = groupObj.getMembers();
                        members = members != null ? members + "," + value : value;
                        groupObj.setMembers(members);
                    }
                    groupObj.setType("Service");
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("serviceObjGroupElements")) {
                String members = null;
                String tempObjectName = null;
                String protocol = null;
                String startPort = null;
                String endPort = null;
                FirewallGroupObject groupObj = this.currentGroupObject;
                Iterator<FWAEnumConstants.ParserKeys> itr = resultMap.keySet().iterator();
                ServiceObject serviceObj = null;
                while (itr.hasNext()) {
                    String serviceObjectName;
                    FWAEnumConstants.ParserKeys key = itr.next();
                    String value = resultMap.get((Object)key);
                    if (this.currentServiceProtocol != null && (key == FWAEnumConstants.ParserKeys.SERVICEPORT || key == FWAEnumConstants.ParserKeys.PORTRANGE)) {
                        value = key == FWAEnumConstants.ParserKeys.PORTRANGE ? value.replaceAll(" ", " to ") : value;
                        serviceObjectName = "fwaCreatedCustomObject";
                        serviceObj = this.serviceObjMap.get(serviceObjectName);
                        if (serviceObj == null) {
                            serviceObj = new ServiceObject(serviceObjectName);
                            this.serviceObjMap.put(serviceObjectName, serviceObj);
                        }
                        tempObjectName = value;
                        serviceObj.setProtocol(this.currentServiceProtocol);
                        if (value == null) continue;
                        if (key == FWAEnumConstants.ParserKeys.SERVICEPORT) {
                            serviceObj.setDSTPortOperator("eq");
                            serviceObj.setDSTPort(value);
                            continue;
                        }
                        serviceObj.setDSTPortRangeStr("range");
                        String[] portRangeArr = value.split(" to ");
                        serviceObj.setDstStartPort(portRangeArr[0]);
                        serviceObj.setDstEndPort(portRangeArr[1]);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.PROTOCOL) {
                        serviceObjectName = "fwaCreatedCustomObject";
                        serviceObj = this.serviceObjMap.get(serviceObjectName);
                        if (serviceObj == null) {
                            serviceObj = new ServiceObject(serviceObjectName);
                            this.serviceObjMap.put(serviceObjectName, serviceObj);
                        }
                        tempObjectName = value = value.toUpperCase();
                        protocol = value;
                        serviceObj.setProtocol(value);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.COMMENT) {
                        groupObj.setComment(value);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.MEMBERS) {
                        members = groupObj.getMembers();
                        members = members != null ? members + "," + value : value;
                        continue;
                    }
                    if (serviceObj == null) continue;
                    switch (key) {
                        case SRCOPERATOR: {
                            value = this.portOperatorMap.get(value.toLowerCase());
                            serviceObj.setSRCPortOperator(value);
                            tempObjectName = tempObjectName + " srcPort" + value;
                            break;
                        }
                        case SRCPORTVALUE: {
                            serviceObj.setSRCPort(value);
                            tempObjectName = tempObjectName + value;
                            break;
                        }
                        case SRCRANGESTR: {
                            serviceObj.setSRCPortRangeStr(value);
                            tempObjectName = tempObjectName + " srcPort=";
                            break;
                        }
                        case SRCRANGESTART: {
                            startPort = value;
                            serviceObj.setSrcStartPort(value);
                            break;
                        }
                        case SRCRANGEEND: {
                            endPort = value;
                            tempObjectName = tempObjectName + startPort + " to " + endPort;
                            serviceObj.setSrcEndPort(value);
                            break;
                        }
                        case DSTOPERATOR: {
                            value = this.portOperatorMap.get(value.toLowerCase());
                            serviceObj.setDSTPortOperator(value);
                            tempObjectName = tempObjectName != null && tempObjectName.indexOf("srcPort") > -1 ? tempObjectName + " and dstPort" + value : tempObjectName + " dstPort" + value;
                            break;
                        }
                        case DSTPORTVALUE: {
                            tempObjectName = tempObjectName + value;
                            serviceObj.setDSTPort(value);
                            break;
                        }
                        case DSTRANGESTR: {
                            serviceObj.setDSTPortRangeStr(value);
                            tempObjectName = tempObjectName != null && tempObjectName.indexOf("srcPort") > -1 ? tempObjectName + " and dstPort=" : tempObjectName + " dstPort=";
                            break;
                        }
                        case DSTRANGESTART: {
                            startPort = value;
                            serviceObj.setDstStartPort(value);
                            break;
                        }
                        case DSTRANGEEND: {
                            endPort = value;
                            tempObjectName = tempObjectName + startPort + " to " + endPort;
                            serviceObj.setDstEndPort(value);
                            break;
                        }
                        case PROTOCOLSERVICE: {
                            tempObjectName = protocol + " " + value;
                            serviceObj.setService(value);
                            break;
                        }
                        case ICMPTYPE: {
                            tempObjectName = protocol + " " + value;
                            serviceObj.setICMPType(value);
                            break;
                        }
                        case ICMPCODE: {
                            tempObjectName = tempObjectName + " " + value;
                            String icmpType = serviceObj.getICMPType();
                            value = icmpType != null ? icmpType + " " + value : null;
                            serviceObj.setICMPType(value);
                            break;
                        }
                    }
                }
                if (tempObjectName != null) {
                    tempObjectName = this.currentServiceProtocol != null ? "fwaCreatedCustomObject_" + tempObjectName + "_" + this.currentServiceProtocol : "fwaCreatedCustomObject_" + tempObjectName;
                    serviceObj = (ServiceObject)this.serviceObjMap.remove("fwaCreatedCustomObject");
                    serviceObj.setFWACreatedStatus(true);
                    this.serviceObjMap.put(tempObjectName, serviceObj);
                    members = groupObj.getMembers();
                    members = members != null ? members + "," + tempObjectName : tempObjectName;
                    tempObjectName = null;
                }
                groupObj.setMembers(members);
                groupObj.setType("Service");
                break;
            }
            if (parserRuleType.equals("icmpObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.ICMPOBJGROUPNAME);
                if (objName != null) {
                    groupObj = this.icmpObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.icmpObjGroupMap.put(objName, groupObj);
                    }
                    this.currentGroupObject = groupObj;
                    break;
                }
                return false;
            }
            if (!parserRuleType.equals("icmpObjGroupElements")) break;
            String members = null;
            String tempObjectName = null;
            FirewallGroupObject groupObj = this.currentGroupObject;
            ServiceObject serviceObj = null;
            for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                String value = resultMap.get((Object)key);
                switch (key) {
                    case ICMPTYPE: {
                        serviceObj = this.icmpObjMap.get("fwaCreatedCustomObject");
                        if (serviceObj == null) {
                            serviceObj = new ServiceObject("fwaCreatedCustomObject");
                            this.icmpObjMap.put("fwaCreatedCustomObject", serviceObj);
                        }
                        tempObjectName = "ICMP " + value;
                        serviceObj.setProtocol("ICMP");
                        serviceObj.setICMPType(value);
                        break;
                    }
                    case MEMBERS: {
                        members = groupObj.getMembers();
                        members = members != null ? members + "," + value : value;
                        break;
                    }
                    case ICMPOBJECTGROUPCOMMENT: {
                        groupObj.setComment(value);
                        break;
                    }
                }
            }
            if (tempObjectName != null) {
                tempObjectName = "fwaCreatedCustomObject_" + tempObjectName;
                serviceObj = (ServiceObject)this.icmpObjMap.remove("fwaCreatedCustomObject");
                serviceObj.setFWACreatedStatus(true);
                this.icmpObjMap.put(tempObjectName, serviceObj);
                members = groupObj.getMembers();
                members = members != null ? members + "," + tempObjectName : tempObjectName;
                tempObjectName = null;
            }
            groupObj.setMembers(members);
            groupObj.setType("ICMP");
            break;
        }
        return patternMatched;
    }

    public void updateNATIPPoolWithNetworkObjDetails(String objName) {
        String networkObjIPID = this.getNetworkObjectIPID(objName, this.rID, "Network");
        if (networkObjIPID != null) {
            if (networkObjIPID.indexOf(",") > -1) {
                String[] netObjIPID;
                for (String ipID : netObjIPID = networkObjIPID.split(",")) {
                    this.natIPPool.add(ipID);
                }
            } else {
                this.natIPPool.add(networkObjIPID);
            }
        }
    }

    private String getNetworkObjectIPID(String objName, Long rID, String objType) {
        try {
            NetworkObject netObj = this.netObjMap.get(objName);
            if (netObj != null) {
                return netObj.getIPRangeID();
            }
            Criteria detailsCrit = new Criteria(new Column("FirewallObjects", "RID"), (Object)rID, 0);
            DataObject doo = DataAccess.get((String)"FirewallObjects", (Criteria)(detailsCrit = detailsCrit.and(new Criteria(new Column("FirewallObjects", "NAME"), (Object)objName, 0))));
            if (!doo.isEmpty()) {
                return (String)doo.getFirstValue("FirewallObjects", "IPRANGE_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void processResultsAndPopulateIntoDB(Long rID, String deviceType, String resourceName) throws Exception {
        DataObject doo = DataAccess.constructDataObject();
        this.populateInterfaceDetailsIntoDB(rID, this.interfaceDetailsObjMap, deviceType, resourceName);
        this.populateNetworkObjectsDataIntoDB(doo, rID, this.netObjMap, deviceType, resourceName);
        this.populateServiceObjectsDataIntoDB(doo, rID, this.serviceObjMap, deviceType, resourceName);
        this.populateICMPObjectsDataIntoDB(doo, rID, this.icmpObjMap, deviceType, resourceName);
        DataAccess.add((DataObject)doo);
        doo = DataAccess.constructDataObject();
        this.populateObjectsGroup(doo, this.netObjGroupMap, rID, deviceType, resourceName, "Network");
        this.populateObjectsGroup(doo, this.protoObjGroupMap, rID, deviceType, resourceName, "Protocol");
        this.populateObjectsGroup(doo, this.serviceObjGroupMap, rID, deviceType, resourceName, "Service");
        this.populateObjectsGroup(doo, this.icmpObjGroupMap, rID, deviceType, resourceName, "ICMP");
        DataAccess.add((DataObject)doo);
        doo = DataAccess.constructDataObject();
        this.populatePolicyInfoIntoDB(this.policyObjMap, rID, deviceType, resourceName);
        this.populateRuleInfoIntoDB(doo, this.policyObjMap, rID, deviceType, resourceName);
        DataAccess.add((DataObject)doo);
        this.policyProcessorUtilityObject.updateObjectsWithUsageInfo(rID, deviceType, resourceName, this.usedObjects);
        this.policyProcessorUtilityObject.updateInterfaceDetailsWithUsageInfo(rID, deviceType, resourceName, this.usedInterfaces);
        LOGGER.log(Level.FINER, " ### IPs for which SRC Interfaces can not be determined ### " + this.unFoundSrcInterfaceSet);
        LOGGER.log(Level.FINER, " ### IPs for which DST Interfaces can not be determined ### " + this.unFoundDstInterfaceSet);
        LOGGER.log(Level.FINER, " ### ACLs that were not applied on any interface ### " + this.nonAppliedPolicySet);
        LOGGER.log(Level.INFO, " ### Services for which ports are not resolved ### " + this.unknownPorts);
    }

    private void populatePolicyInfoIntoDB(LinkedHashMap<String, Vector<RuleObject>> policyObjMap, Long rID, String deviceType, String resourceName) throws Exception {
        try {
            LOGGER.fine("populating Policy Details...");
            DataObject dObj = DataAccess.constructDataObject();
            Set<String> st = policyObjMap.keySet();
            Iterator<String> itr = st.iterator();
            String policyName = null;
            while (itr.hasNext()) {
                policyName = itr.next();
                Row policyDetailsRow = new Row("PolicyDetails");
                policyDetailsRow.set("POLICYNAME", (Object)policyName);
                policyDetailsRow.set("RID", (Object)rID);
                LOGGER.log(Level.FINE, " SRXPolicyProcessor :::: PolicyDetails ROW is :::::::: {0} ", policyDetailsRow);
                dObj.addRow(policyDetailsRow);
            }
            dObj = DataAccess.add((DataObject)dObj);
            this.policyProcessorUtilityObject.updatePolicyDetailsMap(dObj, rID, resourceName, this.policyNameVsIDMap);
        }
        catch (Exception exp) {
            throw new Exception("Problem while populating Policy Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRuleInfoIntoDB(DataObject doo, LinkedHashMap<String, Vector<RuleObject>> policyObjMap, Long rID, String deviceType, String resourceName) throws Exception {
        RuleObject currentRuleObj = null;
        HashSet<String> srcUnResolved = new HashSet<String>();
        HashSet<String> dstUnResolved = new HashSet<String>();
        HashSet<String> serviceUnResolved = new HashSet<String>();
        try {
            LOGGER.fine("populating Rule Details...");
            String temp = null;
            HashMap<String, HashSet<String>> protoVsSRCPortSet = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> protoVsDSTPortSet = new HashMap<String, HashSet<String>>();
            HashSet<String> protoSetFromService = new HashSet<String>();
            LOGGER.log(Level.FINER, "policyObjMap is:::" + policyObjMap);
            for (Map.Entry<String, Vector<RuleObject>> entry : policyObjMap.entrySet()) {
                String policyObjName = entry.getKey();
                Long policyID = this.policyNameVsIDMap.get(policyObjName);
                if (policyID == null) {
                    Criteria policyIDCrit = new Criteria(new Column("PolicyDetails", "RID"), (Object)rID, 0);
                    DataObject dObj = DataAccess.get((String)"PolicyDetails", (Criteria)(policyIDCrit = policyIDCrit.and(new Criteria(new Column("PolicyDetails", "POLICYNAME"), (Object)policyObjName, 0))));
                    if (!dObj.isEmpty()) {
                        policyID = (Long)dObj.getFirstValue("PolicyDetails", "POLICYID");
                    }
                }
                Vector<RuleObject> ruleObjList = entry.getValue();
                if (policyID == null) continue;
                int i = 1;
                Iterator<RuleObject> i$ = ruleObjList.iterator();
                while (i$.hasNext()) {
                    String status;
                    RuleObject ruleObj;
                    currentRuleObj = ruleObj = i$.next();
                    this.hasUnknownPorts = false;
                    this.unResolvedObjectsSet.clear();
                    srcUnResolved.clear();
                    dstUnResolved.clear();
                    serviceUnResolved.clear();
                    String[] srcDetails = null;
                    String[] dstDetails = null;
                    String[] serviceDetails = null;
                    protoSetFromService.clear();
                    Row ruleDetailsRow = new Row("RuleDetails");
                    ruleDetailsRow.set("RID", (Object)rID);
                    ruleDetailsRow.set("POLICYID", (Object)policyID);
                    String ruleName = ruleObj.getName();
                    ruleName = ruleName != null && !"".equals(ruleName.trim()) ? ruleName : "" + i;
                    ruleDetailsRow.set("RULENAME", (Object)ruleName);
                    String src = ruleObj.getSrcAddr();
                    String srcIPIDRange = ruleObj.getSrcIPIDRange();
                    String srcIPIDRangeStr = null;
                    String ruleSrc = src;
                    if (srcIPIDRange != null) {
                        srcIPIDRangeStr = srcIPIDRange;
                        ruleDetailsRow.set("RULE_SRC", (Object)src);
                        ruleDetailsRow.set("DETAILED_SRC", (Object)src);
                        ruleDetailsRow.set("SRCID_RANGE", (Object)srcIPIDRange);
                    } else if (src != null) {
                        if (this.policyProcessorUtilityObject.anyList.contains((src = src.trim()).toLowerCase())) {
                            ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SRC", (Object)"Any");
                            ruleDetailsRow.set("SRCID_RANGE", (Object)"Any");
                            ruleDetailsRow.set("GROUPED_SRCID", (Object)"Any");
                        } else {
                            srcDetails = this.getMembersRelatedInfoForDB(src, rID, "Network", true);
                            if (srcDetails != null) {
                                String ipIDRangeStr;
                                ruleDetailsRow.set("RULE_SRC", (Object)srcDetails[0]);
                                temp = srcDetails[1];
                                ruleDetailsRow.set("DETAILED_SRC", (Object)temp);
                                if (temp != null) {
                                    temp = temp.replace("<br>", "\n");
                                    temp = temp.replace("&nbsp;", " ");
                                }
                                if ((ipIDRangeStr = srcDetails[5]) != null && !"null".equals(ipIDRangeStr) && !"".equals(ipIDRangeStr.trim())) {
                                    ruleDetailsRow.set("GROUPED_SRCID", (Object)this.policyProcessorUtilityObject.toGroup(ipIDRangeStr));
                                }
                                ruleDetailsRow.set("SRCID_RANGE", (Object)ipIDRangeStr);
                                ruleDetailsRow.set("GROUPED_SRCID", (Object)this.policyProcessorUtilityObject.toGroup(ipIDRangeStr));
                            }
                        }
                    }
                    srcUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    String dst = ruleObj.getDstAddr();
                    String dstIPIDRange = ruleObj.getDstIPIDRange();
                    String tmpService = ruleObj.getService();
                    if (dst == null && tmpService != null) {
                        ruleObj.setDstAddr(tmpService);
                        ruleObj.setService(null);
                        dst = tmpService;
                    }
                    String dstIPIDRangeStr = null;
                    String ruleDst = dst;
                    if (dstIPIDRange != null) {
                        ruleDetailsRow.set("RULE_DST", (Object)dst);
                        ruleDetailsRow.set("DETAILED_DST", (Object)dst);
                        ruleDetailsRow.set("DSTID_RANGE", (Object)dstIPIDRange);
                        dstIPIDRangeStr = dstIPIDRange;
                    } else if (dst != null) {
                        if (this.policyProcessorUtilityObject.anyList.contains((dst = dst.trim()).toLowerCase())) {
                            ruleDetailsRow.set("RULE_DST", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_DST", (Object)"Any");
                            ruleDetailsRow.set("DSTID_RANGE", (Object)"Any");
                            ruleDetailsRow.set("GROUPED_DSTID", (Object)"all");
                        } else {
                            dstDetails = this.getMembersRelatedInfoForDB(dst, rID, "Network", true);
                            if (dstDetails != null) {
                                String ipIDRangeStr;
                                ruleDetailsRow.set("RULE_DST", (Object)dstDetails[0]);
                                temp = dstDetails[1];
                                ruleDetailsRow.set("DETAILED_DST", (Object)temp);
                                if (temp != null) {
                                    temp = temp.replace("<br>", "\n");
                                    temp = temp.replace("&nbsp;", " ");
                                }
                                if ((ipIDRangeStr = dstDetails[5]) != null && !"null".equals(ipIDRangeStr) && !"".equals(ipIDRangeStr.trim())) {
                                    ruleDetailsRow.set("GROUPED_DSTID", (Object)this.policyProcessorUtilityObject.toGroup(ipIDRangeStr));
                                }
                                ruleDetailsRow.set("DSTID_RANGE", (Object)ipIDRangeStr);
                            }
                        }
                    } else {
                        dst = "Any";
                    }
                    dstUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    String sInt = ruleObj.getSrcInt();
                    ruleDetailsRow.set("SRC_INT", (Object)sInt);
                    this.usedInterfaces.add(sInt);
                    String dInt = ruleObj.getDstInt();
                    ruleDetailsRow.set("DST_INT", (Object)dInt);
                    this.usedInterfaces.add(dInt);
                    if (this.hasInterfaceVsZoneMap) {
                        String srcZone = this.interfaceVsZoneMap.get(sInt);
                        ruleDetailsRow.set("SRC_ZONE", (Object)srcZone);
                        String dstZone = this.interfaceVsZoneMap.get(dInt);
                        ruleDetailsRow.set("DST_ZONE", (Object)dstZone);
                        String direction = "WAN".equals(srcZone) ? "inbound" : ("WAN".equals(dstZone) ? "outbound" : null);
                        ruleDetailsRow.set("DIRECTION", (Object)direction);
                    }
                    if (src != null && dst != null) {
                        src = src.trim();
                        dst = dst.trim();
                        if (this.policyProcessorUtilityObject.anyList.contains(src.toLowerCase())) {
                            ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SRC", (Object)"Any");
                        }
                        if (this.policyProcessorUtilityObject.anyList.contains(dst.toLowerCase())) {
                            ruleDetailsRow.set("RULE_DST", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_DST", (Object)"Any");
                        }
                    }
                    status = "deactivate".equals(status = ruleObj.getStatus()) ? "No" : "Yes";
                    ruleDetailsRow.set("RULE_STATUS", (Object)status);
                    String ruleAction = ruleObj.getAction();
                    String service = ruleObj.getService();
                    if (service != null) {
                        if (this.policyProcessorUtilityObject.anyList.contains(service.trim().toLowerCase())) {
                            ruleDetailsRow.set("SERVICE", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SERVICE", (Object)"Any");
                            ruleDetailsRow.set("PORT_INFO", (Object)"Any:dstPort=Any#srcPort=Any#");
                            ruleDetailsRow.set("GROUPED_PORTS", (Object)"Any:dstPort=Any#srcPort=Any#");
                            temp = "Any";
                        } else {
                            serviceDetails = this.getMembersRelatedInfoForDB(service, rID, "Service", true);
                            String tempService = serviceDetails[0];
                            ruleDetailsRow.set("SERVICE", (Object)tempService);
                            temp = serviceDetails[1];
                            if (this.policyProcessorUtilityObject.anyList.contains(temp.trim().toLowerCase())) {
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)"Any");
                                ruleDetailsRow.set("PORT_INFO", (Object)"Any:dstPort=Any#srcPort=Any#");
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)"Any:dstPort=Any#srcPort=Any#");
                            } else {
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)temp);
                                if (temp != null) {
                                    temp = temp.replace("<br>", "\n");
                                    temp = temp.replace("&nbsp;", " ");
                                }
                                String port_info = this.extractPortInfo(service, temp, protoVsSRCPortSet, protoVsDSTPortSet, resourceName, "SRX Log Format", false, protoSetFromService);
                                ruleDetailsRow.set("PORT_INFO", (Object)port_info);
                                if (!this.hasUnknownPorts && !"".equals(port_info)) {
                                    ruleDetailsRow.set("GROUPED_PORTS", (Object)this.policyProcessorUtilityObject.portGroup(port_info));
                                } else {
                                    this.unResolvedObjectsSet.add(service);
                                }
                            }
                        }
                        String cklServices = null;
                        if (!"deny".equals(ruleAction) && "Yes".equals(status)) {
                            try {
                                cklServices = this.policyProcessorUtilityObject.getAllowedChecklistServices((String)ruleDetailsRow.get("PORT_INFO"));
                                ruleDetailsRow.set("CHECKLIST_SERVICE", (Object)cklServices);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    serviceUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    String unResolvedObjects = this.policyProcessorUtilityObject.getFinalUnResolvedObjs(srcUnResolved, dstUnResolved, serviceUnResolved);
                    ruleDetailsRow.set("UNRESOLVED_OBJECTS", (Object)unResolvedObjects);
                    String logStatus = ruleObj.getLog();
                    logStatus = "log".equals(logStatus) ? "enable" : "disable";
                    ruleDetailsRow.set("LOG", (Object)logStatus);
                    String logLevelValue = this.getLogLevelValue(ruleObj.getLogLevel());
                    ruleDetailsRow.set("LOG_LEVEL", (Object)logLevelValue);
                    ruleDetailsRow.set("LOG_INTERVAL", (Object)ruleObj.getLogInterval());
                    ruleDetailsRow.set("ACTION", (Object)ruleAction);
                    ruleDetailsRow.set("SCHEDULE", (Object)ruleObj.getSchedule());
                    ruleDetailsRow.set("AUTHETICATION", (Object)ruleObj.getUserGroup());
                    ruleDetailsRow.set("COMMENTS", (Object)ruleObj.getRuleComment());
                    String ruleType = ruleObj.getType();
                    ruleDetailsRow.set("RULE_TYPE", (Object)ruleType);
                    String srcVal = (String)ruleDetailsRow.get("RULE_SRC");
                    String dstVal = (String)ruleDetailsRow.get("RULE_DST");
                    String serviceVal = (String)ruleDetailsRow.get("SERVICE");
                    String unResolvedVal = (String)ruleDetailsRow.get("UNRESOLVED_OBJECTS");
                    if ("Any".equals(srcVal) || "All".equals(srcVal)) {
                        ruleDetailsRow.set("ANY_SRC", (Object)Boolean.TRUE);
                    }
                    if ("Any".equals(dstVal) || "All".equals(dstVal)) {
                        ruleDetailsRow.set("ANY_DST", (Object)Boolean.TRUE);
                    }
                    if ("Any".equals(serviceVal) || "All".equals(serviceVal) || "Any TCP".equals(serviceVal) || "Any UDP".equals(serviceVal)) {
                        ruleDetailsRow.set("ANY_SERVICE", (Object)Boolean.TRUE);
                    }
                    if (unResolvedVal != null && !"".equals(unResolvedVal.trim())) {
                        ruleDetailsRow.set("IS_UNRESOLVED_DATA", (Object)Boolean.TRUE);
                    }
                    LOGGER.log(Level.FINER, " SRXPolicyProcessor :::: RuleDetails ROW is :::::::: {0} ", ruleDetailsRow);
                    Object object = this.policyProcessorUtilityObject.ruleDetailsAutoGenKeyLock;
                    synchronized (object) {
                        DataAccess.generateValues((Row)ruleDetailsRow);
                    }
                    doo.addRow(ruleDetailsRow);
                    String[] srcGrps = null;
                    String[] dstGrps = null;
                    String[] serviceGrps = null;
                    String srcGrpStr = null;
                    String dstGrpStr = null;
                    String serviceGrpStr = null;
                    if (srcDetails != null) {
                        srcGrpStr = srcDetails[0];
                    }
                    if (dstDetails != null) {
                        dstGrpStr = dstDetails[0];
                    }
                    if (serviceDetails != null) {
                        serviceGrpStr = serviceDetails[0];
                    }
                    int srcGrpLen = 1;
                    int dstGrpLen = 1;
                    int serviceGrpLen = 1;
                    if (srcGrpStr != null) {
                        srcGrps = srcGrpStr.split("<br>");
                        srcGrpLen = srcGrps.length;
                    }
                    if (dstGrpStr != null) {
                        dstGrps = dstGrpStr.split("<br>");
                        dstGrpLen = dstGrps.length;
                    }
                    if (serviceGrpStr != null) {
                        serviceGrps = serviceGrpStr.split("<br>");
                        serviceGrpLen = serviceGrps.length;
                    }
                    int maxLength = srcGrpLen > dstGrpLen ? (srcGrpLen > serviceGrpLen ? srcGrpLen : serviceGrpLen) : (dstGrpLen > serviceGrpLen ? dstGrpLen : serviceGrpLen);
                    Object ruleID = ruleDetailsRow.get("RULEID");
                    String srcElement = null;
                    String dstElement = null;
                    String serviceElement = null;
                    for (int k = 0; k < maxLength; ++k) {
                        Row ruleVsDetailsRow = new Row("RuleToObjOneToNMapping");
                        ruleVsDetailsRow.set("RULEID", ruleID);
                        if (k < srcGrpLen) {
                            if (srcGrpLen == 1 && srcGrps == null) {
                                ruleVsDetailsRow.set("RULE_SRC", (Object)srcVal);
                            } else {
                                srcElement = srcGrps[k];
                                ruleVsDetailsRow.set("RULE_SRC", (Object)srcElement);
                            }
                        }
                        if (k < dstGrpLen) {
                            if (dstGrpLen == 1 && dstGrps == null) {
                                ruleVsDetailsRow.set("RULE_DST", (Object)dstVal);
                            } else {
                                dstElement = dstGrps[k];
                                ruleVsDetailsRow.set("RULE_DST", (Object)dstElement);
                            }
                        }
                        if (k < serviceGrpLen) {
                            if (serviceGrpLen == 1 && serviceGrps == null) {
                                ruleVsDetailsRow.set("SERVICE", (Object)serviceVal);
                            } else {
                                serviceElement = serviceGrps[k];
                                ruleVsDetailsRow.set("SERVICE", (Object)serviceElement);
                            }
                        }
                        Object object2 = this.policyProcessorUtilityObject.ruleObjMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)ruleVsDetailsRow);
                        }
                        doo.addRow(ruleVsDetailsRow);
                    }
                    ++i;
                }
            }
            protoVsSRCPortSet = null;
            protoVsDSTPortSet = null;
        }
        catch (Exception exp) {
            this.policyProcessorUtilityObject.printRuleObjDetails(currentRuleObj);
            throw new Exception("Problem while populating Rule Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    public String getInterfaceUsingNATRules(String knownInterface, String ipID) {
        try {
            String foundInterface = this.matchWithNATRules(ipID, "static", knownInterface);
            if (foundInterface == null) {
                foundInterface = this.matchWithNATRules(ipID, "dynamic", knownInterface);
            }
            return foundInterface;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private String matchWithNATRules(String ipID, String natType, String knownInterface) {
        HashMap<String, ArrayList<String[]>> natConfig;
        String matchedKey = null;
        HashMap<String, ArrayList<String[]>> hashMap = natConfig = natType.equals("static") ? this.staticNATConfig : this.dynamicNATConfig;
        if (natConfig.containsKey(ipID)) {
            matchedKey = ipID;
        } else {
            String[] ipIDRange = ipID.split("-");
            long lowerIP = Long.parseLong(ipIDRange[0]);
            long higherIP = Long.parseLong(ipIDRange[1]);
            for (String key : natConfig.keySet()) {
                String[] translatedIPNumStrArr = key.split("-");
                long tranIPNumMin = Long.parseLong(translatedIPNumStrArr[0]);
                long tranIPNumMax = Long.parseLong(translatedIPNumStrArr[1]);
                if (tranIPNumMin >= lowerIP && tranIPNumMin <= higherIP) {
                    matchedKey = key;
                    break;
                }
                if (tranIPNumMax >= lowerIP && tranIPNumMax <= higherIP) {
                    matchedKey = key;
                    break;
                }
                if (lowerIP >= tranIPNumMin && lowerIP <= tranIPNumMax) {
                    matchedKey = key;
                    break;
                }
                if (higherIP < tranIPNumMin || higherIP > tranIPNumMax) continue;
                matchedKey = key;
                break;
            }
        }
        if (matchedKey != null) {
            ArrayList<String[]> natDetailsList = natConfig.get(matchedKey);
            if (knownInterface != null) {
                for (String[] natDetails : natDetailsList) {
                    String fromInterface = natDetails[0];
                    String toInterface = natDetails[1];
                    if (knownInterface.equals(fromInterface)) {
                        return toInterface;
                    }
                    if (!knownInterface.equals(toInterface)) continue;
                    return fromInterface;
                }
            }
        }
        return null;
    }

    private String getLogLevelValue(String logLevelString) {
        String toReturn = null;
        if (logLevelString != null) {
            toReturn = (logLevelString = logLevelString.toLowerCase()).equals("emergencies") ? "0" : (logLevelString.equals("alerts") ? "1" : (logLevelString.equals("critical") ? "2" : (logLevelString.equals("errors") ? "3" : (logLevelString.equals("warnings") ? "4" : (logLevelString.equals("notifications") ? "5" : (logLevelString.equals("informational") ? "6" : (logLevelString.equals("debugging") ? "7" : logLevelString)))))));
        }
        return toReturn;
    }

    private void populateInterfaceDetailsIntoDB(Long rID, LinkedHashMap<String, InterfaceDetails> interfaceDetailsObjMap, String deviceType, String resourceName) throws Exception {
        try {
            DataObject doo = DataAccess.constructDataObject();
            if (interfaceDetailsObjMap != null && !interfaceDetailsObjMap.isEmpty()) {
                LOGGER.fine("populating Interface Details.....");
                boolean hasIP = false;
                String objName = null;
                String vlan = null;
                InterfaceDetails interfaceDetailsObj = null;
                for (Map.Entry<String, InterfaceDetails> entry : interfaceDetailsObjMap.entrySet()) {
                    String ip;
                    hasIP = false;
                    objName = entry.getKey();
                    interfaceDetailsObj = entry.getValue();
                    objName = interfaceDetailsObj.getInterfaceName();
                    String aliasName = interfaceDetailsObj.getAliasName();
                    aliasName = aliasName != null ? aliasName : objName;
                    this.allInterfaces.add(objName);
                    Row interfaceDetailsRow = new Row("InterfaceDetails");
                    interfaceDetailsRow.set("RID", (Object)rID);
                    interfaceDetailsRow.set("INTERFACE_NAME", (Object)objName);
                    interfaceDetailsRow.set("ALIAS_NAME", (Object)aliasName);
                    if (this.hasInterfaceVsZoneMap) {
                        interfaceDetailsRow.set("INTERFACE_NETWORK_ZONE", (Object)this.interfaceVsZoneMap.get(aliasName));
                    }
                    if ((ip = interfaceDetailsObj.getIP()) != null && !"".equals(ip) && !"null".equals(ip)) {
                        hasIP = true;
                        ip = ip.replaceAll(" ", "/");
                        this.interfaceVsIPAddrMap.put(aliasName, ip);
                    }
                    interfaceDetailsRow.set("IPADDRESS", (Object)ip);
                    String status = interfaceDetailsObj.getStatus();
                    status = "shutdown".equals(status) ? "No" : "Yes";
                    interfaceDetailsRow.set("ACTIVE", (Object)status);
                    if (status.equals("Yes") && hasIP) {
                        interfaceDetailsRow.set("USED", (Object)1);
                    }
                    vlan = interfaceDetailsObj.getVdomName();
                    interfaceDetailsRow.set("VDOM_NAME", (Object)vlan);
                    if (vlan == null) {
                        interfaceDetailsRow.set("INTERFACE_TYPE", (Object)"physical");
                    } else {
                        interfaceDetailsRow.set("INTERFACE_TYPE", (Object)"logical");
                    }
                    String securityLevel = interfaceDetailsObj.getSecurityLevel();
                    if (securityLevel != null) {
                        this.interfaceVsSecurityLevel.put(aliasName, new Integer(securityLevel));
                    }
                    interfaceDetailsRow.set("SECURITY_LEVEL", (Object)securityLevel);
                    interfaceDetailsRow.set("SPEED", (Object)interfaceDetailsObj.getSpeed());
                    interfaceDetailsRow.set("DUPLEX", (Object)interfaceDetailsObj.getDuplex());
                    interfaceDetailsRow.set("DESCRIPTION", (Object)interfaceDetailsObj.getInterfaceDesc());
                    LOGGER.log(Level.FINER, " SRXPolicyProcessor :::: InterfaceDetails ROW is :::::::: {0} ", interfaceDetailsRow);
                    doo.addRow(interfaceDetailsRow);
                }
                DataAccess.add((DataObject)doo);
            } else {
                LOGGER.info("No Interfaces Found.....");
            }
        }
        catch (Exception exp) {
            throw new Exception("Problem while populating Interface Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateNetworkObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, NetworkObject> netObjMap, String deviceType, String resourceName) throws Exception {
        block11: {
            try {
                if (netObjMap != null && !netObjMap.isEmpty()) {
                    LOGGER.fine("populating Network Objects.....");
                    NetworkObject netObj = null;
                    String[] minMaxID = null;
                    for (Map.Entry<String, NetworkObject> entry : netObjMap.entrySet()) {
                        String objName = entry.getKey();
                        netObj = entry.getValue();
                        String subnet = netObj.getSubnet();
                        String subnetMask = netObj.getSubnetMask();
                        String startIP = netObj.getStartIP();
                        String endIP = netObj.getEndIP();
                        String value = null;
                        value = netObj.getValueInConf() != null ? netObj.getValueInConf() : (subnet != null && subnetMask != null ? subnet + "/" + subnetMask : (startIP != null && endIP != null ? startIP + "-" + endIP : null));
                        Row networkObjRow = new Row("FirewallObjects");
                        networkObjRow.set("RID", (Object)rID);
                        networkObjRow.set("NAME", (Object)netObj.getName());
                        networkObjRow.set("VALUE_IN_CONFIG", (Object)value);
                        subnet = IPRange.getNetwork((String)subnetMask, (String)subnet);
                        networkObjRow.set("SUBNET", (Object)subnet);
                        networkObjRow.set("SUBNETWORK_ID", (Object)String.valueOf(IPRange.getIPNumber((String)subnet)));
                        networkObjRow.set("SUBNET_MASK", (Object)subnetMask);
                        networkObjRow.set("START_IP", (Object)startIP);
                        networkObjRow.set("END_IP", (Object)endIP);
                        String ipIDRange = netObj.getIPRangeID();
                        if (startIP != null && ipIDRange != null) {
                            minMaxID = ipIDRange.split("-");
                            networkObjRow.set("STARTIP_ID", (Object)minMaxID[0]);
                            networkObjRow.set("ENDIP_ID", (Object)minMaxID[1]);
                        }
                        networkObjRow.set("IP_RANGE", (Object)netObj.getIPRange());
                        networkObjRow.set("IPRANGE_ID", (Object)ipIDRange);
                        networkObjRow.set("OBJECT_TYPE", (Object)"Network");
                        networkObjRow.set("TO_DISPLAY", (Object)value);
                        this.netObjInfoMap.put(objName, value);
                        LOGGER.log(Level.FINER, " SRXPolicyProcessor :::: FirewallObjects ROW is :::::::: {0} ", networkObjRow);
                        Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)networkObjRow);
                        }
                        doo.addRow(networkObjRow);
                        if (netObj.isFWACreatedObject()) continue;
                        Object objID = networkObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)objName);
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)value);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object2 = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(objName);
                    }
                    break block11;
                }
                LOGGER.info("No Network Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Network Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateServiceObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, ServiceObject> serviceObjMap, String deviceType, String resourceName) throws Exception {
        block23: {
            try {
                if (serviceObjMap != null && !serviceObjMap.isEmpty()) {
                    LOGGER.fine("populating Service Objects.....");
                    String objName = null;
                    ServiceObject serviceObj = null;
                    boolean isICMP = false;
                    String portDetail = "";
                    for (Map.Entry<String, ServiceObject> entry : serviceObjMap.entrySet()) {
                        Object icmpType;
                        objName = entry.getKey();
                        serviceObj = entry.getValue();
                        boolean hasMultiProto = false;
                        if (this.serviceToTermMap != null && this.serviceToTermMap.get(serviceObj.getName()) != null) {
                            ArrayList<String> list = this.serviceToTermMap.get(serviceObj.getName());
                            if (list.contains(objName)) {
                                list.remove(objName);
                            }
                            if (list.size() > 0) {
                                hasMultiProto = true;
                            }
                        }
                        String serviceProtocol = serviceObj.getProtocol();
                        String service = serviceObj.getService();
                        String valueToBeInDB = null;
                        boolean bothTCPAndUDP = false;
                        isICMP = false;
                        if (serviceProtocol != null) {
                            if ((serviceProtocol = serviceProtocol.toUpperCase()).indexOf("ICMP") < 0) {
                                if (serviceObj.getSRCPort() != null) {
                                    String[] srcPort = serviceObj.getSRCPort().split("-");
                                    valueToBeInDB = srcPort.length == 2 ? (srcPort[1].equals(srcPort[0]) ? serviceProtocol + " srcPort=" + srcPort[0] : serviceProtocol + " srcPort=" + srcPort[0] + " to " + srcPort[1]) : serviceProtocol + " srcPort=" + srcPort[0];
                                }
                                if (serviceObj.getDSTPort() != null) {
                                    String[] dstPort = serviceObj.getDSTPort().split("-");
                                    valueToBeInDB = dstPort.length == 2 ? (valueToBeInDB != null ? (dstPort[1].equals(dstPort[0]) ? valueToBeInDB + ",dstPort=" + dstPort[0] : valueToBeInDB + ",dstPort=" + dstPort[0] + " to " + dstPort[1]) : (dstPort[1].equals(dstPort[0]) ? serviceProtocol + " dstPort=" + dstPort[0] : serviceProtocol + " dstPort=" + dstPort[0] + " to " + dstPort[1])) : (valueToBeInDB != null ? valueToBeInDB + ",dstPort=" + dstPort[0] : serviceProtocol + " dstPort=" + dstPort[0]);
                                }
                            } else {
                                String icmpCode;
                                StringBuilder sb = new StringBuilder();
                                icmpType = serviceObj.getICMPType();
                                if (icmpType != null) {
                                    sb.append((String)icmpType);
                                    sb.append(" ");
                                }
                                if ((icmpCode = serviceObj.getICMPCode()) != null) {
                                    sb.append(icmpCode);
                                }
                                valueToBeInDB = serviceProtocol + " " + sb.toString();
                            }
                            if (hasMultiProto) {
                                portDetail = portDetail + valueToBeInDB + " |_| ";
                                continue;
                            }
                            valueToBeInDB = portDetail.indexOf("|_|") > -1 ? portDetail + valueToBeInDB : valueToBeInDB;
                            portDetail = "";
                        }
                        Row serviceObjRow = new Row("FirewallObjects");
                        serviceObjRow.set("RID", (Object)rID);
                        serviceObjRow.set("NAME", (Object)serviceObj.getName());
                        serviceObjRow.set("PROTOCOL", (Object)serviceProtocol.replaceAll("TCP-UDP", "TCP,UDP"));
                        serviceObjRow.set("VALUE_IN_CONFIG", valueToBeInDB);
                        serviceObjRow.set("COMMENTS", (Object)serviceObj.getComment());
                        serviceObjRow.set("OBJECT_TYPE", (Object)"Service");
                        serviceObjRow.set("TO_DISPLAY", (Object)valueToBeInDB);
                        if (isICMP) {
                            this.icmpObjInfoMap.put(objName, valueToBeInDB);
                        } else {
                            this.serviceObjInfoMap.put(serviceObj.getName(), valueToBeInDB);
                        }
                        LOGGER.log(Level.FINE, " SRXPolicyProcessor :::: Firewall Service Objects ROW is :::::::: {0} ", serviceObjRow);
                        icmpType = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (icmpType) {
                            DataAccess.generateValues((Row)serviceObjRow);
                        }
                        doo.addRow(serviceObjRow);
                        if (serviceObj.isFWACreatedObject()) continue;
                        Object objID = serviceObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)serviceObj.getName());
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)valueToBeInDB);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(serviceObj.getName());
                    }
                    break block23;
                }
                LOGGER.info("No Service Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Service Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateICMPObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, ServiceObject> icmpObjMap, String deviceType, String resourceName) throws Exception {
        block7: {
            try {
                if (icmpObjMap != null && !icmpObjMap.isEmpty()) {
                    LOGGER.fine("populating FWA created temporary ICMP Objects.....");
                    String objName = null;
                    ServiceObject serviceObj = null;
                    for (Map.Entry<String, ServiceObject> entry : icmpObjMap.entrySet()) {
                        objName = entry.getKey();
                        serviceObj = entry.getValue();
                        String valueToBeInDB = "ICMP " + serviceObj.getICMPType();
                        Row serviceObjRow = new Row("FirewallObjects");
                        serviceObjRow.set("RID", (Object)rID);
                        serviceObjRow.set("NAME", (Object)serviceObj.getName());
                        serviceObjRow.set("PROTOCOL", (Object)"ICMP");
                        serviceObjRow.set("VALUE_IN_CONFIG", (Object)valueToBeInDB);
                        serviceObjRow.set("OBJECT_TYPE", (Object)"Service");
                        serviceObjRow.set("TO_DISPLAY", (Object)valueToBeInDB);
                        this.icmpObjInfoMap.put(objName, valueToBeInDB);
                        LOGGER.log(Level.FINE, " SRXPolicyProcessor :::: Firewall ICMP Objects ROW is :::::::: {0} ", serviceObjRow);
                        Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)serviceObjRow);
                        }
                        doo.addRow(serviceObjRow);
                    }
                    break block7;
                }
                LOGGER.info("No ICMP Service Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Service Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateObjectsGroup(DataObject doo, LinkedHashMap<String, FirewallGroupObject> objGroupMap, Long rID, String deviceType, String resourceName, String objectGroupType) throws Exception {
        block24: {
            String objName = "";
            try {
                LOGGER.fine("populating " + objectGroupType + " Objects Groups.....");
                if (objGroupMap == null || objGroupMap.isEmpty()) break block24;
                for (Map.Entry<String, FirewallGroupObject> entry : objGroupMap.entrySet()) {
                    objName = entry.getKey();
                    FirewallGroupObject groupObj = entry.getValue();
                    String members = groupObj.getMembers();
                    String objGroupType = groupObj.getType();
                    String objGroupName = groupObj.getName();
                    String[] results = null;
                    this.unResolvedObjectsSet.clear();
                    if (members != null) {
                        results = this.getMembersRelatedInfoForDB(members, rID, objGroupType, false);
                        if (!this.unResolvedObjectsSet.isEmpty()) {
                            HashSet toMemorize = (HashSet)this.unResolvedObjectsSet.clone();
                            this.objGroupUnResolvedMembers.put(objName, toMemorize);
                        }
                    }
                    String memberDetails = null;
                    String memberSubNetworkDetails = null;
                    String memberSubnetMaskDetails = null;
                    String memberIPRangeDetails = null;
                    String memberIDDetails = null;
                    if (results != null) {
                        members = results[0];
                        memberDetails = results[1];
                        if (objGroupType.equals("Network")) {
                            memberSubNetworkDetails = results[2];
                            memberSubnetMaskDetails = results[3];
                            memberIPRangeDetails = results[4];
                            memberIDDetails = results[5];
                            ArrayList<String> netObjGroupMemberDetails = new ArrayList<String>();
                            netObjGroupMemberDetails.add(memberSubNetworkDetails);
                            netObjGroupMemberDetails.add(memberSubnetMaskDetails);
                            netObjGroupMemberDetails.add(memberIPRangeDetails);
                            netObjGroupMemberDetails.add(memberIDDetails);
                            this.netObjGroupMemberDetailsMap.put(objName, netObjGroupMemberDetails);
                        }
                    }
                    Row firewallObjRow = new Row("FirewallObjects");
                    firewallObjRow.set("RID", (Object)rID);
                    firewallObjRow.set("NAME", (Object)objGroupName);
                    if ("Network".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("SUBNET", (Object)memberSubNetworkDetails);
                        firewallObjRow.set("SUBNET_MASK", (Object)memberSubnetMaskDetails);
                        firewallObjRow.set("IP_RANGE", (Object)memberIPRangeDetails);
                        firewallObjRow.set("IPRANGE_ID", (Object)memberIDDetails);
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Network");
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.netObjInfoMap.put(objGroupName, memberDetails + "<br>");
                    } else if ("Protocol".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Protocol");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.protocolObjInfoMap.put(objGroupName, memberDetails);
                    } else if ("Service".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Service");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.serviceObjInfoMap.put(objGroupName, memberDetails + "<br>");
                    } else if ("ICMP".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"ICMP");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.icmpObjInfoMap.put(objGroupName, memberDetails);
                    }
                    LOGGER.log(Level.FINE, " SRXPolicyProcessor :::: FirewallObjectsGroup ROW is :::::::: {0} ", firewallObjRow);
                    Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                    synchronized (object) {
                        DataAccess.generateValues((Row)firewallObjRow);
                    }
                    doo.addRow(firewallObjRow);
                    String[] ObjGrps = null;
                    int objGrpLen = 0;
                    if (members != null) {
                        ObjGrps = members.split("<br>");
                        objGrpLen = ObjGrps.length;
                    }
                    Object objID = firewallObjRow.get("OBJID");
                    String objElement = null;
                    for (int k = 0; k < objGrpLen; ++k) {
                        objElement = ObjGrps[k];
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)objGroupName);
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)objElement);
                        if (objGroupMap.containsKey(objElement)) {
                            objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"Yes");
                        } else {
                            objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        }
                        Object object2 = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                    }
                    this.allObjects.add(objName);
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating " + objectGroupType + " Objects Groups Details with group name as::" + objName + " into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    private String[] getMembersRelatedInfoForDB(String members, Long rID, String objGroupType, boolean forRuleInfo) throws Exception {
        String[] results = new String[6];
        try {
            StringBuilder memberBuffer = new StringBuilder();
            StringBuilder memberDetailsBuffer = new StringBuilder();
            StringBuilder memberSubNetworkDetailsBuffer = new StringBuilder();
            StringBuilder memberSubNetMaskDetailsBuffer = new StringBuilder();
            StringBuilder memberIPRangeDetailsBuffer = new StringBuilder();
            StringBuilder memberIPIDDetailsBuffer = new StringBuilder();
            String[] membersArray = null;
            membersArray = members.indexOf(",") > -1 ? members.split(",") : new String[]{members};
            int memberCount = membersArray.length;
            String member = null;
            String value = null;
            String temp = null;
            int length = 0;
            boolean fwaCreatedObject = false;
            boolean isServiceObj = false;
            for (int i = 0; i < memberCount; ++i) {
                fwaCreatedObject = false;
                member = membersArray[i];
                if ((member = member.trim()) == null) continue;
                Matcher mat = fwaCustomObjNameExractPattern.matcher(member);
                if (mat.find()) {
                    memberBuffer.append(mat.group(1));
                    fwaCreatedObject = true;
                } else {
                    memberBuffer.append(member);
                }
                if (!fwaCreatedObject && this.allObjects.contains(member)) {
                    this.usedObjects.add(member);
                }
                if (member.equalsIgnoreCase("Any") || member.equalsIgnoreCase("All")) {
                    value = member;
                } else {
                    HashMap<String, String> objInfoMap = null;
                    if ("Network".equals(objGroupType)) {
                        objInfoMap = this.netObjInfoMap;
                    } else if ("Protocol".equals(objGroupType)) {
                        objInfoMap = this.protocolObjInfoMap;
                    } else if ("Service".equals(objGroupType)) {
                        isServiceObj = true;
                        objInfoMap = this.serviceObjInfoMap;
                    } else if ("ICMP".equals(objGroupType)) {
                        objInfoMap = this.icmpObjInfoMap;
                    }
                    value = objInfoMap.get(member);
                    if (value == null) {
                        int protoIndex;
                        if (isServiceObj) {
                            value = this.serviceToPortMap.get(member);
                            String string = value = value == null ? this.icmpObjInfoMap.get(member) : value;
                        }
                        if (value == null && (protoIndex = member.indexOf("(")) > 0) {
                            String objNameHead = member.substring(0, protoIndex);
                            value = objInfoMap.get(objNameHead);
                        }
                    }
                }
                if (value != null && value.indexOf("<br>") > 0) {
                    temp = member + "(Group): ";
                    memberDetailsBuffer.append(temp);
                    length = temp.length();
                    String spaceString = "";
                    for (int k = 0; k < length; ++k) {
                        spaceString = spaceString + " ";
                    }
                    spaceString = spaceString.substring(3);
                    String[] valArray = value.split("<br>");
                    int valLength = valArray.length;
                    for (int j = 0; j < valLength; ++j) {
                        temp = valArray[j];
                        memberDetailsBuffer.append(temp);
                        if (j >= valLength - 1) continue;
                        memberDetailsBuffer.append("<br>");
                        memberDetailsBuffer.append(spaceString);
                    }
                } else if (value != null && !member.equals(value)) {
                    memberDetailsBuffer.append(member);
                    memberDetailsBuffer.append("(");
                    memberDetailsBuffer.append(value);
                    memberDetailsBuffer.append(")");
                } else if (isServiceObj) {
                    String defaultServiceObj = this.serviceToPortMap.get(member.toUpperCase());
                    if (defaultServiceObj != null) {
                        memberDetailsBuffer.append(member);
                        memberDetailsBuffer.append("(");
                        memberDetailsBuffer.append(defaultServiceObj);
                        memberDetailsBuffer.append(")");
                    } else {
                        this.unResolvedObjectsSet.add(member);
                        memberDetailsBuffer.append(member);
                    }
                } else {
                    memberDetailsBuffer.append(member);
                }
                if (objGroupType.equals("Network")) {
                    String[] networkObjMetaData = this.getNetworkSpecificValuesFromObjectsTable(member, rID, objGroupType);
                    if (forRuleInfo && this.objGroupUnResolvedMembers.containsKey(member)) {
                        this.unResolvedObjectsSet.addAll((Collection<String>)this.objGroupUnResolvedMembers.get(member));
                        this.unResolvedObjectsSet.add(member);
                    }
                    if (networkObjMetaData != null) {
                        temp = networkObjMetaData[0];
                        memberSubNetworkDetailsBuffer.append(temp);
                        memberSubNetworkDetailsBuffer.append(",");
                        temp = networkObjMetaData[1];
                        memberSubNetMaskDetailsBuffer.append(temp);
                        memberSubNetMaskDetailsBuffer.append(",");
                        temp = networkObjMetaData[2];
                        if (temp != null) {
                            memberIPRangeDetailsBuffer.append(temp);
                            memberIPRangeDetailsBuffer.append(",");
                        }
                        if ((temp = networkObjMetaData[3]) != null && !"null".equals(temp) && !"".equals(temp)) {
                            memberIPIDDetailsBuffer.append(temp);
                            memberIPIDDetailsBuffer.append(",");
                        } else {
                            this.unResolvedObjectsSet.add(member);
                        }
                    } else {
                        String ipIDRangeStr = this.policyProcessorUtilityObject.getIPNumber(member);
                        if (ipIDRangeStr == null || member.equals(ipIDRangeStr)) {
                            this.unResolvedObjectsSet.add(member);
                        } else {
                            memberIPIDDetailsBuffer.append(ipIDRangeStr);
                            memberIPIDDetailsBuffer.append(",");
                        }
                    }
                }
                memberBuffer.append("<br>");
                memberDetailsBuffer.append("<br>");
            }
            results[0] = this.policyProcessorUtilityObject.removeLastDelimeter(memberBuffer, "<br>");
            results[1] = this.policyProcessorUtilityObject.removeLastDelimeter(memberDetailsBuffer, "<br>");
            if (objGroupType.equals("Network")) {
                results[2] = this.policyProcessorUtilityObject.removeLastDelimeter(memberSubNetworkDetailsBuffer, ",");
                results[3] = this.policyProcessorUtilityObject.removeLastDelimeter(memberSubNetMaskDetailsBuffer, ",");
                results[4] = this.policyProcessorUtilityObject.removeLastDelimeter(memberIPRangeDetailsBuffer, ",");
                results[5] = this.policyProcessorUtilityObject.removeLastDelimeter(memberIPIDDetailsBuffer, ",");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
        return results;
    }

    private String[] getObjectDetails(String objName, Long rID, String objGroupType) throws Exception {
        String[] results = new String[6];
        try {
            StringBuffer memberBuffer = new StringBuffer();
            StringBuffer memberDetailsBuffer = new StringBuffer();
            StringBuffer memberSubNetworkDetailsBuffer = new StringBuffer();
            StringBuffer memberSubNetMaskDetailsBuffer = new StringBuffer();
            StringBuffer memberIPRangeDetailsBuffer = new StringBuffer();
            StringBuffer memberIPIDDetailsBuffer = new StringBuffer();
            String member = objName.trim();
            String value = null;
            if (member != null) {
                String[] networkObjMetaData;
                Matcher mat = fwaCustomObjNameExractPattern.matcher(member);
                if (mat.find()) {
                    memberBuffer.append(mat.group(1));
                } else {
                    memberBuffer.append(member);
                }
                if (this.allObjects.contains(member)) {
                    this.usedObjects.add(member);
                }
                if (member.equalsIgnoreCase("Any") || member.equalsIgnoreCase("All")) {
                    value = member;
                } else {
                    int protoIndex;
                    HashMap<String, String> objInfoMap = null;
                    if ("Network".equals(objGroupType)) {
                        objInfoMap = this.netObjInfoMap;
                    } else if ("Protocol".equals(objGroupType)) {
                        objInfoMap = this.protocolObjInfoMap;
                    } else if ("Service".equals(objGroupType)) {
                        objInfoMap = this.serviceObjInfoMap;
                    } else if ("ICMP".equals(objGroupType)) {
                        objInfoMap = this.icmpObjInfoMap;
                    }
                    value = objInfoMap.get(member);
                    if (value == null && (protoIndex = member.indexOf("(")) > 0) {
                        String objNameHead = member.substring(0, protoIndex);
                        value = objInfoMap.get(objNameHead);
                    }
                }
                if (value != null) {
                    memberDetailsBuffer.append(value);
                } else {
                    memberDetailsBuffer.append(member);
                }
                String temp = null;
                if (objGroupType.equals("Network") && (networkObjMetaData = this.getNetworkSpecificValuesFromObjectsTable(member, rID, objGroupType)) != null) {
                    temp = networkObjMetaData[0];
                    memberSubNetworkDetailsBuffer.append(temp);
                    temp = networkObjMetaData[1];
                    memberSubNetMaskDetailsBuffer.append(temp);
                    temp = networkObjMetaData[2];
                    memberIPRangeDetailsBuffer.append(temp);
                    temp = networkObjMetaData[3];
                    if (temp == null || "null".equals(temp)) {
                        this.unResolvedObjectsSet.add(member);
                    } else {
                        memberIPIDDetailsBuffer.append(temp);
                    }
                }
            }
            results[0] = memberBuffer.toString();
            results[1] = memberDetailsBuffer.toString();
            if (objGroupType.equals("Network")) {
                results[2] = memberSubNetworkDetailsBuffer.toString();
                results[3] = memberSubNetMaskDetailsBuffer.toString();
                results[4] = memberIPRangeDetailsBuffer.toString();
                results[5] = memberIPIDDetailsBuffer.toString();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
        return results;
    }

    private String[] getNetworkSpecificValuesFromObjectsTable(String objName, Long rID, String objType) throws Exception {
        String[] netObjMetaData = null;
        try {
            NetworkObject netObj = this.netObjMap.get(objName);
            if (netObj != null) {
                netObjMetaData = new String[]{netObj.getSubnet(), netObj.getSubnetMask(), netObj.getIPRange(), netObj.getIPRangeID()};
                return netObjMetaData;
            }
            ArrayList<String> tempObjGrpDetails = this.netObjGroupMemberDetailsMap.get(objName);
            if (tempObjGrpDetails != null) {
                netObjMetaData = new String[]{tempObjGrpDetails.get(0), tempObjGrpDetails.get(1), tempObjGrpDetails.get(2), tempObjGrpDetails.get(3)};
                return netObjMetaData;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private String extractPortInfo(String service, String detailedService, HashMap<String, HashSet<String>> protoVsSRCPortSet, HashMap<String, HashSet<String>> protoVsDSTPortSet, String resourceName, String deviceType, boolean ignoreConstruct, HashSet<String> protoSetFromService) throws Exception {
        protoVsSRCPortSet.clear();
        protoVsDSTPortSet.clear();
        try {
            if (detailedService != null && !"".equals(detailedService)) {
                String[] memberArray;
                int matchedpatternIndex = -1;
                ArrayList matcherInfo = null;
                Pattern portSplit = Pattern.compile("([^\\s]*)( to ([^.]*))?");
                String currentProtocol = null;
                for (String member : memberArray = detailedService.split("\n")) {
                    if ((member = member.trim()).indexOf("(") > 0) {
                        member = this.getDataFromBracket(member);
                    }
                    String[] protocolPortsArray = member.split("\\|_\\|");
                    ArrayList<String> protocolPortsList = new ArrayList<String>(Arrays.asList(protocolPortsArray));
                    for (String protocolPortData : protocolPortsList) {
                        matcherInfo = this.getTheMatchedPattern(protocolPortData = protocolPortData.trim());
                        if (matcherInfo != null) {
                            String protoService;
                            HashSet<String> tempDSTPortSet;
                            matchedpatternIndex = (Integer)matcherInfo.get(0);
                            Matcher mat = (Matcher)matcherInfo.get(1);
                            String protocol = mat.group(1);
                            if (protocol != null) {
                                protocol = protocol.trim().toUpperCase();
                                protoSetFromService.add(protocol);
                                currentProtocol = protocol;
                            }
                            String srcPortDetail = null;
                            String dstPortDetail = null;
                            if (matchedpatternIndex == 1 || matchedpatternIndex == 3) {
                                String[] dstPortArr;
                                String portNumber;
                                Matcher m;
                                srcPortDetail = mat.group(2);
                                dstPortDetail = mat.group(3);
                                if (srcPortDetail != null) {
                                    String[] srcPortArr;
                                    HashSet<String> tempSRCPortSet = protoVsSRCPortSet.get(currentProtocol);
                                    for (String srcPortInfo : srcPortArr = srcPortDetail.trim().split(" and srcPort=")) {
                                        if (this.policyProcessorUtilityObject.anyList.contains(srcPortInfo.toLowerCase())) {
                                            srcPortInfo = "1-65535";
                                        } else {
                                            m = portSplit.matcher(srcPortInfo);
                                            m.find();
                                            srcPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(1)) ? (portNumber = this.getPortNumber(m.group(1), currentProtocol)) : m.group(1);
                                            if (m.group(3) != null) {
                                                srcPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(3)) ? ((portNumber = this.getPortNumber(m.group(3), currentProtocol)) != null ? srcPortInfo + "-" + portNumber : portNumber) : srcPortInfo + "-" + m.group(3);
                                            }
                                        }
                                        if (tempSRCPortSet == null) {
                                            tempSRCPortSet = new HashSet();
                                        }
                                        tempSRCPortSet.add(srcPortInfo);
                                    }
                                    protoVsSRCPortSet.put(currentProtocol, tempSRCPortSet);
                                }
                                if (dstPortDetail == null) continue;
                                tempDSTPortSet = protoVsDSTPortSet.get(currentProtocol);
                                for (String dstPortInfo : dstPortArr = dstPortDetail.trim().split(" and dstPort=")) {
                                    if (this.policyProcessorUtilityObject.anyList.contains(dstPortInfo.toLowerCase())) {
                                        dstPortInfo = "1-65535";
                                    } else {
                                        m = portSplit.matcher(dstPortInfo);
                                        m.find();
                                        dstPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(1)) ? (portNumber = this.getPortNumber(m.group(1), currentProtocol)) : m.group(1);
                                        if (m.group(3) != null) {
                                            dstPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(3)) ? ((portNumber = this.getPortNumber(m.group(3), currentProtocol)) != null ? dstPortInfo + "-" + portNumber : portNumber) : dstPortInfo + "-" + m.group(3);
                                        }
                                    }
                                    if (tempDSTPortSet == null) {
                                        tempDSTPortSet = new HashSet();
                                    }
                                    tempDSTPortSet.add(dstPortInfo);
                                }
                                protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet);
                                continue;
                            }
                            if (matchedpatternIndex == 2) {
                                String icmpType = mat.group(2);
                                String icmpCode = mat.group(3);
                                dstPortDetail = icmpType.trim();
                                tempDSTPortSet = protoVsDSTPortSet.get(currentProtocol);
                                if (tempDSTPortSet == null) {
                                    tempDSTPortSet = new HashSet();
                                }
                                tempDSTPortSet.add(dstPortDetail);
                                protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet);
                                continue;
                            }
                            if (matchedpatternIndex == 4) {
                                protoService = mat.group(2);
                                tempDSTPortSet = protoVsDSTPortSet.get(currentProtocol);
                                if (tempDSTPortSet == null) {
                                    tempDSTPortSet = new HashSet();
                                }
                                if (protoService != null) {
                                    protoService = protoService.trim();
                                    tempDSTPortSet.add(protoService);
                                }
                                protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet);
                                continue;
                            }
                            if (matchedpatternIndex != 5) continue;
                            protoService = mat.group(1);
                            HashMap serviceMap = this.getServiceDetails(protoService);
                            if (serviceMap != null) {
                                for (String key : serviceMap.keySet()) {
                                    HashSet<String> tempDSTPortSet2 = protoVsDSTPortSet.get(key);
                                    if (tempDSTPortSet2 == null) {
                                        tempDSTPortSet2 = new HashSet();
                                    }
                                    tempDSTPortSet2.addAll((Collection)serviceMap.get(key));
                                    protoVsDSTPortSet.put(key, tempDSTPortSet2);
                                }
                                continue;
                            }
                            this.unResolvedObjectsSet.add(protoService);
                            continue;
                        }
                        throw new Exception("Problem while matching the portExtract Patterns for the line:::" + protocolPortData + " of service object::: " + service + " that have the data as:::" + detailedService + " for the firewall::: " + resourceName + " of Fortigate Vendor..");
                    }
                }
                if (!ignoreConstruct) {
                    HashSet<String> dstPortSet = null;
                    HashSet<String> srcPortSet = null;
                    String completePortInfo = null;
                    StringBuilder servicePortBuilder = new StringBuilder();
                    StringBuilder protocolPortBuilder = new StringBuilder();
                    String tempValue = null;
                    for (String proto : protoVsDSTPortSet.keySet()) {
                        dstPortSet = protoVsDSTPortSet.get(proto);
                        srcPortSet = protoVsSRCPortSet.remove(proto);
                        completePortInfo = this.constructProtocolSpecificPorts(dstPortSet, srcPortSet, protocolPortBuilder, tempValue);
                        servicePortBuilder.append(proto);
                        servicePortBuilder.append(":");
                        servicePortBuilder.append(completePortInfo);
                        servicePortBuilder.append("&&");
                    }
                    for (String proto : protoVsSRCPortSet.keySet()) {
                        srcPortSet = protoVsSRCPortSet.get(proto);
                        completePortInfo = this.constructProtocolSpecificPorts(null, srcPortSet, protocolPortBuilder, tempValue);
                        servicePortBuilder.append(proto);
                        servicePortBuilder.append(":");
                        servicePortBuilder.append(completePortInfo);
                        servicePortBuilder.append("&&");
                    }
                    return this.policyProcessorUtilityObject.removeLastDelimeter(servicePortBuilder, "&&");
                }
                return "";
            }
            this.hasUnknownPorts = true;
            this.unResolvedObjectsSet.add(service);
            this.unknownPorts.add(service);
            return "";
        }
        catch (Exception ee) {
            throw new Exception("Problem while matching the portExtract Patterns for the service object " + service + " having the data:: " + detailedService + " for the firewall::: " + resourceName + " of " + deviceType + " Vendor..", ee);
        }
    }

    private HashMap getServiceDetails(String defaultService) {
        HashMap<String, HashSet<String>> serviceMap = null;
        String upperService = defaultService.toUpperCase();
        if (this.serviceToPortMap.containsKey(upperService)) {
            String toReturn = this.serviceToPortMap.get(upperService);
            HashMap<String, HashSet<String>> tt1 = new HashMap<String, HashSet<String>>();
            serviceMap = new HashMap<String, HashSet<String>>();
            HashSet<String> tt3 = new HashSet<String>();
            try {
                this.extractPortInfo(upperService, toReturn, tt1, serviceMap, this.resourceName, "SRX Log Format", true, tt3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return serviceMap;
    }

    private String constructProtocolSpecificPorts(HashSet<String> dstPortSet, HashSet<String> srcPortSet, StringBuilder protocolPortBuilder, String tempValue) throws Exception {
        Iterator<String> itr;
        protocolPortBuilder.setLength(0);
        if (dstPortSet != null && !dstPortSet.isEmpty()) {
            protocolPortBuilder.append("dstPort=");
            itr = dstPortSet.iterator();
            while (itr.hasNext()) {
                protocolPortBuilder.append(itr.next());
                protocolPortBuilder.append(",");
            }
            tempValue = this.policyProcessorUtilityObject.removeLastChar(protocolPortBuilder, protocolPortBuilder.length());
            protocolPortBuilder.setLength(0);
            protocolPortBuilder.append(tempValue);
            protocolPortBuilder.append("#");
        } else {
            protocolPortBuilder.append("dstPort=Any#");
        }
        if (srcPortSet != null && !srcPortSet.isEmpty()) {
            protocolPortBuilder.append("srcPort=");
            itr = srcPortSet.iterator();
            while (itr.hasNext()) {
                protocolPortBuilder.append(itr.next());
                protocolPortBuilder.append(",");
            }
            tempValue = this.policyProcessorUtilityObject.removeLastChar(protocolPortBuilder, protocolPortBuilder.length());
            protocolPortBuilder.setLength(0);
            protocolPortBuilder.append(tempValue);
            protocolPortBuilder.append("#");
        } else {
            protocolPortBuilder.append("srcPort=Any#");
        }
        return protocolPortBuilder.toString();
    }

    private String getPortNumber(String service, String protocol) {
        String upperService = service.toUpperCase();
        if ("ICMP".equals(protocol)) {
            String icmpTypeNumber = this.policyProcessorUtilityObject.getICMPType(upperService);
            if (icmpTypeNumber != null) {
                return icmpTypeNumber;
            }
        } else if (this.serviceToPortMap.containsKey(upperService)) {
            String toReturn = this.serviceToPortMap.get(upperService);
            HashMap<String, HashSet<String>> tt1 = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> tt2 = new HashMap<String, HashSet<String>>();
            HashSet<String> tt3 = new HashSet<String>();
            try {
                this.extractPortInfo(upperService, toReturn, tt1, tt2, this.resourceName, "SRX Log Format", true, tt3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String proto : tt3) {
                if (!proto.equals(protocol)) continue;
                String portNumber = "";
                try {
                    portNumber = this.policyProcessorUtilityObject.convertHashSetToString(tt2.get(proto));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return portNumber;
            }
        }
        this.hasUnknownPorts = true;
        this.unknownPorts.add(service);
        this.unResolvedObjectsSet.add(service);
        return service;
    }

    private String getDataFromBracket(String member) throws Exception {
        Matcher mat = bracketExtractPattern.matcher(member);
        if (mat.matches()) {
            member = mat.group(1);
        }
        return member;
    }

    private ArrayList getTheMatchedPattern(String protocolPortData) {
        ArrayList<Object> matcherInfo = new ArrayList<Object>();
        int i = 1;
        for (Pattern pat : this.portExtractPatternList) {
            Matcher mat = pat.matcher(protocolPortData);
            if (mat.matches()) {
                matcherInfo.add(i);
                matcherInfo.add(mat);
                return matcherInfo;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void cleanupMemory() {
        this.currentNetworkObject = null;
        this.currentServiceObject = null;
        this.currentGroupObject = null;
        this.rID = null;
        this.versionNo = null;
        this.netObjMap = null;
        this.serviceObjMap = null;
        this.icmpObjMap = null;
        this.policyObjMap = null;
        this.netObjGroupMemberDetailsMap = null;
        this.netObjInfoMap = null;
        this.serviceObjInfoMap = null;
        this.protocolObjInfoMap = null;
        this.icmpObjInfoMap = null;
        this.netObjList = null;
        this.serviceObjList = null;
        this.netObjGroupMap = null;
        this.protoObjGroupMap = null;
        this.serviceObjGroupMap = null;
        this.icmpObjGroupMap = null;
        this.allObjects = null;
        this.usedObjects = null;
        this.policyNameVsIDMap = null;
        this.interfaceDetailsObjMap = null;
        this.interfaceAliasVsOriginalNamesMap = null;
        this.interfaceVsZoneMap = null;
        this.interfaceVsIPAddrMap = null;
        this.interfaceVsSecurityLevel = null;
        this.allInterfaces = null;
        this.usedInterfaces = null;
        this.staticNATConfig = null;
        this.dynamicNATConfig = null;
        this.natIPPool = null;
        this.decryptionObj = null;
        this.fpf = null;
        this.portExtractPatternList = null;
        this.portOperatorMap = null;
        this.serviceToPortMap = null;
        this.unFoundSrcInterfaceSet = null;
        this.unFoundDstInterfaceSet = null;
        this.nonAppliedPolicySet = null;
        this.unknownPorts = null;
        this.unResolvedObjectsSet = null;
        this.serviceToTermMap = null;
        this.objGroupUnResolvedMembers = null;
    }
}

