import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.QueryConstants;
import com.adventnet.nms.util.DBParamsParser;
import com.adventnet.nms.util.NmsUtil;
import com.adventnet.persistence.DataAccess;
import com.manageengine.opmanager.vservers.vmware.VIConstants;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class RemoveDBEntriesNew
{
	private static final String dbParamsConf = "conf/database_params.conf";
	private static Connection conn = null;
	private static Statement stmt = null;
	private static String devicename = null;

	public static void main (String args[]) throws Exception
	{
		if (args.length != 1)
		{
			System.out.println("Specify the device name to be removed. [Usage: RemoveDBEntriesNew <devicename>] ");
			return;
		}
		conn = getDBConnection(dbParamsConf); 
		if(conn == null)
		{
			System.out.println("Unable to create DB connection");
			return;
		}
		devicename = args[0];
		stmt = conn.createStatement();
		if(stmt == null)
		{
			System.out.println("Unable to create statement");
			return;
		}
		
		List moList = checkMatchingEntries(devicename);
		checkAndDeleteVirtualDevice(devicename, moList);

		String[] queries = {
				"delete from NetworkRangeTable",
				"delete from Alert where Source like '%" + devicename + "%'",
				"delete from CHILDRENSTATUS where KEYSTRING like '%" + devicename + "%'",
				"delete from DBINTERFACES where VALUESTRING like '%" + devicename + "%'",
				"delete from DBMAP where KEYSTRING like '%" + devicename + "%'",
				"delete from GroupTable where MEMBERNAME like '%" + devicename + "%'",
				"delete from InetService where NAME like '%" + devicename + "%'",
				"delete from IpAddress where NAME like '%" + devicename + "%'",
				"delete from ManagedObject where NAME like '%" + devicename + "%'",
				"delete from MapContainer where OBJNAME like '%" + devicename + "%'",
				"delete from MapSymbol where OBJNAME like '%" + devicename + "%'",
				"delete from Node where NAME like '%" + devicename + "%'",
				"delete from OpManagerObject where NAME like '%" + devicename + "%'",
				"delete from PolledData where AGENT like '%" + devicename + "%'",
				"delete from SnmpInterface where NAME like '%" + devicename + "%'",
				"delete from SnmpNode where NAME like '%" + devicename + "%'",
				"delete from SwitchObject where NAME like '%" + devicename + "%'",
				"delete from TOPODBSPECIALKEY where KEYSTRING like '%" + devicename + "%'",
				"delete from TopoObject where NAME like '%" + devicename + "%'",
				"delete from CHILDRENSTATUS where KEYSTRING like '%" + devicename + "%'",
				"delete from CLIDetails where AGENTNAME like '%" + devicename + "%'",
				"delete from CustomFieldsForDevices where DEVICENAME like '%" + devicename + "%'",
				"delete from CustomFieldsForInterfaces where DEVICENAME like '%" + devicename + "%'",
				"delete from DCObject where NAME like '%" + devicename + "%'",
				"delete from DeviceToEventLogRuleMap where DEVICENAME like '%" + devicename + "%'",
				"delete from EventLogDeviceInfo where DEVICENAME like '%" + devicename + "%'",
				"delete from EventLogRunnable where DEVICENAME like '%" + devicename + "%'",
				"delete from HRDetails where AGENTNAME like '%" + devicename + "%'",
				"delete from InterfacesToNotify where NAME like '%" + devicename + "%'",
				"delete from MaintenanceDevices where MD_NAME like '%" + devicename + "%'",
				"delete from MapLink where SOURCE like '%" + devicename + "%'",
				"delete from MapLink where DEST like '%" + devicename + "%'",
				"delete from NamedInstanceObject where PARENTDEVICENAME like '%" + devicename + "%'",
				"delete from NTServices where DEVICENAME like '%" + devicename + "%'",
				"delete from OBJECTSTOLINK where KEYSTRING like '%" + devicename + "%'",
				"delete from OpmObjectDomainController where DEVICENAME like '%" + devicename + "%'",
				"delete from POLLUSERPROPS where AGENT like '%" + devicename + "%'",
				"delete from Printer where NAME like '%" + devicename + "%'",
				"delete from ProfileCriteria where CRITERIANAME like '%" + devicename + "%'",
				"delete from Services where PARENTDEVICENAME like '%" + devicename + "%'",
				"delete from TOPOUSERPROPS where NAME like '%" + devicename + "%'",
				"delete from UPSObject where NAME like '%" + devicename + "%'"			
		};

		for (int i=0; i<queries.length; i++)
		{
			String query = null;
			try
			{
				query = queries [i];
				stmt.executeUpdate(query);
				//System.out.println("\tExecuted query : " + query);
			}
			catch (Exception ex)
			{
				System.err.println("Exception removing entries : query : " + query);
				ex.printStackTrace();
				return;
			}
		}
		if(moList.size() > 0)
		{
			System.out.println("\nFollowing device entries removed from DB : " + moList);
		}
		System.out.println("\nRemove stale entry process completed. Please restart OpManager Server to make the changes effective.");
		System.exit(0);
		return;
	}


	public static Connection getDBConnection(String file) throws Exception
	{
		try
		{
			DBParamsParser parser = DBParamsParser.getInstance(new File(file));
			if(parser==null)
			{
				return null;
			}
			String url = parser.getURL();
			String driverName = parser.getDriverName();
			String userName = parser.getUserName();
			String passWord = parser.getPassword();
			Class.forName(driverName);
			conn = DriverManager.getConnection(url,userName, passWord);
			return conn;
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		return null;
	}

	private static List checkMatchingEntries(String deviceName)
	{
		String qry = "select mo.NAME, MOID, CATEGORY from ManagedObject mo JOIN OpManagerObject oo on mo.NAME = oo.NAME where mo.NAME like '%" + deviceName + "%';";
		List<Map> moList = null;
		try
		{
			moList = executeQuery(qry);
			if(moList.size() > 1)
			{
				System.out.println("\n\nATTENTION : More devices matching the delete criteria!!!");
				for(Map moMap : moList)
				{
					System.out.println("\t" + moMap);
				}
				System.out.print("\nDo you want to proceed on deletion? Y (Yes) or N (No) : ");
				proceedFurther();
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		return moList;
	}

	private static void checkAndDeleteVirtualDevice(String moOrEntityName, List<Map> moList)
	{
		List<Map> viList = null;
		if(moList.size() > 0)
		{
			String allMos = null;
			for (Map moDetails : moList)
			{
				String moName = moDetails.get("NAME").toString();
				String moId = moDetails.get("MOID").toString();
				String moCategory = moDetails.get("CATEGORY").toString();
				
				if (allMos == null)
				{
					allMos = moId;
				}
				else
				{
					allMos = allMos + "," + moId;
				}
			}
			if (allMos != null)
			{
				String qry = "select vemm.ENTITY_ID, vemm.ENTITY_NAME, MO_ID AS MOID, ve.ENTITY_TYPE from VIEntityMOMap vemm " +
					"join VIEntity ve on vemm.ENTITY_ID = ve.ENTITY_ID where MO_ID in (" + allMos + ")";

				try
				{
					viList = executeQuery(qry);
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}
		
		if (viList == null || viList.size() < 1)
		{
			String qry = "select vemm.ENTITY_ID, vemm.ENTITY_NAME, ve.ENTITY_TYPE, MO_ID AS MOID from VIEntityMOMap vemm " +
			"join VIEntity ve on vemm.ENTITY_ID = ve.ENTITY_ID where vemm.ENTITY_NAME like '%" + moOrEntityName + "%'";

			try
			{
				viList = executeQuery(qry);
				if(viList.size() < 1)
				{
					qry = "select VHOST_ID AS ENTITY_ID, VHOST_NAME AS ENTITY_NAME, 'HostSystem' AS ENTITY_TYPE from VHostProps where VHOST_DNS_NAME like '%" + moOrEntityName + "%'";
					viList = executeQuery(qry);
				}
				if(viList.size() < 1)
				{
					qry = "select VM_ID AS ENTITY_ID, VM_NAME AS ENTITY_NAME, 'VirtualMachine' AS ENTITY_TYPE from VMProperties where VM_NAME like '%" + moOrEntityName + "%'";
					viList = executeQuery(qry);
				}
				if (viList.size() > 1 && moList.size() <= 1)
				{
					System.out.println("\n\nATTENTION : More Virtual Devices matching the delete criteria!!!");
					for(Map virtualDevice : viList)
					{
						System.out.println("\t" + virtualDevice);
					}
					System.out.print("\nDo you want to proceed on deletion? Y (Yes) or N (No) : ");
					proceedFurther();
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}

		List<String> viStaleQueries = constructVirtualDeviceDeleteQueries(viList);
		if(viList.size() > 0)
		{
			System.out.println("\nFollowing Virtual Device entries are to be removed from DB : " + viList);
		}
		for(String qry : viStaleQueries)
		{
			try
			{
				stmt.executeUpdate(qry);
				//System.out.println("\tExecuted VirtualDevice query : " + qry);
			}
			catch (Exception ex)
			{
				System.out.println("Exception running query : " + qry);
				ex.printStackTrace();
			}
		}
	}
	
	private static List constructVirtualDeviceDeleteQueries(List<Map> viList)
	{
		List staleQueries = new ArrayList();
		String allVM = null;
		String allVMName = null;
		String allHost = null;
		for(Map viDetails : viList)
		{
			String entityName = viDetails.get("ENTITY_NAME").toString();
			String entityType = viDetails.get("ENTITY_TYPE").toString();
			String entityId = viDetails.get("ENTITY_ID").toString();
			if(VIConstants.VM_ENTITY_TYPE.equals(entityType))
			{
				if (allVM == null)
				{
					allVM = entityId;
					allVMName = "'" + entityName + "'";
				}
				else
				{
					allVM = allVM + "," + entityId;
					allVMName = allVMName + ",'" + entityName + "'";
				}
			}
			else if(VIConstants.HOST_ENTITY_TYPE.equals(entityType))
			{
				if (allHost == null)
				{
					allHost = entityId;
				}
				else
				{
					allHost = allHost + "," + entityId;
				}
			}
		}
		/*
		 * Stale entries still exist in ThresholdObjects, which is not addressed because of the Threshold.conf dependency.
		 * But, ThresholdObjects stale entry is not harm because the past MOID will not be generated for any new devices.
		 */
		if (allHost != null)
		{
			staleQueries.add("delete from VHostProps where VHOST_ID in (" +allHost + ")");
			staleQueries.add("delete from VIEntity where ENTITY_ID in (" +allHost + ")");
			staleQueries.add("delete from VIEntityMOMap where ENTITY_ID in (" +allHost + ")");
			staleQueries.add("delete from VICredential where ENTITY_ID in (" +allHost + ")");
		}
		if (allVM != null)
		{
			staleQueries.add("delete from VMProperties where VM_ID in (" +allVM + ")");
			staleQueries.add("delete from VIEntity where ENTITY_ID in (" +allVM + ")");
			staleQueries.add("delete from VIEntityMOMap where ENTITY_ID in (" +allVM + ")");
			staleQueries.add("delete from PolledData where COMMUNITY = 'VirtualMachine' and NAME IN (" + allVM + ")");
		}
		return staleQueries;
	}

	private static void proceedFurther()
	{
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		String name = null;
		try 
		{
			name = br.readLine();
			if("y".equalsIgnoreCase(name) || "yes".equalsIgnoreCase(name))
			{
				return;
			}
			else
			{
				System.exit(0);
			}
		} 
		catch (Exception ex) 
		{
			System.exit(1);
			ex.printStackTrace();
		}
	}
	
	
    private static List executeQuery(String query)
    {
        List resultList = new ArrayList();
        ResultSet rs = null;
        try
        {
            rs = stmt.executeQuery(query);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while(rs.next())
            {
                HashMap colVsVal = new HashMap();
                for (int i = 1; i <= columnCount; i++)
                {
                    String columnName = metaData.getColumnName(i);
                    Object value = rs.getObject(i);
                    if(value != null)
                    {
                        colVsVal.put(columnName,value);
                    }
                }
                if(columnCount > 0)
                {
                    resultList.add(colVsVal);
                }
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            closeResultSetAndStatement(rs);
        }
        return resultList; 
    }

    public static void closeResultSetAndStatement(ResultSet rs)
    {
        try
        {
            if(rs != null)
            {
                rs.close();
            }
        }catch(Exception exp) {}
    }
	
}    
